/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.datatypes;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDImplicitSized;
import oracle.dbtools.crest.model.datatype.MDPackedSized;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.DataTypeObject;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.datatypes.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class SelectLogicalTypeDialog
extends CustomDialog {
    private JDialog dialog;
    private DataTypeObject object;
    private JPanel buttonPanel;
    private JPanel general;
    private JButton bnLogicalType;
    private String selectedRdbmsSite;
    private JComboBox cbLogicalType;
    private JTextField ifSize;
    private JIntegerField ifPrecision;
    private JIntegerField ifScale;
    protected static final int FIELD_WIDTH = 18;
    private static final String EMPTY_STRING = "";
    private static Dimension dim = new Dimension(205, 20);
    private boolean usePreferredList = false;
    private TreeMap typesRDBMSSites = new TreeMap();
    private int precisionDefaultValue;
    private int scaleDefaultValue;

    public SelectLogicalTypeDialog(ApplicationView view, DataTypeObject object, JButton bnLogicalType, String selectedRdbmsSite, boolean usePreferred) {
        super(view);
        this.usePreferredList = usePreferred;
        this.object = object;
        this.bnLogicalType = bnLogicalType;
        this.selectedRdbmsSite = selectedRdbmsSite;
        this.general = new JPanel(new SpringLayout());
        this.general.setBorder(BorderFactory.createEtchedBorder(0));
        this.initGeneral();
        this.add((Component)this.general, "Center");
        JPanel bottomPanel = this.getButtonPanel();
        this.add((Component)bottomPanel, "South");
        this.general.setPreferredSize(new Dimension(350, 140));
    }

    private void initGeneral() {
        Iterator it1 = Design.getDefaultRDBMSTypeSet().iterator();
        while (it1.hasNext()) {
            RDBMSType t = (RDBMSType)it1.next();
            this.typesRDBMSSites.put(t.getType(), t.getName());
        }
        this.initSize();
        this.initPrecision();
        this.initScale();
        this.initLogicalType();
    }

    private void initLogicalType() {
        JLabel label = new JLabel(Messages.getString("SelectLogicalTypeDialog.LogicalType"));
        this.general.add(label);
        this.cbLogicalType = new JComboBox<Object>(this.object.getDesign().getLogicalDatatypeSet().toArray());
        this.general.add(this.cbLogicalType);
        this.cbLogicalType.setBackground(Color.WHITE);
        this.cbLogicalType.setFont(new Font(this.cbLogicalType.getFont().getName(), 0, this.cbLogicalType.getFont().getSize()));
        this.cbLogicalType.setPreferredSize(dim);
        this.cbLogicalType.setMaximumRowCount(20);
        this.cbLogicalType.addActionListener(new DatatypeListener());
        this.cbLogicalType.setSelectedItem(this.object.getDesign().getLogicalDatatypeSet().getDefaultType());
        this.setLabelConstraints(label, 15);
        this.setObjectConstraints(this.cbLogicalType, 15);
    }

    private void initSize() {
        JLabel label = new JLabel(Messages.getString("SelectLogicalTypeDialog.Size"));
        this.general.add(label);
        this.ifSize = new JTextField();
        this.ifSize.setPreferredSize(dim);
        this.general.add(this.ifSize);
        this.setLabelConstraints(label, 45);
        this.setObjectConstraints(this.ifSize, 45);
    }

    private void initPrecision() {
        JLabel label = new JLabel(Messages.getString("SelectLogicalTypeDialog.Precision"));
        this.general.add(label);
        this.ifPrecision = new JIntegerField();
        this.ifPrecision.setPreferredSize(dim);
        this.general.add(this.ifPrecision);
        this.setLabelConstraints(label, 75);
        this.setObjectConstraints(this.ifPrecision, 75);
    }

    private void initScale() {
        JLabel label = new JLabel(Messages.getString("SelectLogicalTypeDialog.Scale"));
        this.general.add(label);
        this.ifScale = new JIntegerField();
        this.ifScale.setPreferredSize(dim);
        this.general.add(this.ifScale);
        this.setLabelConstraints(label, 105);
        this.setObjectConstraints(this.ifScale, 105);
    }

    public void initProperties() {
        if (this.object.getType() instanceof LogicalDatatype) {
            LogicalDatatype logicalDatatype = (LogicalDatatype)this.object.getType();
            Map<String, String> m = logicalDatatype.getToPhysical();
            MDDataType datatype = logicalDatatype.createDataType(this.selectedRdbmsSite, m);
            this.cbLogicalType.removeAllItems();
            if (this.usePreferredList) {
                Iterator<LogicalDatatype> it = this.getApplicationView().getSettings().getPreferredLogicaltypes().iterator();
                while (it.hasNext()) {
                    this.cbLogicalType.addItem(it.next());
                }
            } else {
                Iterator it = this.object.getDesign().getLogicalDatatypeSet().iterator();
                while (it.hasNext()) {
                    this.cbLogicalType.addItem(it.next());
                }
            }
            this.cbLogicalType.setSelectedItem(this.object.getType());
            if (datatype instanceof MDImplicitSized) {
                this.ifSize.setEnabled(false);
                this.ifPrecision.setEnabled(false);
                this.ifScale.setEnabled(false);
            } else if (datatype instanceof MDPackedSized) {
                this.ifSize.setEnabled(false);
                try {
                    if (this.object.getPrecision() >= 0) {
                        this.ifPrecision.setValue((long)this.object.getPrecision());
                    } else if (datatype.getPrecision() != 0) {
                        this.ifPrecision.setValue(datatype.getPrecision() > 0 ? (long)datatype.getPrecision() : 0L);
                    }
                    datatype.getPrecision();
                    this.ifPrecision.setEnabled(true);
                }
                catch (Exception e) {
                    this.ifPrecision.setEnabled(false);
                }
                try {
                    if (this.object.getScale() > 0) {
                        this.ifScale.setValue(this.object.getScale() > 0 ? (long)this.object.getScale() : 0L);
                    } else if (datatype.getScale() != 0) {
                        this.ifScale.setValue(datatype.getScale() > 0 ? (long)datatype.getScale() : 0L);
                    }
                    datatype.getScale();
                    this.ifScale.setEnabled(true);
                }
                catch (Exception e) {
                    this.ifScale.setEnabled(false);
                }
            } else {
                try {
                    if (!this.object.getSize().equals(EMPTY_STRING)) {
                        this.ifSize.setText(this.object.getSize());
                    } else if (!datatype.getSize().equalsIgnoreCase("0")) {
                        this.ifSize.setText(datatype.getSize());
                    }
                    datatype.getSize();
                    this.ifSize.setEnabled(true);
                }
                catch (Exception e) {
                    this.ifSize.setEnabled(false);
                }
                try {
                    if (this.object.getPrecision() > 0) {
                        this.ifPrecision.setValue(this.object.getPrecision() > 0 ? (long)this.object.getPrecision() : 0L);
                    } else if (datatype.getPrecision() != 0) {
                        this.ifPrecision.setValue(datatype.getPrecision() > 0 ? (long)datatype.getPrecision() : 0L);
                    }
                    datatype.getPrecision();
                    this.ifPrecision.setEnabled(true);
                }
                catch (Exception e) {
                    this.ifPrecision.setEnabled(false);
                }
                try {
                    if (this.object.getScale() > 0) {
                        this.ifScale.setValue(this.object.getScale() > 0 ? (long)this.object.getScale() : 0L);
                    } else if (datatype.getScale() != 0) {
                        this.ifScale.setValue(datatype.getScale() > 0 ? (long)datatype.getScale() : 0L);
                    }
                    datatype.getScale();
                    this.ifScale.setEnabled(true);
                }
                catch (Exception e) {
                    this.ifScale.setEnabled(false);
                }
            }
        }
    }

    private void setProperties() {
        this.object.setType((DesignObject)this.cbLogicalType.getSelectedItem());
        Map defaults = ((LogicalDatatype)this.cbLogicalType.getSelectedItem()).getLTDefaultValues();
        String pdf = (String)defaults.get("precision_default_value");
        this.precisionDefaultValue = pdf != EMPTY_STRING && pdf != null ? new Integer((String)defaults.get("precision_default_value")) : 0;
        String sizeDefaultValue = (String)defaults.get("size_default_value");
        String scdf = (String)defaults.get("scale_default_value");
        this.scaleDefaultValue = scdf != EMPTY_STRING && scdf != null ? new Integer((String)defaults.get("scale_default_value")) : 0;
        try {
            if (!this.ifSize.getText().equals(sizeDefaultValue)) {
                this.object.setSize(this.ifSize.getText());
            } else {
                this.object.setSize(EMPTY_STRING);
            }
        }
        catch (Exception e) {
            this.object.setSize(EMPTY_STRING);
        }
        try {
            if (this.ifPrecision.getIntValue() != this.precisionDefaultValue || this.ifScale.getIntValue() != this.scaleDefaultValue) {
                this.object.setPrecision(this.ifPrecision.getIntValue());
                this.object.setScale(this.ifScale.getIntValue());
            } else {
                this.object.setPrecision(0);
                this.object.setScale(0);
            }
        }
        catch (Exception e) {
            this.object.setPrecision(0);
            this.object.setScale(0);
        }
        this.bnLogicalType.setText(this.object.getDataType());
    }

    protected void setLabelConstraints(JLabel label, int y) {
        SpringLayout.Constraints labelCons = this.getGeneralLayout().getConstraints(label);
        labelCons.setX(Spring.constant(10));
        labelCons.setY(Spring.constant(y));
    }

    protected void setObjectConstraints(Component c, int y) {
        SpringLayout.Constraints labelCons = this.getGeneralLayout().getConstraints(c);
        labelCons.setX(Spring.constant(125));
        labelCons.setY(Spring.constant(y));
    }

    protected SpringLayout getGeneralLayout() {
        return (SpringLayout)this.general.getLayout();
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            JButton ok = new JButton(Messages.getString("SelectLogicalTypeDialog.OK"));
            ok.setMnemonic(79);
            ok.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SelectLogicalTypeDialog.this.setProperties();
                    SelectLogicalTypeDialog.this.close();
                }
            });
            JButton cancel = new JButton(Messages.getString("SelectLogicalTypeDialog.Cancel"));
            cancel.setMnemonic(67);
            cancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SelectLogicalTypeDialog.this.close();
                }
            });
            JButton bnHelp = new JButton(this.getHelpAction());
            bnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.buttonPanel.add(ok);
            this.buttonPanel.add(cancel);
            this.buttonPanel.add(bnHelp);
        }
        return this.buttonPanel;
    }

    @Override
    public void show() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("SelectLogicalTypeDialog.SelectLogicalType"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setResizable(false);
            this.dialog.setModal(true);
        }
        return this.dialog;
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected String getHelpIndex() {
        return "LOGICAL_DATATYPE_DIALOG";
    }

    private class DatatypeListener
    implements ActionListener {
        private DatatypeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            SelectLogicalTypeDialog.this.ifSize.setText(SelectLogicalTypeDialog.EMPTY_STRING);
            SelectLogicalTypeDialog.this.ifPrecision.setText(SelectLogicalTypeDialog.EMPTY_STRING);
            SelectLogicalTypeDialog.this.ifScale.setText(SelectLogicalTypeDialog.EMPTY_STRING);
            LogicalDatatype selected = (LogicalDatatype)SelectLogicalTypeDialog.this.cbLogicalType.getSelectedItem();
            if (selected != null) {
                Map defaults = selected.getLTDefaultValues();
                String pdf = (String)defaults.get("precision_default_value");
                SelectLogicalTypeDialog.this.precisionDefaultValue = pdf != SelectLogicalTypeDialog.EMPTY_STRING && pdf != null ? new Integer((String)defaults.get("precision_default_value")) : 0;
                String scdf = (String)defaults.get("scale_default_value");
                SelectLogicalTypeDialog.this.scaleDefaultValue = scdf != SelectLogicalTypeDialog.EMPTY_STRING && scdf != null ? new Integer((String)defaults.get("scale_default_value")) : 0;
                Map<String, String> m = selected.getToPhysical();
                MDDataType datatype = selected.createDataType(SelectLogicalTypeDialog.this.selectedRdbmsSite, m);
                if (datatype instanceof MDImplicitSized) {
                    SelectLogicalTypeDialog.this.ifSize.setEnabled(false);
                    SelectLogicalTypeDialog.this.ifPrecision.setEnabled(false);
                    SelectLogicalTypeDialog.this.ifScale.setEnabled(false);
                } else if (datatype instanceof MDPackedSized) {
                    SelectLogicalTypeDialog.this.ifSize.setText(SelectLogicalTypeDialog.EMPTY_STRING);
                    SelectLogicalTypeDialog.this.ifSize.setEnabled(false);
                    try {
                        if (datatype.getPrecision() != 0) {
                            SelectLogicalTypeDialog.this.ifPrecision.setValue((long)datatype.getPrecision());
                        } else {
                            SelectLogicalTypeDialog.this.ifPrecision.setValue(SelectLogicalTypeDialog.this.precisionDefaultValue > 0 ? (long)SelectLogicalTypeDialog.this.precisionDefaultValue : 0L);
                        }
                        SelectLogicalTypeDialog.this.ifPrecision.setEnabled(true);
                    }
                    catch (Exception e) {
                        SelectLogicalTypeDialog.this.ifPrecision.setEnabled(false);
                    }
                    try {
                        if (datatype.getScale() != 0) {
                            SelectLogicalTypeDialog.this.ifScale.setValue((long)datatype.getScale());
                        } else {
                            SelectLogicalTypeDialog.this.ifScale.setValue(SelectLogicalTypeDialog.this.scaleDefaultValue > 0 ? (long)SelectLogicalTypeDialog.this.scaleDefaultValue : 0L);
                        }
                        SelectLogicalTypeDialog.this.ifScale.setEnabled(true);
                    }
                    catch (Exception e) {
                        SelectLogicalTypeDialog.this.ifScale.setEnabled(false);
                    }
                } else {
                    try {
                        if (!datatype.getSize().equalsIgnoreCase("0")) {
                            SelectLogicalTypeDialog.this.ifSize.setText(datatype.getSize());
                        }
                        SelectLogicalTypeDialog.this.ifSize.setEnabled(true);
                    }
                    catch (Exception e) {
                        SelectLogicalTypeDialog.this.ifSize.setEnabled(false);
                    }
                    try {
                        if (datatype.getPrecision() != 0) {
                            SelectLogicalTypeDialog.this.ifPrecision.setValue((long)datatype.getPrecision());
                        }
                        SelectLogicalTypeDialog.this.ifPrecision.setEnabled(true);
                    }
                    catch (Exception e) {
                        SelectLogicalTypeDialog.this.ifPrecision.setEnabled(false);
                    }
                    try {
                        if (datatype.getScale() != 0) {
                            SelectLogicalTypeDialog.this.ifScale.setValue((long)datatype.getScale());
                        }
                        SelectLogicalTypeDialog.this.ifScale.setEnabled(true);
                    }
                    catch (Exception e) {
                        SelectLogicalTypeDialog.this.ifScale.setEnabled(false);
                    }
                }
            }
        }
    }
}

