/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v9i;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RollbackSegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PartitionListOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.SnapshotOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableProxyOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.AbstractPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.PropertiesPropagationDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.editor.storage.oracle.ObjectPermissionsDialogOracle;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.gui.swing.JPositiveIntegerField;
import oracle.dbtools.crest.util.gui.swing.SQLSyntaxTextArea;
import oracle.dbtools.crest.util.options.Settings;
import org.fife.ui.rtextarea.RTextScrollPane;

public class SnapshotPropertyDialogOraclev9i
extends AbstractOraclePropertyDialog {
    private SnapshotOraclev9i snapshot;
    private TableProxyOracle implementedTable;
    private JComboBox cbOwner;
    private JTextField tfStartDate;
    private JTextField tfNextDate;
    private JTextArea taBody;
    private JComboBox cbPartitioned;
    private JComboBox cbSegment;
    private JComboBox cbCluster;
    private JComboBox cbParalelClause;
    private JComboBox cbBuild;
    private JComboBox cbReducedPrecision;
    private JComboBox cbOnPrebuild;
    private JComboBox cbUseIndex;
    private JComboBox cbForUpdate;
    private JComboBox cbQueryRewrite;
    private JComboBox cbRefresh;
    private JComboBox cbRefreshType;
    private JComboBox cbAction;
    private JComboBox cbWith;
    private JComboBox cbDefaultSegment;
    private JComboBox cbSegmentType;
    private JComboBox cbRollbackSegment;
    private JComboBox cbTablespace;
    private JComboBox cbIndexTablespace;
    private JComboBox cbLogging;
    private JComboBox cbCache;
    private JComboBox cbIndexStorage;
    private JPositiveIntegerField ifDegree;
    private JPanel pnPartitioning;
    private JPanel pnPartGeneral;
    private JTabbedPane tpPartitions;
    private JComboBox cbPartType;
    private JIntegerField ifHashPQuantity;
    private JIntegerField ifSubPartQuantity;
    private JPanel subPartColumns;
    private JPanel subPartTS;
    private JList allSubPartTSList;
    private JList selectedSubPartTSList;
    private DefaultListModel allSubPartTSModel;
    private DefaultListModel selectedSubPartTSModel;
    private JButton bnAddSubPartTS;
    private JButton bnRemoveSubPartTS;
    private JPanel hashPTS;
    private JList allHashPTSList;
    private JList selectedHashPTSList;
    private DefaultListModel allHashPTSModel;
    private DefaultListModel selectedHashPTSModel;
    private JButton bnAddHashPTS;
    private JButton bnRemoveHashPTS;
    private JTextArea taColumns;
    private JTextArea taSubPartColumns;
    private JTextArea clusterColumnsBody;
    private JPanel refreshPanel;
    private JPanel bodyPanel;
    private JPanel clusterColumnsPanel;
    protected RTextScrollPane spBody;
    private JButton bnPermissions;
    private ObjectPermissionsDialogOracle dialog;
    private JTextField tfImplementedTable;
    private JTextField tfAlias;
    private int mMinHeight = 760;
    private int minWidth = 500;

    public SnapshotPropertyDialogOraclev9i(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.snapshot = (SnapshotOraclev9i)object;
        super.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int w = SnapshotPropertyDialogOraclev9i.this.getWidth();
                int h = SnapshotPropertyDialogOraclev9i.this.getHeight();
                w = Math.max(SnapshotPropertyDialogOraclev9i.this.getMinimumWidth(), w);
                h = Math.max(SnapshotPropertyDialogOraclev9i.this.getMinimumHeight(), h);
                SnapshotPropertyDialogOraclev9i.this.setSize(new Dimension(w, h));
            }
        });
        Settings.DialogSettings ds = view.getSettings().getDialogSettings(this.getClass().getName());
        if (ds == null) {
            int w = this.getMinimumWidth();
            int h = this.getMinimumHeight();
            this.setSize(w, h);
            CommonUtil.centerOnScreen(this);
        } else {
            int w = Math.max(this.getMinimumWidth(), (int)ds.rec.getSize().getWidth());
            int h = Math.max(this.getMinimumHeight(), (int)ds.rec.getSize().getHeight());
            this.setSize(w, h);
            this.setLocation(ds.rec.getLocation());
        }
        this.initCommentsView(280);
        this.initCommentsInRDBMS(280);
        this.initNotesView(580);
        this.pack();
        this.initProperties();
    }

    @Override
    protected int getDialogWidth() {
        return 490;
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initAlias();
        this.initImplementedTable();
        this.initOwner();
        this.initPartitioned();
        this.initSegment();
        this.initCluster();
        this.initParalelClause();
        this.initDegree();
        this.initBuild();
        this.initReducedPrecision();
        this.initOnPrebuild();
        this.initUseIndex();
        this.initForUpdate();
        this.initQueryRewrite();
        this.initTablespace();
        this.initIndexTablespace();
        this.initIndexStorage();
        this.initLogging();
        this.initCache();
        if (this.isEditable()) {
            this.initPropagatePropsButton();
        }
        this.initPermissionsButton();
    }

    @Override
    protected void addTabs() {
        this.initBodyView();
        this.initClusterColumnsView();
        this.initPartitioningView();
        this.initRefreshView();
    }

    private void initBodyView() {
        this.bodyPanel = new JPanel(new BorderLayout());
        this.getPane().addTab(Messages.getString("SnapshotPropertyDialogOracle.Body"), this.bodyPanel);
        this.taBody = new SQLSyntaxTextArea(false);
        this.spBody = new RTextScrollPane((Component)this.taBody);
        this.spBody.setPreferredSize(new Dimension(395, 580));
        this.spBody.setBorder(BorderFactory.createEtchedBorder(0));
        this.taBody.setLineWrap(true);
        this.bodyPanel.add((Component)this.spBody);
    }

    private void initClusterColumnsView() {
        this.clusterColumnsPanel = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("SnapshotPropertyDialogOracle.ClusterColumns"), this.clusterColumnsPanel);
        this.clusterColumnsBody = new JTextArea();
        JScrollPane spBody = new JScrollPane(this.clusterColumnsBody);
        spBody.setPreferredSize(new Dimension(460, 640));
        spBody.setBorder(BorderFactory.createEtchedBorder(0));
        this.clusterColumnsBody.setLineWrap(true);
        this.clusterColumnsPanel.add(spBody);
        this.setObjectConstraints(this.getClusterColumnsLayout(), spBody, 10, 12);
    }

    private void initRefreshView() {
        this.refreshPanel = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("SnapshotPropertyDialogOracle.RefreshClause"), this.refreshPanel);
        this.initRefresh();
        this.initRefreshType();
        this.initAction();
        this.initStartDate();
        this.initNextDate();
        this.initWith();
        this.initDefaultSegment();
        this.initSegmentType();
        this.initRollbackSegment();
    }

    private void initAlias() {
        JLabel label = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.Alias"));
        this.general.add(label);
        this.tfAlias = new JTextField();
        this.setBG(this.tfAlias);
        this.tfAlias.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.tfAlias);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.tfAlias, 50);
    }

    private void initImplementedTable() {
        JLabel label = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.ImplementsTable"));
        this.general.add(label);
        this.tfImplementedTable = new JTextField();
        this.tfImplementedTable.setEnabled(false);
        this.setBG(this.tfImplementedTable);
        this.tfImplementedTable.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.tfImplementedTable);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.tfImplementedTable, 80);
    }

    private void initOwner() {
        JLabel label = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.User"));
        this.general.add(label);
        this.cbOwner = new JComboBox();
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getUserSet().toArray(), this.cbOwner);
        }
        this.cbOwner.removeItem(this.getStorageDesign().getUserSet().getByName("PUBLIC"));
        this.setBG(this.cbOwner);
        this.cbOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOwner);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.cbOwner, 110);
    }

    private void initPartitioned() {
        JLabel label = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.Partitioned"));
        this.general.add(label);
        this.cbPartitioned = new JComboBox<String>(YES_NO);
        this.setBG(this.cbPartitioned);
        this.cbPartitioned.setPreferredSize(this.tfName.getPreferredSize());
        this.cbPartitioned.addActionListener(new PartitionedAction());
        this.general.add(this.cbPartitioned);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.cbPartitioned, 140);
    }

    private void initSegment() {
        JLabel label = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.Segment"));
        this.general.add(label);
        this.cbSegment = new JComboBox();
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSegmentSet().toArray(), this.cbSegment);
        }
        this.setBG(this.cbSegment);
        this.cbSegment.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSegment);
        this.setLabelConstraints(label, 260);
        this.setObjectConstraints(this.cbSegment, 260);
    }

    private void clusterStateChanged() {
        boolean enable;
        boolean bl = enable = this.cbCluster.getSelectedItem() == null;
        if (this.cbTablespace != null) {
            this.cbTablespace.setEnabled(enable);
        }
        if (this.cbSegment != null) {
            this.cbSegment.setEnabled(enable);
        }
    }

    private void initCluster() {
        JLabel label = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.Cluster"));
        this.general.add(label);
        this.cbCluster = new JComboBox();
        this.cbCluster.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SnapshotPropertyDialogOraclev9i.this.clusterStateChanged();
            }
        });
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getClusterSet().toArray(), this.cbCluster);
        }
        this.setBG(this.cbCluster);
        this.cbCluster.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCluster);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(this.cbCluster, 170);
    }

    private void initParalelClause() {
        JLabel label = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.ParalelClause"));
        this.general.add(label);
        this.cbParalelClause = new JComboBox<String>(YES_NO);
        this.setBG(this.cbParalelClause);
        this.cbParalelClause.addActionListener(new ParallelListener());
        this.cbParalelClause.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbParalelClause);
        this.setLabelConstraints(label, 290);
        this.setObjectConstraints(this.cbParalelClause, 290);
    }

    private void initDegree() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.Degree"));
        this.general.add(label);
        this.ifDegree = new JPositiveIntegerField(0, 26);
        this.general.add(this.ifDegree);
        this.setLabelConstraints(label, 320);
        this.setObjectConstraints(this.ifDegree, 320);
    }

    private void initBuild() {
        JLabel label = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.Build"));
        this.general.add(label);
        this.cbBuild = new JComboBox<String>(SnapshotOracle.BUILD_STATES);
        this.setBG(this.cbBuild);
        this.cbBuild.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbBuild);
        this.setLabelConstraints(label, 350);
        this.setObjectConstraints(this.cbBuild, 350);
    }

    private void initReducedPrecision() {
        JLabel label = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.ReducedPrecision"));
        this.general.add(label);
        this.cbReducedPrecision = new JComboBox<String>(YES_NO);
        this.setBG(this.cbReducedPrecision);
        this.cbReducedPrecision.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbReducedPrecision);
        this.setLabelConstraints(label, 410);
        this.setObjectConstraints(this.cbReducedPrecision, 410);
    }

    private void initOnPrebuild() {
        JLabel label = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.OnPrebuildTable"));
        this.general.add(label);
        this.cbOnPrebuild = new JComboBox();
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableProxySet().getElements().toArray(), this.cbOnPrebuild);
        }
        this.cbOnPrebuild.addActionListener(new PrebuildListener());
        this.setBG(this.cbOnPrebuild);
        this.cbOnPrebuild.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOnPrebuild);
        this.setLabelConstraints(label, 380);
        this.setObjectConstraints(this.cbOnPrebuild, 380);
    }

    private void initUseIndex() {
        JLabel label = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.UseIndex"));
        this.general.add(label);
        this.cbUseIndex = new JComboBox<String>(NONE_YES_NO);
        this.setBG(this.cbUseIndex);
        this.cbUseIndex.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbUseIndex);
        this.setLabelConstraints(label, 500);
        this.setObjectConstraints(this.cbUseIndex, 500);
    }

    private void initForUpdate() {
        JLabel label = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.ForUpdate"));
        this.general.add(label);
        this.cbForUpdate = new JComboBox<String>(YES_NO);
        this.setBG(this.cbForUpdate);
        this.cbForUpdate.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbForUpdate);
        this.setLabelConstraints(label, 440);
        this.setObjectConstraints(this.cbForUpdate, 440);
    }

    private void initQueryRewrite() {
        JLabel label = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.QueryRewrite"));
        this.general.add(label);
        this.cbQueryRewrite = new JComboBox<String>(SnapshotOracle.QUERY_REWRITE_STATES);
        this.setBG(this.cbQueryRewrite);
        this.cbQueryRewrite.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbQueryRewrite);
        this.setLabelConstraints(label, 470);
        this.setObjectConstraints(this.cbQueryRewrite, 470);
    }

    private void initTablespace() {
        JLabel label = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.Tablespace"));
        this.general.add(label);
        this.cbTablespace = new JComboBox();
        this.setBG(this.cbTablespace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbTablespace);
        }
        this.cbTablespace.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTablespace);
        this.setLabelConstraints(label, 200);
        this.setObjectConstraints(this.cbTablespace, 200);
    }

    private void initIndexTablespace() {
        JLabel label = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.IndexTablespace"));
        this.general.add(label);
        this.cbIndexTablespace = new JComboBox();
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbIndexTablespace);
        }
        this.setBG(this.cbIndexTablespace);
        this.cbIndexTablespace.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbIndexTablespace);
        this.setLabelConstraints(label, 530);
        this.setObjectConstraints(this.cbIndexTablespace, 530);
    }

    private void initIndexStorage() {
        JLabel label = new JLabel(Messages.getString("SnapshotPropertyDialogOraclev9i.IndexSegment"));
        this.general.add(label);
        this.cbIndexStorage = new JComboBox();
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSegmentSet().toArray(), this.cbIndexStorage);
        }
        this.setBG(this.cbIndexStorage);
        this.cbIndexStorage.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbIndexStorage);
        this.setLabelConstraints(label, 560);
        this.setObjectConstraints(this.cbIndexStorage, 560);
    }

    private void initLogging() {
        JLabel label = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.Logging"));
        this.general.add(label);
        this.cbLogging = new JComboBox<String>(NONE_YES_NO);
        this.setBG(this.cbLogging);
        this.cbLogging.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbLogging);
        this.setLabelConstraints(label, 230);
        this.setObjectConstraints(this.cbLogging, 230);
    }

    private void initCache() {
        JLabel label = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.Cache"));
        this.general.add(label);
        this.cbCache = new JComboBox<String>(NONE_YES_NO);
        this.setBG(this.cbCache);
        this.cbCache.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCache);
        this.setLabelConstraints(label, 590);
        this.setObjectConstraints(this.cbCache, 590);
    }

    private void initPropagatePropsButton() {
        JButton bnPropagateProps = new JButton(Messages.getString("SnapshotPropertyDialogOracle.PropagateProperties"));
        bnPropagateProps.setIcon(this.getAppView().getConfiguration().getIcon("PROPS_PROPAGATION", 16));
        bnPropagateProps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList list = new ArrayList();
                list.addAll(SnapshotPropertyDialogOraclev9i.this.getStorageDesign().getSnapshotSet().getElementsList());
                list.remove(SnapshotPropertyDialogOraclev9i.this.snapshot);
                new PropertiesPropagationDialog(SnapshotPropertyDialogOraclev9i.this.getAppView(), SnapshotPropertyDialogOraclev9i.this.snapshot, list).showDialog();
            }
        });
        this.general.add(bnPropagateProps);
        this.setObjectConstraints(bnPropagateProps, 10, 625);
    }

    private void initPermissionsButton() {
        this.bnPermissions = new JButton(Messages.getString("SnapshotPropertyDialogOracle.Permissions"));
        this.bnPermissions.setIcon(this.getAppView().getConfiguration().getIcon("PERMISSIONS_ICON", 16));
        this.bnPermissions.addActionListener(new PermissionsListener());
        this.general.add(this.bnPermissions);
        this.setObjectConstraints(this.bnPermissions, 270, 625);
    }

    private void initRefresh() {
        JLabel label = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.Refresh"));
        this.refreshPanel.add(label);
        this.cbRefresh = new JComboBox<String>(SnapshotOracle.REFRESH_STATES);
        this.setBG(this.cbRefresh);
        this.cbRefresh.setPreferredSize(this.tfName.getPreferredSize());
        this.refreshPanel.add(this.cbRefresh);
        this.setLabelConstraints(this.getRefreshLayout(), label, 10, 20);
        this.setObjectConstraints(this.getRefreshLayout(), this.cbRefresh, 20);
    }

    private void initRefreshType() {
        JLabel label = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.RefreshType"));
        this.refreshPanel.add(label);
        this.cbRefreshType = new JComboBox<String>(SnapshotOracle.REFRESH_TYPE_STATES);
        this.setBG(this.cbRefreshType);
        this.cbRefreshType.setPreferredSize(this.tfName.getPreferredSize());
        this.refreshPanel.add(this.cbRefreshType);
        this.setLabelConstraints(this.getRefreshLayout(), label, 10, 50);
        this.setObjectConstraints(this.getRefreshLayout(), this.cbRefreshType, 50);
    }

    private void updateDates() {
        this.tfStartDate.setEnabled(this.cbAction.getSelectedIndex() == 0);
        this.tfNextDate.setEnabled(this.tfStartDate.isEnabled());
    }

    private void initAction() {
        JLabel label = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.Action"));
        this.refreshPanel.add(label);
        this.cbAction = new JComboBox<String>(SnapshotOracle.ACTION_STATES);
        this.cbAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SnapshotPropertyDialogOraclev9i.this.updateDates();
            }
        });
        this.setBG(this.cbAction);
        this.cbAction.setPreferredSize(this.tfName.getPreferredSize());
        this.refreshPanel.add(this.cbAction);
        this.setLabelConstraints(this.getRefreshLayout(), label, 10, 80);
        this.setObjectConstraints(this.getRefreshLayout(), this.cbAction, 80);
    }

    private void initStartDate() {
        JLabel label = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.StartDate"));
        this.refreshPanel.add(label);
        this.tfStartDate = new JTextField();
        this.setBG(this.tfStartDate);
        this.tfStartDate.setPreferredSize(this.tfName.getPreferredSize());
        this.refreshPanel.add(this.tfStartDate);
        this.setLabelConstraints(this.getRefreshLayout(), label, 10, 110);
        this.setObjectConstraints(this.getRefreshLayout(), this.tfStartDate, 110);
    }

    private void initNextDate() {
        JLabel label = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.NextDate"));
        this.refreshPanel.add(label);
        this.tfNextDate = new JTextField();
        this.setBG(this.tfNextDate);
        this.tfNextDate.setPreferredSize(this.tfName.getPreferredSize());
        this.refreshPanel.add(this.tfNextDate);
        this.setLabelConstraints(this.getRefreshLayout(), label, 10, 140);
        this.setObjectConstraints(this.getRefreshLayout(), this.tfNextDate, 140);
    }

    private void initWith() {
        JLabel label = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.With"));
        this.refreshPanel.add(label);
        this.cbWith = new JComboBox<String>(SnapshotOracle.WITH_STATES);
        this.setBG(this.cbWith);
        this.cbWith.setPreferredSize(this.tfName.getPreferredSize());
        this.refreshPanel.add(this.cbWith);
        this.setLabelConstraints(this.getRefreshLayout(), label, 10, 170);
        this.setObjectConstraints(this.getRefreshLayout(), this.cbWith, 170);
    }

    private void updateRollbackSegment() {
        this.cbRollbackSegment.setEnabled(!YES.equalsIgnoreCase((String)this.cbDefaultSegment.getSelectedItem()));
    }

    private void initDefaultSegment() {
        JLabel label = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.DefaultSegment"));
        this.refreshPanel.add(label);
        this.cbDefaultSegment = new JComboBox<String>(YES_NO);
        this.cbDefaultSegment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SnapshotPropertyDialogOraclev9i.this.updateRollbackSegment();
            }
        });
        this.setBG(this.cbDefaultSegment);
        this.cbDefaultSegment.setPreferredSize(this.tfName.getPreferredSize());
        this.refreshPanel.add(this.cbDefaultSegment);
        this.setLabelConstraints(this.getRefreshLayout(), label, 10, 200);
        this.setObjectConstraints(this.getRefreshLayout(), this.cbDefaultSegment, 200);
    }

    private void initSegmentType() {
        JLabel label = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.SegmentType"));
        this.refreshPanel.add(label);
        this.cbSegmentType = new JComboBox<String>(SnapshotOracle.SEGMENT_TYPE_STATES);
        this.setBG(this.cbSegmentType);
        this.cbSegmentType.setPreferredSize(this.tfName.getPreferredSize());
        this.refreshPanel.add(this.cbSegmentType);
        this.setLabelConstraints(this.getRefreshLayout(), label, 10, 230);
        this.setObjectConstraints(this.getRefreshLayout(), this.cbSegmentType, 230);
    }

    private void initRollbackSegment() {
        JLabel label = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.RollbackSegment"));
        this.refreshPanel.add(label);
        this.cbRollbackSegment = new JComboBox();
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getRollbackSegmentSet().toArray(), this.cbRollbackSegment);
        }
        this.setBG(this.cbRollbackSegment);
        this.cbRollbackSegment.setPreferredSize(this.tfName.getPreferredSize());
        this.refreshPanel.add(this.cbRollbackSegment);
        this.setLabelConstraints(this.getRefreshLayout(), label, 10, 260);
        this.setObjectConstraints(this.getRefreshLayout(), this.cbRollbackSegment, 260);
    }

    private void initPartitioningView() {
        this.pnPartitioning = new JPanel(new BorderLayout());
        this.getPane().addTab(Messages.getString("SnapshotPropertyDialogOraclev9i.Partitioning"), this.pnPartitioning);
        this.tpPartitions = new JTabbedPane();
        this.pnPartitioning.add((Component)this.tpPartitions, "Center");
        this.pnPartGeneral = new JPanel(new SpringLayout());
        this.hashPTS = new JPanel(new SpringLayout());
        this.subPartColumns = new JPanel(new SpringLayout());
        this.subPartTS = new JPanel(new SpringLayout());
        this.tpPartitions.addTab(Messages.getString("SnapshotPropertyDialogOraclev9i.General"), this.pnPartGeneral);
        this.tpPartitions.addTab(Messages.getString("SnapshotPropertyDialogOraclev9i.HashPartTableSpaces"), this.hashPTS);
        this.tpPartitions.addTab(Messages.getString("SnapshotPropertyDialogOraclev9i.SubPartColumns"), this.subPartColumns);
        this.tpPartitions.addTab(Messages.getString("SnapshotPropertyDialogOraclev9i.HashSubPartTableSpaces"), this.subPartTS);
        this.initPartitioning();
    }

    protected SpringLayout getHashPTSLayout() {
        return (SpringLayout)this.hashPTS.getLayout();
    }

    protected SpringLayout getSubPartTSLayout() {
        return (SpringLayout)this.subPartTS.getLayout();
    }

    protected SpringLayout getSubPartColumnsLayout() {
        return (SpringLayout)this.subPartColumns.getLayout();
    }

    protected SpringLayout getGeneralPartitioningLayout() {
        return (SpringLayout)this.pnPartGeneral.getLayout();
    }

    private void initPartitioning() {
        this.initGeneralPartitioning();
        this.initHashPTS();
        this.initSubPartColumns();
        this.initSubPartTS();
    }

    private void initGeneralPartitioning() {
        this.initPartType();
        this.initHashPQuantity();
        this.initSubPartQuantity();
        this.initColumns();
    }

    private void initColumns() {
        JLabel label = new JLabel(Messages.getString("SnapshotPropertyDialogOraclev9i.PartitioningColumns"));
        this.pnPartGeneral.add(label);
        this.taColumns = new JTextArea();
        JScrollPane spColumns = new JScrollPane(this.taColumns);
        spColumns.setPreferredSize(new Dimension(395, 330));
        spColumns.setBorder(BorderFactory.createEtchedBorder(0));
        this.pnPartGeneral.add(spColumns);
        this.setLabelConstraints(this.getGeneralPartitioningLayout(), label, 110);
        this.setObjectConstraints(this.getGeneralPartitioningLayout(), spColumns, 10, 130);
    }

    private void initHashPTS() {
        this.initAllHashPTSList();
        this.initSelectedHashPTSList();
        this.initHashPTSButtons();
    }

    private void initSubPartColumns() {
        this.taSubPartColumns = new JTextArea();
        JScrollPane spColumns = new JScrollPane(this.taSubPartColumns);
        spColumns.setPreferredSize(new Dimension(390, 535));
        spColumns.setBorder(BorderFactory.createEtchedBorder(0));
        this.subPartColumns.add(spColumns);
        this.setObjectConstraints(this.getSubPartColumnsLayout(), spColumns, 10, 12);
    }

    private void initSubPartTS() {
        this.initAllSubPartTSList();
        this.initSelectedSubPartTSList();
        this.initSubPartTSButtons();
    }

    private void initPartType() {
        JLabel label = new JLabel(Messages.getString("SnapshotPropertyDialogOraclev9i.PartitionType"));
        this.pnPartGeneral.add(label);
        this.cbPartType = new JComboBox<String>(PartitionListOraclev9i.getPartitionTypes());
        this.setBG(this.cbPartType);
        this.cbPartType.setPreferredSize(this.tfName.getPreferredSize());
        this.pnPartGeneral.add(this.cbPartType);
        this.setLabelConstraints(this.getGeneralPartitioningLayout(), label, 20);
        this.setObjectConstraints(this.getGeneralPartitioningLayout(), this.cbPartType, 20);
    }

    private void initHashPQuantity() {
        JLabel label = new JLabel(Messages.getString("SnapshotPropertyDialogOraclev9i.HashPQuantity"));
        this.pnPartGeneral.add(label);
        this.ifHashPQuantity = new JIntegerField(0, 26);
        this.pnPartGeneral.add(this.ifHashPQuantity);
        this.setLabelConstraints(this.getGeneralPartitioningLayout(), label, 50);
        this.setObjectConstraints(this.getGeneralPartitioningLayout(), this.ifHashPQuantity, 50);
    }

    private void initSubPartQuantity() {
        JLabel label = new JLabel(Messages.getString("SnapshotPropertyDialogOraclev9i.SubPartQuantity"));
        this.pnPartGeneral.add(label);
        this.ifSubPartQuantity = new JIntegerField(0, 26);
        this.pnPartGeneral.add(this.ifSubPartQuantity);
        this.setLabelConstraints(this.getGeneralPartitioningLayout(), label, 80);
        this.setObjectConstraints(this.getGeneralPartitioningLayout(), this.ifSubPartQuantity, 80);
    }

    private void initAllHashPTSList() {
        JLabel label = new JLabel(Messages.getString("SnapshotPropertyDialogOraclev9i.AllTableSpaces"));
        this.hashPTS.add(label);
        this.allHashPTSModel = new DefaultListModel();
        this.allHashPTSList = new JList(this.allHashPTSModel);
        ListSelectionModel listSelectionModel = this.allHashPTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllHashPTSListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allHashPTSList);
        sp.setPreferredSize(new Dimension(144, 525));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.hashPTS.add(sp);
        this.setLabelConstraints(this.getHashPTSLayout(), label, 8, 4);
        this.setObjectConstraints(this.getHashPTSLayout(), sp, 6, 22);
    }

    private void initSelectedHashPTSList() {
        JLabel label = new JLabel(Messages.getString("SnapshotPropertyDialogOraclev9i.SelectedTableSpaces"));
        this.hashPTS.add(label);
        this.selectedHashPTSModel = new DefaultListModel();
        this.selectedHashPTSList = new JList(this.selectedHashPTSModel);
        ListSelectionModel listSelectionModel = this.selectedHashPTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedHashPTSListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedHashPTSList);
        sp.setPreferredSize(new Dimension(145, 525));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.hashPTS.add(sp);
        this.setLabelConstraints(this.getHashPTSLayout(), label, 292, 4);
        this.setObjectConstraints(this.getHashPTSLayout(), sp, 290, 22);
    }

    private void initHashPTSButtons() {
        this.bnAddHashPTS = new JButton(ADD_CAPTION);
        this.bnAddHashPTS.addActionListener(new AddHashPTSActionListener());
        this.bnAddHashPTS.setEnabled(false);
        this.hashPTS.add(this.bnAddHashPTS);
        this.setObjectConstraints(this.getHashPTSLayout(), this.bnAddHashPTS, 175, 195);
        this.bnRemoveHashPTS = new JButton(REMOVE_CAPTION);
        this.bnRemoveHashPTS.setEnabled(false);
        this.bnRemoveHashPTS.addActionListener(new RemoveHashPTSActionListener());
        this.hashPTS.add(this.bnRemoveHashPTS);
        this.setObjectConstraints(this.getHashPTSLayout(), this.bnRemoveHashPTS, 175, 225);
        SnapshotPropertyDialogOraclev9i.equalizeButtonSizes(this.bnAddHashPTS, this.bnRemoveHashPTS);
    }

    private void setPartitioning(boolean use) {
        this.taColumns.setEnabled(use);
        this.allHashPTSList.setEnabled(use);
        this.selectedHashPTSList.setEnabled(use);
        this.bnAddHashPTS.setEnabled(use && this.allHashPTSList.getSelectedIndex() != -1);
        this.bnRemoveHashPTS.setEnabled(use && this.selectedHashPTSList.getSelectedIndex() != -1);
        this.taSubPartColumns.setEnabled(use);
        this.allSubPartTSList.setEnabled(use);
        this.selectedSubPartTSList.setEnabled(use);
        this.bnAddSubPartTS.setEnabled(use && this.allSubPartTSList.getSelectedIndex() != -1);
        this.bnRemoveSubPartTS.setEnabled(use && this.selectedSubPartTSList.getSelectedIndex() != -1);
        this.cbPartType.setEnabled(use);
        this.ifHashPQuantity.setEditable(use);
        this.ifSubPartQuantity.setEditable(use);
        this.allHashPTSModel.clear();
        this.selectedHashPTSModel.clear();
        this.allSubPartTSModel.clear();
        this.selectedSubPartTSModel.clear();
        if (use) {
            this.initPartColumns();
            this.initHashPTS((PartitionListOraclev9i)this.snapshot.getPartitionList());
            this.initSubPartColumnsArea();
            this.initSubPartTS((PartitionListOraclev9i)this.snapshot.getPartitionList());
        }
    }

    private void initPartColumns() {
        this.taColumns.setText(this.snapshot.getColumns());
    }

    private void initHashPTS(PartitionListOraclev9i partList) {
        if (partList != null) {
            Iterator tsIt = partList.getHashPartitionsTableSpacesSet().iterator();
            while (tsIt.hasNext()) {
                ModelIDObject ts = this.getStorageDesign().getTableSpaceSet().getById((String)tsIt.next());
                if (!(ts instanceof TableSpaceOracle)) continue;
                this.selectedHashPTSModel.addElement(ts);
            }
        }
        TableSpaceOracle[] tsSet = (TableSpaceOracle[])this.getStorageDesign().getTableSpaceSet().toArray();
        for (int i = 0; i < tsSet.length; ++i) {
            TableSpaceOracle ts = tsSet[i];
            if (this.selectedHashPTSModel.contains(ts)) continue;
            this.allHashPTSModel.addElement(ts);
        }
    }

    private void initSubPartColumnsArea() {
        this.taSubPartColumns.setText(this.snapshot.getSubPartColumns());
    }

    private void initSubPartTS(PartitionListOraclev9i partList) {
        if (partList != null) {
            Iterator tsIt = partList.getSubPartitionsTableSpacesSet().iterator();
            while (tsIt.hasNext()) {
                ModelIDObject ts = this.getStorageDesign().getTableSpaceSet().getById((String)tsIt.next());
                if (!(ts instanceof TableSpaceOracle)) continue;
                this.selectedSubPartTSModel.addElement(ts);
            }
        }
        TableSpaceOracle[] tsSet = (TableSpaceOracle[])this.getStorageDesign().getTableSpaceSet().toArray();
        for (int i = 0; i < tsSet.length; ++i) {
            TableSpaceOracle ts = tsSet[i];
            if (this.selectedSubPartTSModel.contains(ts)) continue;
            this.allSubPartTSModel.addElement(ts);
        }
    }

    private void initAllSubPartTSList() {
        JLabel label = new JLabel(Messages.getString("SnapshotPropertyDialogOraclev9i.AllTableSpaces"));
        this.subPartTS.add(label);
        this.allSubPartTSModel = new DefaultListModel();
        this.allSubPartTSList = new JList(this.allSubPartTSModel);
        ListSelectionModel listSelectionModel = this.allSubPartTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllSubPartTSListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allSubPartTSList);
        sp.setPreferredSize(new Dimension(144, 525));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.subPartTS.add(sp);
        this.setLabelConstraints(this.getSubPartTSLayout(), label, 8, 4);
        this.setObjectConstraints(this.getSubPartTSLayout(), sp, 6, 22);
    }

    private void initSelectedSubPartTSList() {
        JLabel label = new JLabel(Messages.getString("SnapshotPropertyDialogOraclev9i.SelectedTableSpaces"));
        this.subPartTS.add(label);
        this.selectedSubPartTSModel = new DefaultListModel();
        this.selectedSubPartTSList = new JList(this.selectedSubPartTSModel);
        ListSelectionModel listSelectionModel = this.selectedSubPartTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedSubPartTSListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedSubPartTSList);
        sp.setPreferredSize(new Dimension(145, 525));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.subPartTS.add(sp);
        this.setLabelConstraints(this.getSubPartTSLayout(), label, 292, 4);
        this.setObjectConstraints(this.getSubPartTSLayout(), sp, 290, 22);
    }

    private void initSubPartTSButtons() {
        this.bnAddSubPartTS = new JButton(ADD_CAPTION);
        this.bnAddSubPartTS.addActionListener(new AddSubPartTSActionListener());
        this.bnAddSubPartTS.setEnabled(false);
        this.subPartTS.add(this.bnAddSubPartTS);
        this.setObjectConstraints(this.getSubPartTSLayout(), this.bnAddSubPartTS, 175, 195);
        this.bnRemoveSubPartTS = new JButton(REMOVE_CAPTION);
        this.bnRemoveSubPartTS.setEnabled(false);
        this.bnRemoveSubPartTS.addActionListener(new RemoveSubPartTSActionListener());
        this.subPartTS.add(this.bnRemoveSubPartTS);
        this.setObjectConstraints(this.getSubPartTSLayout(), this.bnRemoveSubPartTS, 175, 225);
        SnapshotPropertyDialogOraclev9i.equalizeButtonSizes(this.bnAddSubPartTS, this.bnRemoveSubPartTS);
    }

    protected SpringLayout getRefreshLayout() {
        return (SpringLayout)this.refreshPanel.getLayout();
    }

    protected SpringLayout getBodyLayout() {
        return (SpringLayout)this.bodyPanel.getLayout();
    }

    protected SpringLayout getClusterColumnsLayout() {
        return (SpringLayout)this.clusterColumnsPanel.getLayout();
    }

    @Override
    public void initProperties() {
        this.implementedTable = this.snapshot.getImplementedTable();
        this.initCaption(this.snapshot.getName());
        this.tfName.setText(this.snapshot.getName());
        this.tfAlias.setText(this.snapshot.getAlias());
        this.tfImplementedTable.setText(this.implementedTable != null ? this.implementedTable.getLongName() : "");
        this.cbOwner.setSelectedItem(this.snapshot.getUser());
        this.cbPartitioned.setSelectedItem(SnapshotPropertyDialogOraclev9i.translateYesNoForDisplay(this.snapshot.getPartitioned()));
        this.cbSegment.setSelectedItem(this.snapshot.getSegment());
        this.cbCluster.setSelectedItem(this.snapshot.getCluster());
        this.cbParalelClause.setSelectedItem(SnapshotPropertyDialogOraclev9i.translateYesNoForDisplay(this.snapshot.getParalelClause()));
        this.ifDegree.setValue((long)this.snapshot.getDegree());
        this.cbBuild.setSelectedItem(this.snapshot.getBuild());
        this.cbReducedPrecision.setSelectedItem(SnapshotPropertyDialogOraclev9i.translateYesNoForDisplay(this.snapshot.getReducedPrecision()));
        if (this.implementedTable != null) {
            this.cbOnPrebuild.setEnabled(false);
        } else {
            this.cbOnPrebuild.setSelectedItem(this.snapshot.getOnPrebuildTable());
        }
        this.cbUseIndex.setSelectedItem(SnapshotPropertyDialogOraclev9i.translateNoneYesNoForDisplay(this.snapshot.getUseIndex()));
        this.cbForUpdate.setSelectedItem(SnapshotPropertyDialogOraclev9i.translateYesNoForDisplay(this.snapshot.getForUpdate()));
        this.cbQueryRewrite.setSelectedItem(this.snapshot.getQueryRewrite());
        this.cbTablespace.setSelectedItem(this.snapshot.getTablespace());
        this.cbIndexTablespace.setSelectedItem(this.snapshot.getIndexTablespace());
        this.cbIndexStorage.setSelectedItem(this.snapshot.getIndexSegment());
        this.cbLogging.setSelectedItem(SnapshotPropertyDialogOraclev9i.translateNoneYesNoForDisplay(this.snapshot.getLogging()));
        this.cbCache.setSelectedItem(SnapshotPropertyDialogOraclev9i.translateNoneYesNoForDisplay(this.snapshot.getCache()));
        this.taBody.setText(this.snapshot.getSubquery());
        this.clusterColumnsBody.setText(this.snapshot.getClusterColumns());
        if (this.snapshot.getPartitionList() != null) {
            this.setPartitioning(true);
            PartitionListOraclev9i pl = (PartitionListOraclev9i)this.snapshot.getPartitionList();
            this.cbPartType.setSelectedItem(pl.getPartitionType());
            this.ifHashPQuantity.setValue((long)pl.getHashPQuantity());
            this.ifSubPartQuantity.setValue((long)pl.getSubPartitionsQuantity());
        }
        this.cbRefresh.setSelectedItem(this.snapshot.getRefresh());
        this.cbRefreshType.setSelectedItem(this.snapshot.getRefreshType());
        this.cbAction.setSelectedItem(this.snapshot.getAction());
        if (this.cbAction.getSelectedIndex() == 0) {
            this.tfStartDate.setText(this.snapshot.getStartDate());
            this.tfNextDate.setText(this.snapshot.getNextDate());
        }
        this.cbWith.setSelectedItem(this.snapshot.getWith());
        this.cbDefaultSegment.setSelectedItem(SnapshotPropertyDialogOraclev9i.translateYesNoForDisplay(this.snapshot.getDefaultSegment()));
        this.cbSegmentType.setSelectedItem(this.snapshot.getSegmentType());
        this.cbRollbackSegment.setSelectedItem(this.snapshot.getRollbackSegment());
        this.getCommentsList().insert(this.snapshot.getComment(), 0);
        this.taCommentsInRDBMS.insert(this.snapshot.getCommentInRDBMS(), 0);
        this.taNotes.setText(this.snapshot.getNotes());
        this.updateDates();
        this.updateRollbackSegment();
        this.clusterStateChanged();
    }

    @Override
    protected void setProperties() {
        if (this.snapshot != null) {
            this.snapshot.setUser((UserOracle)this.cbOwner.getSelectedItem());
            this.snapshot.setName(this.tfName.getText());
            this.snapshot.setAlias(this.tfAlias.getText());
            this.snapshot.setPartitioned(SnapshotPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbPartitioned.getSelectedItem()));
            this.snapshot.setSegment((SegmentOracle)this.cbSegment.getSelectedItem());
            this.snapshot.setCluster((ClusterOracle)this.cbCluster.getSelectedItem());
            this.snapshot.setParalelClause(SnapshotPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbParalelClause.getSelectedItem()));
            this.snapshot.setDegree(this.ifDegree.getIntValue());
            this.snapshot.setBuild((String)this.cbBuild.getSelectedItem());
            this.snapshot.setReducedPrecision(SnapshotPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbReducedPrecision.getSelectedItem()));
            this.snapshot.setOnPrebuildTable((TableProxyOracle)this.cbOnPrebuild.getSelectedItem());
            this.snapshot.setUseIndex(SnapshotPropertyDialogOraclev9i.translateNoneYesNoForStorage((String)this.cbUseIndex.getSelectedItem()));
            this.snapshot.setForUpdate(SnapshotPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbForUpdate.getSelectedItem()));
            this.snapshot.setQueryRewrite((String)this.cbQueryRewrite.getSelectedItem());
            this.snapshot.setTablespace((TableSpaceOracle)this.cbTablespace.getSelectedItem());
            this.snapshot.setIndexTablespace((TableSpaceOracle)this.cbIndexTablespace.getSelectedItem());
            this.snapshot.setIndexSegment((SegmentOracle)this.cbIndexStorage.getSelectedItem());
            this.snapshot.setLogging(SnapshotPropertyDialogOraclev9i.translateNoneYesNoForStorage((String)this.cbLogging.getSelectedItem()));
            this.snapshot.setCache(SnapshotPropertyDialogOraclev9i.translateNoneYesNoForStorage((String)this.cbCache.getSelectedItem()));
            this.snapshot.setSubquery(this.taBody.getText());
            this.snapshot.setClusterColumns(this.clusterColumnsBody.getText());
            Object selected = this.cbPartitioned.getSelectedItem();
            boolean result = String.valueOf(selected).equalsIgnoreCase(YES);
            if (result) {
                Object ts;
                int i;
                PartitionListOraclev9i partList = this.snapshot.getPartitionList() != null ? (PartitionListOraclev9i)this.snapshot.getPartitionList() : (PartitionListOraclev9i)this.getStorageDesign().getPartitionListSet().createPartitionList();
                partList.setPartitionType((String)this.cbPartType.getSelectedItem());
                partList.setHashPQuantity(this.ifHashPQuantity.getIntValue());
                partList.setSubPartitionsQuantity(this.ifSubPartQuantity.getIntValue());
                this.snapshot.setPartitionList(partList);
                partList.clear();
                this.snapshot.setColumns(this.taColumns.getText());
                Object[] tsSet = this.selectedHashPTSModel.toArray();
                for (i = 0; i < tsSet.length; ++i) {
                    ts = tsSet[i];
                    if (!(ts instanceof TableSpaceOracle)) continue;
                    partList.setHashPTableSpaces(((TableSpaceOracle)ts).getObjectID());
                }
                this.snapshot.setSubPartColumns(this.taSubPartColumns.getText());
                tsSet = this.selectedSubPartTSModel.toArray();
                for (i = 0; i < tsSet.length; ++i) {
                    ts = tsSet[i];
                    if (!(ts instanceof TableSpaceOracle)) continue;
                    partList.setSubPartitionsTableSpaces(((TableSpaceOracle)ts).getObjectID());
                }
            } else if (this.snapshot.getPartitionList() != null) {
                PartitionListOraclev9i partList = (PartitionListOraclev9i)this.snapshot.getPartitionList();
                this.snapshot.setPartitionList(null);
                partList.remove();
            }
            this.snapshot.setRefresh((String)this.cbRefresh.getSelectedItem());
            this.snapshot.setRefreshType((String)this.cbRefreshType.getSelectedItem());
            this.snapshot.setAction((String)this.cbAction.getSelectedItem());
            if (this.cbAction.getSelectedIndex() == 0) {
                this.snapshot.setStartDate(this.tfStartDate.getText());
                this.snapshot.setNextDate(this.tfNextDate.getText());
            }
            this.snapshot.setWith((String)this.cbWith.getSelectedItem());
            this.snapshot.setDefaultSegment(SnapshotPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbDefaultSegment.getSelectedItem()));
            this.snapshot.setSegmentType((String)this.cbSegmentType.getSelectedItem());
            this.snapshot.setRollbackSegment((RollbackSegmentOracle)this.cbRollbackSegment.getSelectedItem());
            this.snapshot.setComment(this.getCommentsList().getText());
            this.snapshot.setCommentInRDBMS(this.taCommentsInRDBMS.getText());
            this.snapshot.setNotes(this.taNotes.getText());
        }
    }

    @Override
    protected boolean allowName(String newName) {
        Object selectedUser = this.cbOwner.getSelectedItem();
        if (selectedUser instanceof UserOracle) {
            newName = ((UserOracle)selectedUser).getName() + "." + (String)newName;
        }
        return this.getStorageObject().allowName((String)newName, true);
    }

    protected int getMinimumWidth() {
        return this.minWidth;
    }

    protected int getMinimumHeight() {
        return this.mMinHeight;
    }

    private class RemoveSubPartTSActionListener
    implements ActionListener {
        private RemoveSubPartTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!SnapshotPropertyDialogOraclev9i.this.selectedSubPartTSModel.isEmpty()) {
                Object[] selectedObjects = SnapshotPropertyDialogOraclev9i.this.selectedSubPartTSList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (SnapshotPropertyDialogOraclev9i.this.allSubPartTSModel.contains(ob)) continue;
                    SnapshotPropertyDialogOraclev9i.this.allSubPartTSModel.addElement(ob);
                    SnapshotPropertyDialogOraclev9i.this.selectedSubPartTSModel.removeElement(ob);
                }
            }
        }
    }

    private class AddSubPartTSActionListener
    implements ActionListener {
        private AddSubPartTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!SnapshotPropertyDialogOraclev9i.this.allSubPartTSModel.isEmpty()) {
                Object[] selectedObjects = SnapshotPropertyDialogOraclev9i.this.allSubPartTSList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (SnapshotPropertyDialogOraclev9i.this.selectedSubPartTSModel.contains(ob)) continue;
                    SnapshotPropertyDialogOraclev9i.this.selectedSubPartTSModel.addElement(ob);
                    SnapshotPropertyDialogOraclev9i.this.allSubPartTSModel.removeElement(ob);
                }
            }
        }
    }

    private class SelectedSubPartTSListSelectionHandler
    implements ListSelectionListener {
        private SelectedSubPartTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (SnapshotPropertyDialogOraclev9i.this.isEditable() && !e.getValueIsAdjusting()) {
                if (SnapshotPropertyDialogOraclev9i.this.selectedSubPartTSList.getSelectedIndex() == -1) {
                    SnapshotPropertyDialogOraclev9i.this.bnRemoveSubPartTS.setEnabled(false);
                } else {
                    SnapshotPropertyDialogOraclev9i.this.bnRemoveSubPartTS.setEnabled(true);
                }
            }
        }
    }

    private class AllSubPartTSListSelectionHandler
    implements ListSelectionListener {
        private AllSubPartTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (SnapshotPropertyDialogOraclev9i.this.isEditable() && !e.getValueIsAdjusting()) {
                if (SnapshotPropertyDialogOraclev9i.this.allSubPartTSList.getSelectedIndex() == -1) {
                    SnapshotPropertyDialogOraclev9i.this.bnAddSubPartTS.setEnabled(false);
                } else {
                    SnapshotPropertyDialogOraclev9i.this.bnAddSubPartTS.setEnabled(true);
                }
            }
        }
    }

    private class PartitionedAction
    implements ActionListener {
        private PartitionedAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean partitioned = ((String)SnapshotPropertyDialogOraclev9i.this.cbPartitioned.getSelectedItem()).equalsIgnoreCase(AbstractPropertyDialog.YES);
            int partitionedTabIndex = SnapshotPropertyDialogOraclev9i.this.getPane().indexOfComponent(SnapshotPropertyDialogOraclev9i.this.pnPartitioning);
            if (partitionedTabIndex > -1) {
                SnapshotPropertyDialogOraclev9i.this.getPane().setEnabledAt(partitionedTabIndex, partitioned);
            }
            SnapshotPropertyDialogOraclev9i.this.setPartitioning(partitioned);
        }
    }

    private class RemoveHashPTSActionListener
    implements ActionListener {
        private RemoveHashPTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!SnapshotPropertyDialogOraclev9i.this.selectedHashPTSModel.isEmpty()) {
                Object[] selectedObjects = SnapshotPropertyDialogOraclev9i.this.selectedHashPTSList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (SnapshotPropertyDialogOraclev9i.this.allHashPTSModel.contains(ob)) continue;
                    SnapshotPropertyDialogOraclev9i.this.allHashPTSModel.addElement(ob);
                    SnapshotPropertyDialogOraclev9i.this.selectedHashPTSModel.removeElement(ob);
                }
            }
        }
    }

    private class AddHashPTSActionListener
    implements ActionListener {
        private AddHashPTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!SnapshotPropertyDialogOraclev9i.this.allHashPTSModel.isEmpty()) {
                Object[] selectedObjects = SnapshotPropertyDialogOraclev9i.this.allHashPTSList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (SnapshotPropertyDialogOraclev9i.this.selectedHashPTSModel.contains(ob)) continue;
                    SnapshotPropertyDialogOraclev9i.this.selectedHashPTSModel.addElement(ob);
                    SnapshotPropertyDialogOraclev9i.this.allHashPTSModel.removeElement(ob);
                }
            }
        }
    }

    private class SelectedHashPTSListSelectionHandler
    implements ListSelectionListener {
        private SelectedHashPTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (SnapshotPropertyDialogOraclev9i.this.isEditable() && !e.getValueIsAdjusting()) {
                if (SnapshotPropertyDialogOraclev9i.this.selectedHashPTSList.getSelectedIndex() == -1) {
                    SnapshotPropertyDialogOraclev9i.this.bnRemoveHashPTS.setEnabled(false);
                } else {
                    SnapshotPropertyDialogOraclev9i.this.bnRemoveHashPTS.setEnabled(true);
                }
            }
        }
    }

    private class AllHashPTSListSelectionHandler
    implements ListSelectionListener {
        private AllHashPTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (SnapshotPropertyDialogOraclev9i.this.isEditable() && !e.getValueIsAdjusting()) {
                if (SnapshotPropertyDialogOraclev9i.this.allHashPTSList.getSelectedIndex() == -1) {
                    SnapshotPropertyDialogOraclev9i.this.bnAddHashPTS.setEnabled(false);
                } else {
                    SnapshotPropertyDialogOraclev9i.this.bnAddHashPTS.setEnabled(true);
                }
            }
        }
    }

    private class PermissionsListener
    implements ActionListener {
        private PermissionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SnapshotPropertyDialogOraclev9i.this.dialog = new ObjectPermissionsDialogOracle(SnapshotPropertyDialogOraclev9i.this.getAppView(), SnapshotPropertyDialogOraclev9i.this.getStorageDesign(), SnapshotPropertyDialogOraclev9i.this.snapshot);
            SnapshotPropertyDialogOraclev9i.this.dialog.showDialog();
        }
    }

    private class PrebuildListener
    implements ActionListener {
        private PrebuildListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SnapshotPropertyDialogOraclev9i.this.cbOnPrebuild.getSelectedItem() != null && SnapshotPropertyDialogOraclev9i.this.cbOnPrebuild.getSelectedItem() instanceof TableProxyOraclev9i) {
                TableProxyOraclev9i table = (TableProxyOraclev9i)SnapshotPropertyDialogOraclev9i.this.cbOnPrebuild.getSelectedItem();
                SnapshotPropertyDialogOraclev9i.this.tfName.setText(table.getName());
                SnapshotPropertyDialogOraclev9i.this.tfName.setEnabled(false);
            } else {
                SnapshotPropertyDialogOraclev9i.this.tfName.setEnabled(true);
                SnapshotPropertyDialogOraclev9i.this.tfName.setText(SnapshotPropertyDialogOraclev9i.this.snapshot.getName());
            }
        }
    }

    private class ParallelListener
    implements ActionListener {
        private ParallelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SnapshotPropertyDialogOraclev9i.this.ifDegree.setEnabled(SnapshotPropertyDialogOraclev9i.this.cbParalelClause.getSelectedItem().equals(AbstractPropertyDialog.YES));
        }
    }
}

