/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v9i;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.TableViewProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableViewProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableViewProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.UserOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.PropertiesPropagationDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.editor.storage.oracle.ObjectPermissionsDialogOracle;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.string.StringUtilities;

public class TableViewPropertyDialogOraclev9i
extends AbstractOraclePropertyDialog {
    private TableViewProxyOraclev9i view;
    private JComboBox cbOwner;
    private JComboBox cbForce;
    private JComboBox cbReadOnly;
    private JComboBox cbCheckOption;
    private JComboBox cbEditioning;
    private JComboBox cbUseOid;
    private JTextField cbCheckOptionName;
    private JTextField tfOidAttributes;
    private JTextArea taDefinition;
    private String commentInRDBMS;
    private String comment;
    private JButton bnPermissions;
    private ObjectPermissionsDialogOracle dialog;

    public TableViewPropertyDialogOraclev9i(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.view = (TableViewProxyOraclev9i)object;
        this.setHeight(540);
        this.initCommentsView(230);
        this.initCommentsInRDBMS(230);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initOwner();
        this.initCheckOption(80);
        this.initForce(110);
        this.initReadOnly(140);
        int ycoord = 170;
        if (this.storageDesign instanceof StorageDesignOraclev11g) {
            this.initEditioning(ycoord);
            ycoord = 200;
        }
        this.initUseOID(ycoord);
        this.initOIDAttributes(ycoord + 30);
        this.initCheckOptionName(ycoord + 60);
        this.initDefinition(ycoord + 90);
        if (this.isEditable()) {
            this.initPropagatePropsButton(ycoord + 280);
        }
        this.initPermissionsButton(ycoord + 280);
    }

    private void initOwner() {
        JLabel label = new JLabel(Messages.getString("TableViewPropertyDialogOraclev9i.User"));
        this.general.add(label);
        this.cbOwner = new JComboBox();
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getUserSet().toArray(), this.cbOwner);
        }
        this.cbOwner.removeItem(this.getStorageDesign().getUserSet().getByName("PUBLIC"));
        this.setBG(this.cbOwner);
        this.cbOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOwner);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbOwner, 50);
    }

    private void initCheckOption(int ycoord) {
        JLabel label = new JLabel(Messages.getString("TableViewPropertyDialogOraclev9i.CheckOption"));
        this.general.add(label);
        this.cbCheckOption = new JComboBox<String>(YES_NO);
        this.setBG(this.cbCheckOption);
        this.cbCheckOption.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCheckOption);
        this.setLabelConstraints(label, ycoord);
        this.setObjectConstraints(this.cbCheckOption, ycoord);
    }

    private void initForce(int ycoord) {
        JLabel label = new JLabel(Messages.getString("TableViewPropertyDialogOraclev9i.Force"));
        this.general.add(label);
        this.cbForce = new JComboBox<String>(YES_NO);
        this.setBG(this.cbForce);
        this.cbForce.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbForce);
        this.setLabelConstraints(label, ycoord);
        this.setObjectConstraints(this.cbForce, ycoord);
    }

    private void initReadOnly(int ycoord) {
        JLabel label = new JLabel(Messages.getString("TableViewPropertyDialogOraclev9i.ReadOnly"));
        this.general.add(label);
        this.cbReadOnly = new JComboBox<String>(YES_NO);
        this.setBG(this.cbReadOnly);
        this.cbReadOnly.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbReadOnly);
        this.setLabelConstraints(label, ycoord);
        this.setObjectConstraints(this.cbReadOnly, ycoord);
    }

    private void initEditioning(int ycoord) {
        JLabel label = new JLabel(Messages.getString("TableViewPropertyDialogOraclev9i.Editioning"));
        this.general.add(label);
        this.cbEditioning = new JComboBox<String>(YES_NO);
        this.setBG(this.cbEditioning);
        this.cbEditioning.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbEditioning);
        this.setLabelConstraints(label, ycoord);
        this.setObjectConstraints(this.cbEditioning, ycoord);
    }

    private void initUseOID(int ycoord) {
        JLabel label = new JLabel(Messages.getString("TableViewPropertyDialogOraclev9i.UseOID"));
        this.general.add(label);
        this.cbUseOid = new JComboBox<String>(TableViewProxyOracle.USE_OID_CHOICES);
        this.setBG(this.cbUseOid);
        this.cbUseOid.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbUseOid);
        this.setLabelConstraints(label, ycoord);
        this.setObjectConstraints(this.cbUseOid, ycoord);
    }

    private void initOIDAttributes(int ycoord) {
        JLabel label = new JLabel(Messages.getString("TableViewPropertyDialogOraclev9i.OIDAttributes"));
        this.general.add(label);
        this.tfOidAttributes = new JTextField();
        this.setBG(this.tfOidAttributes);
        this.tfOidAttributes.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.tfOidAttributes);
        this.setLabelConstraints(label, ycoord);
        this.setObjectConstraints(this.tfOidAttributes, ycoord);
    }

    private void initCheckOptionName(int ycoord) {
        JLabel label = new JLabel(Messages.getString("TableViewPropertyDialogOraclev9i.CheckOptionName"));
        this.general.add(label);
        this.cbCheckOptionName = new JTextField();
        this.setBG(this.cbCheckOptionName);
        this.cbCheckOptionName.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCheckOptionName);
        this.setLabelConstraints(label, ycoord);
        this.setObjectConstraints(this.cbCheckOptionName, ycoord);
    }

    private void initDefinition(int ycoord) {
        JLabel bodyLabel = new JLabel(Messages.getString("TableViewPropertyDialogOraclev9i.Definition"));
        this.general.add(bodyLabel);
        this.setLabelConstraints(bodyLabel, ycoord);
        this.taDefinition = new JTextArea();
        JScrollPane sp = new JScrollPane(this.taDefinition);
        sp.setPreferredSize(new Dimension(395, 150));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.taDefinition.setLineWrap(true);
        this.general.add(sp);
        this.setObjectConstraints(sp, 10, ycoord + 20);
    }

    private void initPropagatePropsButton(int yCoord) {
        JButton bnPropagateProps = new JButton(Messages.getString("TablePropertyDialogOracle.PropagateProperties"));
        bnPropagateProps.setIcon(this.getAppView().getConfiguration().getIcon("PROPS_PROPAGATION", 16));
        bnPropagateProps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList list = new ArrayList();
                list.addAll(TableViewPropertyDialogOraclev9i.this.getStorageDesign().getTableViewProxySet().getElements());
                list.remove(TableViewPropertyDialogOraclev9i.this.view);
                new PropertiesPropagationDialog(TableViewPropertyDialogOraclev9i.this.getAppView(), TableViewPropertyDialogOraclev9i.this.view, list).showDialog();
            }
        });
        this.general.add(bnPropagateProps);
        this.setObjectConstraints(bnPropagateProps, 10, yCoord);
    }

    private void initPermissionsButton(int ycoord) {
        this.bnPermissions = new JButton(Messages.getString("TableViewPropertyDialogOraclev9i.Permissions"));
        this.bnPermissions.setIcon(this.getAppView().getConfiguration().getIcon("PERMISSIONS_ICON", 16));
        this.bnPermissions.addActionListener(new PermissionsListener());
        this.general.add(this.bnPermissions);
        this.setObjectConstraints(this.bnPermissions, 270, ycoord);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.view.getName());
        this.tfName.setText(this.view.getName());
        this.cbOwner.setSelectedItem(this.view.getUser());
        this.cbForce.setSelectedItem(TableViewPropertyDialogOraclev9i.translateYesNoForDisplay(this.view.getForce()));
        this.cbReadOnly.setSelectedItem(TableViewPropertyDialogOraclev9i.translateYesNoForDisplay(this.view.getReadOnly()));
        if (this.storageDesign instanceof StorageDesignOraclev11g) {
            this.cbEditioning.setSelectedItem(TableViewPropertyDialogOraclev9i.translateYesNoForDisplay(((TableViewProxyOraclev10g)this.view).getEditioning()));
        }
        this.cbUseOid.setSelectedItem(this.view.getUseOID());
        this.tfOidAttributes.setText(this.view.getOidAttributes());
        this.tfOidAttributes.setEnabled(false);
        this.cbCheckOptionName.setText(this.view.getCheckOptionName());
        if (this.view.getCheckOption()) {
            this.cbCheckOption.setSelectedItem(YES);
        } else {
            this.cbCheckOption.setSelectedItem(NO);
        }
        this.taDefinition.setText(this.view.getDefinition());
        this.comment = this.view.getObject().getComment();
        this.commentInRDBMS = this.view.getObject().getCommentInRDBMS();
        if (this.view.isCommentChanged()) {
            this.getCommentsList().insert(this.view.getComment(), 0);
        } else {
            this.getCommentsList().insert(this.comment, 0);
        }
        if (this.view.isCommentInRDBMSChanged()) {
            this.taCommentsInRDBMS.insert(this.view.getCommentInRDBMS(), 0);
        } else {
            this.taCommentsInRDBMS.insert(this.commentInRDBMS, 0);
        }
    }

    @Override
    protected void setProperties() {
        if (this.view != null) {
            this.view.setName(this.tfName.getText());
            this.view.setUser((UserOraclev9i)this.cbOwner.getSelectedItem());
            this.view.setForce(TableViewPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbForce.getSelectedItem()));
            this.view.setReadOnly(TableViewPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbReadOnly.getSelectedItem()));
            if (this.storageDesign instanceof StorageDesignOraclev11g) {
                ((TableViewProxyOraclev10g)this.view).setEditioning(TableViewPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbEditioning.getSelectedItem()));
            }
            this.view.setUseOID((String)this.cbUseOid.getSelectedItem());
            this.view.setCheckOptionName(this.cbCheckOptionName.getText());
            if (((String)this.cbCheckOption.getSelectedItem()).equalsIgnoreCase(YES)) {
                this.view.setCheckOption(true);
            } else {
                this.view.setCheckOption(false);
            }
            this.view.setDefinition(this.taDefinition.getText());
            String commentText = this.getCommentsList().getText();
            if (StringUtilities.isNotEmpty(commentText) && !this.comment.equals(commentText)) {
                this.view.setComment(commentText);
                this.view.setCommentChanged(true);
            } else {
                this.view.setComment("");
                this.view.setCommentChanged(false);
            }
            String commentInRDBMSText = this.taCommentsInRDBMS.getText();
            if (StringUtilities.isNotEmpty(commentInRDBMSText) && !this.commentInRDBMS.equals(commentInRDBMSText)) {
                this.view.setCommentInRDBMS(commentInRDBMSText);
                this.view.setCommentInRDBMSChanged(true);
            } else {
                this.view.setCommentInRDBMS("");
                this.view.setCommentInRDBMSChanged(false);
            }
        }
    }

    private class PermissionsListener
    implements ActionListener {
        private PermissionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TableViewPropertyDialogOraclev9i.this.dialog = new ObjectPermissionsDialogOracle(TableViewPropertyDialogOraclev9i.this.getAppView(), TableViewPropertyDialogOraclev9i.this.getStorageDesign(), TableViewPropertyDialogOraclev9i.this.view);
            TableViewPropertyDialogOraclev9i.this.dialog.showDialog();
        }
    }
}

