/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.sqlserver.DefaultSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.ColumnProxySqlServerv2k;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.AbstractSqlServerPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.gui.swing.JNumericField;
import oracle.dbtools.crest.util.string.StringUtilities;

public class ColumnProxyPropertyDialogSqlServer
extends AbstractSqlServerPropertyDialog {
    private static final int MAX_DIGITS = 31;
    private ColumnProxySqlServerv2k column;
    private String comment = "";
    private String commentInRDBMS = "";
    private String formula = "";
    private boolean computed = false;
    private JTextField tfDataType;
    private JTextField tfBelongsToPK;
    private JTextField tfNullsAllowed;
    private JTextField tfDefaultValue;
    private JTextField tfFormula;
    private JTextField tfCollation;
    private JTextField tfIdentitySeed;
    private JIntegerField ifIdentityIncrement;
    private JCheckBox chbDefineDefault;
    private JCheckBox chbAsIdentity;
    private JCheckBox chbComputed;
    private JComboBox cbDefaultObject;
    private JComboBox cbIdentityForReplication;
    private JComboBox cbRowGuidCol;
    private ExtPropertiesModel model;
    private JPanel panelExtProperties;
    private JTable extProperties;
    private JButton bnAddProperty;
    private JButton bnRemoveProperty;
    private String startWith;
    private Integer incrementBy;
    private boolean asIdentity;

    public ColumnProxyPropertyDialogSqlServer(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.column = (ColumnProxySqlServerv2k)object;
        this.setHeight(520);
        this.initCommentsView(220);
        this.initCommentsInRDBMS(220);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("ColumnProxyPropertyDialogSqlServer.ColumnProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initDataType();
        this.initBelongsToPK();
        this.initNullsAllowed();
        this.initDefineDefault();
        this.initDefaultValue();
        this.initDefaultObject();
        this.initAsIdentity();
        this.initIdentitySeed();
        this.initIdentityIncrement();
        this.initIdentityForReplication();
        this.initRowGuidCol();
        this.initComputed();
        this.initFormula();
        this.initCollation();
    }

    private void initDataType() {
        JLabel label = new JLabel(Messages.getString("ColumnProxyPropertyDialogSqlServer.DataType"));
        this.general.add(label);
        this.tfDataType = new JTextField("", 26);
        this.tfDataType.setEnabled(false);
        this.general.add(this.tfDataType);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.tfDataType, 50);
    }

    private void initBelongsToPK() {
        JLabel label = new JLabel(Messages.getString("ColumnProxyPropertyDialogSqlServer.BelongsToPK"));
        this.general.add(label);
        this.tfBelongsToPK = new JTextField("", 26);
        this.tfBelongsToPK.setEnabled(false);
        this.general.add(this.tfBelongsToPK);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.tfBelongsToPK, 80);
    }

    private void initNullsAllowed() {
        JLabel label = new JLabel(Messages.getString("ColumnProxyPropertyDialogSqlServer.NullsAllowed"));
        this.general.add(label);
        this.tfNullsAllowed = new JTextField("", 26);
        this.tfNullsAllowed.setEnabled(false);
        this.general.add(this.tfNullsAllowed);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.tfNullsAllowed, 110);
    }

    private void initRowGuidCol() {
        JLabel label = new JLabel(Messages.getString("ColumnProxyPropertyDialogSqlServer.ROWGIUDCOL"));
        this.general.add(label);
        this.cbRowGuidCol = new JComboBox<String>(YES_NO);
        this.setBG(this.cbRowGuidCol);
        this.cbRowGuidCol.setPreferredSize(this.tfDataType.getPreferredSize());
        this.general.add(this.cbRowGuidCol);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.cbRowGuidCol, 140);
    }

    private void initDefineDefault() {
        this.chbDefineDefault = new JCheckBox(Messages.getString("ColumnProxyPropertyDialogSqlServer.UseDefaultObject"));
        this.chbDefineDefault.addActionListener(new DefaultListener());
        this.general.add(this.chbDefineDefault);
        this.setObjectConstraints(this.chbDefineDefault, 8, 170);
    }

    private void initDefaultValue() {
        JLabel label = new JLabel(Messages.getString("ColumnProxyPropertyDialogSqlServer.DefaultValue"));
        this.general.add(label);
        this.tfDefaultValue = new JTextField("", 26);
        this.general.add(this.tfDefaultValue);
        this.setLabelConstraints(label, 200);
        this.setObjectConstraints(this.tfDefaultValue, 200);
    }

    private void initDefaultObject() {
        JLabel label = new JLabel(Messages.getString("ColumnProxyPropertyDialogSqlServer.DefaultObject"));
        this.general.add(label);
        this.cbDefaultObject = new JComboBox();
        this.setBG(this.cbDefaultObject);
        this.cbDefaultObject.setPreferredSize(this.tfDataType.getPreferredSize());
        this.general.add(this.cbDefaultObject);
        this.setLabelConstraints(label, 230);
        this.setObjectConstraints(this.cbDefaultObject, 230);
    }

    private void initAsIdentity() {
        this.chbAsIdentity = new JCheckBox(Messages.getString("ColumnProxyPropertyDialogSqlServer.AsIdentity"));
        this.chbAsIdentity.addActionListener(new IdentityListener());
        this.general.add(this.chbAsIdentity);
        this.setObjectConstraints(this.chbAsIdentity, 8, 270);
    }

    private void initIdentitySeed() {
        JLabel label = new JLabel(Messages.getString("ColumnProxyPropertyDialogSqlServer.IdentitySeed"));
        this.general.add(label);
        this.tfIdentitySeed = new JNumericField(31, 26);
        this.general.add(this.tfIdentitySeed);
        this.setLabelConstraints(label, 300);
        this.setObjectConstraints(this.tfIdentitySeed, 300);
    }

    private void initIdentityIncrement() {
        JLabel label = new JLabel(Messages.getString("ColumnProxyPropertyDialogSqlServer.IdentityIncrement"));
        this.general.add(label);
        this.ifIdentityIncrement = new JIntegerField(0, 26);
        this.general.add(this.ifIdentityIncrement);
        this.setLabelConstraints(label, 330);
        this.setObjectConstraints(this.ifIdentityIncrement, 330);
    }

    private void initIdentityForReplication() {
        JLabel label = new JLabel(Messages.getString("ColumnProxyPropertyDialogSqlServer.IdentityForRepl"));
        this.general.add(label);
        this.cbIdentityForReplication = new JComboBox<String>(YES_NO);
        this.setBG(this.cbIdentityForReplication);
        this.cbIdentityForReplication.setPreferredSize(this.tfDataType.getPreferredSize());
        this.general.add(this.cbIdentityForReplication);
        this.setLabelConstraints(label, 360);
        this.setObjectConstraints(this.cbIdentityForReplication, 360);
    }

    private void initComputed() {
        this.chbComputed = new JCheckBox(Messages.getString("ColumnProxyPropertyDialogSqlServer.Computed"));
        this.chbComputed.addActionListener(new ComputedListener());
        this.general.add(this.chbComputed);
        this.setObjectConstraints(this.chbComputed, 8, 390);
    }

    private void initFormula() {
        JLabel label = new JLabel(Messages.getString("ColumnProxyPropertyDialogSqlServer.Formula"));
        this.general.add(label);
        this.tfFormula = new JTextField("", 26);
        this.general.add(this.tfFormula);
        this.setLabelConstraints(label, 420);
        this.setObjectConstraints(this.tfFormula, 420);
    }

    private void initCollation() {
        JLabel label = new JLabel(Messages.getString("ColumnProxyPropertyDialogSqlServer.Collation"));
        this.general.add(label);
        this.tfCollation = new JTextField("", 26);
        this.general.add(this.tfCollation);
        this.setLabelConstraints(label, 450);
        this.setObjectConstraints(this.tfCollation, 450);
    }

    @Override
    protected void addTabs() {
        this.initExtProperties();
    }

    protected SpringLayout getExtPropertiesLayout() {
        return (SpringLayout)this.panelExtProperties.getLayout();
    }

    private void initExtProperties() {
        this.initAllExtProperties();
        this.initExtPropertiesButtons();
    }

    private void initExtPropertiesButtons() {
        this.bnAddProperty = new JButton(Messages.getString("ColumnProxyPropertyDialogSqlServer.Add"));
        this.bnAddProperty.setEnabled(this.isEditable());
        this.bnRemoveProperty = new JButton(Messages.getString("ColumnProxyPropertyDialogSqlServer.Remove"));
        this.bnRemoveProperty.setEnabled(this.isEditable());
        this.bnAddProperty.addActionListener(new AddExtPropertyActionListener());
        this.panelExtProperties.add(this.bnAddProperty);
        this.setObjectConstraints(this.getExtPropertiesLayout(), this.bnAddProperty, 5, 463);
        this.bnRemoveProperty.addActionListener(new RemoveExtPropertyActionListener());
        this.panelExtProperties.add(this.bnRemoveProperty);
        this.setObjectConstraints(this.getExtPropertiesLayout(), this.bnRemoveProperty, 70, 463);
        ColumnProxyPropertyDialogSqlServer.equalizeButtonSizes(this.bnAddProperty, this.bnRemoveProperty);
    }

    private void initAllExtProperties() {
        this.panelExtProperties = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("ColumnProxyPropertyDialogSqlServer.ExtendedProperties"), this.panelExtProperties);
        this.extProperties = new ExtProperties();
        this.extProperties.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.extProperties.setPreferredScrollableViewportSize(new Dimension(416, 457));
        JScrollPane pane = new JScrollPane(this.extProperties);
        pane.setPreferredSize(new Dimension(416, 459));
        this.model = (ExtPropertiesModel)this.extProperties.getModel();
        this.setBG(this.extProperties);
        this.panelExtProperties.add(pane);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.column.getName());
        this.tfName.setText(this.column.getName());
        this.tfDataType.setText(this.column.getDatatypeString());
        this.tfBelongsToPK.setText(this.column.belongsToPK() ? YES : NO);
        this.tfNullsAllowed.setText(this.column.getNullsAllowed() ? YES : NO);
        this.tfDefaultValue.setText(this.column.getDefaultValue());
        this.cbDefaultObject.setSelectedItem(this.column.getDefaultObject());
        this.chbDefineDefault.setSelected(this.column.getDefineDefault());
        this.chbDefineDefault.setEnabled(this.column.getDefineDefault() || !this.column.getAsIdentity() && !this.column.getComputed());
        this.tfDefaultValue.setEnabled(!this.column.getDefineDefault());
        this.cbDefaultObject.setEnabled(this.column.getDefineDefault());
        if (this.column.getTableProxy().getDatabase() != null) {
            for (DefaultSqlServer def : (StorageObjectCollection)this.column.getTableProxy().getDatabase().getChild(2)) {
                this.cbDefaultObject.addItem(def);
            }
        }
        this.initColumnIdentityProperties();
        this.cbRowGuidCol.setSelectedItem(ColumnProxyPropertyDialogSqlServer.translateYesNoForDisplay(this.column.getRowGuidCol()));
        if (this.column.getDataTypeName().equalsIgnoreCase("uniqueidentifier") && !this.column.getTableProxy().existRowGuidColUniqueID(this.column)) {
            this.cbRowGuidCol.setEnabled(true);
        } else {
            this.cbRowGuidCol.setEnabled(false);
        }
        this.computed = this.column.getComputed();
        this.chbComputed.setSelected(this.computed);
        this.chbComputed.setEnabled(this.computed || !this.column.getDefineDefault() && !this.column.getAsIdentity());
        this.formula = this.column.getFormula();
        this.tfFormula.setText(this.formula);
        this.tfCollation.setText(this.column.getCollation());
        if (this.column.getExtPropsSet() != null) {
            Object[] props = this.column.getExtPropsSet().toArray();
            for (int i = 0; i < props.length; ++i) {
                String p = (String)props[i];
                String pplus = (String)props[++i];
                Object[] obj = new Object[]{p, pplus};
                this.model.addRow(obj);
            }
        }
        this.comment = this.column.getObject().getComment();
        this.commentInRDBMS = this.column.getObject().getCommentInRDBMS();
        if (this.column.isCommentChanged()) {
            this.getCommentsList().insert(this.column.getComment(), 0);
        } else {
            this.getCommentsList().insert(this.comment, 0);
        }
        if (this.column.isCommentInRDBMSChanged()) {
            this.getCommentsInRDBMSList().insert(this.column.getCommentInRDBMS(), 0);
        } else {
            this.getCommentsInRDBMSList().insert(this.commentInRDBMS, 0);
        }
    }

    protected void initColumnIdentityProperties() {
        Column columnObject = (Column)this.column.getObject();
        this.startWith = columnObject.getAutoIncrementStartWith();
        this.incrementBy = columnObject.getAutoIncrementIncrementBy();
        this.asIdentity = columnObject.isIdentityColumn();
        if (this.column.isAsIdentityChanged()) {
            this.chbAsIdentity.setSelected(this.column.getAsIdentity());
            this.chbAsIdentity.setEnabled(this.column.getAsIdentity() || !this.column.getDefineDefault() && !this.column.getComputed());
        } else {
            this.chbAsIdentity.setSelected(this.asIdentity);
            this.chbAsIdentity.setEnabled(this.asIdentity || !this.column.getDefineDefault() && !this.column.getComputed());
        }
        if (!this.column.isAsIdentityChanged() && !this.asIdentity) {
            this.chbAsIdentity.setEnabled(false);
        }
        if (this.column.isStartWithChanged()) {
            this.tfIdentitySeed.setText(this.column.getIdentitySeed());
        } else {
            this.tfIdentitySeed.setText(this.startWith);
        }
        if (this.column.isIncrementByChanged()) {
            this.ifIdentityIncrement.setValue((long)this.column.getIdentityIncrement());
        } else {
            this.ifIdentityIncrement.setValue(this.incrementBy);
        }
        this.cbIdentityForReplication.setSelectedItem(ColumnProxyPropertyDialogSqlServer.translateYesNoForDisplay(this.column.getIdentityForReplication()));
        this.tfIdentitySeed.setEnabled(this.column.getAsIdentity());
        this.ifIdentityIncrement.setEnabled(this.column.getAsIdentity());
        this.cbIdentityForReplication.setEnabled(this.column.getAsIdentity());
    }

    @Override
    protected void setProperties() {
        if (this.column != null) {
            this.column.setName(this.tfName.getText());
            this.column.setDefineDefault(this.chbDefineDefault.isSelected());
            this.column.setDefaultValue(this.tfDefaultValue.getText());
            this.column.setDefaultObject((DefaultSqlServer)this.cbDefaultObject.getSelectedItem());
            this.setColumnIdentityProperties();
            this.column.setRowGuidCol(ColumnProxyPropertyDialogSqlServer.translateYesNoForStorage((String)this.cbRowGuidCol.getSelectedItem()));
            if (this.chbComputed.isSelected() != this.computed) {
                this.column.setComputed(this.chbComputed.isSelected());
                this.column.setComputedChanged(true);
            }
            if (!this.tfFormula.getText().equals(this.formula)) {
                this.column.setFormula(this.tfFormula.getText());
                this.column.setFormulaChanged(true);
            }
            this.column.setCollation(this.tfCollation.getText());
            Object[] propSet = this.model.getRows();
            this.column.clear();
            String name = null;
            String value = null;
            for (int i = 0; i < propSet.length; ++i) {
                Object pr = propSet[i];
                if (!(pr instanceof String)) continue;
                StringTokenizer st = new StringTokenizer(pr.toString(), ",");
                if (st.hasMoreTokens()) {
                    name = st.nextToken().trim();
                }
                if (!st.hasMoreTokens()) continue;
                value = st.nextToken().trim();
                this.column.setProps(name);
                this.column.setProps(value);
            }
            String commentText = this.getCommentsList().getText();
            if (StringUtilities.isNotEmpty(commentText) && !this.comment.equals(commentText)) {
                this.column.setComment(commentText);
                this.column.setCommentChanged(true);
            } else {
                this.column.setComment("");
                this.column.setCommentChanged(false);
            }
            String commentInRDBMSText = this.taCommentsInRDBMS.getText();
            if (StringUtilities.isNotEmpty(commentInRDBMSText) && !this.commentInRDBMS.equals(commentInRDBMSText)) {
                this.column.setCommentInRDBMS(commentInRDBMSText);
                this.column.setCommentInRDBMSChanged(true);
            } else {
                this.column.setCommentInRDBMS("");
                this.column.setCommentInRDBMSChanged(false);
            }
        }
    }

    private void setColumnIdentityProperties() {
        if (this.asIdentity != this.chbAsIdentity.isSelected()) {
            this.column.setAsIdentity(this.chbAsIdentity.isSelected());
            this.column.setAsIdentityChanged(true);
        } else {
            this.column.setAsIdentityChanged(false);
        }
        if (this.notEquals(this.startWith, this.tfIdentitySeed)) {
            this.column.setIdentitySeed(this.tfIdentitySeed.getText());
            this.column.setStartWithChanged(true);
        } else {
            this.column.setStartWithChanged(false);
        }
        if (this.notEquals(this.incrementBy, this.ifIdentityIncrement)) {
            this.column.setIdentityIncrement(this.ifIdentityIncrement.getIntValue());
            this.column.setIncrementByChanged(true);
        } else {
            this.column.setIncrementByChanged(false);
        }
        this.column.setIdentityForReplication(ColumnProxyPropertyDialogSqlServer.translateYesNoForStorage((String)this.cbIdentityForReplication.getSelectedItem()));
    }

    private class RemoveExtPropertyActionListener
    implements ActionListener {
        private RemoveExtPropertyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ColumnProxyPropertyDialogSqlServer.this.model.getRowCount() >= 1) {
                for (int i = ColumnProxyPropertyDialogSqlServer.this.model.getRowCount() - 1; i >= 0; --i) {
                    if (!ColumnProxyPropertyDialogSqlServer.this.extProperties.isRowSelected(i)) continue;
                    ColumnProxyPropertyDialogSqlServer.this.model.removeRow(i);
                }
                ColumnProxyPropertyDialogSqlServer.this.extProperties.updateUI();
            }
        }
    }

    private class AddExtPropertyActionListener
    implements ActionListener {
        private AddExtPropertyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String propertyName = "";
            String propertyValue = "";
            ColumnProxyPropertyDialogSqlServer.this.model.addRow(new Object[]{propertyName, propertyValue});
            ColumnProxyPropertyDialogSqlServer.this.extProperties.updateUI();
            ColumnProxyPropertyDialogSqlServer.this.extProperties.changeSelection(ColumnProxyPropertyDialogSqlServer.this.model.getRowCount() - 1, 0, false, false);
            ColumnProxyPropertyDialogSqlServer.this.extProperties.requestFocus();
        }
    }

    class ExtPropertiesCellRenderer
    extends JLabel
    implements TableCellRenderer {
        ExtPropertiesCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setOpaque(true);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            this.setHorizontalAlignment(2);
            this.setText((String)(value == null ? "" : "  " + value.toString()));
            return this;
        }
    }

    class ExtProperties
    extends JTable {
        ExtPropertiesModel dataModel;

        public ExtProperties() {
            this.dataModel = new ExtPropertiesModel();
            this.setModel(this.dataModel);
            TableColumnModel tableColumn = this.getColumnModel();
            for (int i = 0; i < 2; ++i) {
                tableColumn.getColumn(i).setCellRenderer(new ExtPropertiesCellRenderer());
            }
            this.initColumnSizes();
        }

        public void clearTable() {
            int rows = this.dataModel.getRowCount();
            for (int i = rows - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        private void initColumnSizes() {
            TableColumn column = null;
            for (int i = 0; i < 2; ++i) {
                column = this.getColumnModel().getColumn(i);
                if (i == 0) {
                    column.setPreferredWidth(50);
                    continue;
                }
                if (i != 1) continue;
                column.setPreferredWidth(150);
            }
        }
    }

    class ExtPropertiesModel
    extends DefaultTableModel {
        String[] cNames = new String[]{Messages.getString("ColumnProxyPropertyDialogSqlServer.PropertyName"), Messages.getString("ColumnProxyPropertyDialogSqlServer.PropertyValue")};

        ExtPropertiesModel() {
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return ColumnProxyPropertyDialogSqlServer.this.isEditable();
        }

        @Override
        public String getColumnName(int column) {
            return this.cNames[column];
        }

        @Override
        public int getColumnCount() {
            return this.cNames.length;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        public void setData(Vector data) {
            this.dataVector = data;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public Object[] getColumnData(int column) {
            int rowCount = ColumnProxyPropertyDialogSqlServer.this.model.getRowCount();
            Object[] data = new Object[rowCount];
            for (int i = 0; i < rowCount; ++i) {
                data[i] = this.getValueAt(i, column);
            }
            return data;
        }

        public Object[] getPropertyNameColumn() {
            int rowCount = ColumnProxyPropertyDialogSqlServer.this.model.getRowCount();
            Object[] data = new Object[rowCount];
            return data;
        }

        public Object[] getRows() {
            int rowCount = ColumnProxyPropertyDialogSqlServer.this.model.getRowCount();
            Object[] data = new Object[rowCount];
            for (int i = 0; i < rowCount; ++i) {
                String couple = (String)this.getValueAt(i, 0) + "," + (String)this.getValueAt(i, 1);
                data[i] = couple;
            }
            return data;
        }

        public Object[] getPropertyValueColumn() {
            int rowCount = ColumnProxyPropertyDialogSqlServer.this.model.getRowCount();
            Object[] data = new Object[rowCount];
            for (int i = 0; i < rowCount; ++i) {
                if (this.getValueAt(i, 2) == null || ((String)this.getValueAt(i, 2)).trim().equalsIgnoreCase("")) continue;
                data[i] = this.getValueAt(i, 2);
            }
            return data;
        }

        public void tableChanged(TableModelEvent e) {
            this.fireTableChanged(e);
        }
    }

    private class ComputedListener
    implements ActionListener {
        private ComputedListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ColumnProxyPropertyDialogSqlServer.this.chbDefineDefault.setEnabled(!ColumnProxyPropertyDialogSqlServer.this.chbComputed.isSelected());
            ColumnProxyPropertyDialogSqlServer.this.chbAsIdentity.setEnabled(!ColumnProxyPropertyDialogSqlServer.this.chbComputed.isSelected());
        }
    }

    private class IdentityListener
    implements ActionListener {
        private IdentityListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ColumnProxyPropertyDialogSqlServer.this.tfIdentitySeed.setEnabled(ColumnProxyPropertyDialogSqlServer.this.chbAsIdentity.isSelected());
            ColumnProxyPropertyDialogSqlServer.this.ifIdentityIncrement.setEnabled(ColumnProxyPropertyDialogSqlServer.this.chbAsIdentity.isSelected());
            ColumnProxyPropertyDialogSqlServer.this.cbIdentityForReplication.setEnabled(ColumnProxyPropertyDialogSqlServer.this.chbAsIdentity.isSelected());
            ColumnProxyPropertyDialogSqlServer.this.chbDefineDefault.setEnabled(!ColumnProxyPropertyDialogSqlServer.this.chbAsIdentity.isSelected());
            ColumnProxyPropertyDialogSqlServer.this.chbComputed.setEnabled(!ColumnProxyPropertyDialogSqlServer.this.chbAsIdentity.isSelected());
        }
    }

    private class DefaultListener
    implements ActionListener {
        private DefaultListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ColumnProxyPropertyDialogSqlServer.this.tfDefaultValue.setEnabled(!ColumnProxyPropertyDialogSqlServer.this.chbDefineDefault.isSelected());
            ColumnProxyPropertyDialogSqlServer.this.cbDefaultObject.setEnabled(ColumnProxyPropertyDialogSqlServer.this.chbDefineDefault.isSelected());
            ColumnProxyPropertyDialogSqlServer.this.chbAsIdentity.setEnabled(!ColumnProxyPropertyDialogSqlServer.this.chbDefineDefault.isSelected());
            ColumnProxyPropertyDialogSqlServer.this.chbComputed.setEnabled(!ColumnProxyPropertyDialogSqlServer.this.chbDefineDefault.isSelected());
        }
    }
}

