/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver.v2k5;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.border.LineBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.LoginSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.AbstractSqlServerPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class LoginPropertyDialogSqlServerv2k5
extends AbstractSqlServerPropertyDialog {
    private LoginSqlServer login;
    private JComboBox cbAuthentication;
    private JComboBox cbDataBase;
    private JPasswordField passField;
    private JTextField tfLanguage;
    private JPanel pDBAccess;
    private JTable table;
    private UsersTableModel model;

    public LoginPropertyDialogSqlServerv2k5(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.login = (LoginSqlServer)object;
        this.setHeight(200);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("LoginPropertyDialogSqlServerv2k5.LoginProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initAuthentication();
        this.initPassword();
        this.initDefaultDatabase();
        this.initDefaultLanguage();
    }

    @Override
    protected void addTabs() {
        this.initDBAccessView();
    }

    private void initDBAccessView() {
        this.pDBAccess = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("LoginPropertyDialogSqlServerv2k5.DatabAseAccess"), this.pDBAccess);
        this.table = new UsersTable();
        this.table.setPreferredScrollableViewportSize(new Dimension(398, 142));
        JScrollPane pane = new JScrollPane(this.table);
        this.model = (UsersTableModel)this.table.getModel();
        this.setBG(this.table);
        this.pDBAccess.add(pane);
    }

    private void initAuthentication() {
        JLabel label = new JLabel(Messages.getString("LoginPropertyDialogSqlServerv2k5.Authentication"));
        this.general.add(label);
        this.cbAuthentication = new JComboBox<String>(LoginSqlServer.AUTH_CHOICES);
        this.setBG(this.cbAuthentication);
        this.cbAuthentication.setPreferredSize(this.tfName.getPreferredSize());
        this.cbAuthentication.addActionListener(new AuthenticationListener());
        this.general.add(this.cbAuthentication);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbAuthentication, 50);
    }

    private void initPassword() {
        JLabel label = new JLabel(Messages.getString("LoginPropertyDialogSqlServer.Password"));
        this.general.add(label);
        this.passField = new JPasswordField();
        this.setBG(this.passField);
        this.passField.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.passField);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.passField, 80);
    }

    private void initDefaultDatabase() {
        JLabel label = new JLabel(Messages.getString("LoginPropertyDialogSqlServerv2k5.DefaultDB"));
        this.general.add(label);
        this.cbDataBase = new JComboBox();
        this.setBG(this.cbDataBase);
        this.cbDataBase.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDataBase);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.cbDataBase, 110);
    }

    private void initDefaultLanguage() {
        JLabel label = new JLabel(Messages.getString("LoginPropertyDialogSqlServerv2k5.DefaultLang"));
        this.general.add(label);
        this.tfLanguage = new JTextField();
        this.setBG(this.tfLanguage);
        this.tfLanguage.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.tfLanguage);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.tfLanguage, 140);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.login.getName());
        this.tfName.setText(this.login.getName());
        this.cbAuthentication.setSelectedItem(this.login.getAuthentication());
        this.passField.setText(this.login.decodePassword());
        if (this.login.getAuthentication().equals("SQL Server")) {
            this.passField.setEnabled(true);
        } else {
            this.passField.setEnabled(false);
        }
        for (DataBaseSqlServer db : this.getStorageDesign().getDataBaseSet()) {
            if (db.isNullInstance()) continue;
            this.cbDataBase.addItem(db);
        }
        this.cbDataBase.setSelectedItem(this.login.getDefaultDatabase());
        this.tfLanguage.setText(this.login.getLanguage());
        Iterator dbIterator = this.getStorageDesign().getDataBaseSet().iterator();
        boolean check = false;
        String name = "";
        while (dbIterator.hasNext()) {
            check = false;
            name = "";
            DataBaseSqlServer database = (DataBaseSqlServer)dbIterator.next();
            for (UserSqlServer user : this.getStorageDesign().getUserSet()) {
                if (user.getDatabase() != database || !this.login.getUserSet().contains(user.getName())) continue;
                check = true;
                name = user.getName();
                break;
            }
            this.model.addRow(new Object[]{check, database, name});
        }
        this.getCommentsList().insert(this.login.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        TableCellEditor cellEditor;
        if (this.table != null && this.table.getRowCount() > 0 && (cellEditor = this.table.getCellEditor()) != null) {
            this.table.getCellEditor().stopCellEditing();
        }
        if (this.login != null) {
            this.login.setName(this.tfName.getText());
            this.login.setAuthentication((String)this.cbAuthentication.getSelectedItem());
            this.login.encodePassword(String.valueOf(this.passField.getPassword()));
            this.login.setDefaultDatabase((DataBaseSqlServer)this.cbDataBase.getSelectedItem());
            this.login.setLanguage(this.tfLanguage.getText());
            ArrayList userSet = this.model.getUserColumn();
            Iterator it = userSet.iterator();
            this.login.clear();
            while (it.hasNext()) {
                Object ob = it.next();
                if (ob == null || !(ob instanceof UserSqlServer)) continue;
                UserSqlServer user = (UserSqlServer)ob;
                this.login.setUsers(user.getName());
                StorageObjectCollection users = (StorageObjectCollection)user.getDatabase().getChild(3);
                if (!users.containsName(user.getName())) {
                    users.add(user);
                }
                if (this.getStorageDesign().getUserSet().contains(user)) continue;
                this.getStorageDesign().getUserSet().add(user);
            }
            this.login.setComment(this.getCommentsList().getText());
        }
    }

    class CellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 3343391564974068010L;
        private JTextField tf;
        private String val;
        private JTable tab;

        public CellEditor(JTextField tf) {
            super(tf);
            this.tf = tf;
            super.setClickCountToStart(1);
        }

        public void focusGained(FocusEvent e) {
            this.tf.selectAll();
        }

        public void focusLost(FocusEvent e) {
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.tf.setText(value.toString());
            this.tf.selectAll();
            this.tf.setBorder(null);
            this.val = this.tf.getText();
            this.tab = table;
            return this.tf;
        }

        @Override
        public boolean stopCellEditing() {
            JTextField tf = (JTextField)this.getComponent();
            String newValue = tf.getText().trim();
            Boolean dbSelected = (Boolean)this.tab.getModel().getValueAt(this.tab.getSelectedRow(), 0);
            if (dbSelected.booleanValue() && newValue.length() == 0) {
                JOptionPane.showMessageDialog(LoginPropertyDialogSqlServerv2k5.this, Messages.getString("LoginPropertyDialogSqlServerv2k5.NameCanNotBeEmpty"), Messages.getString("LoginPropertyDialogSqlServerv2k5.Warning"), 2);
                tf.setText(this.val);
                tf.setBorder(new LineBorder(Color.black));
                tf.requestFocusInWindow();
                return false;
            }
            return super.stopCellEditing();
        }
    }

    class CheckBoxTableCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        CheckBoxTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setOpaque(true);
            this.setBackground(table.getBackground());
            this.setHorizontalAlignment(0);
            this.setSelected((Boolean)value);
            return this;
        }
    }

    class UsersTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        UsersTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setOpaque(true);
            this.setBackground(table.getBackground());
            this.setHorizontalAlignment(2);
            this.setText((String)(value == null ? "" : "  " + value.toString()));
            return this;
        }
    }

    class UsersTable
    extends JTable {
        UsersTableModel dataModel;

        public UsersTable() {
            this.dataModel = new UsersTableModel();
            this.setModel(this.dataModel);
            TableColumnModel tableColumn = this.getColumnModel();
            tableColumn.getColumn(0).setCellRenderer(new CheckBoxTableCellRenderer());
            tableColumn.getColumn(1).setCellRenderer(new UsersTableCellRenderer());
            for (int i = 1; i < 3; ++i) {
                tableColumn.getColumn(i).setCellRenderer(new UsersTableCellRenderer());
            }
            tableColumn.getColumn(2).setCellEditor(new CellEditor(new JTextField()));
            this.initColumnSizes();
        }

        public void clearTable() {
            int rows = this.dataModel.getRowCount();
            for (int i = rows - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        private void initColumnSizes() {
            TableColumn column = null;
            for (int i = 0; i < 3; ++i) {
                column = this.getColumnModel().getColumn(i);
                if (i == 0) {
                    column.setPreferredWidth(50);
                    continue;
                }
                if (i == 1) {
                    column.setPreferredWidth(150);
                    continue;
                }
                column.setPreferredWidth(220);
            }
        }
    }

    class UsersTableModel
    extends DefaultTableModel
    implements TableModelListener {
        String[] cNames = new String[]{Messages.getString("LoginPropertyDialogSqlServerv2k5.Permit"), Messages.getString("LoginPropertyDialogSqlServerv2k5.Database"), Messages.getString("LoginPropertyDialogSqlServerv2k5.User")};

        public UsersTableModel() {
            this.addTableModelListener(this);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (!LoginPropertyDialogSqlServerv2k5.this.isEditable()) {
                return false;
            }
            return col != 1;
        }

        @Override
        public String getColumnName(int column) {
            return this.cNames[column];
        }

        @Override
        public int getColumnCount() {
            return this.cNames.length;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        public void setData(Vector data) {
            this.dataVector = data;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public Class getColumnClass(int c) {
            if (this.getValueAt(0, c) != null) {
                return this.getValueAt(0, c).getClass();
            }
            return null;
        }

        public Object[] getColumnData(int column) {
            int rowCount = LoginPropertyDialogSqlServerv2k5.this.model.getRowCount();
            Object[] data = new Object[rowCount];
            for (int i = 0; i < rowCount; ++i) {
                data[i] = this.getValueAt(i, column);
            }
            return data;
        }

        public ArrayList getUserColumn() {
            boolean found = true;
            ArrayList<Object> loginUsers = new ArrayList<Object>();
            int rowCount = LoginPropertyDialogSqlServerv2k5.this.model.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                UserSqlServer user2;
                DataBaseSqlServer database = (DataBaseSqlServer)this.getValueAt(i, 1);
                if (this.getValueAt(i, 2) == null || !((Boolean)this.getValueAt(i, 0)).booleanValue()) continue;
                if (this.getValueAt(i, 2) instanceof UserSqlServer) {
                    loginUsers.add(this.getValueAt(i, 2));
                    continue;
                }
                String loginUser = ((String)this.getValueAt(i, 2)).trim();
                if (loginUser == null || !((Boolean)this.getValueAt(i, 0)).booleanValue()) continue;
                UserSetSqlServer allUsers = LoginPropertyDialogSqlServerv2k5.this.getStorageDesign().getUserSet();
                for (UserSqlServer user2 : LoginPropertyDialogSqlServerv2k5.this.getStorageDesign().getUserSet()) {
                    if (user2.getName().equalsIgnoreCase(loginUser)) {
                        found = true;
                        user2.setName(loginUser);
                        user2.setDatabase(database);
                        user2.setLogin(LoginPropertyDialogSqlServerv2k5.this.login);
                        loginUsers.add(user2);
                        break;
                    }
                    found = false;
                }
                if (found) continue;
                user2 = (UserSqlServer)allUsers.createElement(null);
                user2.setName(loginUser);
                user2.setDatabase(database);
                user2.setLogin(LoginPropertyDialogSqlServerv2k5.this.login);
                loginUsers.add(user2);
            }
            return loginUsers;
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            try {
                int row = e.getFirstRow();
                int column = e.getColumn();
                UsersTableModel model = (UsersTableModel)e.getSource();
                Object data = model.getValueAt(row, column);
                if (data instanceof Boolean) {
                    Boolean state = (Boolean)data;
                    if (state.booleanValue()) {
                        if (LoginPropertyDialogSqlServerv2k5.this.table.getValueAt(row, 2) == null || LoginPropertyDialogSqlServerv2k5.this.table.getValueAt(row, 2) instanceof String && ((String)LoginPropertyDialogSqlServerv2k5.this.table.getValueAt(row, 2)).equalsIgnoreCase("")) {
                            DataBaseSqlServer db = (DataBaseSqlServer)LoginPropertyDialogSqlServerv2k5.this.table.getValueAt(row, 1);
                            Iterator users = LoginPropertyDialogSqlServerv2k5.this.getStorageDesign().getUserSet().iterator();
                            UserSqlServer user = null;
                            UserSqlServer tmp = null;
                            while (users.hasNext()) {
                                tmp = (UserSqlServer)users.next();
                                if (tmp.getDatabase() != db || tmp.getLogin() != LoginPropertyDialogSqlServerv2k5.this.login) continue;
                                user = tmp;
                                break;
                            }
                            if (user != null) {
                                LoginPropertyDialogSqlServerv2k5.this.table.setValueAt(user, row, 2);
                            } else {
                                LoginPropertyDialogSqlServerv2k5.this.table.setValueAt(LoginPropertyDialogSqlServerv2k5.this.login.getName(), row, 2);
                            }
                        }
                    } else {
                        LoginPropertyDialogSqlServerv2k5.this.table.setValueAt(null, row, 2);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class AuthenticationListener
    implements ActionListener {
        private AuthenticationListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (((String)LoginPropertyDialogSqlServerv2k5.this.cbAuthentication.getSelectedItem()).equals("SQL Server")) {
                LoginPropertyDialogSqlServerv2k5.this.passField.setEnabled(true);
            } else {
                LoginPropertyDialogSqlServerv2k5.this.passField.setEnabled(false);
            }
        }
    }
}

