/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.udb.v81;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.DataBaseUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.DataBaseUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableSpaceUDBv81;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.AbstractPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.AbstractUDBPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class DatabasePropertyDialogUDBv81
extends AbstractUDBPropertyDialog {
    private DataBaseUDBv81 database;
    private JComboBox cbAutomaticStorage;
    private JTextField tfOnPath;
    private JTextField tfDBPathOn;
    private JTextField tfAlias;
    private JTextField tfCodeSet;
    private JTextField tfTerritory;
    private JComboBox cbCollatingSeq;
    private JIntegerField ifNumSegs;
    private JIntegerField ifDefExtentSize;
    private JComboBox cbCatalogTS;
    private JComboBox cbUserTS;
    private JComboBox cbTempTS;
    protected JPanel autoConfigurePanel;
    protected JCheckBox chbUseAutoConfigure;
    protected JComboBox cbApplyChanges;
    private JTable table;
    private OptionsTableModel model;

    public DatabasePropertyDialogUDBv81(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.database = (DataBaseUDBv81)object;
        this.setHeight(440);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("DatabasePropertyDialogUDBv81.DatabaseProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initAutomaticStorage();
        this.initOnPath();
        this.initAlias();
        this.initCodeSet();
        this.initTerritory();
        this.initCollatingSeq();
        this.initNumSegs();
        this.initDiffExtentSize();
        this.initCatalogTableSpace();
        this.initUserTableSpace();
        this.initTempTableSpace();
    }

    @Override
    protected void addTabs() {
        this.initAutoConfigureView();
    }

    protected void initAutoConfigureView() {
        this.autoConfigurePanel = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("DatabasePropertyDialogUDBv81.AutoConfigure"), this.autoConfigurePanel);
        this.initAutoConfigure();
    }

    private void initAutoConfigure() {
        this.initUseAutoConfigure();
        this.initApplyChanges();
        this.initTable();
    }

    private void initUseAutoConfigure() {
        this.chbUseAutoConfigure = new JCheckBox(Messages.getString("DatabasePropertyDialogUDBv81.AutoConfigure"));
        this.chbUseAutoConfigure.addActionListener(new UseAutoConfigureListener());
        this.autoConfigurePanel.add(this.chbUseAutoConfigure);
        this.setObjectConstraints(this.getAutoConfigureLayout(), this.chbUseAutoConfigure, 5, 12);
    }

    private void initApplyChanges() {
        JLabel label = new JLabel(Messages.getString("DatabasePropertyDialogUDBv81.ApplyChanges"));
        this.autoConfigurePanel.add(label);
        this.cbApplyChanges = new JComboBox<String>(DataBaseUDBv81.getApplyChangesChoices());
        this.setBG(this.cbApplyChanges);
        this.cbApplyChanges.setPreferredSize(this.tfName.getPreferredSize());
        this.autoConfigurePanel.add(this.cbApplyChanges);
        this.setLabelConstraints(this.getAutoConfigureLayout(), label, 50);
        this.setObjectConstraints(this.getAutoConfigureLayout(), this.cbApplyChanges, 50);
    }

    private void initTable() {
        JLabel label = new JLabel(Messages.getString("DatabasePropertyDialogUDBv81.AutoConfigureOptions"));
        this.autoConfigurePanel.add(label);
        this.setLabelConstraints(this.getAutoConfigureLayout(), label, 100);
        this.table = new OptionsTable();
        this.table.setPreferredScrollableViewportSize(new Dimension(392, 144));
        JScrollPane pane = new JScrollPane(this.table);
        this.model = (OptionsTableModel)this.table.getModel();
        this.setBG(this.table);
        this.autoConfigurePanel.add(pane);
        this.setObjectConstraints(this.getAutoConfigureLayout(), pane, 10, 120);
    }

    protected SpringLayout getAutoConfigureLayout() {
        return (SpringLayout)this.autoConfigurePanel.getLayout();
    }

    private void initAutomaticStorage() {
        JLabel label = new JLabel(Messages.getString("DatabasePropertyDialogUDBv81.AutomaticStorage"));
        this.general.add(label);
        this.cbAutomaticStorage = new JComboBox<String>(DataBaseUDB.getAutomaticStorageChoices());
        this.setBG(this.cbAutomaticStorage);
        this.cbAutomaticStorage.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbAutomaticStorage);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbAutomaticStorage, 50);
    }

    private void initOnPath() {
        JLabel label = new JLabel(Messages.getString("DatabasePropertyDialogUDBv81.OnPath"));
        this.general.add(label);
        this.tfOnPath = new JTextField("", 26);
        this.general.add(this.tfOnPath);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.tfOnPath, 80);
        label = new JLabel(Messages.getString("DatabasePropertyDialogUDBv81.DBPathOn"));
        this.general.add(label);
        this.tfDBPathOn = new JTextField("", 26);
        this.general.add(this.tfDBPathOn);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.tfDBPathOn, 110);
    }

    private void initAlias() {
        JLabel label = new JLabel(Messages.getString("DatabasePropertyDialogUDBv81.Alias"));
        this.general.add(label);
        this.tfAlias = new JTextField("", 26);
        this.general.add(this.tfAlias);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.tfAlias, 140);
    }

    private void initCodeSet() {
        JLabel label = new JLabel(Messages.getString("DatabasePropertyDialogUDBv81.CodeSet"));
        this.general.add(label);
        this.tfCodeSet = new JTextField("", 26);
        this.general.add(this.tfCodeSet);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(this.tfCodeSet, 170);
    }

    private void initTerritory() {
        JLabel label = new JLabel(Messages.getString("DatabasePropertyDialogUDBv81.Territory"));
        this.general.add(label);
        this.tfTerritory = new JTextField("", 26);
        this.general.add(this.tfTerritory);
        this.setLabelConstraints(label, 200);
        this.setObjectConstraints(this.tfTerritory, 200);
    }

    private void initCollatingSeq() {
        JLabel label = new JLabel(Messages.getString("DatabasePropertyDialogUDBv81.CollatingSequence"));
        this.general.add(label);
        this.cbCollatingSeq = new JComboBox<String>(DataBaseUDBv81.getCollatingSequencesChoices());
        this.setBG(this.cbCollatingSeq);
        this.cbCollatingSeq.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCollatingSeq);
        this.setLabelConstraints(label, 230);
        this.setObjectConstraints(this.cbCollatingSeq, 230);
    }

    private void initNumSegs() {
        JLabel label = new JLabel("NUMSEGS:");
        this.general.add(label);
        this.ifNumSegs = new JIntegerField(0, 26);
        this.general.add(this.ifNumSegs);
        this.setLabelConstraints(label, 260);
        this.setObjectConstraints(this.ifNumSegs, 260);
    }

    private void initDiffExtentSize() {
        JLabel label = new JLabel(Messages.getString("DatabasePropertyDialogUDBv81.DftExtentSize"));
        this.general.add(label);
        this.ifDefExtentSize = new JIntegerField(0, 26);
        this.general.add(this.ifDefExtentSize);
        this.setLabelConstraints(label, 290);
        this.setObjectConstraints(this.ifDefExtentSize, 290);
    }

    private void initCatalogTableSpace() {
        JLabel lbTableSpace = new JLabel(Messages.getString("DatabasePropertyDialogUDBv81.CtlgTableSpace"));
        this.general.add(lbTableSpace);
        this.cbCatalogTS = new JComboBox();
        this.setBG(this.cbCatalogTS);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbCatalogTS);
        }
        this.cbCatalogTS.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCatalogTS);
        this.setLabelConstraints(lbTableSpace, 320);
        this.setObjectConstraints(this.cbCatalogTS, 320);
    }

    private void initUserTableSpace() {
        JLabel lbTableSpace = new JLabel(Messages.getString("DatabasePropertyDialogUDBv81.UserTableSpace"));
        this.general.add(lbTableSpace);
        this.cbUserTS = new JComboBox();
        this.setBG(this.cbUserTS);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbUserTS);
        }
        this.cbUserTS.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbUserTS);
        this.setLabelConstraints(lbTableSpace, 350);
        this.setObjectConstraints(this.cbUserTS, 350);
    }

    private void initTempTableSpace() {
        JLabel lbTableSpace = new JLabel(Messages.getString("DatabasePropertyDialogUDBv81.TempTableSpace"));
        this.general.add(lbTableSpace);
        this.cbTempTS = new JComboBox();
        this.setBG(this.cbTempTS);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbTempTS);
        }
        this.cbTempTS.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTempTS);
        this.setLabelConstraints(lbTableSpace, 380);
        this.setObjectConstraints(this.cbTempTS, 380);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.database.getName());
        this.tfName.setText(this.database.getName());
        this.cbAutomaticStorage.setSelectedItem(this.database.getAutomaticStorage());
        this.tfOnPath.setText(this.database.getOnPath());
        this.tfDBPathOn.setText(this.database.getDBPathOn());
        this.tfAlias.setText(this.database.getAlias());
        this.tfCodeSet.setText(this.database.getCodeSet());
        this.tfTerritory.setText(this.database.getTerritory());
        this.cbCollatingSeq.setSelectedItem(this.database.getCollatingSequence());
        this.ifNumSegs.setValue((long)this.database.getSegmentNumber());
        this.ifDefExtentSize.setValue((long)this.database.getDefaultExtentSize());
        this.cbCatalogTS.setSelectedItem(this.database.getCatalogTableSpace());
        this.cbUserTS.setSelectedItem(this.database.getUserTableSpace());
        this.cbTempTS.setSelectedItem(this.database.getTemporaryTableSpace());
        this.chbUseAutoConfigure.setSelected(this.database.getAutoConfigure());
        this.cbApplyChanges.setSelectedItem(this.database.getApplyChanges());
        if (this.database.getAutoConfigure()) {
            if (this.table.getRowCount() == 0) {
                this.model.addRow(new Object[]{this.database.getUseMemPercent(), "mem_percent", "" + this.database.getMemPercent()});
                this.model.addRow(new Object[]{this.database.getUseWorkloadType(), "workload_type", this.database.getWorkloadType()});
                this.model.addRow(new Object[]{this.database.getUseNumStmts(), "num_stmts", "" + this.database.getNumStmts()});
                this.model.addRow(new Object[]{this.database.getUseTpm(), "tpm", "" + this.database.getTpm()});
                this.model.addRow(new Object[]{this.database.getUseAdminProperty(), "admin_property", this.database.getAdminProperty()});
                this.model.addRow(new Object[]{this.database.getUseNumLocalApps(), "num_local_apps", "" + this.database.getNumLocalApps()});
                this.model.addRow(new Object[]{this.database.getUseNumRemoteApps(), "num_remote_apps", "" + this.database.getNumRemoteApps()});
                this.model.addRow(new Object[]{this.database.getUseIsolation(), "isolation", this.database.getIsolation()});
                this.model.addRow(new Object[]{this.database.getUseBpResizeable(), "bp_resizeable", DatabasePropertyDialogUDBv81.translateYesNoForDisplay(this.database.getBpResizeable())});
            } else {
                Boolean selected = this.database.getUseMemPercent();
                this.model.setValueAt(selected, 0, 0);
                this.model.setValueAt(new Integer(this.database.getMemPercent()), 0, 2);
                selected = this.database.getUseWorkloadType();
                this.model.setValueAt(selected, 1, 0);
                this.model.setValueAt(this.database.getWorkloadType(), 1, 2);
                selected = this.database.getUseNumStmts();
                this.model.setValueAt(selected, 2, 0);
                this.model.setValueAt(new Integer(this.database.getNumStmts()), 2, 2);
                selected = this.database.getUseTpm();
                this.model.setValueAt(selected, 3, 0);
                this.model.setValueAt(new Integer(this.database.getTpm()), 3, 2);
                selected = this.database.getUseAdminProperty();
                this.model.setValueAt(selected, 4, 0);
                this.model.setValueAt(this.database.getAdminProperty(), 4, 2);
                selected = this.database.getUseNumLocalApps();
                this.model.setValueAt(selected, 5, 0);
                this.model.setValueAt(new Integer(this.database.getNumLocalApps()), 5, 2);
                selected = this.database.getUseNumRemoteApps();
                this.model.setValueAt(selected, 6, 0);
                this.model.setValueAt(new Integer(this.database.getNumRemoteApps()), 6, 2);
                selected = this.database.getUseIsolation();
                this.model.setValueAt(selected, 7, 0);
                this.model.setValueAt(this.database.getIsolation(), 7, 2);
                selected = this.database.getUseBpResizeable();
                this.model.setValueAt(selected, 8, 0);
                this.model.setValueAt(DatabasePropertyDialogUDBv81.translateYesNoForDisplay(this.database.getBpResizeable()), 8, 2);
            }
        }
        this.getCommentsList().insert(this.database.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.database != null) {
            this.database.setName(this.tfName.getText());
            this.database.setAutomaticStorage((String)this.cbAutomaticStorage.getSelectedItem());
            this.database.setOnPath(this.tfOnPath.getText());
            this.database.setDBPathOn(this.tfDBPathOn.getText());
            this.database.setAlias(this.tfAlias.getText());
            this.database.setCodeSet(this.tfCodeSet.getText());
            this.database.setTerritory(this.tfTerritory.getText());
            this.database.setCollatingSequence((String)this.cbCollatingSeq.getSelectedItem());
            this.database.setSegmentNumber(this.ifNumSegs.getIntValue());
            this.database.setDefaultExtentSize(this.ifDefExtentSize.getIntValue());
            Object selected = this.cbCatalogTS.getSelectedItem();
            if (selected instanceof TableSpaceUDBv81) {
                this.database.setCatalogTableSpace((TableSpaceUDBv81)selected);
            } else {
                this.database.setCatalogTableSpace(null);
            }
            selected = this.cbUserTS.getSelectedItem();
            if (selected instanceof TableSpaceUDBv81) {
                this.database.setUserTableSpace((TableSpaceUDBv81)selected);
            } else {
                this.database.setUserTableSpace(null);
            }
            selected = this.cbTempTS.getSelectedItem();
            if (selected instanceof TableSpaceUDBv81) {
                this.database.setTemporaryTableSpace((TableSpaceUDBv81)selected);
            } else {
                this.database.setTemporaryTableSpace(null);
            }
            this.database.setAutoConfigure(this.chbUseAutoConfigure.isSelected());
            this.database.setApplyChanges((String)this.cbApplyChanges.getSelectedItem());
            if (this.chbUseAutoConfigure.isSelected()) {
                selected = this.model.getValueAt(0, 0);
                if (selected.equals(Boolean.TRUE)) {
                    try {
                        this.database.setMemPercent(Integer.parseInt(((String)this.model.getValueAt(0, 2)).trim()));
                        this.database.setUseMemPercent(true);
                    }
                    catch (ClassCastException classCastException) {}
                } else {
                    this.database.setUseMemPercent(false);
                }
                selected = this.model.getValueAt(1, 0);
                if (selected.equals(Boolean.TRUE)) {
                    try {
                        this.database.setWorkloadType((String)this.model.getValueAt(1, 2));
                        this.database.setUseWorkloadType(true);
                    }
                    catch (ClassCastException classCastException) {}
                } else {
                    this.database.setUseWorkloadType(false);
                }
                selected = this.model.getValueAt(2, 0);
                if (selected.equals(Boolean.TRUE)) {
                    try {
                        this.database.setNumStmts(Integer.parseInt(((String)this.model.getValueAt(2, 2)).trim()));
                        this.database.setUseNumStmts(true);
                    }
                    catch (ClassCastException classCastException) {}
                } else {
                    this.database.setUseNumStmts(false);
                }
                selected = this.model.getValueAt(3, 0);
                if (selected.equals(Boolean.TRUE)) {
                    try {
                        this.database.setTpm(Integer.parseInt(((String)this.model.getValueAt(3, 2)).trim()));
                        this.database.setUseTpm(true);
                    }
                    catch (ClassCastException classCastException) {}
                } else {
                    this.database.setUseTpm(false);
                }
                selected = this.model.getValueAt(4, 0);
                if (selected.equals(Boolean.TRUE)) {
                    try {
                        this.database.setAdminProperty((String)this.model.getValueAt(4, 2));
                        this.database.setUseAdminProperty(true);
                    }
                    catch (ClassCastException classCastException) {}
                } else {
                    this.database.setUseAdminProperty(false);
                }
                selected = this.model.getValueAt(5, 0);
                if (selected.equals(Boolean.TRUE)) {
                    try {
                        this.database.setNumLocalApps(Integer.parseInt(((String)this.model.getValueAt(5, 2)).trim()));
                        this.database.setUseNumLocalApps(true);
                    }
                    catch (ClassCastException classCastException) {}
                } else {
                    this.database.setUseNumLocalApps(false);
                }
                selected = this.model.getValueAt(6, 0);
                if (selected.equals(Boolean.TRUE)) {
                    try {
                        this.database.setNumRemoteApps(Integer.parseInt(((String)this.model.getValueAt(6, 2)).trim()));
                        this.database.setUseNumRemoteApps(true);
                    }
                    catch (ClassCastException classCastException) {}
                } else {
                    this.database.setUseNumRemoteApps(false);
                }
                selected = this.model.getValueAt(7, 0);
                if (selected.equals(Boolean.TRUE)) {
                    try {
                        this.database.setIsolation((String)this.model.getValueAt(7, 2));
                        this.database.setUseIsolation(true);
                    }
                    catch (ClassCastException classCastException) {}
                } else {
                    this.database.setUseIsolation(false);
                }
                selected = this.model.getValueAt(8, 0);
                if (selected.equals(Boolean.TRUE)) {
                    try {
                        this.database.setBpResizeable(DatabasePropertyDialogUDBv81.translateYesNoForStorage((String)this.model.getValueAt(8, 2)));
                        this.database.setUseBpResizeable(true);
                    }
                    catch (ClassCastException classCastException) {}
                } else {
                    this.database.setUseBpResizeable(false);
                }
            } else {
                this.database.setUseMemPercent(false);
                this.database.setUseWorkloadType(false);
                this.database.setUseNumStmts(false);
                this.database.setUseTpm(false);
                this.database.setUseAdminProperty(false);
                this.database.setUseNumLocalApps(false);
                this.database.setUseNumRemoteApps(false);
                this.database.setUseIsolation(false);
                this.database.setUseBpResizeable(false);
            }
            this.database.setComment(this.getCommentsList().getText());
        }
    }

    class CheckBoxCellEditor
    extends DefaultCellEditor {
        JCheckBox chBox;

        CheckBoxCellEditor() {
            super(new JCheckBox());
            this.chBox = (JCheckBox)this.getComponent();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.chBox.setSelected((Boolean)value);
            this.chBox.setHorizontalAlignment(0);
            return this.chBox;
        }
    }

    class TextCellEditor
    extends DefaultCellEditor {
        JTextField tfield;

        TextCellEditor() {
            super(new JTextField());
            this.tfield = (JTextField)this.getComponent();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.tfield.setText((String)(value == null ? "" : value.toString()));
            return this.tfield;
        }
    }

    class BPResizeableCellEditor
    extends DefaultCellEditor {
        JComboBox cbox;

        BPResizeableCellEditor() {
            super(new JComboBox());
            this.cbox = (JComboBox)this.getComponent();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.cbox.setModel(new DefaultComboBoxModel<String>(AbstractPropertyDialog.YES_NO));
            return this.cbox;
        }
    }

    class IsolationCellEditor
    extends DefaultCellEditor {
        JComboBox cbox;

        IsolationCellEditor() {
            super(new JComboBox());
            this.cbox = (JComboBox)this.getComponent();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.cbox.setModel(new DefaultComboBoxModel<String>(DataBaseUDBv81.getIsolationChoices()));
            return this.cbox;
        }
    }

    class AdminPriorityCellEditor
    extends DefaultCellEditor {
        JComboBox cbox;

        AdminPriorityCellEditor() {
            super(new JComboBox());
            this.cbox = (JComboBox)this.getComponent();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.cbox.setModel(new DefaultComboBoxModel<String>(DataBaseUDBv81.getAdminPropertyChoices()));
            return this.cbox;
        }
    }

    class WorkloadTypeCellEditor
    extends DefaultCellEditor {
        JComboBox cbox;

        WorkloadTypeCellEditor() {
            super(new JComboBox());
            this.cbox = (JComboBox)this.getComponent();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.cbox.setModel(new DefaultComboBoxModel<String>(DataBaseUDBv81.getWorkloadTypeChoices()));
            return this.cbox;
        }
    }

    class CheckBoxTableCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        CheckBoxTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setOpaque(true);
            this.setBackground(table.getBackground());
            this.setHorizontalAlignment(0);
            this.setSelected((Boolean)value);
            return this;
        }
    }

    class LabelTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        LabelTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setOpaque(true);
            this.setBackground(table.getBackground());
            this.setHorizontalAlignment(2);
            this.setText((String)(value == null ? "" : "  " + value.toString()));
            return this;
        }
    }

    class OptionsTable
    extends JTable {
        OptionsTableModel dataModel;

        public OptionsTable() {
            this.dataModel = new OptionsTableModel();
            this.setModel(this.dataModel);
            this.initColumnSizes();
        }

        public void clearTable() {
            int rows = this.dataModel.getRowCount();
            for (int i = rows - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        private void initColumnSizes() {
            TableColumn column = null;
            for (int i = 0; i < 3; ++i) {
                column = this.getColumnModel().getColumn(i);
                if (i == 0) {
                    column.setPreferredWidth(50);
                    continue;
                }
                if (i == 1) {
                    column.setPreferredWidth(150);
                    continue;
                }
                column.setPreferredWidth(220);
            }
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int col) {
            if (col == 0) {
                return new CheckBoxTableCellRenderer();
            }
            if (col == 1 || col == 2) {
                return new LabelTableCellRenderer();
            }
            return super.getCellRenderer(row, col);
        }

        @Override
        public TableCellEditor getCellEditor(int row, int col) {
            if (col == 0) {
                return new CheckBoxCellEditor();
            }
            if (col == 2) {
                if (row == 1) {
                    return new WorkloadTypeCellEditor();
                }
                if (row == 4) {
                    return new AdminPriorityCellEditor();
                }
                if (row == 7) {
                    return new IsolationCellEditor();
                }
                if (row == 8) {
                    return new BPResizeableCellEditor();
                }
                return new TextCellEditor();
            }
            return super.getCellEditor();
        }
    }

    class OptionsTableModel
    extends DefaultTableModel {
        String[] cNames = new String[]{Messages.getString("DatabasePropertyDialogUDBv81.Use"), Messages.getString("DatabasePropertyDialogUDBv81.Keyword"), Messages.getString("DatabasePropertyDialogUDBv81.Value")};

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 0 || col == 2;
        }

        @Override
        public String getColumnName(int column) {
            return this.cNames[column];
        }

        @Override
        public int getColumnCount() {
            return this.cNames.length;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        public void setData(Vector data) {
            this.dataVector = data;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public Object[] getColumnData(int column) {
            int rowCount = DatabasePropertyDialogUDBv81.this.model.getRowCount();
            Object[] data = new Object[rowCount];
            for (int i = 0; i < rowCount; ++i) {
                data[i] = this.getValueAt(i, column);
            }
            return data;
        }
    }

    private class UseAutoConfigureListener
    implements ActionListener {
        private UseAutoConfigureListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DatabasePropertyDialogUDBv81.this.cbApplyChanges.setEnabled(DatabasePropertyDialogUDBv81.this.chbUseAutoConfigure.isSelected());
            if (DatabasePropertyDialogUDBv81.this.chbUseAutoConfigure.isSelected()) {
                DatabasePropertyDialogUDBv81.this.model.addRow(new Object[]{DatabasePropertyDialogUDBv81.this.database.getUseMemPercent(), "mem_percent", "" + DatabasePropertyDialogUDBv81.this.database.getMemPercent()});
                DatabasePropertyDialogUDBv81.this.model.addRow(new Object[]{DatabasePropertyDialogUDBv81.this.database.getUseWorkloadType(), "workload_type", DatabasePropertyDialogUDBv81.this.database.getWorkloadType()});
                DatabasePropertyDialogUDBv81.this.model.addRow(new Object[]{DatabasePropertyDialogUDBv81.this.database.getUseNumStmts(), "num_stmts", "" + DatabasePropertyDialogUDBv81.this.database.getNumStmts()});
                DatabasePropertyDialogUDBv81.this.model.addRow(new Object[]{DatabasePropertyDialogUDBv81.this.database.getUseTpm(), "tpm", "" + DatabasePropertyDialogUDBv81.this.database.getTpm()});
                DatabasePropertyDialogUDBv81.this.model.addRow(new Object[]{DatabasePropertyDialogUDBv81.this.database.getUseAdminProperty(), "admin_property", DatabasePropertyDialogUDBv81.this.database.getAdminProperty()});
                DatabasePropertyDialogUDBv81.this.model.addRow(new Object[]{DatabasePropertyDialogUDBv81.this.database.getUseNumLocalApps(), "num_local_apps", "" + DatabasePropertyDialogUDBv81.this.database.getNumLocalApps()});
                DatabasePropertyDialogUDBv81.this.model.addRow(new Object[]{DatabasePropertyDialogUDBv81.this.database.getUseNumRemoteApps(), "num_remote_apps", "" + DatabasePropertyDialogUDBv81.this.database.getNumRemoteApps()});
                DatabasePropertyDialogUDBv81.this.model.addRow(new Object[]{DatabasePropertyDialogUDBv81.this.database.getUseIsolation(), "isolation", DatabasePropertyDialogUDBv81.this.database.getIsolation()});
                DatabasePropertyDialogUDBv81.this.model.addRow(new Object[]{DatabasePropertyDialogUDBv81.this.database.getUseBpResizeable(), "bp_resizeable", AbstractPropertyDialog.translateYesNoForDisplay(DatabasePropertyDialogUDBv81.this.database.getBpResizeable())});
            } else {
                int rows = DatabasePropertyDialogUDBv81.this.model.getRowCount();
                for (int i = 0; i < rows; ++i) {
                    DatabasePropertyDialogUDBv81.this.model.removeRow(0);
                }
            }
        }
    }
}

