/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.engineeringcompare;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.PatternSyntaxException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultRowSorter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.Messages;
import oracle.dbtools.crest.swingui.WindowsTableHeader;
import oracle.dbtools.crest.swingui.engineeringcompare.CompareTabularViewReportDialog;
import oracle.dbtools.crest.swingui.engineeringcompare.CompareTreeRenderer;
import oracle.dbtools.crest.swingui.wizards.metadata.AbstractDBMExtractionWizardImpl;
import oracle.dbtools.crest.swingui.wizards.reports.ReportConstants;
import oracle.dbtools.crest.swingui.wizards.reports.ReportUtils;
import oracle.dbtools.crest.util.MessageDialogs;

public class CompareTabularView {
    private JPanel tabularView = new JPanel();
    private List<SelectionPair> listedObects = new ArrayList<SelectionPair>();
    private Map objectTypes = new TreeMap();
    private List<String> objectTypesList_ALL = new ArrayList<String>();
    private List<SelectionPair> allObjects = new ArrayList<SelectionPair>();
    public static String UNCHANGED = oracle.dbtools.crest.swingui.engineeringcompare.Messages.getString("EngineeringCompareDialog.Unchanged");
    public static String MODIFIED = oracle.dbtools.crest.swingui.engineeringcompare.Messages.getString("EngineeringCompareDialog.Modified");
    public static String NEW = oracle.dbtools.crest.swingui.engineeringcompare.Messages.getString("EngineeringCompareDialog.New");
    public static String DELETED = oracle.dbtools.crest.swingui.engineeringcompare.Messages.getString("EngineeringCompareDialog.Deleted");
    private String STATUS = oracle.dbtools.crest.swingui.engineeringcompare.Messages.getString("EngineeringCompareDialog.Status");
    private String TYPE = oracle.dbtools.crest.swingui.engineeringcompare.Messages.getString("EngineeringCompareDialog.Type");
    private String FILTER_BY_STATUS = oracle.dbtools.crest.swingui.engineeringcompare.Messages.getString("EngineeringCompareDialog.FilterByStatus");
    private String FILTER_BY_TYPE = oracle.dbtools.crest.swingui.engineeringcompare.Messages.getString("EngineeringCompareDialog.FilterByType");
    private String FILTER_BY_MODEL = oracle.dbtools.crest.swingui.engineeringcompare.Messages.getString("EngineeringCompareDialog.FilterByModel");
    private String MODEL = oracle.dbtools.crest.swingui.engineeringcompare.Messages.getString("EngineeringCompareDialog.Model");
    private JToolBar toolBar;
    private JButton selectAll;
    private JButton deselectAll;
    private JTable table;
    private JTextField filterText;
    private static String ALL = Messages.getString("SelectNeighborsDialog.All");
    private static String ALL_ = "ALL";
    public static String[] STATUSES = new String[]{ALL, UNCHANGED, MODIFIED, NEW, DELETED};
    private JComboBox cbStatuses;
    private JComboBox cbTypes;
    private JComboBox cbModels;
    private List models = new ArrayList();
    boolean useModels = false;
    private ApplicationView appView;
    private boolean compareModels = false;
    private boolean dmdImport = false;
    private String reportCaption = "";

    public CompareTabularView(ModelIdObjectSelection root, boolean useModels, ApplicationView appView) {
        this.useModels = useModels;
        this.appView = appView;
        this.buildTabularModel(root);
        this.initTabularView();
    }

    private void initTabularView() {
        this.tabularView.setLayout(new BorderLayout());
        this.toolBar = new JToolBar();
        this.selectAll = AbstractDBMExtractionWizardImpl.createSelectAllButton();
        this.deselectAll = AbstractDBMExtractionWizardImpl.createDeselectAllButton();
        this.toolBar.add(this.selectAll);
        this.toolBar.add(this.deselectAll);
        this.table = new JTable(new TabularViewModel());
        this.table.setSelectionMode(0);
        TableColumn col = this.table.getColumnModel().getColumn(0);
        col.setMaxWidth(70);
        col.setPreferredWidth(60);
        col = this.table.getColumnModel().getColumn(1);
        col.setCellRenderer(new TabularViewCellRenderer());
        this.initFiltering(this.table);
        this.tabularView.add((Component)this.toolBar, "North");
        this.table.setAutoCreateRowSorter(true);
        WindowsTableHeader.setSortedHeader(this.table);
        this.tabularView.add((Component)new JScrollPane(this.table), "Center");
        this.selectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompareTabularView.this.checkAll(CompareTabularView.this.table, true);
            }
        });
        this.deselectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompareTabularView.this.checkAll(CompareTabularView.this.table, false);
            }
        });
        if (this.useModels) {
            this.initModelsCombo();
        }
        this.initStatusCombo();
        this.initTypeCombo();
        ImageIcon imgReport = (ImageIcon)GUIConfiguration.getInstance().getIcon("REPORTS_ICON");
        JButton btnPrintReport = new JButton(imgReport);
        btnPrintReport.setToolTipText(oracle.dbtools.crest.swingui.engineeringcompare.Messages.getString("CompareTabularView.GenerateReport"));
        btnPrintReport.setMnemonic(80);
        btnPrintReport.addActionListener(new PrintReportAction());
        this.toolBar.addSeparator();
        this.toolBar.add(btnPrintReport);
    }

    private void initStatusCombo() {
        JLabel label = new JLabel(this.STATUS);
        label.setToolTipText(this.FILTER_BY_STATUS);
        this.cbStatuses = new JComboBox<String>(STATUSES);
        this.cbStatuses.setPreferredSize(new Dimension(80, MessageDialogs.BUTTON_SIZE_EX.height - 2));
        this.cbStatuses.setMaximumSize(new Dimension(100, MessageDialogs.BUTTON_SIZE_EX.height - 2));
        this.cbStatuses.setToolTipText(this.FILTER_BY_STATUS);
        label.setLabelFor(this.cbStatuses);
        this.toolBar.addSeparator();
        this.toolBar.add(label);
        this.toolBar.add(this.cbStatuses);
        this.cbStatuses.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String status = (String)CompareTabularView.this.cbStatuses.getSelectedItem();
                String type = (String)CompareTabularView.this.cbTypes.getSelectedItem();
                CompareTabularView.this.filterByStatusAndType(type, status);
            }
        });
    }

    private void initTypeCombo() {
        JLabel label = new JLabel(this.TYPE);
        label.setToolTipText(this.FILTER_BY_TYPE);
        this.cbTypes = new JComboBox<Object>(this.objectTypesList_ALL.toArray());
        this.cbTypes.setPreferredSize(new Dimension(100, MessageDialogs.BUTTON_SIZE_EX.height - 2));
        this.cbTypes.setMaximumSize(new Dimension(120, MessageDialogs.BUTTON_SIZE_EX.height - 2));
        this.cbTypes.setToolTipText(this.FILTER_BY_TYPE);
        label.setLabelFor(this.cbTypes);
        this.toolBar.addSeparator();
        this.toolBar.add(label);
        this.toolBar.add(this.cbTypes);
        this.cbTypes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String type = (String)CompareTabularView.this.cbTypes.getSelectedItem();
                String status = (String)CompareTabularView.this.cbStatuses.getSelectedItem();
                CompareTabularView.this.filterByStatusAndType(type, status);
            }
        });
    }

    private void initModelsCombo() {
        JLabel label = new JLabel(this.MODEL);
        label.setToolTipText(this.FILTER_BY_MODEL);
        this.cbModels = new JComboBox<Object>(this.models.toArray());
        this.cbModels.setPreferredSize(new Dimension(100, MessageDialogs.BUTTON_SIZE_EX.height - 2));
        this.cbModels.setMaximumSize(new Dimension(120, MessageDialogs.BUTTON_SIZE_EX.height - 2));
        this.cbModels.setToolTipText(this.FILTER_BY_MODEL);
        label.setLabelFor(this.cbModels);
        this.toolBar.addSeparator();
        this.toolBar.add(label);
        this.toolBar.add(this.cbModels);
        this.cbModels.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String type = (String)CompareTabularView.this.cbTypes.getSelectedItem();
                String status = (String)CompareTabularView.this.cbStatuses.getSelectedItem();
                CompareTabularView.this.filterByStatusAndType(type, status);
            }
        });
    }

    private void filterByStatusAndType(String type, String status) {
        Object mod;
        this.listedObects.clear();
        ModelIDObject model = null;
        ArrayList<SelectionPair> temp = new ArrayList<SelectionPair>();
        if (this.useModels && this.cbModels != null && !ALL_.equals(mod = this.cbModels.getSelectedItem()) && mod instanceof ModelIDObject) {
            model = (ModelIDObject)mod;
        }
        if (ALL.equals(status)) {
            if (model == null) {
                temp.addAll(this.allObjects);
            } else {
                for (SelectionPair sp : this.allObjects) {
                    if (model != sp.getModel()) continue;
                    temp.add(sp);
                }
            }
        } else {
            int stat = 0;
            if (NEW.equals(status)) {
                stat = 2;
            } else if (MODIFIED.equals(status)) {
                stat = 1;
            } else if (DELETED.equals(status)) {
                stat = 3;
            }
            for (SelectionPair sp : this.allObjects) {
                if (stat != sp.getStatus() || model != null && model != sp.getModel()) continue;
                temp.add(sp);
            }
        }
        if (ALL_.equals(type)) {
            this.listedObects.addAll(temp);
        } else {
            for (SelectionPair sp : temp) {
                if (!type.equals(sp.getType())) continue;
                this.listedObects.add(sp);
            }
        }
        ((TabularViewModel)this.table.getModel()).fireTableDataChanged();
    }

    private void initFiltering(final JTable tableForFiltering) {
        JLabel flabel = new JLabel(oracle.dbtools.crest.swingui.wizards.Messages.getString("AbstractDBMExtractionWizardImpl.Filter"));
        this.filterText = new JTextField();
        this.filterText.setPreferredSize(new Dimension(130, MessageDialogs.BUTTON_SIZE_EX.height));
        this.filterText.setMaximumSize(new Dimension(180, MessageDialogs.BUTTON_SIZE_EX.height));
        this.filterText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                CompareTabularView.this.newFilter(CompareTabularView.this.filterText, tableForFiltering);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                CompareTabularView.this.newFilter(CompareTabularView.this.filterText, tableForFiltering);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CompareTabularView.this.newFilter(CompareTabularView.this.filterText, tableForFiltering);
            }
        });
        flabel.setLabelFor(this.filterText);
        this.toolBar.add(flabel);
        this.toolBar.add(this.filterText);
    }

    private void changeAll(JTable table, boolean select) {
        if (table != null && table.getRowCount() != table.getModel().getRowCount()) {
            int count = table.getRowCount();
            for (int i = 0; i < count; ++i) {
                int index = table.convertRowIndexToModel(i);
                if (index <= -1 || index >= this.listedObects.size()) continue;
                SelectionPair sp = this.listedObects.get(index);
                sp.leftSel.setSelectedNoPropagateSelection(select);
            }
        } else {
            for (int i = 0; i < this.listedObects.size(); ++i) {
                SelectionPair sp = this.listedObects.get(i);
                sp.leftSel.setSelectedNoPropagateSelection(select);
            }
        }
    }

    protected void checkAll(JTable table, boolean checked) {
        ListSelectionModel selectionModel = table.getSelectionModel();
        this.changeAll(table, checked);
        if (selectionModel.isSelectionEmpty()) {
            this.changeAll(table, checked);
        } else {
            for (int i = 0; i < this.listedObects.size(); ++i) {
                if (!selectionModel.isSelectedIndex(i)) continue;
                SelectionPair sp = this.listedObects.get(i);
                sp.leftSel.setSelectedNoPropagateSelection(checked);
            }
        }
        table.updateUI();
    }

    private void newFilter(JTextField filterText, JTable currentTable) {
        RowFilter rf = null;
        if (currentTable != null) {
            if (!"".equals(filterText.getText())) {
                try {
                    rf = RowFilter.regexFilter("(?i)" + filterText.getText(), currentTable.convertColumnIndexToModel(1));
                    this.cbTypes.setEnabled(false);
                    this.cbStatuses.setEnabled(false);
                    if (this.cbModels != null) {
                        this.cbModels.setEnabled(false);
                    }
                }
                catch (PatternSyntaxException e) {
                    return;
                }
                ((DefaultRowSorter)currentTable.getRowSorter()).setRowFilter(rf);
            } else {
                ((DefaultRowSorter)currentTable.getRowSorter()).setRowFilter(null);
                currentTable.clearSelection();
                this.cbTypes.setEnabled(true);
                this.cbStatuses.setEnabled(true);
                if (this.cbModels != null) {
                    this.cbModels.setEnabled(true);
                }
            }
        }
    }

    public void buildTabularModel(ModelIdObjectSelection leftEngineer) {
        this.listedObects.clear();
        this.allObjects.clear();
        this.buildPairs(leftEngineer, this.allObjects, null);
        this.buildTypes(this.allObjects);
        this.buildModels(this.allObjects);
        this.listedObects.addAll(this.allObjects);
    }

    public void updateTabularModel(ModelIdObjectSelection leftEngineer) {
        this.listedObects.clear();
        this.allObjects.clear();
        ((DefaultRowSorter)this.table.getRowSorter()).setRowFilter(null);
        this.table.clearSelection();
        this.filterText.setText("");
        this.cbStatuses.setSelectedItem(ALL);
        this.buildPairs(leftEngineer, this.allObjects, null);
        this.buildTypes(this.allObjects);
        this.listedObects.addAll(this.allObjects);
        this.cbTypes.setModel(new DefaultComboBoxModel<Object>(this.objectTypesList_ALL.toArray()));
        this.cbTypes.setSelectedItem(ALL_);
        this.cbTypes.setEnabled(true);
        this.cbStatuses.setEnabled(true);
        if (this.useModels) {
            this.buildModels(this.allObjects);
            this.cbModels.setModel(new DefaultComboBoxModel<Object>(this.models.toArray()));
            this.cbModels.setSelectedItem(ALL_);
            this.cbModels.setEnabled(true);
        }
        this.table.updateUI();
    }

    private void buildPairs(ModelIdObjectSelection node, List<SelectionPair> list, ModelIDObject model) {
        ModelIDObject obj = node.getObject();
        ModelIDObject currModel = model;
        if (model == null && obj instanceof DesignPart) {
            currModel = obj;
        }
        List childs = node.getChilds();
        if ((!(obj instanceof Relation) || childs.size() <= 0) && (obj != null && !(obj instanceof DesignPart) || obj == null && node.getStatus() == 3)) {
            SelectionPair sp = new SelectionPair(node);
            currModel = sp.getModel();
            if (currModel == null && model != null) {
                currModel = model;
                sp.setParentModel(model);
            }
            list.add(sp);
        }
        for (ModelIdObjectSelection child : childs) {
            this.buildPairs(child, list, currModel);
        }
    }

    private void buildTypes(List<SelectionPair> list) {
        this.objectTypes.clear();
        this.objectTypesList_ALL.clear();
        for (SelectionPair sp : list) {
            if (this.objectTypes.containsKey(sp.getType())) continue;
            this.objectTypes.put(sp.getType(), sp.getType());
        }
        this.objectTypesList_ALL.add(ALL_);
        this.objectTypesList_ALL.addAll(this.objectTypes.values());
    }

    private void buildModels(List<SelectionPair> list) {
        this.models.clear();
        for (SelectionPair sp : list) {
            ModelIDObject model = sp.getModel();
            if (model == null || this.models.contains(model)) continue;
            this.models.add(model);
        }
        Collections.sort(this.models, ModelObjectSet.NAME_COMPARATOR);
        this.models.add(0, ALL_);
    }

    public JTable getTable() {
        return this.table;
    }

    public JPanel getTabularView() {
        return this.tabularView;
    }

    public void setCompareModels(boolean compareModels) {
        this.compareModels = compareModels;
    }

    public boolean isCompareModels() {
        return this.compareModels;
    }

    public String getReportCaption() {
        return this.reportCaption;
    }

    public void setReportCaption(String reportCaption) {
        this.reportCaption = reportCaption;
    }

    public boolean isDmdImport() {
        return this.dmdImport;
    }

    public void setDmdImport(boolean dmdImport) {
        this.dmdImport = dmdImport;
    }

    protected void generateReport() {
    }

    public boolean isHasNewObjects() {
        for (SelectionPair sp : this.listedObects) {
            if (2 != sp.status) continue;
            return true;
        }
        return false;
    }

    private class PrintReportAction
    implements ActionListener {
        private PrintReportAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HashMap<String, Object> extraParams = new HashMap<String, Object>();
            extraParams.put("compareModels", CompareTabularView.this.isCompareModels());
            extraParams.put("DMDImport", CompareTabularView.this.isDmdImport());
            extraParams.put("reportCaption", CompareTabularView.this.getReportCaption());
            extraParams.put("reportCustomFilenName", ReportUtils.getReportFileName(ReportUtils.getReportsPath(CompareTabularView.this.appView), "ObjectsComparison"));
            CompareTabularViewReportDialog reportsDialog = new CompareTabularViewReportDialog(CompareTabularView.this.appView, CompareTabularView.this.listedObects, extraParams);
            reportsDialog.showDialog();
        }
    }

    public static class SelectionPair {
        public ModelIdObjectSelection leftSel;
        public ModelIdObjectSelection rightSel;
        ModelIDObject leftObj;
        ModelIDObject rightObj;
        int status;
        String type;
        Icon icon;
        ModelIDObject parentModel;

        public SelectionPair(ModelIdObjectSelection node) {
            ModelIDObject obj;
            this.leftObj = obj = node.getObject();
            this.leftSel = node;
            this.rightSel = node.getCorrespondentObjectSelection();
            if (this.rightSel != null) {
                this.rightObj = this.rightSel.getObject();
            }
            this.status = node.getStatus();
            if (1 == this.status && !node.isModified()) {
                this.status = 0;
            }
            this.icon = CompareTreeRenderer.getIcon(this.leftSel, this.status);
            this.type = "";
            if (this.leftObj != null) {
                String tt;
                Class<?> cl = this.leftObj.getClass();
                if (this.leftObj instanceof DesignPartViewPlaceHolder) {
                    this.type = "Subview";
                }
                if ((tt = ReportConstants.classToNameMap.get(cl)) != null) {
                    this.type = tt;
                }
            } else {
                String tt;
                Object desc = this.leftSel.getElementDescriptor();
                if (desc instanceof Class && (tt = ReportConstants.classToNameMap.get(desc)) != null) {
                    this.type = tt;
                }
            }
        }

        public String getType() {
            return this.type;
        }

        public int getStatus() {
            return this.status;
        }

        Icon getIcon() {
            return this.icon;
        }

        public String toString() {
            if (this.leftObj != null) {
                return this.leftObj.getLongName();
            }
            return this.leftSel.getName();
        }

        public ModelIDObject getModel() {
            if (this.leftObj != null) {
                if (this.leftObj instanceof DesignObject) {
                    DesignPart dp = ((DesignObject)this.leftObj).getDesignPart();
                    if (dp == null) {
                        return this.leftObj.getDesign();
                    }
                    return dp;
                }
                if (this.leftObj instanceof StorageObject) {
                    return ((StorageObject)this.leftObj).getStorageDesign();
                }
            }
            return this.parentModel;
        }

        public ModelIDObject getParentModel() {
            return this.parentModel;
        }

        public void setParentModel(ModelIDObject parentModel) {
            this.parentModel = parentModel;
        }

        public ModelIDObject getLeftObj() {
            return this.leftObj;
        }

        public ModelIDObject getRightObj() {
            return this.rightObj;
        }
    }

    class TabularViewCellRenderer
    extends JLabel
    implements TableCellRenderer {
        TabularViewCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            if (value instanceof SelectionPair && col == 1) {
                SelectionPair sp = (SelectionPair)value;
                Icon icon = sp.getIcon();
                this.setIcon(icon);
                this.setOpaque(true);
                this.setText(sp.toString());
                if (isSelected) {
                    this.setBackground(table.getSelectionBackground());
                } else {
                    this.setBackground(table.getBackground());
                }
            }
            this.setHorizontalAlignment(2);
            return this;
        }
    }

    public class TabularViewModel
    extends AbstractTableModel {
        @Override
        public int getRowCount() {
            return CompareTabularView.this.listedObects.size();
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            if (columnIndex == 1) {
                return SelectionPair.class;
            }
            return String.class;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 1) {
                return oracle.dbtools.crest.swingui.engineeringcompare.Messages.getString("EngineeringCompareDialog.Source");
            }
            if (column == 2) {
                return oracle.dbtools.crest.swingui.engineeringcompare.Messages.getString("EngineeringCompareDialog.Target");
            }
            if (column == 3) {
                return CompareTabularView.this.TYPE;
            }
            if (column == 0) {
                return oracle.dbtools.crest.swingui.engineeringcompare.Messages.getString("EngineeringCompareDialog.Selected");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row < CompareTabularView.this.listedObects.size()) {
                SelectionPair sp = CompareTabularView.this.listedObects.get(row);
                if (col == 1) {
                    return sp;
                }
                if (col == 2) {
                    ModelIDObject dobj = sp.rightObj;
                    if (dobj != null) {
                        return dobj.getLongName();
                    }
                } else {
                    if (col == 3) {
                        return sp.getType();
                    }
                    if (col == 0) {
                        return sp.leftSel.isSelected();
                    }
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0 && aValue instanceof Boolean) {
                SelectionPair sp = CompareTabularView.this.listedObects.get(rowIndex);
                boolean val = (Boolean)aValue;
                sp.leftSel.setSelectedNoPropagateSelection(val);
                ModelIdObjectSelection parsel = sp.leftSel.getContainerSelectionObject();
                if (parsel != null && val) {
                    parsel.setSelectedNoPropagateSelection(val);
                }
            }
        }

        @Override
        public int getColumnCount() {
            return 4;
        }
    }
}

