/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.engineeringcompare;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.model.GeneralPropertiesComparator;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.compare.CompareTreeNavigationDesign;
import oracle.dbtools.crest.model.design.engineering.EngEmptyPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngFilter;
import oracle.dbtools.crest.model.design.engineering.EngFilteredSelection;
import oracle.dbtools.crest.model.design.engineering.EngPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.engineering.EngineeringObjectSelection;
import oracle.dbtools.crest.model.design.engineering.FE_LogicalToRelational;
import oracle.dbtools.crest.model.design.engineering.RE_RelationalToLogical;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.editor.TextCompareDialog;
import oracle.dbtools.crest.swingui.engineeringcompare.CompareCheckEditor;
import oracle.dbtools.crest.swingui.engineeringcompare.CompareTabularView;
import oracle.dbtools.crest.swingui.engineeringcompare.CompareTreeRenderer;
import oracle.dbtools.crest.swingui.engineeringcompare.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.OSEnvironment;
import oracle.dbtools.crest.util.compare.StringComparator;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class EngineeringCompareDialog
extends CustomDialog
implements TreeSelectionListener,
TreeExpansionListener,
AdjustmentListener {
    private JPanel leftTreePanel;
    private JPanel rightTreePanel;
    private JPanel entitiesPanel;
    private JPanel attributesPanel;
    private DesignPart designPart;
    private CompareTreeNavigationDesign leftNavDesign;
    private CompareTreeNavigationDesign rightNavDesign;
    private JComboBox pdcombo;
    private JComboBox ldvcombo;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private JTabbedPane mainTabbedPane = new JTabbedPane();
    private JPanel optionsTab;
    private JPanel tabularView;
    private CompareTabularView compareTabularView;
    private JTextPane infoTab = new JTextPane();
    private JTable shouldBeDeletedTab = new JTable(new DeletedModel());
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private GridBagLayout gridBagLayout3 = new GridBagLayout();
    private Border border1;
    private JScrollPane detailsSP;
    private TitledBorder titledBorder1;
    private Border border2;
    private MyJTree leftTree;
    private MyJTree rightTree;
    private TitledBorder titledBorder2;
    private JPanel optionsPanel = new JPanel();
    private JPanel infoPanel = new JPanel();
    private JCheckBox showMappings = new JCheckBox(Messages.getString("EngineeringCompareDialog.ShowMappings"));
    private JCheckBox shouldBeDeleted = new JCheckBox(Messages.getString("EngineeringCompareDialog.SynchronizationOfDeletedObjects"));
    private JCheckBox engCoordinates = new JCheckBox(Messages.getString("EngineeringCompareDialog.EngineerCoordinates"));
    private JCheckBox engGenerated;
    private JCheckBox cbUseDataTypeKind;
    private JCheckBox engAsSubView = new JCheckBox(Messages.getString("EngineeringCompareDialog.AsSubView"));
    private JCheckBox applyNameStd = new JCheckBox(Messages.getString("EngineeringCompareDialog.ApplyNameTranslation"));
    private JCheckBox usePreferredAbbr = new JCheckBox(Messages.getString("EngineeringCompareDialog.UsePreferredAbbreviations"));
    private JCheckBox useTemplateTable = new JCheckBox(Messages.getString("EngineeringCompareDialog.UseTemplateTable"));
    private JCheckBox prefForEntHierColumns = new JCheckBox("Prefix for Columns from Entity Hierarchies");
    public static boolean PREFIX_ENT_HIER_COLS = true;
    private JComboBox templateTable = new JComboBox();
    private JTable compareTable = new JTable();
    private SelectedCellRenderer selRenderer = new SelectedCellRenderer();
    private ModifiableCellRenderer propertyNamerenderer = new ModifiableCellRenderer();
    private RelationalDesign currenPHdes;
    private EngineeringObjectSelection leftRoot;
    private Map comparatorsMap;
    private String designPartName = "";
    private JDialog dialog;
    private JPanel buttonPanel;
    private JPopupMenu popupMenu;
    private static String STATE_ALL = Messages.getString("EngineeringCompareDialog.ShowAllObjects");
    private static String STATE_NEW = Messages.getString("EngineeringCompareDialog.ShowNewObjects");
    private static String STATE_DELETED = Messages.getString("EngineeringCompareDialog.ShowDeletedObjects");
    private static String STATE_MODIFIED = Messages.getString("EngineeringCompareDialog.ShowModifiedObjects");
    private static String[] filters = new String[]{STATE_ALL, STATE_NEW, STATE_DELETED, STATE_MODIFIED};
    private JComboBox cbFilter = new JComboBox<String>(filters);
    JCheckBoxMenuItem item = new JCheckBoxMenuItem(Messages.getString("EngineeringCompareDialog.ShowAllObjects"));
    JCheckBoxMenuItem item1 = new JCheckBoxMenuItem(Messages.getString("EngineeringCompareDialog.ShowNewObjects"));
    JCheckBoxMenuItem item2 = new JCheckBoxMenuItem(Messages.getString("EngineeringCompareDialog.ShowDeletedObjects"));
    JCheckBoxMenuItem item3 = new JCheckBoxMenuItem(Messages.getString("EngineeringCompareDialog.ShowModifiedObjects"));
    private JPopupMenu menu;
    private LogicalDesign.EntHolder currentEntHolder;
    private List overlappingEnts = new ArrayList();
    private JTable entsJTable;
    private JTable attribsJTable;
    private JPanel comparePanel;
    private JPanel objPanel;
    private JTable propsTable;
    private JButton updateTreeButton;
    private JCheckBox ckShowSelProp;
    private JCheckBox ckNoApply;
    private JCheckBox ckExcFromTree;
    private String[] items = new String[]{Design.ENTITY_TABLE, Design.ATTRIBUTE_COLUMN, Design.KEY_INDEX, Design.RELATION_FK, Design.RELATION_TABLE, Design.ENTVIEW_TBLVIEW};
    private JList desObjectList;
    private List propertiesList = new ArrayList();
    private String caption = Messages.getString("EngineeringCompareDialog.Engineering");
    private OverlappedAttributesModel overlappedAttributesModel;
    private JTable table;
    private PopupListener spopUPListener;
    JScrollBar leftSB;
    JScrollBar rightSB;
    private JButton button;
    EngineeringObjectSelection leftEngineer = null;
    MyJTree startTree = null;
    boolean started = false;
    boolean sb_started = false;
    boolean sel_started = false;

    public EngineeringCompareDialog(ApplicationView view, DesignPart design) {
        super(view);
        EngineeringObjectSelection engineer;
        DesignPartView currentDPV;
        this.designPart = design;
        this.designPartName = "\"" + design.getName() + "\"";
        this.engGenerated = new JCheckBox(MessageFormat.format(Messages.getString("EngineeringCompareDialog.EngineerOnlyObjectsCreatedIn"), this.designPartName));
        this.cbUseDataTypeKind = new JCheckBox(oracle.dbtools.crest.util.Messages.getString("OptionsDialog.UseDataTypeKindProperty"));
        design.getDesign().clearGlossaries();
        if (design instanceof RelationalDesign) {
            this.caption = Messages.getString("EngineeringCompareDialog.EngineerToLogicalModel");
            this.currenPHdes = (RelationalDesign)design;
            currentDPV = this.getApplicationView().getCurrentDPV();
            if (currentDPV == null || currentDPV.getDesignPart() != design) {
                currentDPV = design.getMainView();
            }
            this.leftEngineer = engineer = new RE_RelationalToLogical((RelationalDesign)design, currentDPV);
            this.comparatorsMap = ((RE_RelationalToLogical)engineer).getComparatorsMap();
            this.initLeftTreePanel(((RE_RelationalToLogical)engineer).getRelationalRoot());
            this.initRightTreePanel(((RE_RelationalToLogical)engineer).getLogicalRoot());
            if (this.currenPHdes.isLoaded()) {
                this.resetLeftTree(((RE_RelationalToLogical)engineer).getRelationalRoot());
                this.resetRightTree(((RE_RelationalToLogical)engineer).getLogicalRoot());
            }
        } else {
            this.caption = Messages.getString("EngineeringCompareDialog.EngineerToRelationalModel");
            this.currenPHdes = design.getDesign().getRelationalDesign();
            currentDPV = this.getApplicationView().getCurrentDPV();
            if (currentDPV == null || currentDPV.getDesignPart() != design) {
                currentDPV = ((LogicalDesign)design).getMainView();
            }
            this.leftEngineer = engineer = new FE_LogicalToRelational((LogicalDesign)design, design.getDesign().getRelationalDesign(), currentDPV);
            this.comparatorsMap = ((FE_LogicalToRelational)engineer).getComparatorsMap();
            this.initRightTreePanel(((FE_LogicalToRelational)engineer).getRelationalRoot());
            this.initLeftTreePanel(((FE_LogicalToRelational)engineer).getLogicalRoot());
            if (this.currenPHdes.isLoaded()) {
                this.resetRightTree(((FE_LogicalToRelational)engineer).getRelationalRoot());
                this.resetLeftTree(((FE_LogicalToRelational)engineer).getLogicalRoot());
            }
        }
        design.getDesign().setEngineerGenerated(true);
        this.leftTreePanel.setPreferredSize(new Dimension(350, 400));
        this.rightTreePanel.setPreferredSize(new Dimension(350, 400));
        this.leftTreePanel.setMinimumSize(new Dimension(350, 200));
        this.rightTreePanel.setMinimumSize(new Dimension(350, 200));
        this.tabbedPane.setPreferredSize(new Dimension(800, 220));
        RelationalDesign[] pdes = (RelationalDesign[])this.designPart.getDesign().getRelationalDesigns().toArray();
        ArrayList<RelationalDesign> loadedPdes = new ArrayList<RelationalDesign>();
        for (int i = 0; i < pdes.length; ++i) {
            if (!pdes[i].isLoaded()) continue;
            loadedPdes.add(pdes[i]);
        }
        this.pdcombo = new JComboBox<Object>(loadedPdes.toArray());
        this.ldvcombo = new JComboBox();
        this.fillComboWithDPVs(this.designPart, this.ldvcombo);
        this.detailsSP = new JScrollPane(this.compareTable);
        this.compareTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int col;
                if (e.getClickCount() == 2 && ((col = EngineeringCompareDialog.this.compareTable.getSelectedColumn()) == 2 || col == 3)) {
                    int row = EngineeringCompareDialog.this.compareTable.getSelectedRow();
                    String name = (String)EngineeringCompareDialog.this.compareTable.getModel().getValueAt(row, 0);
                    Object leftValue = EngineeringCompareDialog.this.compareTable.getModel().getValueAt(row, 2);
                    Object rightValue = EngineeringCompareDialog.this.compareTable.getModel().getValueAt(row, 3);
                    if (leftValue instanceof String && rightValue instanceof String && (!"".equalsIgnoreCase((String)leftValue) || !"".equalsIgnoreCase((String)rightValue))) {
                        TextCompareDialog dialog = new TextCompareDialog(EngineeringCompareDialog.this.getApplicationView(), (String)leftValue, (String)rightValue);
                        dialog.setTitle(name);
                        dialog.showDialog();
                    }
                }
            }
        });
        this.detailsSP.setPreferredSize(new Dimension(700, 200));
        JSplitPane sp1 = new JSplitPane(1);
        sp1.setLeftComponent(this.leftTreePanel);
        sp1.setRightComponent(this.rightTreePanel);
        sp1.setDividerLocation(-1);
        sp1.setResizeWeight(0.5);
        this.compareTabularView = new CompareTabularView(this.leftEngineer, false, this.getApplicationView());
        this.compareTabularView.setReportCaption(this.getCaption());
        this.tabularView = this.compareTabularView.getTabularView();
        this.mainTabbedPane.add((Component)sp1, oracle.dbtools.crest.swingui.ddl.Messages.getString("DDLSelectionDialog.TreeView"));
        this.mainTabbedPane.add((Component)this.tabularView, Messages.getString("EngineeringCompareDialog.TabularView"));
        JSplitPane splitPane = new JSplitPane(0, this.mainTabbedPane, this.tabbedPane);
        this.add((Component)splitPane, "Center");
        this.tabbedPane.add(Messages.getString("EngineeringCompareDialog.Details"), this.detailsSP);
        this.initToolbar();
        this.addTabs();
        if (design instanceof LogicalDesign) {
            this.initOverlappingKeysPanel((LogicalDesign)design);
            this.scanOverlappingStatus(this.currenPHdes);
        }
        this.compareTabularView.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                EngineeringCompareDialog.this.table = EngineeringCompareDialog.this.compareTabularView.getTable();
                int row = EngineeringCompareDialog.this.table.getSelectedRow();
                ModelIdObjectSelection obj = null;
                if (row > -1 && row < EngineeringCompareDialog.this.table.getRowCount()) {
                    CompareTabularView.SelectionPair sp = (CompareTabularView.SelectionPair)EngineeringCompareDialog.this.table.getValueAt(row, 1);
                    obj = sp.leftSel;
                }
                EngineeringCompareDialog.this.updateCompareTable(obj);
            }
        });
        this.add((Component)this.getButtonPanel(), "South");
        this.updateCompareTable(null);
    }

    public String getCaption() {
        return this.caption;
    }

    private void initOptions() {
        this.border1 = new EtchedBorder(0);
        this.titledBorder1 = new TitledBorder(this.border1, "");
        this.border2 = new EtchedBorder(0);
        this.titledBorder2 = new TitledBorder(this.border2, Messages.getString("EngineeringCompareDialog.ObjectInfo"));
        this.optionsPanel.setLayout(this.gridBagLayout1);
        this.optionsTab.setBorder(this.titledBorder1);
        this.optionsTab.setLayout(this.gridBagLayout2);
        this.infoPanel.setBorder(this.titledBorder2);
        this.infoPanel.setLayout(this.gridBagLayout3);
        JPanel empty = new JPanel();
        this.optionsPanel.add((Component)this.optionsTab, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(16, 12, 0, 10), 4, 25));
        this.optionsTab.add((Component)this.engCoordinates, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 12, 0, 82), 20, 0));
        this.optionsTab.add((Component)this.engGenerated, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 12, 4, 39), 3, 0));
        this.optionsTab.add((Component)this.applyNameStd, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 12, 4, 39), 3, 0));
        this.optionsTab.add((Component)this.usePreferredAbbr, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 12, 4, 39), 3, 0));
        this.optionsTab.add((Component)this.cbUseDataTypeKind, new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 12, 4, 39), 3, 0));
        if (this.designPart instanceof LogicalDesign) {
            Table table;
            ArrayList list = new ArrayList();
            list.add(null);
            this.currenPHdes.getTableSet().addAllElementsTo(list);
            this.useTemplateTable.setSelected(this.currenPHdes.isUseTemplateTable());
            this.templateTable.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
            this.templateTable.setMinimumSize(new Dimension(70, 10));
            if (list.size() == 1) {
                this.templateTable.setPreferredSize(new Dimension(200, 19));
            }
            if ((table = this.currenPHdes.getTemplateTable()) != null) {
                table = (Table)this.currenPHdes.getTableSet().getObjectByID(table.getObjectID());
            }
            if (table == null && (table = (Table)this.currenPHdes.getTableSet().getByName("table_template")) == null) {
                table = (Table)this.currenPHdes.getTableSet().getByName("template_table");
            }
            if (table != null) {
                this.templateTable.setSelectedItem(table);
            }
            JPanel template = new JPanel(new FlowLayout(0));
            template.add(this.useTemplateTable);
            template.add(this.templateTable);
            this.optionsTab.add((Component)template, new GridBagConstraints(0, 7, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 6, 4, 39), 3, 0));
            this.prefForEntHierColumns.setSelected(PREFIX_ENT_HIER_COLS);
            this.optionsTab.add((Component)this.prefForEntHierColumns, new GridBagConstraints(0, 8, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 12, 4, 39), 3, 0));
            this.prefForEntHierColumns.setToolTipText("Option to use entity short name as column name prefix for columns generated from entity hierachies");
            this.prefForEntHierColumns.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PREFIX_ENT_HIER_COLS = EngineeringCompareDialog.this.prefForEntHierColumns.isSelected();
                }
            });
            final JCheckBox applyTemplateFK = new JCheckBox("Apply template for FK columns");
            applyTemplateFK.setSelected(ApplyNamingStandards.applyToFKColumn);
            applyTemplateFK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ApplyNamingStandards.applyToFKColumn = applyTemplateFK.isSelected();
                }
            });
            this.optionsTab.add((Component)applyTemplateFK, new GridBagConstraints(0, 9, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 12, 4, 39), 3, 0));
        }
        this.optionsPanel.add((Component)empty, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(6, 11, 16, 11), 10, 10));
        if (this.designPart instanceof RelationalDesign) {
            this.usePreferredAbbr.setEnabled(false);
        }
    }

    private void initLeftTreePanel(ModelIdObjectSelection root) {
        this.leftTreePanel = new JPanel(new BorderLayout());
        this.leftTree = new MyJTree();
        this.leftTree.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                JTree tree;
                Object obj;
                int k = 0;
                ++k;
                if (e.getSource() instanceof JTree && e.getKeyCode() == 32 && (obj = (tree = (JTree)e.getSource()).getLastSelectedPathComponent()) != null) {
                    try {
                        tree.startEditingAtPath(tree.getSelectionPath());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    CompareCheckEditor ed = (CompareCheckEditor)tree.getCellEditor();
                    ed.cbox.doClick();
                    ed.cancelCellEditing();
                }
            }
        });
        ToolTipManager.sharedInstance().registerComponent(this.leftTree);
        this.leftTree.setEditable(true);
        CompareTreeRenderer renderer = new CompareTreeRenderer(true);
        this.leftTree.setCellRenderer(renderer);
        CompareCheckEditor editor = new CompareCheckEditor(true);
        this.leftTree.setCellEditor(editor);
        JScrollPane jsp = new JScrollPane(this.leftTree);
        this.leftTreePanel.add((Component)jsp, "Center");
        this.leftTree.addTreeSelectionListener(this);
        this.leftTree.addTreeExpansionListener(this);
        this.leftSB = jsp.getVerticalScrollBar();
        this.leftSB.addAdjustmentListener(this);
        this.leftTree.addMouseListener(this.getPopUPListener());
    }

    private void resetLeftTree(EngineeringObjectSelection root) {
        this.leftRoot = root;
        root.resetModifiedStatus();
        this.leftNavDesign = new CompareTreeNavigationDesign(root);
        this.leftTree.setModel(this.leftNavDesign);
        this.synchronizeDeletedWithJComponent(this.shouldBeDeletedTab);
        this.leftTree.removeMouseListener(this.getPopUPListener());
        this.leftTree.addMouseListener(this.getPopUPListener());
    }

    private void synchronizeDeletedWithJComponent(JComponent component) {
        for (EngineeringObjectSelection sel : this.getDeletedMappings()) {
            sel.setDependentComponent(component);
        }
    }

    private void initRightTreePanel(ModelIdObjectSelection root) {
        this.rightTreePanel = new JPanel(new BorderLayout());
        this.rightTree = new MyJTree();
        CompareTreeRenderer renderer = new CompareTreeRenderer(false);
        this.rightTree.setCellRenderer(renderer);
        JScrollPane jsp = new JScrollPane(this.rightTree);
        this.rightTreePanel.add((Component)jsp, "Center");
        this.rightTree.addTreeSelectionListener(this);
        this.rightTree.addTreeExpansionListener(this);
        this.rightSB = jsp.getVerticalScrollBar();
        this.rightSB.addAdjustmentListener(this);
    }

    private void resetRightTree(EngineeringObjectSelection root) {
        root.resetModifiedStatus();
        this.rightNavDesign = new CompareTreeNavigationDesign(root);
        this.rightTree.setModel(this.rightNavDesign);
    }

    private void unregisterListeners() {
        this.leftNavDesign.unregisterAsListener();
        this.rightNavDesign.unregisterAsListener();
    }

    private void initToolbar() {
        if (this.designPart instanceof LogicalDesign) {
            Dimension dim = new Dimension(200, 23);
            this.ldvcombo.setPreferredSize(dim);
            this.ldvcombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    EngineeringCompareDialog.this.resetEngAsSubView();
                    EngineeringCompareDialog.this.resetDesignsByLogicalSubview();
                    EngineeringCompareDialog.this.updateCompareTable(null);
                }
            });
            JPanel jpanel1 = new JPanel(new FlowLayout(0));
            jpanel1.add(this.ldvcombo);
            this.button = new JButton(Messages.getString("EngineeringCompareDialog.Filter"));
            this.button.setMnemonic(70);
            this.button.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    JPopupMenu menu = EngineeringCompareDialog.this.getFilterPopupMenu();
                    menu.show(EngineeringCompareDialog.this.button, e.getPoint().x, e.getPoint().y);
                }
            });
            this.button.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            jpanel1.add(this.button);
            this.leftTreePanel.add((Component)jpanel1, "North");
            JPanel jpanel2 = new JPanel(new FlowLayout(0));
            this.pdcombo.setPreferredSize(dim);
            this.pdcombo.setSelectedItem(this.getDesign().getRelationalDesign());
            jpanel2.add(this.pdcombo);
            this.pdcombo.addActionListener(new UpdateTreeListener());
            DesignPartView currentDPV = this.getApplicationView().getCurrentDPV();
            if (currentDPV == null) {
                currentDPV = this.designPart.getMainView();
            }
            if (this.designPart.getMainView() == currentDPV) {
                this.engAsSubView.setSelected(false);
                this.engAsSubView.setEnabled(false);
                this.designPart.getDesign().setEngineerAsSubView(false);
            } else {
                this.engAsSubView.setSelected(this.designPart.getDesign().isEngineerAsSubView());
            }
            jpanel2.add(this.engAsSubView);
            this.rightTreePanel.add((Component)jpanel2, "North");
        } else if (this.designPart instanceof RelationalDesign) {
            Dimension dim = new Dimension(200, 23);
            this.ldvcombo.setPreferredSize(dim);
            this.ldvcombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    EngineeringCompareDialog.this.resetEngAsSubView();
                    EngineeringCompareDialog.this.resetDesignsByRelational();
                    EngineeringCompareDialog.this.updateCompareTable(null);
                }
            });
            this.engAsSubView.setSelected(this.designPart.getDesign().isEngineerAsSubView());
            JPanel jpanel3 = new JPanel(new FlowLayout(0));
            jpanel3.add(this.engAsSubView);
            this.rightTreePanel.add((Component)jpanel3, "North");
            JPanel jpanel4 = new JPanel(new FlowLayout(0));
            jpanel4.setPreferredSize(jpanel3.getPreferredSize());
            jpanel4.add(this.ldvcombo);
            this.button = new JButton(Messages.getString("EngineeringCompareDialog.Filter"));
            this.button.setMnemonic(70);
            this.button.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    JPopupMenu menu = EngineeringCompareDialog.this.getFilterPopupMenu();
                    menu.show(EngineeringCompareDialog.this.button, e.getPoint().x, e.getPoint().y);
                }
            });
            this.button.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            jpanel4.add(this.button);
            this.leftTreePanel.add((Component)jpanel4, "North");
        }
        this.engAsSubView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                EngineeringCompareDialog.this.designPart.getDesign().setEngineerAsSubView(EngineeringCompareDialog.this.engAsSubView.isSelected());
            }
        });
    }

    private void addTabs() {
        this.addOptionsTab();
        this.initOptions();
        this.addCompareTab();
        this.addShouldBeDeletedTab();
    }

    private JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.popupMenu.add(new AbstractAction(Messages.getString("EngineeringCompareDialog.SelectAll")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EngineeringCompareDialog.this.selecteDeletedObjects(true);
                }
            });
            this.popupMenu.add(new AbstractAction(Messages.getString("EngineeringCompareDialog.DeselectAll")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EngineeringCompareDialog.this.selecteDeletedObjects(false);
                }
            });
        }
        return this.popupMenu;
    }

    private void selecteDeletedObjects(boolean selected) {
        for (EngineeringObjectSelection sel : this.getDeletedMappings()) {
            sel.setSelected(selected);
        }
    }

    private void addShouldBeDeletedTab() {
        TableColumn column = this.shouldBeDeletedTab.getColumnModel().getColumn(0);
        column.setPreferredWidth(60);
        column.setWidth(60);
        column.setMaxWidth(70);
        this.shouldBeDeletedTab.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    EngineeringCompareDialog.this.getPopupMenu().show(EngineeringCompareDialog.this.shouldBeDeletedTab, e.getX(), e.getY());
                }
            }
        });
        this.tabbedPane.add(Messages.getString("EngineeringCompareDialog.SynchronizationOfDeletedObjects"), new JScrollPane(this.shouldBeDeletedTab));
    }

    private void addOptionsTab() {
        this.optionsTab = new JPanel();
        this.tabbedPane.addTab(Messages.getString("EngineeringCompareDialog.GeneralOptions"), this.optionsPanel);
        this.initOptionsTab();
    }

    private void initOptionsTab() {
        this.initShowMappings();
        this.initEngineerCoordinates();
        this.initEngineerGenerated();
        this.initUseDataTypeKind();
        this.initApplyNameStandardization();
        this.initUsePreferredAbbreviations();
        this.usePreferredAbbr.setEnabled(this.applyNameStd.isSelected());
    }

    void initShowMappings() {
        this.showMappings.setSelected(this.designPart.getDesign().isShowMappingsInEngineeringDialog());
        this.showMappings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                EngineeringCompareDialog.this.designPart.getDesign().setShowMappingsInEngineeringDialog(EngineeringCompareDialog.this.showMappings.isSelected());
                EngineeringCompareDialog.this.showInfo();
            }
        });
    }

    void initShouldBeDeleted() {
        this.shouldBeDeleted.setSelected(this.designPart.getDesign().isDeleteWithoutOrigin());
        this.shouldBeDeleted.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                EngineeringCompareDialog.this.designPart.getDesign().setDeleteWithoutOrigin(EngineeringCompareDialog.this.shouldBeDeleted.isSelected());
            }
        });
    }

    private void resetDesignsByRelational() {
        if (this.designPart instanceof RelationalDesign) {
            this.unregisterListeners();
            DesignPartView dpv = (DesignPartView)this.ldvcombo.getSelectedItem();
            this.designPart.getDesign().setRelationalDesign((RelationalDesign)this.designPart);
            RE_RelationalToLogical engineer = new RE_RelationalToLogical((RelationalDesign)this.designPart, dpv);
            this.comparatorsMap = engineer.getComparatorsMap();
            this.leftEngineer = engineer;
            this.resetLeftTree(engineer.getRelationalRoot());
            this.resetRightTree(engineer.getLogicalRoot());
            this.currenPHdes = (RelationalDesign)this.designPart;
            this.compareTabularView.updateTabularModel(this.leftEngineer);
        }
    }

    private void resetDesignsByLogicalSubview() {
        DesignPart design = (DesignPart)this.pdcombo.getSelectedItem();
        if (design instanceof RelationalDesign) {
            this.unregisterListeners();
            DesignPartView dpv = (DesignPartView)this.ldvcombo.getSelectedItem();
            design.getDesign().setRelationalDesign((RelationalDesign)design);
            FE_LogicalToRelational engineer = new FE_LogicalToRelational(design.getDesign().getLogicalDesign(), (RelationalDesign)design, dpv);
            this.comparatorsMap = engineer.getComparatorsMap();
            this.leftEngineer = engineer;
            this.resetRightTree(engineer.getRelationalRoot());
            this.resetLeftTree(engineer.getLogicalRoot());
            this.currenPHdes = (RelationalDesign)design;
            this.scanOverlappingStatus(this.currenPHdes);
            this.compareTabularView.updateTabularModel(this.leftEngineer);
        }
    }

    private void resetEngAsSubView() {
        if (this.designPart.getMainView() == this.ldvcombo.getSelectedItem()) {
            this.engAsSubView.setSelected(false);
            this.engAsSubView.setEnabled(false);
            this.designPart.getDesign().setEngineerAsSubView(false);
        } else {
            this.engAsSubView.setEnabled(true);
            this.engAsSubView.setSelected(this.designPart.getDesign().isEngineerAsSubView());
        }
    }

    void initEngineerCoordinates() {
        this.engCoordinates.setSelected(this.designPart.getDesign().isEngineerCoordinates());
        this.engCoordinates.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                EngineeringCompareDialog.this.designPart.getDesign().setEngineerCoordinates(EngineeringCompareDialog.this.engCoordinates.isSelected());
            }
        });
    }

    void initEngineerGenerated() {
        this.engGenerated.setSelected(!this.designPart.getDesign().isEngineerGenerated());
        this.getDesign().setEngineerGenerated(true);
        this.engGenerated.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                EngineeringCompareDialog.this.designPart.getDesign().setEngineerGenerated(!EngineeringCompareDialog.this.engGenerated.isSelected());
            }
        });
    }

    void initUseDataTypeKind() {
        this.cbUseDataTypeKind.setSelected(this.designPart.getAppView().getSettings().isUseDataTypeKindInCompare());
        this.cbUseDataTypeKind.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                EngineeringCompareDialog.this.designPart.getDesign().getAppView().getSettings().setUseDataTypeKindInCompare(EngineeringCompareDialog.this.cbUseDataTypeKind.isSelected());
            }
        });
    }

    private void initApplyNameStandardization() {
        this.applyNameStd.setSelected(this.designPart.getDesign().isApplyNameStandardization());
        this.applyNameStd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                EngineeringCompareDialog.this.designPart.getDesign().setApplyNameStandardization(EngineeringCompareDialog.this.applyNameStd.isSelected());
                if (EngineeringCompareDialog.this.designPart instanceof LogicalDesign) {
                    EngineeringCompareDialog.this.resetDesignsByLogicalSubview();
                } else {
                    EngineeringCompareDialog.this.resetDesignsByRelational();
                }
                EngineeringCompareDialog.this.updateCompareTable(null);
                EngineeringCompareDialog.this.usePreferredAbbr.setEnabled(EngineeringCompareDialog.this.applyNameStd.isSelected());
            }
        });
    }

    private void initUsePreferredAbbreviations() {
        this.usePreferredAbbr.setSelected(this.designPart.getDesign().isUsePreferredAbbreviation());
        this.usePreferredAbbr.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                EngineeringCompareDialog.this.designPart.getDesign().setUsePreferredAbbreviation(EngineeringCompareDialog.this.usePreferredAbbr.isSelected());
                if (EngineeringCompareDialog.this.designPart instanceof LogicalDesign) {
                    EngineeringCompareDialog.this.resetDesignsByLogicalSubview();
                } else {
                    EngineeringCompareDialog.this.resetDesignsByRelational();
                }
                EngineeringCompareDialog.this.updateCompareTable(null);
            }
        });
    }

    SpringLayout getOptionsLayout() {
        return (SpringLayout)this.optionsTab.getLayout();
    }

    protected void setObjectConstraints(SpringLayout layout, Component c, int x, int y) {
        SpringLayout.Constraints labelCons = layout.getConstraints(c);
        labelCons.setX(Spring.constant(x));
        labelCons.setY(Spring.constant(y));
    }

    private void addCompareTab() {
        this.comparePanel = new JPanel(new BorderLayout());
        this.comparePanel.setPreferredSize(new Dimension(700, 200));
        JPanel toolBar = new JPanel(new BorderLayout());
        toolBar.setPreferredSize(new Dimension(700, 20));
        this.objPanel = new JPanel(new BorderLayout());
        this.objPanel.setPreferredSize(new Dimension(500, 200));
        JPanel listPanel = new JPanel(new BorderLayout());
        listPanel.setPreferredSize(new Dimension(145, 200));
        this.desObjectList = new JList<String>(this.items);
        ListSelectionModel selectionModel = this.desObjectList.getSelectionModel();
        selectionModel.addListSelectionListener(new TypeListener());
        JScrollPane pane = new JScrollPane(this.desObjectList);
        listPanel.add(pane);
        JPanel tablePanel = new JPanel(new BorderLayout());
        tablePanel.setPreferredSize(new Dimension(350, 200));
        this.propsTable = new JTable(new PropertiesModel());
        JTableHeader header = this.propsTable.getTableHeader();
        header.setReorderingAllowed(false);
        header.setResizingAllowed(false);
        TableColumn column = this.propsTable.getColumnModel().getColumn(0);
        column.setPreferredWidth(60);
        column.setWidth(60);
        column.setMaxWidth(80);
        column = this.propsTable.getColumnModel().getColumn(1);
        this.propsTable.setSelectionMode(0);
        JScrollPane propPane = new JScrollPane(this.propsTable);
        propPane.setPreferredSize(new Dimension(350, 200));
        tablePanel.add(propPane);
        this.objPanel.add((Component)listPanel, "West");
        this.objPanel.add((Component)tablePanel, "East");
        toolBar.add((Component)this.objPanel, "West");
        JPanel ckPanel = new JPanel(new BorderLayout());
        ckPanel.setPreferredSize(new Dimension(200, 200));
        JPanel boxesPanel = new JPanel(new FlowLayout(0));
        boxesPanel.setPreferredSize(new Dimension(200, 160));
        this.ckShowSelProp = new JCheckBox();
        this.ckShowSelProp.setSelected(this.getDesign().getShowSelPropsOnly());
        this.ckShowSelProp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EngineeringCompareDialog.this.getDesign().setShowSelPropsOnly(EngineeringCompareDialog.this.ckShowSelProp.isSelected());
            }
        });
        JLabel lbShowSelProp = new JLabel(Messages.getString("EngineeringCompareDialog.ShowSelectedPropertiesOnly"));
        this.ckNoApply = new JCheckBox();
        this.ckNoApply.setSelected(this.getDesign().getNotForNewObjects());
        this.ckNoApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EngineeringCompareDialog.this.getDesign().setNotForNewObjects(EngineeringCompareDialog.this.ckNoApply.isSelected());
            }
        });
        JLabel lbNoApply = new JLabel(Messages.getString("EngineeringCompareDialog.DontApplyForNewObjects"));
        JLabel lbExcFromTree = new JLabel(Messages.getString("EngineeringCompareDialog.ExcludeUncheckedObjectsFromTree"));
        this.ckExcFromTree = new JCheckBox();
        this.ckExcFromTree.setSelected(this.getDesign().getExcludeFromTree());
        this.ckExcFromTree.setToolTipText(Messages.getString("EngineeringCompareDialog.ExcludeFrom"));
        this.ckExcFromTree.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EngineeringCompareDialog.this.getDesign().setExcludeFromTree(EngineeringCompareDialog.this.ckExcFromTree.isSelected());
            }
        });
        JPanel pnProps = new JPanel(new FlowLayout(0));
        JPanel pnApply = new JPanel(new FlowLayout(0));
        JPanel pnExclude = new JPanel(new FlowLayout(0));
        pnProps.add(this.ckShowSelProp);
        pnProps.add(lbShowSelProp);
        pnApply.add(this.ckNoApply);
        pnApply.add(lbNoApply);
        pnExclude.add(this.ckExcFromTree);
        pnExclude.add(lbExcFromTree);
        boxesPanel.add(pnProps);
        boxesPanel.add(pnApply);
        boxesPanel.add(pnExclude);
        ckPanel.add((Component)boxesPanel, "North");
        JPanel buttPanel = new JPanel(new FlowLayout(0));
        buttPanel.setPreferredSize(new Dimension(180, 30));
        this.updateTreeButton = new JButton(Messages.getString("EngineeringCompareDialog.UpdateTree"));
        this.updateTreeButton.setMnemonic(85);
        this.updateTreeButton.setPreferredSize(MessageDialogs.BUTTON_SIZE_200);
        this.updateTreeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EngineeringCompareDialog.this.leftRoot.applySelectionToEngineering();
                if (EngineeringCompareDialog.this.designPart instanceof LogicalDesign) {
                    EngineeringCompareDialog.this.resetDesignsByLogicalSubview();
                } else {
                    EngineeringCompareDialog.this.resetDesignsByRelational();
                }
                EngineeringCompareDialog.this.cbFilter.setSelectedItem(STATE_ALL);
                EngineeringCompareDialog.this.updateCompareTable(null);
            }
        });
        buttPanel.add(this.updateTreeButton);
        ckPanel.add((Component)buttPanel, "South");
        toolBar.add(ckPanel);
        this.comparePanel.add(toolBar);
        this.tabbedPane.addTab(Messages.getString("EngineeringCompareDialog.CompareCopyOptions"), this.comparePanel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void engineer() {
        if (this.designPart instanceof LogicalDesign) {
            pd = (RelationalDesign)this.pdcombo.getSelectedItem();
            this.getDesign().setRelationalDesign(pd);
            ApplicationView.log(Messages.getString("EngineeringCompareDialog.ForwardEngineering"));
            ApplicationView.canLogging = false;
            this.getDialog().setCursor(Cursor.getPredefinedCursor(3));
            try {
                if (pd == this.currenPHdes) {
                    pd.setUseTemplateTable(this.useTemplateTable.isSelected());
                    if (this.useTemplateTable.isSelected()) {
                        pd.setTemplateTable((Table)this.templateTable.getSelectedItem());
                    } else {
                        pd.setTemplateTable(null);
                    }
                }
                pd.setMainViewVisible(false);
                this.deleteSelected(this.getDeletedMappings());
                this.leftRoot.applySelectionToEngineering();
                dpv = (DesignPartView)this.ldvcombo.getSelectedItem();
                this.getDesign().forwardEngineer(dpv, this.comparatorsMap);
                pd.sortCollections();
                if (dpv != dpv.getDesignPart().getMainView() || pd.getTableSet().size() >= 100) ** GOTO lbl45
                pd.setMainViewVisible(true);
            }
            finally {
                this.getDialog().setCursor(Cursor.getPredefinedCursor(0));
                ApplicationView.canLogging = true;
            }
        } else if (this.designPart instanceof RelationalDesign) {
            this.getDesign().setRelationalDesign((RelationalDesign)this.designPart);
            ApplicationView.log(Messages.getString("EngineeringCompareDialog.ReverseEngineering"));
            ApplicationView.canLogging = false;
            this.getDialog().setCursor(Cursor.getPredefinedCursor(3));
            try {
                this.deleteSelected(this.getDeletedMappings());
                this.leftRoot.applySelectionToEngineering();
                dpv = (DesignPartView)this.ldvcombo.getSelectedItem();
                this.getDesign().reverseEngineer(this.comparatorsMap, (DesignPartView)this.ldvcombo.getSelectedItem());
                this.getDesign().getLogicalDesign().sortCollections();
                if (dpv == dpv.getDesignPart().getMainView() && this.getDesign().getLogicalDesign().getEntitySet().size() < 100) {
                    this.getDesign().getLogicalDesign().setMainViewVisible(true);
                }
            }
            finally {
                this.getDialog().setCursor(Cursor.getPredefinedCursor(0));
                ApplicationView.canLogging = true;
            }
        }
        if (((JDialog)this.getDialog()).isModal()) {
            this.unregisterListeners();
        }
    }

    private void applySelectionOnly() {
        this.leftRoot.applySelectionToEngineering(true);
    }

    private void deleteSelected(List deletedMappings) {
        for (EngineeringObjectSelection sel : deletedMappings) {
            DesignObject obj;
            EngineeringObjectSelection cor_sel;
            if (!sel.isSelected() || (cor_sel = sel.getCorrespondentNode()) == null || cor_sel.getObject() == null || (obj = (DesignObject)cor_sel.getObject()) == null) continue;
            if (obj instanceof Entity) {
                ((Entity)obj).remove(true);
                continue;
            }
            if (obj instanceof FKIndexAssociation) {
                XtdMapping dm = cor_sel.getDelMapping();
                String del_id = null;
                if (dm != null) {
                    del_id = dm.getDeletedID();
                }
                ((FKIndexAssociation)obj).setSilentRemove(true);
                FKIndexAssociation fk = (FKIndexAssociation)obj;
                FKContainer table = fk.getTable();
                if (table != null && table instanceof Table) {
                    Index ind = ((Table)table).getUniqueIndex((Column[])fk.getColumns());
                    if (ind == null) {
                        // empty if block
                    }
                    if (ind != null && (fk.isAllColumnGenerated() || del_id != null && del_id.equals(ind.getRelationGeneratorID()))) {
                        ind.remove();
                    }
                }
                obj.remove();
                continue;
            }
            obj.remove();
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.synchroizeSelection(e);
        TreePath path = e.getPath();
        Object object = path.getLastPathComponent();
        this.updateCompareTable(object);
    }

    private void updateCompareTable(Object object) {
        if (object instanceof EngineeringObjectSelection || object == null) {
            int[] wide = new int[]{0, 0, 0, 0};
            boolean exists = this.compareTable.getColumnModel() != null;
            int count = 4;
            if (exists) {
                count = this.compareTable.getColumnModel().getColumnCount();
                for (int i = 0; i < count; ++i) {
                    wide[i] = this.compareTable.getColumnModel().getColumn(i).getWidth();
                }
            }
            GeneralPropertiesComparator pc = object == null ? new EngEmptyPropertiesComparator(null, null) : ((EngineeringObjectSelection)object).getPropertiesComparator();
            this.compareTable.setModel(new CompareModel(pc));
            this.compareTable.getColumnModel().getColumn(1);
            TableColumn column = this.compareTable.getColumnModel().getColumn(1);
            column.setPreferredWidth(60);
            column.setWidth(60);
            column.setMaxWidth(70);
            column.setCellRenderer(this.selRenderer);
            column = this.compareTable.getColumnModel().getColumn(0);
            column.setCellRenderer(this.propertyNamerenderer);
            if (exists) {
                for (int i = 0; i < count; ++i) {
                    this.compareTable.getColumnModel().getColumn(i).setWidth(wide[i]);
                    this.compareTable.getColumnModel().getColumn(i).setPreferredWidth(wide[i]);
                }
            }
            this.compareTable.updateUI();
        }
    }

    public void showInfo() {
        TreePath path = this.leftTree.getSelectionPath();
        if (path != null) {
            Object object = path.getLastPathComponent();
            this.infoTab.setText("");
            if (object instanceof DesignObjectPlaceHolder) {
                object = ((DesignObjectPlaceHolder)object).getDesignObject();
            }
            if (object != null && this.shouldShowObjectInfo(object)) {
                if (this.belongsToLogical(object)) {
                    this.showGenerator((DesignObject)object);
                    if (this.showMappings.isSelected()) {
                        this.showMappings((DesignObject)object);
                    }
                } else {
                    this.showGeneratorRel((DesignObject)object);
                }
            }
            this.infoTab.setCaretPosition(0);
        }
    }

    private boolean shouldShowObjectInfo(Object object) {
        if (this.belongsToLogical(object)) {
            return true;
        }
        return this.belongsToPhysical(object);
    }

    private boolean belongsToLogical(Object object) {
        return object instanceof Entity || object instanceof EntityView || object instanceof Attribute || object instanceof Relation || object instanceof CandidateKey;
    }

    private boolean belongsToPhysical(Object object) {
        return object instanceof Table || object instanceof TableView || object instanceof Column || object instanceof FKIndexAssociation || object instanceof Index;
    }

    private void showGenerator(DesignObject object) {
        String old = this.infoTab.getText();
        StringBuffer sb = new StringBuffer(old);
        if ("None".equalsIgnoreCase(object.getGeneratorLongName())) {
            sb.append(Messages.getString("EngineeringCompareDialog.GeneratorNameNone"));
        } else {
            sb.append(Messages.getString("EngineeringCompareDialog.GeneratorName")).append(object.getGeneratorLongName());
        }
        this.infoTab.setText(sb.toString());
    }

    private void showGeneratorRel(DesignObject object) {
        Relation relation;
        String old = this.infoTab.getText();
        StringBuffer sb = new StringBuffer(old);
        sb.append(Messages.getString("EngineeringCompareDialog.GeneratorName")).append(object.getGeneratorLongName());
        if (object instanceof Column) {
            Attribute attribute = ((Column)object).getEngAttribute();
            if (attribute != null) {
                sb.append(Messages.getString("EngineeringCompareDialog.CorrespondingAttribute")).append(attribute.getLongName());
            }
        } else if (object instanceof Table) {
            Entity entity = ((Table)object).getEngEntity();
            if (entity != null) {
                sb.append(Messages.getString("EngineeringCompareDialog.CorrespondingEntity")).append(entity.getLongName());
            }
        } else if (object instanceof FKIndexAssociation && (relation = ((FKIndexAssociation)object).getEngRelation()) != null) {
            sb.append(Messages.getString("EngineeringCompareDialog.CorrespondingRelation")).append(relation.getLongName());
        }
        this.infoTab.setText(sb.toString());
    }

    private void showMappings(DesignObject object) {
        List mappings = this.getDesign().getExtendedMap().getOrCreateCollector(object).getAllMappings();
        if (mappings.size() > 0) {
            String old = this.infoTab.getText();
            StringBuffer sb = new StringBuffer(old);
            sb.append(Messages.getString("EngineeringCompareDialog.Targets"));
            Iterator it = mappings.iterator();
            boolean hasTargets = false;
            while (it.hasNext()) {
                XtdMapping mapping = (XtdMapping)it.next();
                DesignObject dobj = mapping.getOwnerObject();
                if (dobj == null || dobj != object) continue;
                hasTargets = true;
                DesignObject target = mapping.getObjectMappedTo(object);
                if (target == null) continue;
                if (object instanceof Attribute) {
                    if (!(target instanceof Column)) continue;
                    sb.append("\n   ").append(target.getDesignPart().getName() + "." + ((ContainedObject)target).getContainer().getName() + ".").append(target.getName());
                    continue;
                }
                sb.append("\n   ").append(target.getDesignPart().getName() + ".").append(target.getName());
            }
            if (!hasTargets) {
                sb.append("NONE");
            }
            this.infoTab.setText(sb.toString());
        }
    }

    private void fillComboWithDPVs(DesignPart designp, JComboBox combo) {
        combo.addItem(designp.getMainView());
        Iterator it = designp.getDesignSubviews().iterator();
        while (it.hasNext()) {
            DesignPartViewPlaceHolder dpvph = (DesignPartViewPlaceHolder)it.next();
            combo.addItem(dpvph.getDesignPartView());
        }
        DesignPartView current = this.getApplicationView().getCurrentDPV();
        if (current != null) {
            combo.setSelectedItem(current);
        } else {
            combo.setSelectedIndex(0);
        }
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
        this.processExpEvent(event, false);
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        this.processExpEvent(event, true);
    }

    void processExpEvent(TreeExpansionEvent event, boolean state) {
        Object source = event.getSource();
        if (source instanceof JTree && !this.started) {
            this.startTree = (MyJTree)source;
            this.started = true;
            TreePath tp = event.getPath();
            EngineeringObjectSelection os = (EngineeringObjectSelection)tp.getLastPathComponent();
            MyJTree other = this.getOtherTree(this.startTree);
            other.setExpandedState(new TreePath(os.getCorrespondentNode().getPath()), state);
            this.started = false;
        }
    }

    MyJTree getOtherTree(JTree tree) {
        if (tree == this.leftTree) {
            return this.rightTree;
        }
        return this.leftTree;
    }

    private List getDeletedMappings() {
        if (this.leftEngineer != null) {
            if (this.leftEngineer instanceof FE_LogicalToRelational) {
                return ((FE_LogicalToRelational)this.leftEngineer).getDeletedMappings();
            }
            if (this.leftEngineer instanceof RE_RelationalToLogical) {
                return ((RE_RelationalToLogical)this.leftEngineer).getDeletedMappings();
            }
        }
        return new ArrayList();
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        Object source = e.getSource();
        if (source instanceof JScrollBar && !this.sb_started) {
            JScrollBar jsb = (JScrollBar)source;
            if (jsb == this.leftSB) {
                this.sb_started = true;
                this.rightSB.setValue(this.leftSB.getValue());
                this.sb_started = false;
            } else if (jsb == this.rightSB) {
                this.sb_started = true;
                this.leftSB.setValue(this.rightSB.getValue());
                this.sb_started = false;
            }
        }
    }

    private void synchroizeSelection(TreeSelectionEvent event) {
        Object source = event.getSource();
        if (source instanceof JTree && !this.sel_started) {
            this.startTree = (MyJTree)source;
            this.sel_started = true;
            TreePath tp = event.getPath();
            EngineeringObjectSelection os = (EngineeringObjectSelection)tp.getLastPathComponent();
            MyJTree other = this.getOtherTree(this.startTree);
            other.setSelectionPath(new TreePath(os.getCorrespondentNode().getPath()));
            this.sel_started = false;
        }
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), this.getCaption());
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.addWindowListener(new ClosingListener());
            this.dialog.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    int w = EngineeringCompareDialog.this.dialog.getWidth();
                    int h = EngineeringCompareDialog.this.dialog.getHeight();
                    w = Math.max(800, w);
                    h = Math.max(600, h);
                    EngineeringCompareDialog.this.dialog.setSize(w, h);
                }
            });
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
        }
        return this.dialog;
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected String getHelpIndex() {
        return "ENGINEERING_DIALOG";
    }

    public void setModal(boolean modal) {
        ((JDialog)this.getDialog()).setModal(modal);
    }

    @Override
    public void show() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel(new FlowLayout(2));
            JButton bnEngineer = new JButton(Messages.getString("EngineeringCompareDialog.Engineer"));
            bnEngineer.setMnemonic(69);
            bnEngineer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EngineeringCompareDialog.this.engineer();
                    EngineeringCompareDialog.this.close();
                }
            });
            boolean gen = this.leftRoot.checkSelected();
            bnEngineer.setEnabled(gen);
            JButton bnCancel = new JButton(Messages.getString("EngineeringCompareDialog.Cancel"));
            bnCancel.setMnemonic(67);
            bnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EngineeringCompareDialog.this.close();
                }
            });
            JButton bnApplySelection = new JButton(Messages.getString("EngineeringCompareDialog.ApplySelection"));
            bnApplySelection.setToolTipText(Messages.getString("EngineeringCompareDialog.ApplySelectionToObjectsNew"));
            bnApplySelection.setMnemonic(65);
            bnApplySelection.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EngineeringCompareDialog.this.applySelectionOnly();
                }
            });
            JButton bnHelp = new JButton(this.getHelpAction());
            bnHelp.setMnemonic(72);
            bnEngineer.setPreferredSize(MessageDialogs.BUTTON_SIZE_180);
            bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
            bnApplySelection.setPreferredSize(MessageDialogs.BUTTON_SIZE_180);
            bnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.buttonPanel.add(bnEngineer);
            this.buttonPanel.add(bnApplySelection);
            this.buttonPanel.add(bnCancel);
            this.buttonPanel.add(bnHelp);
        }
        return this.buttonPanel;
    }

    public void enableButton(String text, boolean enable) {
        if (this.buttonPanel != null) {
            Component[] comps = this.buttonPanel.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                JButton comp;
                if (!(comps[i] instanceof JButton) || !text.equals((comp = (JButton)comps[i]).getText())) continue;
                comp.setEnabled(enable);
                this.buttonPanel.validate();
                break;
            }
        }
    }

    private void setFilter(JTree tree, EngFilter filter) {
        EngineeringObjectSelection rightRoot = (EngineeringObjectSelection)tree.getModel().getRoot();
        int index = rightRoot.getNumberOfChildren();
        for (int i = 0; i < index; ++i) {
            ((EngFilteredSelection)rightRoot.getChild(i)).setFilter(filter);
        }
    }

    private JPopupMenu getFilterPopupMenu() {
        if (this.menu == null) {
            this.menu = new JPopupMenu();
            this.item.addActionListener(new ShowAllListener());
            this.item.setSelected(true);
            this.item.setEnabled(false);
            this.item1.addActionListener(new PopupMenuListener());
            this.item2.addActionListener(new PopupMenuListener());
            this.item3.addActionListener(new PopupMenuListener());
            this.menu.add(this.item);
            this.menu.add(this.item1);
            this.menu.add(this.item2);
            this.menu.add(this.item3);
        }
        return this.menu;
    }

    private void initOverlappingKeysPanel(LogicalDesign ldes) {
        DisabledCellRenderer disabledRend = new DisabledCellRenderer();
        this.overlappingEnts = this.getOverlappingEntities(ldes);
        if (this.overlappingEnts.size() > 0) {
            this.currentEntHolder = (LogicalDesign.EntHolder)this.overlappingEnts.get(0);
            Collections.sort(this.currentEntHolder.attrHolders, new StringComparator());
        }
        this.entitiesPanel = new JPanel(new BorderLayout());
        this.attributesPanel = new JPanel(new BorderLayout());
        this.entsJTable = new JTable(new EntitiesModel());
        TableColumn column = this.entsJTable.getColumnModel().getColumn(0);
        column.setPreferredWidth(65);
        column.setWidth(65);
        column.setMaxWidth(70);
        column.setCellRenderer(disabledRend);
        column = this.entsJTable.getColumnModel().getColumn(1);
        column.setPreferredWidth(65);
        column.setWidth(65);
        column.setMaxWidth(70);
        column.setCellRenderer(disabledRend);
        JScrollPane jsp = new JScrollPane(this.entsJTable);
        this.entitiesPanel.add(jsp);
        this.overlappedAttributesModel = new OverlappedAttributesModel();
        this.attribsJTable = new JTable(this.overlappedAttributesModel);
        column = this.attribsJTable.getColumnModel().getColumn(0);
        column.setPreferredWidth(50);
        column.setWidth(50);
        column.setMaxWidth(60);
        column = this.attribsJTable.getColumnModel().getColumn(1);
        column.setPreferredWidth(40);
        column.setWidth(40);
        column.setMaxWidth(50);
        column.setCellRenderer(disabledRend);
        column = this.attribsJTable.getColumnModel().getColumn(2);
        column.setPreferredWidth(60);
        column.setWidth(60);
        column.setMaxWidth(70);
        column.setCellRenderer(disabledRend);
        column = this.attribsJTable.getColumnModel().getColumn(3);
        column.setCellRenderer(new OverlappedCellRenderer());
        jsp = new JScrollPane(this.attribsJTable);
        this.attributesPanel.add(jsp);
        JSplitPane sp1 = new JSplitPane(1);
        sp1.setLeftComponent(this.entitiesPanel);
        sp1.setRightComponent(this.attributesPanel);
        sp1.setDividerLocation(-1);
        sp1.setResizeWeight(0.4);
        this.tabbedPane.add(Messages.getString("EngineeringCompareDialog.OverlappingAndFoldingKeys"), sp1);
        if (this.overlappingEnts.size() > 0) {
            this.entsJTable.setSelectionMode(0);
            this.entsJTable.getSelectionModel().addListSelectionListener(new EntSelectionListener());
            this.entsJTable.getSelectionModel().setSelectionInterval(0, 0);
            this.tabbedPane.setSelectedComponent(sp1);
        }
    }

    private List getOverlappingEntities(LogicalDesign ldes) {
        List list = ldes.getEntitiesWuthOverlappingKeys(true);
        return list;
    }

    private void scanOverlappingStatus(RelationalDesign phdes) {
        for (LogicalDesign.EntHolder entHolder : this.overlappingEnts) {
            for (LogicalDesign.AttrHolder holder : entHolder.attrHolders) {
                Entity entity = (Entity)holder.attr1.getContainerWithKeyObject();
                ContainedObject col1 = holder.attr1.getEngColumn(phdes);
                ContainedObject col2 = holder.attr2.getEngColumn(phdes);
                if (col1 != null && col2 != null && col1 == col2) {
                    holder.overlapped = true;
                    holder.overlap = true;
                    continue;
                }
                if (col1 != null && col2 != null) {
                    holder.overlapped = false;
                    holder.overlap = false;
                    continue;
                }
                if (col1 != null || col2 != null) continue;
                Map folded = entity.getFoldedAttributesMap();
                boolean fold = false;
                String id1 = (String)folded.get(holder.attr1.getObjectID());
                if (id1 != null && id1.equals(holder.attr2.getObjectID())) {
                    fold = true;
                }
                if (!fold && (id1 = (String)folded.get(holder.attr2.getObjectID())) != null && id1.equals(holder.attr1.getObjectID())) {
                    fold = true;
                }
                holder.overlapped = false;
                holder.overlap = fold;
            }
        }
        this.entsJTable.updateUI();
        this.attribsJTable.updateUI();
    }

    private void addToList(List list, List listToAdd, JTable table) {
        for (EngPropertyHolder holder : list) {
            listToAdd.add(holder);
            table.updateUI();
        }
    }

    public PopupListener getPopUPListener() {
        if (this.spopUPListener == null) {
            this.spopUPListener = new PopupListener();
        }
        return this.spopUPListener;
    }

    class PopupListener
    extends MouseAdapter {
        private TreePath treePath;

        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Component comp;
            if (!OSEnvironment.isWindows() && (comp = EngineeringCompareDialog.this.leftTree.findComponentAt(e.getPoint())) instanceof JCheckBox && !EngineeringCompareDialog.this.started && !e.isPopupTrigger()) {
                ((JCheckBox)comp).doClick();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            Component comp;
            if (OSEnvironment.isWindows() && (comp = EngineeringCompareDialog.this.leftTree.findComponentAt(e.getPoint())) instanceof JCheckBox && !EngineeringCompareDialog.this.started && !e.isPopupTrigger()) {
                ((JCheckBox)comp).doClick();
            }
        }
    }

    private class UpdateTreeListener
    implements ActionListener {
        private UpdateTreeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EngineeringCompareDialog.this.resetDesignsByLogicalSubview();
            EngineeringCompareDialog.this.cbFilter.setSelectedItem(STATE_ALL);
            EngineeringCompareDialog.this.updateCompareTable(null);
        }
    }

    class TypeListener
    implements ListSelectionListener {
        TypeListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            EngineeringCompareDialog.this.propertiesList.clear();
            if (((String)EngineeringCompareDialog.this.desObjectList.getSelectedValue()).equalsIgnoreCase(Design.ENTITY_TABLE)) {
                EngineeringCompareDialog.this.addToList(EngineeringCompareDialog.this.getDesign().getEntTablePropertyList(), EngineeringCompareDialog.this.propertiesList, EngineeringCompareDialog.this.propsTable);
            } else if (((String)EngineeringCompareDialog.this.desObjectList.getSelectedValue()).equalsIgnoreCase(Design.ATTRIBUTE_COLUMN)) {
                EngineeringCompareDialog.this.addToList(EngineeringCompareDialog.this.getDesign().getAttrColPropertyList(), EngineeringCompareDialog.this.propertiesList, EngineeringCompareDialog.this.propsTable);
            } else if (((String)EngineeringCompareDialog.this.desObjectList.getSelectedValue()).equalsIgnoreCase(Design.KEY_INDEX)) {
                EngineeringCompareDialog.this.addToList(EngineeringCompareDialog.this.getDesign().getKeyIdxPropertyList(), EngineeringCompareDialog.this.propertiesList, EngineeringCompareDialog.this.propsTable);
            } else if (((String)EngineeringCompareDialog.this.desObjectList.getSelectedValue()).equalsIgnoreCase(Design.RELATION_FK)) {
                EngineeringCompareDialog.this.addToList(EngineeringCompareDialog.this.getDesign().getRelFKPropertyList(), EngineeringCompareDialog.this.propertiesList, EngineeringCompareDialog.this.propsTable);
            } else if (((String)EngineeringCompareDialog.this.desObjectList.getSelectedValue()).equalsIgnoreCase(Design.RELATION_TABLE)) {
                EngineeringCompareDialog.this.addToList(EngineeringCompareDialog.this.getDesign().getRelTablePropertyList(), EngineeringCompareDialog.this.propertiesList, EngineeringCompareDialog.this.propsTable);
            } else if (((String)EngineeringCompareDialog.this.desObjectList.getSelectedValue()).equalsIgnoreCase(Design.ENTVIEW_TBLVIEW)) {
                EngineeringCompareDialog.this.addToList(EngineeringCompareDialog.this.getDesign().getViewPropertyList(), EngineeringCompareDialog.this.propertiesList, EngineeringCompareDialog.this.propsTable);
            }
        }
    }

    class PropertiesModel
    extends AbstractTableModel {
        PropertiesModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("EngineeringCompareDialog.Selected");
            }
            if (column == 1) {
                return Messages.getString("EngineeringCompareDialog.Property");
            }
            return "";
        }

        @Override
        public int getRowCount() {
            return EngineeringCompareDialog.this.propertiesList.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            EngPropertyHolder h = (EngPropertyHolder)EngineeringCompareDialog.this.propertiesList.get(row);
            if (col == 0) {
                return new Boolean(h.isSelected());
            }
            if (col == 1) {
                return h.getName();
            }
            return new Integer(row * col);
        }

        public Class getColumnClass(int column) {
            return this.getValueAt(0, column).getClass();
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            EngPropertyHolder obj = (EngPropertyHolder)EngineeringCompareDialog.this.propertiesList.get(row);
            if (col == 0) {
                obj.setSelected((Boolean)value);
            }
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 0;
        }
    }

    public class EntSelectionListener
    implements ListSelectionListener {
        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            int row = ((ListSelectionModel)e.getSource()).getAnchorSelectionIndex();
            if (row != -1) {
                EngineeringCompareDialog.this.currentEntHolder = (LogicalDesign.EntHolder)EngineeringCompareDialog.this.overlappingEnts.get(row);
                Collections.sort(EngineeringCompareDialog.this.currentEntHolder.attrHolders, new StringComparator());
                EngineeringCompareDialog.this.attribsJTable.updateUI();
            }
        }
    }

    public class EntitiesModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return EngineeringCompareDialog.this.overlappingEnts.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("EngineeringCompareDialog.Overlapping");
            }
            if (column == 1) {
                return Messages.getString("EngineeringCompareDialog.Overlapped");
            }
            if (column == 2) {
                return Messages.getString("EngineeringCompareDialog.Entities");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        boolean hasOverlapping(List list) {
            for (LogicalDesign.AttrHolder holder : list) {
                if (!holder.overlap) continue;
                return true;
            }
            return false;
        }

        boolean hasOverlappedCols(List list) {
            for (LogicalDesign.AttrHolder holder : list) {
                if (!holder.overlapped) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object getValueAt(int row, int col) {
            LogicalDesign.EntHolder holder = (LogicalDesign.EntHolder)EngineeringCompareDialog.this.overlappingEnts.get(row);
            if (col == 0) {
                return new Boolean(this.hasOverlapping(holder.attrHolders));
            }
            if (col == 1) {
                return new Boolean(this.hasOverlappedCols(holder.attrHolders));
            }
            if (col == 2) {
                return holder.ent.getName();
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
        }
    }

    public class OverlappedAttributesModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            if (EngineeringCompareDialog.this.currentEntHolder != null) {
                return EngineeringCompareDialog.this.currentEntHolder.attrHolders.size();
            }
            return 0;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("EngineeringCompareDialog.Overlap");
            }
            if (column == 1) {
                return Messages.getString("EngineeringCompareDialog.InPK");
            }
            if (column == 2) {
                return Messages.getString("EngineeringCompareDialog.Overlapped");
            }
            if (column == 3) {
                return Messages.getString("EngineeringCompareDialog.AttributesPairs");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (columnIndex == 0 && EngineeringCompareDialog.this.currentEntHolder != null) {
                LogicalDesign.AttrHolder holder = (LogicalDesign.AttrHolder)EngineeringCompareDialog.this.currentEntHolder.attrHolders.get(rowIndex);
                return !holder.readOnly;
            }
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            LogicalDesign.AttrHolder holder = (LogicalDesign.AttrHolder)EngineeringCompareDialog.this.currentEntHolder.attrHolders.get(row);
            if (col == 0) {
                return new Boolean(holder.overlap);
            }
            if (col == 1) {
                return new Boolean(holder.inpk);
            }
            if (col == 2) {
                return new Boolean(holder.overlapped);
            }
            if (col == 3) {
                return holder.attr1.getName() + " - " + holder.attr2.getName();
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            LogicalDesign.AttrHolder holder = (LogicalDesign.AttrHolder)EngineeringCompareDialog.this.currentEntHolder.attrHolders.get(row);
            if (col == 0) {
                boolean overlap;
                holder.overlap = overlap = ((Boolean)aValue).booleanValue();
                this.setRelatedReadOnly(holder, overlap);
                holder.readOnly = false;
                this.fireTableDataChanged();
            }
        }

        private void setRelatedReadOnly(LogicalDesign.AttrHolder holder, boolean overlap) {
            for (LogicalDesign.AttrHolder attrHolder : holder.relatedHolders) {
                attrHolder.readOnly = overlap;
            }
        }
    }

    class ShowAllListener
    implements ActionListener {
        EngFilter filter = new EngFilter();

        ShowAllListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EngineeringCompareDialog.this.item.isSelected()) {
                this.filter.clearFilters();
                EngineeringCompareDialog.this.item.setEnabled(false);
                EngineeringCompareDialog.this.item1.setSelected(false);
                EngineeringCompareDialog.this.item2.setSelected(false);
                EngineeringCompareDialog.this.item3.setSelected(false);
                this.filter.addFilter(EngFilter.NO_FILTER);
                EngineeringCompareDialog.this.setFilter(EngineeringCompareDialog.this.leftTree, this.filter);
                EngineeringCompareDialog.this.setFilter(EngineeringCompareDialog.this.rightTree, this.filter);
                EngineeringCompareDialog.this.leftTree.updateUI();
                EngineeringCompareDialog.this.rightTree.updateUI();
            } else {
                EngineeringCompareDialog.this.item.setEnabled(true);
            }
            EngineeringCompareDialog.this.item.setSelected(true);
        }
    }

    class PopupMenuListener
    implements ActionListener {
        EngFilter filter = new EngFilter();

        PopupMenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.filter.clearFilters();
            if (EngineeringCompareDialog.this.item1.isSelected() || EngineeringCompareDialog.this.item2.isSelected() || EngineeringCompareDialog.this.item3.isSelected()) {
                EngineeringCompareDialog.this.item.setSelected(false);
            }
            if (EngineeringCompareDialog.this.item1.isSelected()) {
                this.filter.addFilter(EngFilter.STATE_NEW_FILTER);
            }
            if (EngineeringCompareDialog.this.item2.isSelected()) {
                this.filter.addFilter(EngFilter.STATE_DELETED_FILTER);
            }
            if (EngineeringCompareDialog.this.item3.isSelected()) {
                this.filter.addFilter(EngFilter.STATE_MODIFIED_FILTER);
            }
            EngineeringCompareDialog.this.item.setEnabled(true);
            if (!(EngineeringCompareDialog.this.item1.isSelected() || EngineeringCompareDialog.this.item2.isSelected() || EngineeringCompareDialog.this.item3.isSelected())) {
                this.filter.addFilter(EngFilter.NO_FILTER);
                EngineeringCompareDialog.this.item.setSelected(true);
                EngineeringCompareDialog.this.item.setEnabled(false);
            }
            EngineeringCompareDialog.this.setFilter(EngineeringCompareDialog.this.leftTree, this.filter);
            EngineeringCompareDialog.this.setFilter(EngineeringCompareDialog.this.rightTree, this.filter);
            EngineeringCompareDialog.this.leftTree.updateUI();
            EngineeringCompareDialog.this.rightTree.updateUI();
        }
    }

    class OverlappedCellRenderer
    extends JLabel
    implements TableCellRenderer {
        OverlappedCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            if (table.getModel() instanceof OverlappedAttributesModel && EngineeringCompareDialog.this.currentEntHolder != null) {
                LogicalDesign.AttrHolder holder = (LogicalDesign.AttrHolder)EngineeringCompareDialog.this.currentEntHolder.attrHolders.get(row);
                this.setOpaque(true);
                String text = (String)value;
                this.setText(text);
                if (holder.relatedHolders.size() > 1) {
                    this.setForeground(Color.RED);
                } else {
                    this.setForeground(table.getForeground());
                }
                if (isSelected) {
                    this.setBackground(table.getSelectionBackground());
                } else {
                    this.setBackground(table.getBackground());
                }
            }
            this.setHorizontalAlignment(2);
            return this;
        }
    }

    class ModifiableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        ModifiableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            if (table.getModel() instanceof CompareModel) {
                CompareModel cm = (CompareModel)table.getModel();
                EngPropertyHolder ph = (EngPropertyHolder)cm.getPropertiesList().get(row);
                this.setOpaque(true);
                this.setText(ph.getName());
                if (ph.isModified() && ph.isFiltered()) {
                    this.setForeground(new Color(0, 204, 51));
                } else if (ph.isModified() && !ph.isFiltered()) {
                    this.setForeground(Color.RED);
                } else {
                    this.setForeground(table.getForeground());
                }
                if (isSelected) {
                    this.setBackground(table.getSelectionBackground());
                    if (!ph.isModified()) {
                        this.setForeground(table.getSelectionForeground());
                    }
                } else {
                    this.setBackground(table.getBackground());
                }
            }
            this.setHorizontalAlignment(2);
            return this;
        }
    }

    class DisabledCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        DisabledCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            boolean val = (Boolean)value;
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
            this.setSelected(val);
            this.setEnabled(false);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            return this;
        }
    }

    class SelectedCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        SelectedCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            boolean val = (Boolean)value;
            if (table.getModel() instanceof CompareModel) {
                CompareModel cm = (CompareModel)table.getModel();
                EngPropertyHolder ph = (EngPropertyHolder)cm.getPropertiesList().get(row);
                this.setOpaque(true);
                this.setHorizontalAlignment(0);
                this.setSelected(val);
                if (ph.isModified() && !ph.isFiltered() && !cm.isReadonly()) {
                    this.setEnabled(true);
                } else {
                    this.setEnabled(false);
                }
                if (isSelected) {
                    this.setBackground(table.getSelectionBackground());
                } else {
                    this.setBackground(table.getBackground());
                }
            } else if (table.getModel() instanceof PropertiesModel) {
                this.setOpaque(true);
                this.setHorizontalAlignment(0);
                this.setSelected(val);
                if (isSelected) {
                    this.setBackground(table.getSelectionBackground());
                } else {
                    this.setBackground(table.getBackground());
                }
            }
            return this;
        }
    }

    public class DeletedModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return EngineeringCompareDialog.this.getDeletedMappings().size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("EngineeringCompareDialog.Select");
            }
            if (column == 1) {
                return Messages.getString("EngineeringCompareDialog.Deleted");
            }
            if (column == 2) {
                return Messages.getString("EngineeringCompareDialog.ToBeDeleted");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        private String getName(EngineeringObjectSelection sel) {
            if (sel.getObject() != null) {
                return sel.getObject().getLongName();
            }
            return sel.getName();
        }

        @Override
        public Object getValueAt(int row, int col) {
            EngineeringObjectSelection sel = (EngineeringObjectSelection)EngineeringCompareDialog.this.getDeletedMappings().get(row);
            if (col == 0) {
                return new Boolean(sel.isSelected());
            }
            if (col == 1) {
                return this.getName(sel);
            }
            if (col == 2) {
                return this.getName(sel.getCorrespondentNode());
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            EngineeringObjectSelection sel = (EngineeringObjectSelection)EngineeringCompareDialog.this.getDeletedMappings().get(row);
            if (col == 0) {
                sel.setSelected((Boolean)aValue, false);
            }
        }
    }

    public class CompareModel
    extends AbstractTableModel {
        private GeneralPropertiesComparator comp;

        CompareModel(GeneralPropertiesComparator comparator) {
            this.comp = comparator;
        }

        public List getPropertiesList() {
            return this.comp.getPropertiesList();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return this.comp.getPropertiesList().size();
        }

        private boolean isReadonly() {
            return ((EngPropertiesComparator)this.comp).isReadOnly();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("EngineeringCompareDialog.Property");
            }
            if (column == 1) {
                return Messages.getString("EngineeringCompareDialog.Selected");
            }
            if (column == 2) {
                return this.comp.getLeftName();
            }
            if (column == 3) {
                return this.comp.getRightName();
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (((EngPropertiesComparator)this.comp).isReadOnly()) {
                return false;
            }
            if (columnIndex == 1) {
                EngPropertyHolder ph = (EngPropertyHolder)this.comp.getPropertiesList().get(rowIndex);
                return ph.isEditable();
            }
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            EngPropertyHolder ph = (EngPropertyHolder)this.comp.getPropertiesList().get(row);
            if (col == 0) {
                return ph.getName();
            }
            if (col == 1) {
                return new Boolean(ph.isSelected());
            }
            if (col == 2) {
                return ph.getLeftValue();
            }
            if (col == 3) {
                return ph.getRightValue();
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            if (col == 1) {
                EngPropertyHolder ph = (EngPropertyHolder)this.comp.getPropertiesList().get(row);
                ph.setSelected((Boolean)aValue);
            }
        }
    }

    class MyJTree
    extends JTree {
        public MyJTree(TreeModel model) {
            super(model);
        }

        public MyJTree() {
        }

        @Override
        protected void setExpandedState(TreePath path, boolean state) {
            super.setExpandedState(path, state);
        }
    }

    class ClosingListener
    extends WindowAdapter {
        ClosingListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            EngineeringCompareDialog.this.unregisterListeners();
        }
    }
}

