/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.metadata.udb;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.swingui.wizards.Messages;
import oracle.dbtools.crest.swingui.wizards.metadata.AbstractDBMExtractionWizardImpl;
import oracle.dbtools.crest.swingui.wizards.metadata.DBMExtractionWizard;

public class DBMExtractionWizardUDB
extends AbstractDBMExtractionWizardImpl {
    private static DBMExtractionWizardUDB impl;
    protected JTable tbAliases;
    protected JTable tbBufferpools;
    protected JTable tbOwners;
    protected JTable tbUsergroups;
    protected JTable tbProcedures;
    protected JTable tbTablespaces;
    protected JTable tbDatatypes;
    protected JTable tbSummaryTables;
    protected JTable tbStagingTables;
    protected JTable tbTypedTables;
    protected List aliases = new ArrayList();
    protected List bufferpools = new ArrayList();
    protected List owners = new ArrayList();
    protected List usergroups = new ArrayList();
    protected List procedures = new ArrayList();
    protected List tablespaces = new ArrayList();
    protected List datatypes = new ArrayList();
    protected List summarytables = new ArrayList();
    protected List stagingtables = new ArrayList();
    protected List typedtables = new ArrayList();

    public DBMExtractionWizardUDB(DBMExtractionWizard wizard) {
        super(wizard);
    }

    public static AbstractDBMExtractionWizardImpl getInstance(DBMExtractionWizard wizard) {
        if (impl == null) {
            impl = new DBMExtractionWizardUDB(wizard);
        }
        return impl;
    }

    public static void clearInstance() {
        impl = null;
    }

    @Override
    protected List getCurrentList() {
        int tab = this.getTabbedPane().getSelectedIndex();
        switch (tab) {
            case 0: {
                return this.lsTables;
            }
            case 1: {
                return this.summarytables;
            }
            case 2: {
                return this.stagingtables;
            }
            case 3: {
                return this.typedtables;
            }
            case 4: {
                return this.lsViews;
            }
            case 5: {
                return this.aliases;
            }
            case 6: {
                return this.bufferpools;
            }
            case 7: {
                return this.owners;
            }
            case 8: {
                return this.usergroups;
            }
            case 9: {
                return this.procedures;
            }
            case 10: {
                return this.tablespaces;
            }
            case 11: {
                return this.datatypes;
            }
        }
        return this.lsTables;
    }

    @Override
    protected void addTabs() {
        this.tbTables = this.addTab(this.tbTables, this.lsTables, Messages.getString("DBMExtractionWizardUDB.Tables"));
        this.tbSummaryTables = this.addTab(this.tbSummaryTables, this.summarytables, Messages.getString("DBMExtractionWizardUDB.SummaryTables"));
        this.tbStagingTables = this.addTab(this.tbStagingTables, this.stagingtables, Messages.getString("DBMExtractionWizardUDB.StagingTables"));
        this.tbTypedTables = this.addTab(this.tbTypedTables, this.typedtables, Messages.getString("DBMExtractionWizardUDB.TypedTables"));
        this.tbViews = this.addTab(this.tbViews, this.lsViews, Messages.getString("DBMExtractionWizardUDB.Views"));
        this.tbAliases = this.addTab(this.tbAliases, this.aliases, Messages.getString("DBMExtractionWizardUDB.Aliases"));
        this.tbBufferpools = this.addTab(this.tbBufferpools, this.bufferpools, Messages.getString("DBMExtractionWizardUDB.Bufferpools"));
        this.tbOwners = this.addTab(this.tbOwners, this.owners, Messages.getString("DBMExtractionWizardUDB.Owners"));
        this.tbUsergroups = this.addTab(this.tbUsergroups, this.usergroups, Messages.getString("DBMExtractionWizardUDB.Usergroups"));
        this.tbProcedures = this.addTabProcedure(this.tbProcedures, this.procedures, Messages.getString("DBMExtractionWizardUDB.Procedures"));
        this.tbTablespaces = this.addTab(this.tbTablespaces, this.tablespaces, Messages.getString("DBMExtractionWizardUDB.Tablespaces"));
        this.tbDatatypes = this.addTabDataType(this.tbDatatypes, this.datatypes, Messages.getString("DBMExtractionWizardUDB.Datatypes"));
    }

    @Override
    protected void updateTables() {
        this.tbTables.updateUI();
        this.tbViews.updateUI();
        this.tbAliases.updateUI();
        this.tbBufferpools.updateUI();
        this.tbOwners.updateUI();
        this.tbUsergroups.updateUI();
        this.tbProcedures.updateUI();
        this.tbTablespaces.updateUI();
        this.tbDatatypes.updateUI();
        this.tbSummaryTables.updateUI();
        this.tbStagingTables.updateUI();
        this.tbTypedTables.updateUI();
    }

    @Override
    protected void clearAll() {
        this.lsTables.clear();
        this.lsViews.clear();
        this.aliases.clear();
        this.bufferpools.clear();
        this.owners.clear();
        this.usergroups.clear();
        this.procedures.clear();
        this.tablespaces.clear();
        this.datatypes.clear();
        this.summarytables.clear();
        this.stagingtables.clear();
        this.typedtables.clear();
    }

    @Override
    protected void initSpecificObjects(List dbObjects) {
        this.clearAll();
        for (DBObject dbo : dbObjects) {
            String type = dbo.getType();
            if (type.equalsIgnoreCase("TABLE")) {
                this.lsTables.add(dbo);
                continue;
            }
            if (type.equalsIgnoreCase("VIEW")) {
                this.lsViews.add(dbo);
                continue;
            }
            if (type.equalsIgnoreCase("ALIAS")) {
                this.aliases.add(dbo);
                continue;
            }
            if (type.equalsIgnoreCase("BUFFERPOOL")) {
                this.bufferpools.add(dbo);
                continue;
            }
            if (type.equalsIgnoreCase("OWNER")) {
                this.owners.add(dbo);
                continue;
            }
            if (type.equalsIgnoreCase("USERGROUP")) {
                this.usergroups.add(dbo);
                continue;
            }
            if (type.equalsIgnoreCase("PROCEDURE")) {
                this.procedures.add(dbo);
                continue;
            }
            if (type.equalsIgnoreCase("TABLESPACE")) {
                this.tablespaces.add(dbo);
                continue;
            }
            if (type.equalsIgnoreCase("DATATYPE") || type.equalsIgnoreCase("TYPE")) {
                this.datatypes.add(dbo);
                continue;
            }
            if (type.equalsIgnoreCase("SUMMARY TABLE")) {
                this.summarytables.add(dbo);
                continue;
            }
            if (type.equalsIgnoreCase("STAGING TABLE")) {
                this.stagingtables.add(dbo);
                continue;
            }
            if (!type.equalsIgnoreCase("TYPED TABLE")) continue;
            this.typedtables.add(dbo);
        }
    }

    @Override
    public List getSelectedObjects() {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        for (DBObject dbo : this.lsTables) {
            if (!dbo.isSelected()) continue;
            list.add(dbo);
        }
        for (DBObject dbo : this.lsViews) {
            if (!dbo.isSelected()) continue;
            list.add(dbo);
        }
        for (DBObject dbo : this.aliases) {
            if (!dbo.isSelected()) continue;
            list.add(dbo);
        }
        for (DBObject dbo : this.bufferpools) {
            if (!dbo.isSelected()) continue;
            list.add(dbo);
        }
        for (DBObject dbo : this.owners) {
            if (!dbo.isSelected()) continue;
            list.add(dbo);
        }
        for (DBObject dbo : this.usergroups) {
            if (!dbo.isSelected()) continue;
            list.add(dbo);
        }
        for (DBObject dbo : this.procedures) {
            if (!dbo.isSelected()) continue;
            list.add(dbo);
        }
        for (DBObject dbo : this.tablespaces) {
            if (!dbo.isSelected()) continue;
            list.add(dbo);
        }
        for (DBObject dbo : this.datatypes) {
            if (!dbo.isSelected()) continue;
            list.add(dbo);
        }
        for (DBObject dbo : this.summarytables) {
            if (!dbo.isSelected()) continue;
            list.add(dbo);
        }
        for (DBObject dbo : this.stagingtables) {
            if (!dbo.isSelected()) continue;
            list.add(dbo);
        }
        for (DBObject dbo : this.typedtables) {
            if (!dbo.isSelected()) continue;
            list.add(dbo);
        }
        return list;
    }

    protected JTable addTabProcedure(JTable table, List list, String name) {
        table = new JTable(new ProcedureModel(list));
        TableColumn column = table.getColumnModel().getColumn(0);
        column.setPreferredWidth(10);
        column = table.getColumnModel().getColumn(1);
        column.setPreferredWidth(50);
        column = table.getColumnModel().getColumn(2);
        column.setPreferredWidth(60);
        column = table.getColumnModel().getColumn(3);
        column.setPreferredWidth(60);
        JScrollPane sp = new JScrollPane(table);
        this.getTabbedPane().addTab(name, sp);
        return table;
    }

    protected JTable addTabDataType(JTable table, List list, String name) {
        table = new JTable(new DataTypeModel(list));
        TableColumn column = table.getColumnModel().getColumn(0);
        column.setPreferredWidth(10);
        column = table.getColumnModel().getColumn(1);
        column.setPreferredWidth(50);
        column = table.getColumnModel().getColumn(2);
        column.setPreferredWidth(60);
        column = table.getColumnModel().getColumn(3);
        column.setPreferredWidth(60);
        JScrollPane sp = new JScrollPane(table);
        this.getTabbedPane().addTab(name, sp);
        return table;
    }

    class DataTypeModel
    extends AbstractTableModel {
        List list;

        public DataTypeModel(List list) {
            this.list = list;
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return this.list.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("DBMExtractionWizardUDB.Selected");
            }
            if (column == 1) {
                return Messages.getString("DBMExtractionWizardUDB.Schema");
            }
            if (column == 2) {
                return Messages.getString("DBMExtractionWizardUDB.ObjectName");
            }
            if (column == 3) {
                return Messages.getString("DBMExtractionWizardUDB.DataType");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            DBObject dbo = (DBObject)this.list.get(row);
            switch (col) {
                case 0: {
                    return dbo.isSelected();
                }
                case 1: {
                    return dbo.getSchema();
                }
                case 2: {
                    return dbo.getName();
                }
                case 3: {
                    return dbo.getSpecificName();
                }
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                DBObject dbo = (DBObject)this.list.get(rowIndex);
                DBMExtractionWizardUDB.this.setSelected(dbo, (Boolean)aValue);
            }
        }
    }

    class ProcedureModel
    extends AbstractTableModel {
        List list;

        public ProcedureModel(List list) {
            this.list = list;
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return this.list.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("DBMExtractionWizardUDB.Selected");
            }
            if (column == 1) {
                return Messages.getString("DBMExtractionWizardUDB.Schema");
            }
            if (column == 2) {
                return Messages.getString("DBMExtractionWizardUDB.ObjectName");
            }
            if (column == 3) {
                return Messages.getString("DBMExtractionWizardUDB.SpecificName");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            DBObject dbo = (DBObject)this.list.get(row);
            switch (col) {
                case 0: {
                    return dbo.isSelected();
                }
                case 1: {
                    return dbo.getSchema();
                }
                case 2: {
                    return dbo.getName();
                }
                case 3: {
                    return dbo.getSpecificName();
                }
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                DBObject dbo = (DBObject)this.list.get(rowIndex);
                DBMExtractionWizardUDB.this.setSelected(dbo, (Boolean)aValue);
            }
        }
    }
}

