/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.util.FilteredJList;

public class ASJListsPanel {
    private DesignObject desObj;
    private FilteredJList allList;
    private FilteredJList selectedList;
    private JButton btnAdd;
    private JButton btnRemove;

    public ASJListsPanel(DesignObject desObj) {
        this.desObj = desObj;
    }

    public JPanel getPanel() {
        JPanel jpanel = new JPanel();
        BoxLayout bl = new BoxLayout(jpanel, 2);
        jpanel.setLayout(bl);
        this.initAllList(jpanel);
        this.initButtons(jpanel);
        this.initSelectedList(jpanel);
        return jpanel;
    }

    private void initAllList(JPanel jpanel) {
        JPanel pnAvailable = new JPanel(new BorderLayout(0, 5));
        pnAvailable.setBorder(BorderFactory.createTitledBorder("Available"));
        pnAvailable.setPreferredSize(new Dimension(100, 100));
        this.allList = new FilteredJList();
        JTextField tf = this.allList.getFilterField();
        tf.setPreferredSize(new Dimension(150, 20));
        tf.setMinimumSize(new Dimension(150, 20));
        tf.setMaximumSize(new Dimension(150, 20));
        ListSelectionModel listSelectionModel = this.allList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allList);
        sp.setPreferredSize(new Dimension(145, 220));
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorder(null);
        toolBar.add(tf);
        pnAvailable.add((Component)toolBar, "North");
        pnAvailable.add((Component)sp, "Center");
        jpanel.add(pnAvailable);
    }

    private void initSelectedList(JPanel jpanel) {
        JPanel pnSelected = new JPanel(new BorderLayout(0, 5));
        pnSelected.setBorder(BorderFactory.createTitledBorder("Selected"));
        pnSelected.setPreferredSize(new Dimension(100, 100));
        this.selectedList = new FilteredJList();
        JTextField tf = this.selectedList.getFilterField();
        tf.setPreferredSize(new Dimension(150, 20));
        tf.setMinimumSize(new Dimension(150, 20));
        tf.setMaximumSize(new Dimension(150, 20));
        ListSelectionModel listSelectionModel = this.selectedList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedList);
        sp.setPreferredSize(new Dimension(145, 220));
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorder(null);
        toolBar.add(tf);
        pnSelected.add((Component)toolBar, "North");
        pnSelected.add((Component)sp, "Center");
        jpanel.add(pnSelected);
    }

    private void initButtons(JPanel jpanel) {
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        this.btnAdd = new JButton(configuration.getIcon("MOVE_RIGHT_ICON", 16));
        this.btnAdd.setPreferredSize(new Dimension(32, 32));
        this.btnAdd.setEnabled(false);
        this.btnAdd.setToolTipText("Add");
        this.btnRemove = new JButton(configuration.getIcon("MOVE_LEFT_ICON", 16));
        this.btnRemove.setPreferredSize(new Dimension(32, 32));
        this.btnRemove.setEnabled(false);
        this.btnRemove.setToolTipText("Remove");
        Box verticalBox = Box.createVerticalBox();
        verticalBox.add(Box.createVerticalGlue());
        verticalBox.add(this.btnAdd);
        verticalBox.add(this.btnRemove);
        verticalBox.add(Box.createVerticalGlue());
        jpanel.add(verticalBox);
    }

    protected boolean isEditable() {
        if (this.desObj.getDesign().isHidden()) {
            return false;
        }
        if (this.desObj.isReadOnly()) {
            return false;
        }
        if (this.desObj.isRemoteObject()) {
            return false;
        }
        if (ApplicationView.IS_VIEWER) {
            return false;
        }
        if (ApplicationView.LOGICAL_MODEL_ONLY) {
            return this.desObj.getDesignPart() instanceof LogicalDesign;
        }
        return true;
    }

    public FilteredJList getAllList() {
        return this.allList;
    }

    public FilteredJList getSelectedList() {
        return this.selectedList;
    }

    public JButton getBtnAdd() {
        return this.btnAdd;
    }

    public JButton getBtnRemove() {
        return this.btnRemove;
    }

    private class SelectedListSelectionHandler
    implements ListSelectionListener {
        private SelectedListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (ASJListsPanel.this.isEditable() && !e.getValueIsAdjusting()) {
                if (ASJListsPanel.this.selectedList.getSelectedIndex() == -1) {
                    ASJListsPanel.this.btnRemove.setEnabled(false);
                } else {
                    ASJListsPanel.this.btnRemove.setEnabled(true);
                }
            }
        }
    }

    private class AllListSelectionHandler
    implements ListSelectionListener {
        private AllListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (ASJListsPanel.this.isEditable() && !e.getValueIsAdjusting()) {
                if (ASJListsPanel.this.allList.getSelectedIndex() == -1) {
                    ASJListsPanel.this.btnAdd.setEnabled(false);
                } else {
                    ASJListsPanel.this.btnAdd.setEnabled(true);
                }
            }
        }
    }
}

