/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.DefaultRowSorter;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.RowFilter;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.undo.ShowHideElementsEdit;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.WindowsTableHeader;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class ShowHideElementsDialog
extends CustomDialog {
    protected JDialog dialog;
    protected boolean result = false;
    private JPanel mainPanel;
    private List hiddenElementsList;
    private JTable elementsTable;
    private JCheckBox chbHEApplyToThisViewOnly;
    private JButton btnOk;
    private JButton btnApply;
    private JButton btnCancel;
    private JButton btnHelp;
    private TopView topView;

    public ShowHideElementsDialog(ApplicationView appView, TopView topView) {
        super(appView);
        this.topView = topView;
        this.init();
        this.initButtons();
        this.showDialog();
    }

    private void init() {
        Iterator it;
        this.mainPanel = new JPanel();
        this.mainPanel.setPreferredSize(new Dimension(460, 565));
        this.chbHEApplyToThisViewOnly = new JCheckBox("<html><body><b>" + Messages.getString("TopViewColorDialog.UseCustomFormat") + "</b></body></html>");
        this.hiddenElementsList = new ArrayList();
        HiddenElementsModel tModel = new HiddenElementsModel();
        this.elementsTable = new JTable(tModel);
        this.elementsTable.setSelectionMode(0);
        this.elementsTable.getTableHeader().setReorderingAllowed(false);
        TableColumn col0 = this.elementsTable.getColumnModel().getColumn(0);
        col0.setMinWidth(70);
        col0.setMaxWidth(70);
        col0.setPreferredWidth(70);
        TableColumn col2 = this.elementsTable.getColumnModel().getColumn(2);
        col2.setMinWidth(50);
        col2.setMaxWidth(50);
        col2.setPreferredWidth(50);
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorder(null);
        JButton btnHideAllElements = new JButton(GUIConfiguration.getInstance().getIcon("SELECT_ALL", 16));
        btnHideAllElements.setEnabled(false);
        btnHideAllElements.setToolTipText(Messages.getString("TopViewColorDialog.HideAllElements"));
        btnHideAllElements.setMnemonic(83);
        btnHideAllElements.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        btnHideAllElements.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowHideElementsDialog.this.checkAll(ShowHideElementsDialog.this.elementsTable, ShowHideElementsDialog.this.hiddenElementsList, true);
                ShowHideElementsDialog.this.elementsTable.updateUI();
            }
        });
        JButton btnUnhideAllElements = new JButton(GUIConfiguration.getInstance().getIcon("DESELECT_ALL", 16));
        btnUnhideAllElements.setEnabled(false);
        btnUnhideAllElements.setToolTipText(Messages.getString("TopViewColorDialog.ShowAllElements"));
        btnUnhideAllElements.setMnemonic(68);
        btnUnhideAllElements.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        btnUnhideAllElements.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowHideElementsDialog.this.checkAll(ShowHideElementsDialog.this.elementsTable, ShowHideElementsDialog.this.hiddenElementsList, false);
                ShowHideElementsDialog.this.elementsTable.updateUI();
            }
        });
        JPanel pnOptions = new JPanel(new GridLayout(1, 1, 10, 10));
        pnOptions.setPreferredSize(new Dimension(460, 50));
        pnOptions.setBorder(BorderFactory.createTitledBorder(Messages.getString("TopViewColorDialog.Options")));
        JPanel pn = new JPanel(new FlowLayout(0));
        this.chbHEApplyToThisViewOnly.setSelected(this.topView.isHideElementsInCurrentOnly());
        pn.add(this.chbHEApplyToThisViewOnly);
        pnOptions.add(pn);
        JLabel filterLabel = new JLabel(Messages.getString("TopViewColorDialog.Filter"));
        filterLabel.setPreferredSize(new Dimension(50, 20));
        filterLabel.setMinimumSize(new Dimension(50, 20));
        filterLabel.setMaximumSize(new Dimension(50, 20));
        JTextField elementNamefilter = new JTextField();
        elementNamefilter.setEnabled(false);
        elementNamefilter.setPreferredSize(new Dimension(200, 20));
        elementNamefilter.setMinimumSize(new Dimension(200, 20));
        elementNamefilter.setMaximumSize(new Dimension(200, 20));
        elementNamefilter.getDocument().addDocumentListener(new FilterObjectListener(elementNamefilter, this.elementsTable, 1));
        toolBar.add(btnHideAllElements);
        toolBar.add(btnUnhideAllElements);
        toolBar.addSeparator();
        toolBar.add(filterLabel);
        toolBar.add(elementNamefilter);
        TableRowSorter<HiddenElementsModel> sorter = new TableRowSorter<HiddenElementsModel>(tModel);
        sorter.setSortsOnUpdates(true);
        ArrayList<HiddenObject> tempList = null;
        DesignObject dObj = this.topView.getModel();
        if (dObj instanceof Table) {
            HiddenObject ho;
            tempList = new ArrayList<HiddenObject>();
            for (DesignObject designObject : Arrays.asList(((Table)dObj).getElements())) {
                ho = new HiddenObject(designObject, designObject.getName(), this.topView.getHiddenElements().contains(designObject));
                tempList.add(ho);
            }
            Collections.sort(tempList, new HOComparator());
            this.hiddenElementsList.addAll(tempList);
            tempList = new ArrayList();
            it = ((Table)dObj).getKeySet().iterator();
            while (it.hasNext()) {
                KeyObject keyObject = (KeyObject)it.next();
                if (keyObject.isFK()) continue;
                ho = new HiddenObject(keyObject, keyObject.getName(), this.topView.getHiddenElements().contains(keyObject));
                tempList.add(ho);
            }
            Collections.sort(tempList, new HOComparator());
            this.hiddenElementsList.addAll(tempList);
        } else if (dObj instanceof Entity) {
            HiddenObject ho;
            tempList = new ArrayList();
            for (DesignObject designObject : Arrays.asList(((Entity)dObj).getElements())) {
                ho = new HiddenObject(designObject, designObject.getName(), this.topView.getHiddenElements().contains(designObject));
                tempList.add(ho);
            }
            Collections.sort(tempList, new HOComparator());
            this.hiddenElementsList.addAll(tempList);
            tempList = new ArrayList();
            it = ((Entity)dObj).getKeySet().iterator();
            while (it.hasNext()) {
                CandidateKey candidateKey = (CandidateKey)it.next();
                ho = new HiddenObject(candidateKey, candidateKey.getName(), this.topView.getHiddenElements().contains(candidateKey));
                tempList.add(ho);
            }
            Collections.sort(tempList, new HOComparator());
            this.hiddenElementsList.addAll(tempList);
        }
        if (this.hiddenElementsList.size() > 0) {
            btnHideAllElements.setEnabled(true);
            btnUnhideAllElements.setEnabled(true);
            elementNamefilter.setEnabled(true);
            this.elementsTable.setAutoCreateRowSorter(true);
            this.elementsTable.setRowSorter(sorter);
            WindowsTableHeader.setSortedHeader(this.elementsTable, 0);
        }
        JScrollPane sPane = new JScrollPane(this.elementsTable);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("TopViewColorDialog.Elements")));
        jPanel.add((Component)toolBar, "North");
        jPanel.add((Component)sPane, "Center");
        this.mainPanel.add((Component)pnOptions, "North");
        this.mainPanel.add((Component)jPanel, "Center");
        this.add(this.mainPanel);
    }

    private void initButtons() {
        JPanel buttonsPanel = new JPanel(new FlowLayout(1));
        this.btnOk = new JButton(Messages.getString("ShowHideElementsDialog.Ok"));
        this.btnOk.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.btnOk.addActionListener(new OkAction());
        this.btnOk.setMnemonic(79);
        buttonsPanel.add(this.btnOk);
        this.btnApply = new JButton(Messages.getString("ShowHideElementsDialog.Apply"));
        this.btnApply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.btnApply.addActionListener(new ApplyAction());
        this.btnApply.setMnemonic(65);
        buttonsPanel.add(this.btnApply);
        this.btnCancel = new JButton(Messages.getString("ShowHideElementsDialog.Cancel"));
        this.btnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.btnCancel.addActionListener(new CancelAction());
        this.btnCancel.setMnemonic(67);
        buttonsPanel.add(this.btnCancel);
        this.btnHelp = new JButton(this.getHelpAction());
        this.btnHelp.setMnemonic(72);
        this.btnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        buttonsPanel.add(this.btnHelp);
        this.mainPanel.add((Component)buttonsPanel, "South");
    }

    private void setHiddenElements() {
        this.topView.setHideElementsInCurrentOnly(this.chbHEApplyToThisViewOnly.isSelected());
        List hList = this.topView.getHiddenElements();
        hList.clear();
        for (HiddenObject ho : this.hiddenElementsList) {
            if (!ho.isHidden()) continue;
            hList.add(ho.getObject());
        }
        Object[] arr = new Object[]{this.topView};
        ArrayList backupList = new ArrayList(hList);
        ShowHideElementsEdit shEdit = new ShowHideElementsEdit(arr, this.chbHEApplyToThisViewOnly.isSelected(), backupList);
        shEdit.applyUpdates();
        shEdit.end();
        this.topView.getModel().getDesignPart().postUndoableEdit(shEdit);
        this.topView.getModel().setDirty(true);
        this.topView.getDesignPartView().setDirty(true);
        this.topView.getDesignPartView().getWorkSpace().repaint();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), MessageFormat.format(Messages.getString("ShowHideElementsDialog.ShowHideElements"), this.topView.getModel().getName()));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setModal(true);
            this.dialog.setResizable(false);
        }
        return this.dialog;
    }

    public boolean showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
        return this.result;
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected String getHelpIndex() {
        return "SHOW_HIDE_ELEMENTS_DIALOG";
    }

    private void checkAll(JTable table, List objects, boolean checked) {
        int[] selected = table.getSelectedRows();
        if (selected.length > 0) {
            for (int i = selected.length - 1; i >= 0; --i) {
                Object obj = this.hiddenElementsList.get(table.convertRowIndexToModel(selected[i]));
                ((HiddenObject)obj).setHidden(checked);
            }
        } else {
            this.selectAll(table, objects, checked);
        }
        table.updateUI();
    }

    private void selectAll(JTable table, List objects, boolean selected) {
        if (selected) {
            this.selectAll(table, objects);
        } else {
            this.deselectAll(table, objects);
        }
    }

    private void selectAll(JTable table, List list) {
        if (table != null && table.getRowCount() != table.getModel().getRowCount()) {
            int count = table.getRowCount();
            for (int i = 0; i < count; ++i) {
                int index = table.convertRowIndexToModel(i);
                if (index <= -1 || index >= list.size()) continue;
                this.setSelected(list.get(index), true);
            }
        } else {
            Iterator it = list.iterator();
            while (it.hasNext()) {
                this.setSelected(it.next(), true);
            }
        }
    }

    private void deselectAll(JTable table, List list) {
        if (table != null && table.getRowCount() != table.getModel().getRowCount()) {
            int count = table.getRowCount();
            for (int i = 0; i < count; ++i) {
                int index = table.convertRowIndexToModel(i);
                if (index <= -1 || index >= list.size()) continue;
                this.setSelected(list.get(index), false);
            }
        } else {
            Iterator it = list.iterator();
            while (it.hasNext()) {
                this.setSelected(it.next(), false);
            }
        }
    }

    private void setSelected(Object obj, boolean selected) {
        if (obj != null) {
            ((HiddenObject)obj).setHidden(selected);
        }
    }

    private void hiddenObjectFilter(JTextField filterText, JTable currentTable, int column) {
        RowFilter rf = null;
        if (currentTable != null) {
            if (!"".equals(filterText.getText())) {
                try {
                    rf = RowFilter.regexFilter("(?i)" + filterText.getText(), currentTable.convertColumnIndexToModel(column));
                }
                catch (PatternSyntaxException e) {
                    return;
                }
                ((DefaultRowSorter)currentTable.getRowSorter()).setRowFilter(rf);
            } else {
                ((DefaultRowSorter)currentTable.getRowSorter()).setRowFilter(null);
                currentTable.clearSelection();
            }
        }
    }

    class HiddenObject {
        Object object;
        String name;
        boolean hidden;

        public HiddenObject(Object object, String name, boolean hidden) {
            this.object = object;
            this.name = name;
            this.hidden = hidden;
        }

        public Object getObject() {
            return this.object;
        }

        public void setObject(Object object) {
            this.object = object;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isHidden() {
            return this.hidden;
        }

        public void setHidden(boolean hidden) {
            this.hidden = hidden;
        }
    }

    private class HOComparator
    implements Comparator {
        private HOComparator() {
        }

        public int compare(Object o1, Object o2) {
            HiddenObject ho1 = (HiddenObject)o1;
            HiddenObject ho2 = (HiddenObject)o2;
            return ((DesignObject)ho1.getObject()).getName().compareTo(((DesignObject)ho2.getObject()).getName());
        }
    }

    private class FilterObjectListener
    implements DocumentListener {
        JTextField objectsFilter;
        JTable objectsTable;
        int column;

        FilterObjectListener(JTextField objectsFilter, JTable objectsTable, int column) {
            this.objectsFilter = objectsFilter;
            this.objectsTable = objectsTable;
            this.column = column;
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            ShowHideElementsDialog.this.hiddenObjectFilter(this.objectsFilter, this.objectsTable, this.column);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            ShowHideElementsDialog.this.hiddenObjectFilter(this.objectsFilter, this.objectsTable, this.column);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ShowHideElementsDialog.this.hiddenObjectFilter(this.objectsFilter, this.objectsTable, this.column);
        }
    }

    private class HiddenElementsModel
    extends DefaultTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("TopViewColorDialog.Type"), Messages.getString("TopViewColorDialog.ElementName"), Messages.getString("TopViewColorDialog.Hidden")};

        private HiddenElementsModel() {
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex != 0 && columnIndex != 1;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public int getRowCount() {
            return ShowHideElementsDialog.this.hiddenElementsList.size();
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            HiddenObject ho = (HiddenObject)ShowHideElementsDialog.this.hiddenElementsList.get(row);
            if (col == 2) {
                ho.setHidden((Boolean)value);
            }
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            HiddenObject ho = (HiddenObject)ShowHideElementsDialog.this.hiddenElementsList.get(rowIndex);
            if (columnIndex == 0) {
                DesignObject dObj = (DesignObject)ho.getObject();
                if (dObj instanceof Column) {
                    return "column";
                }
                if (dObj instanceof Index) {
                    if (((Index)dObj).isPK()) {
                        return "primary key";
                    }
                    if (((Index)dObj).isUnique()) {
                        return "unique key";
                    }
                    return "index";
                }
                if (dObj instanceof Attribute) {
                    return "attribute";
                }
                if (dObj instanceof CandidateKey) {
                    return "key";
                }
                return "";
            }
            if (columnIndex == 1) {
                return ho.getName();
            }
            if (columnIndex == 2) {
                return ho.isHidden();
            }
            return "";
        }
    }

    protected class CancelAction
    implements ActionListener {
        protected CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ShowHideElementsDialog.this.getDialog().dispose();
        }
    }

    protected class ApplyAction
    implements ActionListener {
        protected ApplyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ShowHideElementsDialog.this.setHiddenElements();
        }
    }

    protected class OkAction
    implements ActionListener {
        protected OkAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ShowHideElementsDialog.this.setHiddenElements();
            ShowHideElementsDialog.this.getDialog().dispose();
        }
    }
}

