/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.gui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class JListDialog
extends JDialog {
    private static final String KEY_ESCAPE = "ESCAPE";
    private JList list;
    private Object result = null;
    private JButton bnOK;
    private Action escapeAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JListDialog.this.result = null;
            JListDialog.this.dispose();
        }
    };

    public JListDialog(Frame owner, String title, String message, Object[] selectionValues, Object selected, int width) {
        super(owner, title, true);
        this.getContentPane().add((Component)this.init(message, selectionValues, selected), "Center");
        this.getContentPane().add((Component)this.getBottomPanel(), "South");
        int condition = 1;
        JComponent c = (JComponent)this.getContentPane();
        c.getInputMap(condition).put(KeyStroke.getKeyStroke(KEY_ESCAPE), KEY_ESCAPE);
        c.getActionMap().put(KEY_ESCAPE, this.escapeAction);
        this.pack();
        this.setSize(new Dimension(width, 280));
        CommonUtil.centerOnScreen(this);
    }

    private JPanel init(String message, Object[] selectionValues, Object selected) {
        JPanel jpanel = new JPanel(new BorderLayout());
        JLabel label = new JLabel(message);
        jpanel.add((Component)label, "North");
        this.list = new JList<Object>(selectionValues);
        this.list.setSelectionMode(0);
        if (selected != null) {
            this.list.setSelectedValue(selected, true);
        }
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                JListDialog.this.result = JListDialog.this.list.getSelectedValue();
                JListDialog.this.bnOK.setEnabled(JListDialog.this.result != null);
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JListDialog.this.result = JListDialog.this.list.getSelectedValue();
                if (e.getClickCount() == 2) {
                    JListDialog.this.dispose();
                }
                JListDialog.this.bnOK.setEnabled(JListDialog.this.result != null);
            }
        });
        JScrollPane sp = new JScrollPane(this.list);
        jpanel.add(sp);
        return jpanel;
    }

    public JPanel getBottomPanel() {
        JPanel bottomPanel = new JPanel(new FlowLayout(1));
        this.bnOK = new JButton(Messages.getString("JListDialog.OK"));
        this.bnOK.setMnemonic(79);
        this.bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JListDialog.this.result = JListDialog.this.list.getSelectedValue();
                JListDialog.this.dispose();
            }
        });
        this.bnOK.setEnabled(this.list.getSelectedValue() != null);
        this.getRootPane().setDefaultButton(this.bnOK);
        bottomPanel.add(this.bnOK);
        JButton bnCancel = new JButton(Messages.getString("JListDialog.Cancel"));
        bnCancel.setMnemonic(67);
        bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JListDialog.this.result = null;
                JListDialog.this.dispose();
            }
        });
        bottomPanel.add(bnCancel);
        return bottomPanel;
    }

    public Object getResult() {
        return this.result;
    }

    public static Object showDialog(Frame owner, String title, String message, Object[] selectionValues, Object selected) {
        JListDialog dialog = new JListDialog(owner, message, title, selectionValues, selected, 300);
        dialog.setVisible(true);
        return dialog.getResult();
    }

    public static Object showDialog(Frame owner, String title, String message, Object[] selectionValues) {
        return JListDialog.showDialog(owner, title, message, selectionValues, null);
    }
}

