/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.templates;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.dbtools.raptor.newscriptrunner.commands.HiddenParameters;
import oracle.dbtools.raptor.templates.TemplateVariableHandler;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.dbtools.util.Service;
import oracle.ide.Ide;
import oracle.ide.util.IdeUtil;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CodeTemplateUtil {
    public static final char VARIABLE_ESCAPE_CHAR = '\\';
    private static final String VM_ARG_KEY = "raptor.user.codeTemplates";
    private static final String ROWS_NODE = "rows";
    private static final String ROW_NODE = "row";
    private static final String VALUE_NODE = "value";
    private static final String KEY_NODE = "key";
    private static final String CODE_TEMPLATE_XML = "CodeTemplate.xml";
    private static final String TEMPLATE_FILE_PATH = Ide.getUserSettingsDirectory() + "CodeTemplate.xml";
    private static Map<String, String> _templateModel;
    public static final Pattern _tmpVariablePattern;

    public static void insertTemplate(BasicEditorPane basicEditorPane) {
        BasicDocument basicDocument = (BasicDocument)basicEditorPane.getDocument();
        TextBuffer textBuffer = basicDocument.getTextBuffer();
        int n = 0;
        int n2 = 0;
        String string = "";
        if (basicEditorPane.getSelectedText() != null) {
            n = basicEditorPane.getSelectionStart();
            n2 = basicEditorPane.getSelectionEnd();
            string = basicEditorPane.getSelectedText().toLowerCase().startsWith("select") ? "#for#" : basicEditorPane.getSelectedText();
        } else {
            char c;
            n2 = basicEditorPane.getCaretPosition();
            for (n = n2 - 1; n >= 0 && (c = textBuffer.getChar(n)) != '(' && c != ' ' && c != '\n'; --n) {
            }
            string = textBuffer.getString(++n, n2 - n);
        }
        if (n2 == 0) {
            return;
        }
        String string2 = string;
        if (CodeTemplateUtil.isVariable(string)) {
            try {
                string2 = CodeTemplateUtil.computeVariable(basicEditorPane, string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                MessageDialog.error((Component)basicEditorPane, (Object)illegalArgumentException.getMessage(), (String)string, null);
                return;
            }
        } else {
            String string3;
            string2 = CodeTemplateUtil.getTemplate(string);
            StringBuffer stringBuffer = new StringBuffer(string2);
            Matcher matcher = _tmpVariablePattern.matcher(string2);
            int n3 = 0;
            while (matcher.find() && (n3 = stringBuffer.indexOf(string3 = matcher.group(), n3)) >= 0) {
                if (n3 > 0 && stringBuffer.charAt(n3 - 1) == '\\') {
                    stringBuffer.deleteCharAt(n3 - 1);
                    continue;
                }
                String string4 = CodeTemplateUtil.computeVariable(basicEditorPane, string3);
                if (string4 == null || string4.equals(string3)) continue;
                stringBuffer.replace(n3, n3 + string3.length(), string4);
                n3 += string4.length();
            }
            string2 = stringBuffer.toString();
        }
        if (string != null && !string.equals(string2)) {
            int n4 = n;
            try {
                basicDocument.remove(n4, n2 - n);
                basicDocument.insertString(n4, string2, null);
            }
            catch (BadLocationException badLocationException) {
                Logger.getLogger(CodeTemplateUtil.class.getName()).warning("Exception occurred in completion: " + badLocationException);
            }
            basicEditorPane.setCaretPosition(n + string2.length());
        }
    }

    public static String computeVariable(BasicEditorPane basicEditorPane, String string) {
        String string2 = string;
        try {
            TemplateVariableHandler templateVariableHandler = TemplateVariableHandler.getHandler(string);
            if (templateVariableHandler != null) {
                string2 = templateVariableHandler.computeVariable(basicEditorPane);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (Exception exception) {
            Logger.getLogger(CodeTemplateUtil.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return string2;
    }

    private static boolean isVariable(String string) {
        String string2 = String.valueOf('#');
        if (string.startsWith(string2) && string.endsWith(string2)) {
            return TemplateVariableHandler.getHandler(string) != null;
        }
        return false;
    }

    public static String getTemplate(String string) {
        Map<String, String> map = CodeTemplateUtil.getModel();
        String string2 = map.get(string);
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    public static Map<String, String> getModel() {
        if (_templateModel == null) {
            _templateModel = CodeTemplateUtil.loadFiles();
        }
        return _templateModel;
    }

    private static Map<String, String> loadFile(File file) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>(new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                if (string != null) {
                    return string.compareToIgnoreCase(string2);
                }
                if (string2 != null) {
                    return string2.compareToIgnoreCase(string);
                }
                return 0;
            }
        });
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            NodeList nodeList = document.getElementsByTagName(ROW_NODE);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!node.getNodeName().equals(ROW_NODE)) continue;
                Node node2 = XMLHelper.getChildNode((Node)node, (String)KEY_NODE);
                Node node3 = XMLHelper.getChildNode((Node)node, (String)VALUE_NODE);
                String string = node2.getTextContent();
                String string2 = node3.getTextContent();
                if (string.charAt(0) == '.') {
                    string = Service.from4chars((String)string.substring(1));
                    string2 = Service.from4chars((String)string2);
                }
                treeMap.put(string, string2);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(CodeTemplateUtil.class.getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return treeMap;
    }

    public static Map<String, String> loadFiles() {
        File file = new File(TEMPLATE_FILE_PATH);
        if (!file.exists()) {
            try {
                CodeTemplateUtil.copyDefaultTemplates(CODE_TEMPLATE_XML, file);
            }
            catch (IOException iOException) {
                Logger.getLogger(CodeTemplateUtil.class.getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
                return new HashMap<String, String>();
            }
        }
        Map<String, String> map = CodeTemplateUtil.loadFile(file);
        if (System.getProperty(VM_ARG_KEY) != null) {
            char c = ':';
            if (System.getProperty("os.name").startsWith("Windows")) {
                c = ';';
            }
            String[] stringArray = System.getProperty(VM_ARG_KEY).split("[" + c + "]");
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(stringArray[i]);
                if (!file2.exists()) continue;
                map.putAll(CodeTemplateUtil.loadFile(file2));
            }
        }
        return map;
    }

    private static boolean copyDefaultTemplates(String string, File file) throws IOException {
        String string2;
        InputStream inputStream = CodeTemplateUtil.class.getResourceAsStream(string);
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string2 = bufferedReader.readLine()) != null) {
            bufferedWriter.write(string2);
            bufferedWriter.newLine();
        }
        bufferedWriter.close();
        inputStream.close();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(TableModel tableModel) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            Object object;
            Object object2;
            Object object3;
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            DOMImplementation dOMImplementation = documentBuilder.getDOMImplementation();
            Document document = dOMImplementation.createDocument(null, null, null);
            Element element = document.createElement(ROWS_NODE);
            document.appendChild(element);
            Map<String, String> map = CodeTemplateUtil.getModel();
            map.clear();
            for (int i = 0; i < tableModel.getRowCount(); ++i) {
                object3 = (String)tableModel.getValueAt(i, 0);
                object2 = (String)tableModel.getValueAt(i, 1);
                if (object3 == null || ((String)object3).trim().length() == 0) continue;
                if (CodeTemplateUtil.isMultibyte((String)object3) || CodeTemplateUtil.isMultibyte((String)object2) || "true".equals(HiddenParameters.parameters.get("encodeTemplates"))) {
                    object3 = "." + Service.into4chars((String)object3);
                    object2 = Service.into4chars((String)object2);
                }
                map.put((String)object3, (String)object2);
                object = document.createElement(ROW_NODE);
                Element element2 = document.createElement(KEY_NODE);
                element2.setTextContent((String)object3);
                object.appendChild(element2);
                Element element3 = document.createElement(VALUE_NODE);
                element3.setTextContent((String)object2);
                object.appendChild(element3);
                element.appendChild((Node)object);
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            object3 = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(TEMPLATE_FILE_PATH), IdeUtil.getIdeEncoding()));
            object2 = new StreamResult((Writer)object3);
            object = new DOMSource(document);
            transformer.transform((Source)object, (Result)object2);
            ((BufferedWriter)object3).flush();
            ((BufferedWriter)object3).close();
        }
        catch (Exception exception) {
            Logger.getLogger(CodeTemplateUtil.class.getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        finally {
            _templateModel = null;
        }
    }

    static boolean isMultibyte(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ('~' >= c) continue;
            return true;
        }
        return false;
    }

    static {
        _tmpVariablePattern = Pattern.compile("#[^#]+#");
    }
}

