/*
 * Decompiled with CFR 0.152.
 */
package mb.p_raffrayi.actors.impl;

import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import mb.p_raffrayi.actors.impl.IActorScheduler;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;

public class ThreadPoolScheduler
implements IActorScheduler {
    private static final ILogger logger = LoggerUtils.logger(ThreadPoolScheduler.class);
    private final int parallelism;
    private final ThreadPoolExecutor executor;

    public ThreadPoolScheduler(int parallelism) {
        this.parallelism = parallelism;
        this.executor = new ThreadPoolExecutor(parallelism, parallelism, 60L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>());
    }

    @Override
    public int parallelism() {
        return this.parallelism;
    }

    @Override
    public boolean isActive() {
        return this.executor.getActiveCount() != 0 || !this.executor.getQueue().isEmpty();
    }

    @Override
    public void schedule(Runnable runnable, int priority, AtomicReference<Runnable> taskRef) {
        Task task = new Task(runnable);
        if (!taskRef.compareAndSet(null, task)) {
            logger.error("Actor {} already scheduled", runnable);
            throw new IllegalStateException("Actor " + runnable + " already scheduled.");
        }
        this.executor.execute(task);
    }

    @Override
    public void reschedule(Runnable oldTask, int newPriority, AtomicReference<Runnable> taskRef) {
    }

    @Override
    public boolean preempt(int priority) {
        return false;
    }

    @Override
    public void shutdown() {
        this.executor.shutdown();
    }

    @Override
    public void shutdownNow() {
        this.executor.shutdownNow();
    }

    private class Task
    implements Runnable {
        private final Runnable runnable;
        private final AtomicBoolean active;

        Task(Runnable runnable) {
            this.runnable = runnable;
            this.active = new AtomicBoolean(true);
        }

        @Override
        public void run() {
            if (this.active.compareAndSet(true, false)) {
                this.runnable.run();
            }
        }
    }
}

