/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.text.Document;
import oracle.ide.db.controls.AbstractSizeChooser;
import oracle.ide.db.controls.TerabyteSizeChooser;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.resource.UIBundle;

public class TerabyteSizeChooserUnlimited
extends JPanel {
    private final JCheckBox m_chkUnlimited = new JCheckBox();
    private final TerabyteSizeChooser m_sizeChooser = new TerabyteSizeChooser();
    private final List<ChangeListener> m_listeners = new ArrayList<ChangeListener>();

    public TerabyteSizeChooserUnlimited() {
        this.init();
        try {
            this.layoutComponents();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void init() {
        this.m_chkUnlimited.setText(UIBundle.get("FILE_SPECS_INFO_LABEL_UNLIMITED_MAX_SIZE"));
        this.m_chkUnlimited.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                TerabyteSizeChooserUnlimited.this.m_sizeChooser.setEnabled(!((JCheckBox)object).isSelected());
                TerabyteSizeChooserUnlimited.this.notifyListeners();
            }
        });
        this.m_sizeChooser.addChangeListener(new AbstractSizeChooser.ChangeListener(){

            @Override
            public void chooserChanged(AbstractSizeChooser abstractSizeChooser) {
                TerabyteSizeChooserUnlimited.this.notifyListeners();
            }
        });
    }

    @Override
    public final void setName(String string) {
        this.m_sizeChooser.setName(string);
        this.m_chkUnlimited.setName(string + "_UNLIMITED");
    }

    public void setNumber(Number number) {
        if (number != null && number.equals(BigInteger.ZERO)) {
            this.m_chkUnlimited.setSelected(true);
            this.m_sizeChooser.setNumber(null);
            this.m_sizeChooser.setEnabled(false);
        } else {
            this.m_chkUnlimited.setSelected(false);
            this.m_sizeChooser.setNumber(number);
        }
    }

    public Number getNumber() {
        Number number = this.m_chkUnlimited.isSelected() ? BigInteger.ZERO : this.m_sizeChooser.getNumber();
        return number;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.m_chkUnlimited.setEnabled(bl);
        this.m_sizeChooser.setEnabled(bl && !this.m_chkUnlimited.isSelected());
    }

    @Override
    public boolean isEnabled() {
        return this.m_sizeChooser.isEnabled();
    }

    private void layoutComponents() {
        DBUILayoutHelper dBUILayoutHelper = new DBUILayoutHelper(this);
        dBUILayoutHelper.setMargins(0);
        dBUILayoutHelper.add(this.m_sizeChooser);
        dBUILayoutHelper.add(this.m_chkUnlimited);
        dBUILayoutHelper.layout();
    }

    public final void addChangeListener(ChangeListener changeListener) {
        this.m_listeners.add(changeListener);
    }

    public Document getDocument() {
        return this.m_sizeChooser.getDocument();
    }

    public final void removeChangeListener(ChangeListener changeListener) {
        this.m_listeners.remove(changeListener);
    }

    protected void notifyListeners() {
        for (ChangeListener changeListener : this.m_listeners) {
            changeListener.chooserChanged(this);
        }
    }

    public Component[] getRealFocusComponents() {
        Component[] componentArray = this.m_sizeChooser.getComponents();
        Component[] componentArray2 = new Component[componentArray.length + 1];
        System.arraycopy(componentArray, 0, componentArray2, 0, componentArray.length);
        componentArray2[componentArray.length] = this.m_chkUnlimited;
        return componentArray2;
    }

    public static interface ChangeListener {
        public void chooserChanged(TerabyteSizeChooserUnlimited var1);
    }
}

