/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.dialogs;

import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.db.model.DBObjectTypeNode;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderFactory;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.property.Metadata;

abstract class AbstractDBEditorFactory
implements DBEditorFactory {
    AbstractDBEditorFactory() {
    }

    @Override
    public final boolean canCreateDBObject(DBObjectTypeNode dBObjectTypeNode) {
        boolean bl = false;
        try {
            DBObjectProvider dBObjectProvider = DBObjectProviderFactory.findOrCreateProvider((String)dBObjectTypeNode.getProviderType(), (Object)dBObjectTypeNode.getProviderIdentifier());
            if (dBObjectProvider != null) {
                Schema schema = DBObjectNodeUtil.getSchema(dBObjectTypeNode, false);
                bl = this.canCreateDBObject(schema, dBObjectProvider, DBObjectNodeUtil.normalizeType(dBObjectTypeNode));
            }
        }
        catch (DBException dBException) {
            DBExceptionDialog.showErrorDialog(null, null, dBException);
        }
        return bl;
    }

    @Override
    @Deprecated
    public final SchemaObject createDBObject(Schema schema, DBObjectProvider dBObjectProvider, String string) {
        if (!Metadata.getInstance().isSchemaObject(string)) {
            throw new IllegalArgumentException(string + " is not a valid SchemaObject type");
        }
        return (SchemaObject)this.createDBObject(schema, dBObjectProvider, string, null, true);
    }

    @Override
    @Deprecated
    public final SchemaObject createDBObject(DBObjectTypeNode dBObjectTypeNode) {
        SchemaObject schemaObject = null;
        try {
            DBObjectProvider dBObjectProvider = DBObjectProviderFactory.findOrCreateProvider((String)dBObjectTypeNode.getProviderType(), (Object)dBObjectTypeNode.getProviderIdentifier());
            Schema schema = DBObjectNodeUtil.getSchema(dBObjectTypeNode, true);
            schemaObject = this.createDBObject(schema, dBObjectProvider, DBObjectNodeUtil.normalizeType(dBObjectTypeNode));
        }
        catch (DBException dBException) {
            DBExceptionDialog.showErrorDialog(null, null, dBException);
        }
        return schemaObject;
    }

    @Override
    @Deprecated
    public final <T extends SystemObject> T createDBObject(Schema schema, DBObjectProvider dBObjectProvider, T t, boolean bl) {
        return this.createDBObject(schema, dBObjectProvider, t, (DBObject)null, bl);
    }

    @Override
    @Deprecated
    public final <T extends DBObject> T createDBObject(DBObjectProvider dBObjectProvider, T t, DBObject dBObject, boolean bl) {
        return this.createDBObject(DBUtil.getSchema((DBObject)dBObject), dBObjectProvider, t, dBObject, bl);
    }

    @Deprecated
    protected final <T extends DBObject> T createDBObject(Schema schema, DBObjectProvider dBObjectProvider, T t, DBObject dBObject, boolean bl) {
        DBObject dBObject2 = dBObjectProvider.getObjectFactory().newObject(t, dBObject);
        DBEditorConfig dBEditorConfig = DBEditorConfig.newCreateConfig(dBObjectProvider, dBObject2);
        dBEditorConfig.setSchema(schema);
        dBEditorConfig.setCommitToProvider(bl);
        dBEditorConfig.setUseBackgroundTask(false);
        this.launchDialog(dBEditorConfig);
        return (T)(dBEditorConfig.getResult() == DBEditorConfig.Result.SUCCESS ? dBEditorConfig.getUpdatedObject() : null);
    }

    @Override
    @Deprecated
    public final DBObject createDBObject(DBObjectNode dBObjectNode, String string) {
        DBObjectProvider dBObjectProvider = dBObjectNode.getProvider();
        DBObject dBObject = dBObjectNode.getDBObject();
        Schema schema = DBObjectNodeUtil.getSchema(dBObjectNode, true);
        return this.createDBObject(schema, dBObjectProvider, string, dBObject, true);
    }

    @Override
    @Deprecated
    public final boolean createDBObject(DBObject dBObject, DBObjectProvider dBObjectProvider) {
        return this.createDBObject(dBObject, dBObjectProvider, true);
    }

    @Override
    @Deprecated
    public final boolean createDBObject(DBObject dBObject, DBObjectProvider dBObjectProvider, boolean bl) {
        DBEditorConfig dBEditorConfig = DBEditorConfig.newCreateConfig(dBObjectProvider, dBObject);
        dBEditorConfig.setCommitToProvider(bl);
        dBEditorConfig.setUseBackgroundTask(false);
        this.launchDialog(dBEditorConfig);
        return true;
    }

    @Override
    @Deprecated
    public final DBObject createDBObject(Schema schema, DBObjectProvider dBObjectProvider, String string, DBObject dBObject, boolean bl) {
        DBEditorConfig dBEditorConfig;
        if (dBObject == null) {
            dBEditorConfig = DBEditorConfig.newCreateConfig(dBObjectProvider, string, schema);
        } else {
            dBEditorConfig = DBEditorConfig.newCreateConfig(dBObjectProvider, string, dBObject);
            dBEditorConfig.setSchema(schema);
        }
        dBEditorConfig.setCommitToProvider(bl);
        dBEditorConfig.setUseBackgroundTask(false);
        this.launchDialog(dBEditorConfig);
        return dBEditorConfig.getUpdatedObject();
    }

    @Override
    public final boolean canEditDBObject(SchemaObject schemaObject, DBObjectProvider dBObjectProvider) {
        return this.canEditDBObject((DBObject)schemaObject, dBObjectProvider);
    }

    @Override
    @Deprecated
    public final boolean canEditDBObject(DBObjectNode dBObjectNode) {
        return this.canEditDBObject(dBObjectNode.getDBObject(), dBObjectNode.getProvider());
    }

    @Override
    @Deprecated
    public final boolean editDBObject(DBObject dBObject, DBObjectProvider dBObjectProvider) {
        return this.editDBObject(dBObject, dBObjectProvider, true);
    }

    @Override
    @Deprecated
    public final boolean editDBObject(SchemaObject schemaObject, DBObjectProvider dBObjectProvider) {
        return this.editDBObject((DBObject)schemaObject, dBObjectProvider, true);
    }

    @Override
    @Deprecated
    public boolean editDBObject(DBObject dBObject, DBObjectProvider dBObjectProvider, boolean bl) {
        return this.editDBObject(dBObject, dBObjectProvider, null, bl);
    }

    @Override
    @Deprecated
    public final boolean editDBObject(DBObject dBObject, DBObjectProvider dBObjectProvider, DBObject dBObject2) {
        return this.editDBObject(dBObject, dBObjectProvider, dBObject2, true);
    }

    @Override
    public final boolean editDBObject(DBObjectNode dBObjectNode) {
        DBEditorConfig dBEditorConfig = DBEditorConfig.newEditConfig(dBObjectNode);
        this.launchDialog(dBEditorConfig);
        return dBEditorConfig.getResult() == DBEditorConfig.Result.SUCCESS;
    }

    @Override
    @Deprecated
    public final boolean editDBObject(DBObject dBObject, DBObjectProvider dBObjectProvider, DBObject dBObject2, boolean bl) {
        DBEditorConfig dBEditorConfig = DBEditorConfig.newEditConfig(dBObjectProvider, dBObject);
        if (dBObject2 != null) {
            dBEditorConfig.setChildObject(dBObject2);
        }
        dBEditorConfig.setCommitToProvider(bl);
        dBEditorConfig.setUseBackgroundTask(false);
        this.launchDialog(dBEditorConfig);
        return dBEditorConfig.getResult() == DBEditorConfig.Result.SUCCESS;
    }
}

