/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.components;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import oracle.ide.db.components.ComponentContext;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.controls.DBObjectChooser;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.util.ModelUtil;

public class SchemaComponentWrapper
extends ComponentWrapper<DBObjectChooser> {
    private JPanel m_panel;
    private CardLayout m_panelLayout;
    private Component m_publicField;
    private boolean m_isPublic;

    public SchemaComponentWrapper() {
        super(new DBObjectChooser("SCHEMA"));
    }

    @Override
    public void setPropertyValue(Object object) {
        if (!this.isPublicSchema(object)) {
            this.changeLayout(false);
            ((DBObjectChooser)this.getActiveComponent()).setDBObject((DBObject)((Schema)object));
        } else {
            this.changeLayout(true);
        }
    }

    @Override
    public Component getDefaultFocusComponent() {
        return ((DBObjectChooser)this.getActiveComponent()).getDefaultFocusComponent();
    }

    @Override
    public Object getPropertyValue() {
        return ((DBObjectChooser)this.getActiveComponent()).getOrCreateDBObject();
    }

    @Override
    protected void initialiseComponentListener() {
        ((DBObjectChooser)this.getActiveComponent()).addChangeListener(new DBObjectChooser.ChangeListener(){

            @Override
            public void chooserChanged(DBObjectChooser dBObjectChooser, DBObjectID dBObjectID) {
                SchemaComponentWrapper.this.fireChangeEvent();
            }
        });
    }

    @Override
    protected void initialiseComponent() {
        DBObjectChooser dBObjectChooser = (DBObjectChooser)this.getActiveComponent();
        DBObjectProvider dBObjectProvider = this.getProvider();
        dBObjectChooser.setProvider(dBObjectProvider);
        if (!(dBObjectProvider instanceof Database)) {
            dBObjectChooser.setEditable(true);
            dBObjectChooser.getDBObjectCriteria().setUserOnly(true);
        }
        ComponentContext componentContext = this.getComponentContext();
        String string = componentContext.getUpdatedObject().getType();
        String string2 = componentContext.getOriginalSystemObject() == null ? "CREATE" : "MODIFY";
        dBObjectChooser.setFilter(dBObject -> !this.isPublicSchema(dBObject) && dBObjectProvider.hasSystemPrivilege(string, (Schema)dBObject, string2));
        boolean bl = dBObjectProvider.getPropertyManager().supportsProperty(string, "public");
        if (bl) {
            this.m_panelLayout = new CardLayout();
            this.m_panel = new JPanel(this.m_panelLayout);
            this.m_publicField = new JTextArea(dBObjectProvider.getDescriptor().getPublicSchemaName());
            this.m_publicField.setEnabled(false);
            this.m_panel.add((Component)this.getActiveComponent(), Boolean.FALSE.toString());
            this.m_panel.add(this.m_publicField, Boolean.TRUE.toString());
        }
    }

    private boolean isPublicSchema(Object object) {
        return object instanceof Schema && ModelUtil.areEqual((Object)((Schema)object).getName(), (Object)this.getProvider().getDescriptor().getPublicSchemaName());
    }

    @Override
    protected void setActiveImpl(boolean bl) {
        boolean bl2 = this.getComponentContext().isInFlatEditor();
        ((DBObjectChooser)this.getActiveComponent()).setActive(bl, bl2, bl2);
    }

    @Override
    protected Component createComponentForLayout() {
        return this.m_panel == null ? this.getActiveComponent() : this.m_panel;
    }

    private void changeLayout(boolean bl) {
        if (this.m_panelLayout != null && this.m_isPublic != bl) {
            this.m_isPublic = bl;
            this.m_panelLayout.show((Container)this.getComponent(), Boolean.toString(bl));
            ((DBObjectChooser)this.getActiveComponent()).setEnabled(!bl);
        }
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (this.m_publicField != null) {
            ((DBObjectChooser)this.getActiveComponent()).setVisible(false);
            this.m_publicField.setVisible(false);
            if (bl) {
                this.m_isPublic = !this.m_isPublic;
                this.changeLayout(!this.m_isPublic);
            }
        }
    }

    @Override
    public String getPropertyDisplayName() {
        return this.getProvider().getDescriptor().getSchemaDisplayName();
    }
}

