/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.sql;

import java.awt.Component;
import java.awt.datatransfer.Transferable;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.db.DBObjectTransferable;
import oracle.ide.db.controls.DBObjectSourcePicker;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.sql.SQLQueryOwner;

public class QuickPickSourcePicker
extends DBObjectSourcePicker {
    private SQLQueryOwner m_sqlQueryOwner;

    public QuickPickSourcePicker(DBObjectProvider dBObjectProvider, boolean bl, boolean bl2) {
        super(dBObjectProvider, bl, bl2);
        this.m_dbRenderer = new Renderer();
        this.m_dbRenderer.setIncludeIcon(true);
        this.m_tree.setCellRenderer(this.m_dbRenderer);
        this.m_nodeMaker.setDeepFKs(true);
        this.m_nodeMaker.setChildTypes(new String[]{"COLUMN", "FKConstraint"});
        ToolTipManager.sharedInstance().registerComponent(this.m_tree);
    }

    @Override
    protected String getComponentNamePrefix() {
        return "QuickPickSourcePicker";
    }

    @Override
    public void removeSelectedItems() {
        DefaultMutableTreeNode defaultMutableTreeNode;
        TreePath[] treePathArray = this.m_tree.getSelectionPaths();
        if (treePathArray != null && treePathArray.length == 1 && (defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[0].getLastPathComponent()).getUserObject() instanceof Relation) {
            this.m_tree.expandPath(treePathArray[0]);
        }
        super.removeSelectedItems();
    }

    public void setSQLQueryOwner(SQLQueryOwner sQLQueryOwner) {
        this.m_sqlQueryOwner = sQLQueryOwner;
    }

    @Override
    protected SystemObject[] filterAndSort(SystemObject[] systemObjectArray) {
        if (this.m_sqlQueryOwner != null && systemObjectArray != null) {
            int n = -1;
            for (int i = 0; i < systemObjectArray.length; ++i) {
                if (!(systemObjectArray[i] instanceof SQLQueryOwner) || !systemObjectArray[i].getName().equals(this.m_sqlQueryOwner.getName())) continue;
                n = i;
                break;
            }
            if (n >= 0) {
                SchemaObject[] schemaObjectArray = new SchemaObject[systemObjectArray.length - 1];
                System.arraycopy(systemObjectArray, 0, schemaObjectArray, 0, n);
                System.arraycopy(systemObjectArray, n + 1, schemaObjectArray, n, schemaObjectArray.length - n);
                systemObjectArray = schemaObjectArray;
            }
        }
        return super.filterAndSort(systemObjectArray);
    }

    @Override
    public Transferable createTransferable(TreePath treePath) {
        DBObjectTransferable dBObjectTransferable = (DBObjectTransferable)super.createTransferable(treePath);
        if (dBObjectTransferable.getDBObject() instanceof FKConstraint) {
            dBObjectTransferable = null;
        } else if (dBObjectTransferable.getDBObject() instanceof Relation && ((Relation)dBObjectTransferable.getDBObject()).getColumns().length == 0) {
            dBObjectTransferable = null;
        }
        return dBObjectTransferable;
    }

    private class Renderer
    extends DBObjectRenderer {
        private Renderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            JComponent jComponent = (JComponent)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (object instanceof DefaultMutableTreeNode) {
                Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
                if (object2 instanceof Relation) {
                    DBObjectRenderer.setToolTipText(jComponent, DBUtil.getFullyQualifiedName((DBObject)((DBObject)object2)) + ": " + UIBundle.get("PICKER_EXPAND_RELATION"));
                } else if (object2 instanceof FKConstraint) {
                    DBObjectRenderer.setToolTipText(jComponent, DBUtil.getFullyQualifiedName((DBObject)((DBObject)object2)) + ": " + UIBundle.get("PICKER_EXPAND_FK"));
                }
            }
            return jComponent;
        }
    }
}

