/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.controls.DBObjectChooser;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBEditorFactoryRegistry;
import oracle.ide.db.event.SwingDBObjectPropertyListener;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.controls.ValuesPropertyPanel;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Index;
import oracle.javatools.db.Table;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.ui.TitledSeparator;

public class IndexEditorPanel
extends BaseEditorPanel<Index> {
    private DBObjectChooser m_tableSchema;
    private DBObjectChooser m_table;
    private TitledSeparator m_domainIndexSeparator;
    private final boolean m_isStandaloneIndexEditor;
    private final boolean m_isShowAdvancedButton;

    public IndexEditorPanel() {
        this(true, false);
    }

    public IndexEditorPanel(boolean bl, boolean bl2) {
        super("IndexEditorPanel");
        this.m_isStandaloneIndexEditor = bl;
        this.m_isShowAdvancedButton = bl2;
    }

    @Override
    protected void initialiseComponents() {
        JButton jButton;
        ComponentWrapper componentWrapper;
        Object object;
        Object object2;
        Object object3;
        ComponentWrapper componentWrapper2 = this.getOrCreateWrapper("indexType");
        DBUILayoutHelper dBUILayoutHelper = this.getDBUILayoutHelper();
        DBUIResourceHelper dBUIResourceHelper = this.getComponentFactory().getResourceHelper();
        DBUILayoutHelper dBUILayoutHelper2 = dBUILayoutHelper.newChildHelper(2, 1, true, false);
        if (this.m_isStandaloneIndexEditor) {
            this.m_tableSchema = new DBObjectChooser("SCHEMA");
            this.m_table = new DBObjectChooser(this.m_tableSchema, "TABLE", "MATERIALIZED VIEW");
            object3 = PropertyDisplayRegistry.getDisplayName("table", this.getProvider(), this.getUpdatedObject());
            object2 = new JLabel();
            dBUIResourceHelper.resLabel((JLabel)object2, this.m_tableSchema, UIBundle.format("LABEL_IDPROP_SCHEMA", object3), "m_tableSchema");
            dBUILayoutHelper2.add((Component)object2);
            dBUILayoutHelper2.add(this.m_tableSchema);
            dBUILayoutHelper2.nextRow();
            object = new JLabel();
            dBUIResourceHelper.resLabel((JLabel)object, this.m_table, (String)object3 + ":", "m_table");
            dBUILayoutHelper2.add((Component)object);
            dBUILayoutHelper2.add(this.m_table);
            dBUILayoutHelper2.nextRow();
            this.m_tableSchema.setProvider(this.getProvider());
            this.m_table.setProvider(this.getProvider());
            if (!this.getEditorConfig().isCommitToProvider() || this.getOriginalObject() != null && ((Index)this.getOriginalObject()).getTable() != null) {
                this.m_tableSchema.setDBObject((DBObject)((Index)this.getUpdatedObject()).getTable().getSchema());
                this.m_table.setDBObject((DBObject)((Index)this.getUpdatedObject()).getTable());
                this.m_tableSchema.setEnabled(false);
                this.m_table.setEnabled(false);
            } else {
                componentWrapper = (Index)this.getUpdatedObject();
                if (componentWrapper != null) {
                    jButton = componentWrapper.getTable();
                    if (jButton != null) {
                        this.m_tableSchema.setDBObject((DBObject)((Index)this.getUpdatedObject()).getTable().getSchema());
                        this.m_table.setDBObject((DBObject)((Index)this.getUpdatedObject()).getTable());
                    } else {
                        this.m_tableSchema.setDBObject((DBObject)((Index)this.getUpdatedObject()).getSchema());
                        this.m_table.setDBObject(null);
                    }
                }
            }
            this.m_table.addChangeListener(new DBObjectChooser.ChangeListener(){

                @Override
                public void chooserChanged(DBObjectChooser dBObjectChooser, DBObjectID dBObjectID) {
                    ((Index)IndexEditorPanel.this.getUpdatedObject()).setTable((Table)dBObjectChooser.getDBObject());
                    ((Index)IndexEditorPanel.this.getUpdatedObject()).setColumnExpressions(new IndexObject[0]);
                    ComponentWrapper componentWrapper = IndexEditorPanel.this.getOrCreateWrapper("columnExpressions");
                    componentWrapper.setPropertyValue(((Index)IndexEditorPanel.this.getUpdatedObject()).getColumnExpressions());
                    IndexEditorPanel.this.initialisePanel();
                }
            });
        }
        dBUILayoutHelper2.add(componentWrapper2);
        dBUILayoutHelper.nextRow();
        object3 = this.getOrCreateWrapper("columnExpressions");
        dBUILayoutHelper.add(((ComponentWrapper)object3).getComponent(), 2, 1, true, true);
        dBUILayoutHelper.nextRow();
        object2 = PropertyDisplayRegistry.getDisplayName("domainIndextype", this.getProvider(), this.getUpdatedObject());
        this.m_domainIndexSeparator = new TitledSeparator((String)object2);
        dBUILayoutHelper.add((Component)this.m_domainIndexSeparator, 2, 1, true, false);
        object = this.getOrCreateWrapper("domainIndextype");
        componentWrapper = this.getOrCreateWrapper("domainIndextypeParameters");
        dBUILayoutHelper.addChildren((ComponentWrapper)object, new Integer[0]);
        dBUILayoutHelper.nextRow();
        dBUILayoutHelper.add(componentWrapper);
        if (this.m_isShowAdvancedButton) {
            jButton = new JButton();
            dBUIResourceHelper.resButton(jButton, UIBundle.get("INDEX_PANEL_LABEL_ADVANCED"), "indexAdvancedButton");
            jButton.addActionListener(actionEvent -> this.launchAdvancedDialog());
            dBUILayoutHelper.nextRow();
            dBUILayoutHelper.nextColumn();
            dBUILayoutHelper.add(jButton);
            GridBagConstraints gridBagConstraints = dBUILayoutHelper.getConstraints(jButton);
            gridBagConstraints.anchor = 13;
            dBUILayoutHelper.setMarginBottom(0);
        }
        dBUILayoutHelper.layout();
    }

    private void launchAdvancedDialog() {
        DBEditorFactory dBEditorFactory = DBEditorFactoryRegistry.getCreateFactory(this.getProvider(), "INDEX");
        DBEditorConfig dBEditorConfig = DBEditorConfig.newEditConfig(this.getProvider(), this.getUpdatedObject());
        dBEditorConfig.setCommitToProvider(false);
        if (!this.isEditing()) {
            dBEditorConfig.setReplaceAlwaysAllowed(true);
        }
        dBEditorFactory.launchDialog(dBEditorConfig);
        if (dBEditorConfig.getResult() == DBEditorConfig.Result.SUCCESS) {
            this.refreshComponents();
        }
    }

    @Override
    protected void initialisePanel() {
        this.handleIndexType();
    }

    @Override
    protected DBObjectListener createObjectListener() {
        return new SwingDBObjectPropertyListener(new String[]{"indexType", "columnExpressions", Property.createPath((String[])new String[]{"columnExpressions", "expressionSource"})}){

            @Override
            protected void updateUI(DBObject dBObject, String string, PropertyChangeEvent propertyChangeEvent) {
                String string2 = propertyChangeEvent.getPropertyName();
                Object object = propertyChangeEvent.getNewValue();
                if (string2.equals("indexType") && (Index.IndexType.DOMAIN.equals(propertyChangeEvent.getOldValue()) || Index.IndexType.DOMAIN.equals(propertyChangeEvent.getNewValue()))) {
                    IndexEditorPanel.this.handleIndexType();
                    IndexEditorPanel.this.getComponentFactory().processComponents();
                    if (Index.IndexType.DOMAIN.equals(object)) {
                        ComponentWrapper componentWrapper = IndexEditorPanel.this.getOrCreateWrapper("domainIndextype");
                        ComponentWrapper componentWrapper2 = IndexEditorPanel.this.getOrCreateWrapper("domainIndextypeParameters");
                        componentWrapper2.resetPropertyValue(((Index)IndexEditorPanel.this.getUpdatedObject()).getDomainIndextypeParameters());
                        componentWrapper.resetPropertyValue(((Index)IndexEditorPanel.this.getUpdatedObject()).getDomainIndextype());
                    }
                } else if (string.startsWith("columnExpressions")) {
                    Index index = (Index)dBObject;
                    IndexEditorPanel.this.cascadeGlobalIndexColumns(index.getColumnExpressions());
                }
            }
        };
    }

    private void handleIndexType() {
        if (this.m_domainIndexSeparator != null) {
            this.m_domainIndexSeparator.setVisible(Index.IndexType.DOMAIN.equals((Object)((Index)this.getUpdatedObject()).getIndexType()));
        }
    }

    private void cascadeGlobalIndexColumns(IndexObject[] indexObjectArray) {
        DBObjectID[] dBObjectIDArray;
        Index index = (Index)this.getUpdatedObject();
        OracleIndexPartitions oracleIndexPartitions = (OracleIndexPartitions)index.getProperty("OracleIndexPartitions");
        if (oracleIndexPartitions != null && (oracleIndexPartitions.getPartitionType() == OracleIndexPartitions.PartitionType.GLOBAL_RANGE || oracleIndexPartitions.getPartitionType() == OracleIndexPartitions.PartitionType.GLOBAL_HASH) && (dBObjectIDArray = oracleIndexPartitions.getGlobalPartitionColumns()).length > 0) {
            boolean bl = false;
            ArrayList<DBObjectID> arrayList = new ArrayList<DBObjectID>();
            DBObjectID dBObjectID = dBObjectIDArray[dBObjectIDArray.length - 1];
            if (indexObjectArray != null && indexObjectArray.length > 0) {
                IndexObject indexObject;
                SQLFragment sQLFragment;
                IndexObject[] indexObjectArray2 = indexObjectArray;
                int n = indexObjectArray2.length;
                for (int i = 0; i < n && (sQLFragment = (indexObject = indexObjectArray2[i]).getExpression()) instanceof ColumnUsage; ++i) {
                    ColumnUsage columnUsage = (ColumnUsage)sQLFragment;
                    DBObjectID dBObjectID2 = columnUsage.getObjectID();
                    arrayList.add(dBObjectID2);
                    if (!dBObjectID2.equals(dBObjectID)) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    arrayList.clear();
                }
            }
            oracleIndexPartitions.setGlobalPartitionColumns(arrayList.toArray(new DBObjectID[arrayList.size()]));
            ValuesPropertyPanel.updateIndexPartitionMaxValues(arrayList.size(), index);
        }
    }
}

