/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.technology;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.Extension;
import javax.ide.extension.ExtensionDependency;
import javax.ide.util.MetaClass;
import oracle.ide.ExtensionRegistry;
import oracle.ide.file.ContentSetScope;
import oracle.ide.file.FileTable;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Recognizer;
import oracle.ide.model.TechnologyRegistry;
import oracle.ide.model.TechnologyScopeDetector;
import oracle.ide.model.Workspace;
import oracle.ide.persistence.Storage;
import oracle.ide.persistence.Storages;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.library.ExtensionLibrary;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdevimpl.technology.ChangedURLsCallable;

public class TechnologyScopeDetectorByNodeRecognizer
implements TechnologyScopeDetector {
    private static ConcurrentHashMap<String, Boolean> xmlDependencyCache = new ConcurrentHashMap(256);
    private static final String _XML_TECH_ID = "XML";
    private static final String _XML_EXTENSION_ID = "oracle.ide.xmlef";
    private static Logger LOG = Logger.getLogger(TechnologyScopeDetectorByNodeRecognizer.class.getName());
    private ExecutorService execService = Executors.newSingleThreadExecutor();

    public Collection<String> detectTechnologyScopeIds(Workspace workspace, Project project) throws InterruptedException {
        if (workspace != null && project != null) {
            HashSet<String> technologyIds = new HashSet<String>();
            Collection<String> nodeIds = this.detectTechnologyScopeIdsOfProjectChanges(workspace, project, true);
            technologyIds.addAll(nodeIds);
            Collection<String> libraryIds = this.detectTechnologyScopeIdsOfLibraries(project);
            technologyIds.addAll(libraryIds);
            return technologyIds;
        }
        return Collections.emptySet();
    }

    private Collection<String> detectTechnologyScopeIdsOfLibraries(Project project) {
        HashSet<String> ids1 = new HashSet<String>();
        HashSet<String> extensions = new HashSet<String>();
        JProjectLibraries libraries = JProjectLibraries.getInstance((PropertyStorage)project);
        for (JLibrary library : libraries.getLibraries()) {
            ExtensionLibrary extensionLibrary;
            ids1.addAll(this.detectTechnologyScopeIdsOfLibrary(project, library));
            if (!(library instanceof ExtensionLibrary) || !(extensionLibrary = (ExtensionLibrary)library).getForceExtensionInitialization()) continue;
            extensions.add(extensionLibrary.getProviderExtensionId());
        }
        Collection ids0 = TechnologyRegistry.getInstance().getTechnologiesOfGroupByMemberExtension(extensions);
        if (!ids0.equals(ids1)) {
            System.out.println("Project " + project.getShortLabel() + " mismatch\n  " + ids0 + "\n  " + ids1);
        }
        return ids0;
    }

    Collection<String> detectTechnologyScopeIdsOfLibrary(Project project, JLibrary library) {
        ExtensionLibrary extensionLibrary;
        Set<Object> extensions = Collections.emptySet();
        if (library instanceof ExtensionLibrary && (extensionLibrary = (ExtensionLibrary)library).getForceExtensionInitialization()) {
            extensions = Collections.singleton(extensionLibrary.getProviderExtensionId());
        }
        return TechnologyRegistry.getInstance().getTechnologiesOfGroupByMemberExtension(extensions);
    }

    public Collection<String> detectTechnologyScopeIdsOfURL(Project project, URL url) {
        return this.detectTechnologyScopeIdsOfURL(project, url, new ArrayList<String>());
    }

    Set<String> detectTechnologyScopeIdsOfURL(Project project, URL url, Collection<String> currentTechs) {
        HashSet<String> technologyIds = new HashSet<String>(currentTechs);
        MetaClass nodeClass = Recognizer.recognizeURLAsMeta((URL)url);
        Collection nodeIds = TechnologyRegistry.getInstance().getTechnologiesOfExtensionByClassLoader(nodeClass.getClassLoader());
        technologyIds.addAll(nodeIds);
        Extension extension = ExtensionRegistry.getExtensionRegistry().findExtensionByClassLoader(nodeClass.getClassLoader());
        this._checkForXmlSubtype((MetaClass<? extends Node>)nodeClass, extension, technologyIds);
        return technologyIds;
    }

    private void _checkForXmlSubtype(MetaClass<? extends Node> nodeClass, Extension extension, Set<String> technologyIds) {
        if (!technologyIds.contains(_XML_TECH_ID) && this._extensionDependsOnXml(ExtensionRegistry.getExtensionRegistry(), extension)) {
            technologyIds.add(_XML_TECH_ID);
        }
    }

    private boolean _extensionDependsOnXml(ExtensionRegistry registry, Extension extension) {
        if (extension == null) {
            return false;
        }
        String id = extension.getID();
        Boolean result = xmlDependencyCache.get(id);
        if (result == null) {
            if (_XML_EXTENSION_ID.equals(id)) {
                result = true;
            } else {
                result = false;
                for (ExtensionDependency dependency : extension.getDependencies()) {
                    Extension depExt = registry.findExtension(dependency.getID());
                    if (!this._extensionDependsOnXml(registry, depExt)) continue;
                    result = true;
                    break;
                }
            }
            xmlDependencyCache.putIfAbsent(id, result);
        }
        return result;
    }

    public Collection<String> detectTechnologyScopeIdsOfProjectChanges(Workspace workspace, Project project) throws InterruptedException {
        if (workspace != null && project != null) {
            return this.detectTechnologyScopeIdsOfProjectChanges(workspace, project, false);
        }
        return Collections.emptyList();
    }

    public Map<Project, ConcurrentLinkedQueue<URL>> technologyScopesOfProjectBatch(Workspace workspace, Collection<Project> projects) {
        ConcurrentHashMap<Project, ConcurrentLinkedQueue<URL>> project2Queue = new ConcurrentHashMap<Project, ConcurrentLinkedQueue<URL>>();
        for (Project project : projects) {
            project2Queue.put(project, new ConcurrentLinkedQueue());
        }
        IndexRunnable task = new IndexRunnable(workspace, projects, project2Queue);
        this.execService.submit(task);
        return project2Queue;
    }

    private Collection<String> detectTechnologyScopeIdsOfProjectChanges(Workspace workspace, Project project, boolean requeryAll) throws InterruptedException {
        HashSet<String> techIds = new HashSet<String>();
        HashSet allChangedURLs = new HashSet();
        Collection fileTables = ContentSetScope.getInstance((Workspace)workspace, (Project)project).getFileTables();
        Storage projectStorage = Storages.getApplicationStorage((Workspace)workspace);
        for (FileTable fileTable : fileTables) {
            try {
                ChangedURLsCallable c = new ChangedURLsCallable(projectStorage, fileTable.getStorageKey(), fileTable, LOG, requeryAll);
                Collection changedURLs = (Collection)projectStorage.runWhileOpen((Callable)c);
                allChangedURLs.addAll(changedURLs);
                for (URL url : allChangedURLs) {
                    techIds.addAll(this.detectTechnologyScopeIdsOfURL(project, url, techIds));
                }
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Failed while loading from the storage of " + workspace, e);
            }
        }
        return techIds;
    }

    private static class IndexRunnable
    implements Runnable {
        private final Collection<Project> m_projects;
        private final Workspace m_workspace;
        private final ConcurrentHashMap<Project, ConcurrentLinkedQueue<URL>> m_project2Queue;

        public IndexRunnable(Workspace workspace, Collection<Project> projects, ConcurrentHashMap<Project, ConcurrentLinkedQueue<URL>> project2Queue) {
            this.m_projects = projects;
            this.m_workspace = workspace;
            this.m_project2Queue = project2Queue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            for (Project project : this.m_projects) {
                Queue queue = this.m_project2Queue.get(project);
                try {
                    this.scanTablesForProjectChanges(project, true, queue);
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException("Failed while scanning tables for project changes", ie);
                }
                Queue queue2 = queue;
                synchronized (queue2) {
                    queue.add(TechnologyScopeDetector.END);
                    queue.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scanTablesForProjectChanges(Project project, boolean requeryAll, Queue queue) throws InterruptedException {
            Collection fileTables = ContentSetScope.getInstance((Workspace)this.m_workspace, (Project)project).getFileTables();
            Storage projectStorage = Storages.getProjectStorage((Workspace)this.m_workspace, (Project)project);
            for (FileTable fileTable : fileTables) {
                try {
                    ChangedURLsCallable c = new ChangedURLsCallable(projectStorage, fileTable.getStorageKey(), fileTable, LOG, requeryAll);
                    Collection changedURLs = (Collection)projectStorage.runWhileOpen((Callable)c);
                    if (changedURLs.size() <= 0) continue;
                    queue.addAll(changedURLs);
                    Queue queue2 = queue;
                    synchronized (queue2) {
                        queue.notifyAll();
                    }
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, "Failed while loading from the storage of " + this.m_workspace, e);
                }
            }
        }
    }
}

