/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.graphic.layout.column;

import ilog.views.IlvGraphic;
import ilog.views.IlvManager;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.graphic.IlvLine;
import ilog.views.graphic.composite.layout.IlvAttachable;
import ilog.views.graphic.composite.layout.IlvAttachableGraphic;
import oracle.diagram.framework.geom.DimensionFloat;
import oracle.diagram.framework.graphic.ExtendedGraphic;
import oracle.diagram.framework.graphic.layout.AbstractLayout;
import oracle.diagram.framework.manager.ManagerUtil;

public class ColumnLayout
extends AbstractLayout {
    public void layoutGroup(IlvAttachable parent) {
        IlvRect bounds = new IlvRect(((IlvAttachableGraphic)parent).getGraphic().boundingBox(null));
        IlvGraphic parentGraphic = ((IlvAttachableGraphic)parent).getGraphic();
        bounds.x += this.getLeftMargin();
        bounds.width = bounds.width - this.getLeftMargin() - this.getRightMargin();
        bounds.y += this.getTopMargin();
        bounds.height = bounds.height - this.getTopMargin() - this.getBottomMargin();
        IlvAttachable[] children = parent.getAttachables();
        float x = bounds.x;
        for (IlvAttachable child : children) {
            IlvRect childBBox;
            IlvGraphic g = ((IlvAttachableGraphic)child).getGraphic();
            if (g instanceof ExtendedGraphic) {
                childBBox = new IlvRect(g.boundingBox(null));
                DimensionFloat d = ((ExtendedGraphic)g).getPreferedSize(new DimensionFloat());
                IlvRect r = new IlvRect(bounds);
                r.width = d.width;
                r.x = x;
                r.y = bounds.y;
                if (childBBox.width != r.width || childBBox.height != r.height || childBBox.x != r.x || childBBox.y != r.y) {
                    child.move(r.x, r.y);
                    child.resize(new IlvPoint(r.width, r.height));
                    g.moveResize(r);
                }
                x += r.width;
                continue;
            }
            if (!(g instanceof IlvLine)) continue;
            childBBox = new IlvRect(child.getAttachmentBounds());
            IlvLine divider = (IlvLine)g;
            float width = divider.getLineWidth();
            float y0 = bounds.y;
            float y1 = bounds.y + bounds.height - 1.0f;
            float x0 = x;
            if (width > 1.0f) {
                x0 += width / 2.0f;
                y0 += width / 2.0f;
                y1 -= width / 2.0f;
            }
            divider.setFrom(new IlvPoint(x0, y0));
            divider.setTo(new IlvPoint(x0, y1));
            IlvManager mgr = ManagerUtil.getManager(parentGraphic);
            if (mgr != null) {
                mgr.invalidateRegion(childBBox);
            }
            x += width;
        }
        this.fireLayoutPerformed(((IlvAttachableGraphic)parent).getGraphic());
    }
}

