/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.link.glyph;

import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import oracle.diagram.framework.link.RenderedGlyph;

public class DotGlyph
extends RenderedGlyph {
    private Shape _shape;
    private final float _width;
    private final float _height;
    private boolean _filled;

    public DotGlyph() {
        this(true);
    }

    public DotGlyph(boolean filled) {
        this(5.0f, 5.0f, filled);
    }

    public DotGlyph(float width, float height, boolean filled) {
        this._width = width;
        this._height = height;
        this._filled = filled;
        this.initShape();
    }

    @Override
    protected RenderedGlyph.FillColor getFillColor() {
        return this._filled ? RenderedGlyph.FillColor.EDGE_COLOR : RenderedGlyph.FillColor.BACK_COLOR;
    }

    @Override
    protected Shape getShape() {
        return this._shape;
    }

    public void setFilled(boolean filled) {
        this._filled = filled;
    }

    protected void initShape() {
        this._shape = new Ellipse2D.Float(-this._width, -this._height / 2.0f, this._width, this._height);
        RenderingHints rHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        rHints.add(new RenderingHints(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE));
        this.setRenderingHints(rHints);
    }
}

