/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.palette;

import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvManager;
import ilog.views.IlvManagerFrame;
import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.plugin.PluginUtil;
import oracle.diagram.framework.accessibility.ADACreateNode;
import oracle.diagram.framework.accessibility.NavigableGraphicPlugin;
import oracle.diagram.framework.accessibility.PresentableGraphicPlugin;
import oracle.diagram.framework.graphic.IMultipresentationContainer;
import oracle.diagram.framework.manager.VisibleObjectsIterator;
import oracle.diagram.framework.palette.interactor.NodeItemFactory;
import oracle.ide.palette2.PaletteItem;

public class CreateDefaultNodeHandler
extends ADACreateNode {
    private final DiagramContext _context;
    private final PaletteItem _item;
    private final NodeItemFactory _factory;

    public CreateDefaultNodeHandler(DiagramContext context, PaletteItem item, NodeItemFactory factory) {
        this._context = context;
        this._item = item;
        this._factory = factory;
    }

    protected final DiagramContext getDiagramContext() {
        return this._context;
    }

    protected final IlvManagerView getManagerView() {
        return this.getDiagramContext().getManagerView();
    }

    protected final PaletteItem getPaletteItem() {
        return this._item;
    }

    protected final NodeItemFactory getFactory() {
        return this._factory;
    }

    private IlvRect calcGraphicLocation(IlvManager context, Dimension factorySize) {
        IlvRect mgrBounds = context.boundingBox();
        IlvManagerFrame frame = context.getFrame();
        if (frame != null) {
            float leftMargin = frame.getLeftMargin(context, null);
            float rightMargin = frame.getRightMargin(context, null);
            float topMargin = frame.getTopMargin(context, null);
            float bottomMargin = frame.getBottomMargin(context, null);
            mgrBounds.x += leftMargin;
            mgrBounds.y += topMargin;
            mgrBounds.width -= leftMargin + rightMargin;
            mgrBounds.height -= topMargin + bottomMargin;
            IlvTransformer t = context.getTransformer();
            t.inverse(mgrBounds);
        }
        float x = (float)Math.max((double)mgrBounds.x, mgrBounds.getCenterX() - (double)(factorySize.width / 2));
        float y = (float)Math.max((double)mgrBounds.x, mgrBounds.getCenterY() - (double)(factorySize.height / 2));
        IlvRect graphicRect = new IlvRect(x, y, (float)factorySize.width, (float)factorySize.height);
        return graphicRect;
    }

    @Override
    protected boolean createNode(IlvGraphic context) {
        if (context instanceof IlvManager) {
            IlvRect r;
            IlvManagerView view = this.getManagerView();
            Dimension d = this._factory.getPreferredSize();
            IlvPoint location = null;
            if (context == this.getRoot()) {
                location = new IlvPoint((float)(view.getX() + view.getWidth() / 2), (float)(view.getY() + view.getHeight() / 2));
                view.getTransformer().inverse(location);
                r = new IlvRect(location.x - (float)(d.width / 2), location.y - (float)(d.height / 2), (float)d.width, (float)d.height);
            } else {
                r = this.calcGraphicLocation((IlvManager)context, d);
            }
            IlvGraphic g = this._factory.createObject(r);
            if (g != null) {
                this._factory.initializeNewObject(this.getDiagramContext(), this.getPaletteItem(), (IlvGraphic)((IlvManager)context), g);
                if (context instanceof IlvGrapher && this.getFactory().isGrapherMode()) {
                    ((IlvGrapher)context).addNode(g, true);
                } else {
                    ((IlvManager)context).addObject(g, true);
                }
                IlvManager mgr = (IlvManager)context;
                mgr.setSelectionAdjusting(true);
                mgr.deSelectAll(true);
                mgr.setSelected(g, true, true);
                mgr.setSelectionAdjusting(false);
                this._factory.postCreateNewObject(this.getDiagramContext(), this.getPaletteItem(), (IlvGraphic)((IlvManager)context), g, true);
            }
            return true;
        }
        return false;
    }

    @Override
    protected List<IlvGraphic> getValidContexts() {
        IlvManagerView view = this.getManagerView();
        IlvManager mgr = view.getManager();
        int count = mgr.getCardinal(true);
        ArrayList<Object> valid = new ArrayList<Object>(count + 1);
        if (this.getFactory().isValidContext(this.getPaletteItem(), (IlvGraphic)this.getRoot())) {
            valid.add(this.getRoot());
        }
        for (IlvGraphic g : new VisibleObjectsIterator(mgr, true)) {
            if (!this.getFactory().isValidContext(this.getPaletteItem(), g)) continue;
            if (g instanceof IMultipresentationContainer) {
                valid.add(((IMultipresentationContainer)g).getCurrentPresentation());
                continue;
            }
            valid.add(g);
        }
        return Collections.unmodifiableList(valid);
    }

    @Override
    protected NavigableGraphicPlugin getNavigableGraphicPlugin(IlvGraphic g) {
        return PluginUtil.getPlugin(this.getManagerView(), g, NavigableGraphicPlugin.class);
    }

    @Override
    protected PresentableGraphicPlugin getPresentableGraphicPlugin(IlvGraphic g) {
        return PluginUtil.getPlugin(this.getManagerView(), g, PresentableGraphicPlugin.class);
    }

    @Override
    protected IlvManager getRoot() {
        return this.getManagerView().getManager();
    }

    @Override
    protected String getType() {
        return this.getFactory().getType(this.getPaletteItem());
    }

    @Override
    protected IlvGraphic getInitialSelection() {
        IlvManager mgr = this.getManagerView().getManager();
        int count = mgr.getSelectedObjectsCount(true);
        if (count == 1) {
            return mgr.getSelectedObjects(true).nextElement();
        }
        return null;
    }
}

