/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.print;

import ilog.views.IlvManagerView;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import oracle.diagram.core.plugin.PluginUtil;
import oracle.diagram.framework.print.PrintPlugin;
import oracle.diagram.framework.view.DecoratedGrid;
import oracle.diagram.framework.view.GridDecoration;

public class PrintAreaGridDecoration
implements GridDecoration {
    protected static final Stroke STROKE = new BasicStroke(0.8f, 0, 0, 5.0f, new float[]{5.0f, 5.0f}, 0.0f);
    private IlvManagerView _view;

    public PrintAreaGridDecoration(IlvManagerView view) {
        this._view = view;
    }

    @Override
    public final void draw(DecoratedGrid grid, Graphics g, IlvTransformer tx, Rectangle r) {
        IlvRect rPrint;
        PrintPlugin pp = PluginUtil.getPlugin(this.getManagerView(), PrintPlugin.class);
        if (pp != null && (rPrint = pp.getPrintArea()) != null) {
            tx.apply(rPrint);
            Rectangle clip = g.getClip().getBounds();
            if (rPrint.intersects((Rectangle2D)clip)) {
                this.drawPrintAreaBox(g, rPrint);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawPrintAreaBox(Graphics g, IlvRect r) {
        Graphics2D g2d = (Graphics2D)g;
        Paint oldPaint = g2d.getPaint();
        Stroke oldStroke = g2d.getStroke();
        try {
            g2d.setPaint(Color.GRAY);
            g2d.setStroke(STROKE);
            g2d.draw(new Rectangle2D.Float(r.x, r.y, r.width, r.height));
        }
        finally {
            g2d.setStroke(oldStroke);
            g2d.setPaint(oldPaint);
        }
    }

    protected final IlvManagerView getManagerView() {
        return this._view;
    }
}

