/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.swimlanes.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvManager;
import ilog.views.IlvRect;
import ilog.views.IlvSelection;
import ilog.views.IlvUnresizeableDrawSelection;
import ilog.views.graphic.IlvLine;
import ilog.views.graphic.composite.layout.IlvLayoutManager;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import oracle.diagram.framework.geom.DimensionFloat;
import oracle.diagram.framework.selection.SubSelectionManager;
import oracle.diagram.framework.shape.SubShape;
import oracle.diagram.framework.swimlanes.graphic.ExtendedSwimlaneGraphic;
import oracle.diagram.framework.swimlanes.graphic.SwimlaneGraphic;
import oracle.diagram.framework.swimlanes.graphic.SwimlaneGraphicConstraint;
import oracle.diagram.framework.undo.UndoableStep;

public abstract class PoolGraphic
extends SwimlaneGraphic {
    protected ArrayList<SwimlaneGraphic> _lanes = new ArrayList();
    protected ArrayList<DividerLine> _dividers = new ArrayList();
    protected float _dividerThickness = 1.0f;
    protected Color _dividerColor = Color.BLACK;

    protected PoolGraphic(IlvRect rect, IlvLayoutManager layoutManager, List<SwimlaneGraphic> laneGraphics) {
        super(rect, layoutManager);
        for (SwimlaneGraphic lane : laneGraphics) {
            this.addLane(lane);
        }
    }

    public IlvSelection makeSelection() {
        return null;
    }

    public void setDividerThickness(float thickness) {
        this._dividerThickness = thickness;
        if (this._dividers != null) {
            for (DividerLine divider : this._dividers) {
                divider.setLineWidth(this._dividerThickness);
            }
            this.invalidate(true);
            this.reDraw();
        }
    }

    public float getDividerThickness() {
        return this._dividerThickness;
    }

    @Override
    public void setTopLevel(boolean topLevel) {
        super.setTopLevel(topLevel);
        if (this.isTopLevel() && this._lanes.size() > 1 && this._dividers.size() < this._lanes.size()) {
            this.addDividerImpl();
        }
    }

    private void addLane(SwimlaneGraphic lane) {
        if (this.isTopLevel()) {
            this.addLaneImpl(lane);
            this.addDividerImpl();
        } else {
            if (!this._lanes.isEmpty()) {
                this.addDividerImpl();
            }
            this.addLaneImpl(lane);
        }
        this.invalidate(true);
    }

    private void addLaneImpl(SwimlaneGraphic lane) {
        lane.setTopLevel(false);
        if (((ExtendedSwimlaneGraphic)lane).getHeader() != null) {
            ((ExtendedSwimlaneGraphic)lane).getHeader().setOpenBorders(!this.isTopLevel(), true, false, true);
        }
        this.addContent(lane);
        this._lanes.add(lane);
    }

    private void addDividerImpl() {
        DividerLine divider = new DividerLine();
        SubSelectionManager.setSelectable((IlvGraphic)divider, false);
        divider.setLineWidth(this._dividerThickness);
        divider.setForeground(this._dividerColor);
        this.addContent(divider);
        this._dividers.add(divider);
    }

    protected void insertLaneImpl(SwimlaneGraphic lane, int index, DimensionFloat delta) {
        if (index == this._lanes.size()) {
            this.addLane(lane);
        } else {
            lane.setTopLevel(false);
            ((ExtendedSwimlaneGraphic)lane).getHeader().setOpenBorders(!this.isTopLevel(), true, false, true);
            DividerLine divider = new DividerLine();
            SubSelectionManager.setSelectable((IlvGraphic)divider, false);
            divider.setLineWidth(this._dividerThickness);
            divider.setForeground(this._dividerColor);
            int childIndex = index * 2 + 1;
            LinkedList<IlvGraphic> childrenList = new LinkedList<IlvGraphic>(Arrays.asList(this.getChildren()));
            childrenList.add(childIndex, (IlvGraphic)lane);
            childrenList.add(childIndex + 1, (IlvGraphic)divider);
            this.setChildren(childrenList.toArray(new IlvGraphic[childrenList.size()]));
            this._lanes.add(index, lane);
            this._dividers.add(index, divider);
        }
        this.onSizeChanged(delta);
    }

    protected void moveLaneImpl(int fromIndex, int toIndex) {
        LinkedList<Object> childrenList = new LinkedList<Object>();
        IlvGraphic outline = this.getChildren(0);
        childrenList.add(outline);
        int newIndex = toIndex > fromIndex ? toIndex - 1 : toIndex;
        SwimlaneGraphic lane = this._lanes.remove(fromIndex);
        this._lanes.add(newIndex, lane);
        int numLanes = this._lanes.size();
        int numDividers = this._dividers.size();
        for (int i = 0; i < numLanes; ++i) {
            childrenList.add(this._lanes.get(i));
            if (i >= numDividers) continue;
            childrenList.add(this._dividers.get(i));
        }
        this.setChildren(childrenList.toArray(new IlvGraphic[childrenList.size()]));
        this.onSizeChanged(new DimensionFloat(0.0f, 0.0f));
    }

    public abstract UndoableStep createLaneGraphicUndoableStep(SwimlaneGraphic var1);

    public abstract UndoableStep createLaneIndexUndoableStep(int var1);

    public abstract void insertLane(SwimlaneGraphic var1, int var2);

    public abstract void deleteLane(SwimlaneGraphic var1);

    protected void deleteLaneImpl(SwimlaneGraphic lane, DimensionFloat delta) {
        int index = this._lanes.indexOf(lane);
        if (index != -1) {
            int numChildrenToDelete = 1;
            int numLanes = this._lanes.size();
            int numDividers = this._dividers.size();
            int childIndex = index * 2 + 1;
            this._lanes.remove(lane);
            if (this.isTopLevel() && numDividers == numLanes) {
                this._dividers.remove(index);
                ++numChildrenToDelete;
            } else if (!this.isTopLevel() && numLanes > 1 && numDividers == numLanes - 1) {
                if (index == numLanes - 1) {
                    this._dividers.remove(index - 1);
                    --childIndex;
                    ++numChildrenToDelete;
                } else {
                    this._dividers.remove(index);
                    ++numChildrenToDelete;
                }
            }
            IlvGraphic[] currentChildren = this.getChildren();
            IlvGraphic[] newChildren = new IlvGraphic[currentChildren.length - numChildrenToDelete];
            System.arraycopy(currentChildren, 0, newChildren, 0, childIndex);
            System.arraycopy(currentChildren, childIndex + numChildrenToDelete, newChildren, childIndex, newChildren.length - childIndex);
            Object[] currentConstraints = new Object[currentChildren.length];
            Object[] newConstraints = new Object[newChildren.length];
            for (int j = 0; j < currentChildren.length; ++j) {
                currentConstraints[j] = this.getConstraints(j);
            }
            System.arraycopy(currentConstraints, 0, newConstraints, 0, childIndex);
            System.arraycopy(currentConstraints, childIndex + numChildrenToDelete, newConstraints, childIndex, newConstraints.length - childIndex);
            if (this._lanes.size() == 1 && this._dividers.size() == 1) {
                IlvGraphic divider = (IlvGraphic)this._dividers.get(0);
                this._dividers.clear();
                currentChildren = newChildren;
                currentConstraints = newConstraints;
                newChildren = new IlvGraphic[currentChildren.length - 1];
                newConstraints = new IlvGraphic[currentChildren.length - 1];
                int j = 0;
                for (int i = 0; i < currentChildren.length; ++i) {
                    if (currentChildren[i] == divider) continue;
                    newChildren[j] = currentChildren[i];
                    newConstraints[j] = currentConstraints[i];
                    ++j;
                }
            }
            super.removeAll(false);
            super.setChildren(newChildren);
            super.setConstraints(newConstraints);
            for (IlvGraphic child : newChildren) {
                IlvGraphicBag oldBag = child.getGraphicBag();
                if (oldBag != null) {
                    oldBag.removeObject(child, false);
                }
                super.addObject(child, false);
            }
            this.onSizeChanged(delta);
        }
    }

    private void onSizeChanged(DimensionFloat delta) {
        SwimlaneGraphic g = this;
        IlvGraphicBag bag = this.getGraphicBag();
        if (bag != null) {
            while (!(bag instanceof IlvManager)) {
                g = (SwimlaneGraphic)bag;
                bag = g.getGraphicBag();
            }
            IlvRect bbox = new IlvRect(g.boundingBox(null));
            bbox.width += delta.width;
            bbox.height += delta.height;
            ((IlvManager)bag).reshapeObject((IlvGraphic)g, bbox, true);
            g.invalidate(true);
            g.doLayout();
            this.doLayout();
            this.getTopSwimlane().fireLayoutChanged();
        }
    }

    protected void resizeLaneImpl(SwimlaneGraphic lane, DimensionFloat newPreferredSize) {
        DimensionFloat oldPreferredSize = lane.getPreferedSize(new DimensionFloat());
        if (oldPreferredSize.width != newPreferredSize.width || oldPreferredSize.height != newPreferredSize.height) {
            lane.setPreferedSize(new DimensionFloat(newPreferredSize.width, newPreferredSize.height));
            SwimlaneGraphic g = this;
            IlvGraphicBag bag = this.getGraphicBag();
            while (!(bag instanceof IlvManager)) {
                g = (SwimlaneGraphic)bag;
                bag = g.getGraphicBag();
            }
            IlvRect bbox = new IlvRect(g.boundingBox(null));
            bbox.width += newPreferredSize.width - oldPreferredSize.width;
            bbox.height += newPreferredSize.height - oldPreferredSize.height;
            ((IlvManager)bag).reshapeObject((IlvGraphic)g, bbox, true);
            g.invalidate(true);
            g.doLayout();
            this.doLayout();
            this.getTopSwimlane().fireLayoutChanged();
        }
    }

    @Override
    protected int getSwimlaneGraphicConstraintsImpl(LinkedList<SwimlaneGraphicConstraint> constraints, int startIndex) {
        int nextIndex = startIndex;
        List<SwimlaneGraphic> lanes = this.getLanes();
        for (SwimlaneGraphic lane : lanes) {
            nextIndex = lane.getSwimlaneGraphicConstraintsImpl(constraints, nextIndex);
        }
        return super.getSwimlaneGraphicConstraintsImpl(constraints, nextIndex);
    }

    public void setDividerColor(Color color) {
        this._dividerColor = color;
        if (this._dividers != null) {
            for (DividerLine divider : this._dividers) {
                divider.setForeground(this._dividerColor);
            }
        }
    }

    public Color getDividerColor() {
        return this._dividerColor;
    }

    public List<SwimlaneGraphic> getLanes() {
        return Collections.unmodifiableList(this._lanes);
    }

    @Override
    public boolean isLayoutCurrent() {
        List<SwimlaneGraphic> lanes = this.getLanes();
        for (SwimlaneGraphic lane : lanes) {
            if (lane.isLayoutCurrent()) continue;
            return false;
        }
        return true;
    }

    protected static class DividerLine
    extends IlvLine
    implements SubShape {
        public DividerLine() {
            this.setProperty("NonEllipsisShape", Boolean.TRUE);
        }

        public IlvSelection makeSelection() {
            return new IlvUnresizeableDrawSelection((IlvGraphic)this);
        }
    }
}

