/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.common;

import java.util.HashMap;
import oracle.help.common.AssociativeLink;
import oracle.help.common.MergingAssociativeLink;
import oracle.help.library.Book;

public class AssociativeLinkRepository {
    private HashMap _linkTable = new HashMap();

    public void addLink(AssociativeLink aLink) {
        if (aLink != null) {
            String aLinkID = aLink.getLinkID();
            AssociativeLink aLinkInTable = (AssociativeLink)this._linkTable.get(aLinkID);
            if (aLinkInTable == null) {
                this._linkTable.put(aLinkID, aLink);
            } else {
                MergingAssociativeLink mal;
                if (aLinkInTable instanceof MergingAssociativeLink) {
                    mal = (MergingAssociativeLink)aLinkInTable;
                } else {
                    mal = new MergingAssociativeLink(aLinkID);
                    mal.addAssociativeLink(aLinkInTable);
                    this._linkTable.put(aLinkID, mal);
                }
                mal.addAssociativeLink(aLink);
            }
        }
    }

    public void removeLink(AssociativeLink aLink) {
        AssociativeLink aLinkInTable;
        if (aLink != null && (aLinkInTable = (AssociativeLink)this._linkTable.get(aLink.getLinkID())) != null) {
            if (aLinkInTable instanceof MergingAssociativeLink) {
                ((MergingAssociativeLink)aLinkInTable).removeAssociativeLink(aLink);
            } else {
                this._linkTable.remove(aLink.getLinkID());
            }
        }
    }

    public void addLinksInBook(Book book) {
        AssociativeLink[] bookLinks = book.getAssociativeLinks();
        if (bookLinks != null) {
            for (int iter = 0; iter < bookLinks.length; ++iter) {
                this.addLink(bookLinks[iter]);
            }
        }
    }

    public void removeLinksInBook(Book book) {
        AssociativeLink[] bookLinks = book.getAssociativeLinks();
        if (bookLinks != null) {
            for (int iter = 0; iter < bookLinks.length; ++iter) {
                this.removeLink(bookLinks[iter]);
            }
        }
    }

    public AssociativeLink getLink(String linkID) {
        return (AssociativeLink)this._linkTable.get(linkID);
    }
}

