/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1.samples;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class XmlCompare {
    protected static final String FEATURE_XML_ROUNDTRIP = "http://xmlpull.org/v1/doc/features.html#xml-roundtrip";

    public static void main(String[] stringArray) throws XmlPullParserException, IOException {
        XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance(System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
        xmlPullParserFactory.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        XmlPullParser xmlPullParser = xmlPullParserFactory.newPullParser();
        try {
            xmlPullParser.setFeature(FEATURE_XML_ROUNDTRIP, false);
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new RuntimeException("could nto disable roundtrip feature: " + xmlPullParserException);
        }
        System.out.println("parser implementation class is " + xmlPullParser.getClass());
        xmlPullParser.setInput(new FileReader("fcked_up2.xml"));
        String string = XmlCompare.getNextElementText(xmlPullParser);
        XmlCompare.compareXmlTwoFiles(new FileReader("fcked_up2.xml"), new StringReader(string));
    }

    public static String getNextElementText(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        if (!xmlPullParser.getFeature(FEATURE_XML_ROUNDTRIP)) {
            throw new RuntimeException("roundtrip feature must be enabled to get tag content");
        }
        int n = 1;
        StringBuffer stringBuffer = new StringBuffer();
        xmlPullParser.nextTag();
        stringBuffer.append(xmlPullParser.getText());
        while (n > 0) {
            int n2 = xmlPullParser.next();
            String string = xmlPullParser.getText();
            if (n2 == 2) {
                stringBuffer.append(string);
                if (xmlPullParser.isEmptyElementTag()) {
                    xmlPullParser.next();
                    continue;
                }
                ++n;
                continue;
            }
            if (n2 == 3) {
                stringBuffer.append(string);
                --n;
                continue;
            }
            if (string.length() <= 0) continue;
            StringBuffer stringBuffer2 = new StringBuffer(string.length());
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '<') {
                    stringBuffer2.append("&lt;");
                    continue;
                }
                if (c == '&') {
                    stringBuffer2.append("&amp;");
                    continue;
                }
                if (c == '\"') {
                    stringBuffer2.append("&quot;");
                    continue;
                }
                if (c == '\'') {
                    stringBuffer2.append("&apos;");
                    continue;
                }
                stringBuffer2.append(c);
            }
            stringBuffer.append(stringBuffer2);
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    static void compareXmlTwoFiles(Reader reader, Reader reader2) throws XmlPullParserException, IOException {
        XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance("org.xmlpull.mxp1.MXParserFactory", null);
        xmlPullParserFactory.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        XmlPullParser xmlPullParser = xmlPullParserFactory.newPullParser();
        xmlPullParser.setInput(reader);
        XmlPullParser xmlPullParser2 = xmlPullParserFactory.newPullParser();
        xmlPullParser2.setInput(reader2);
        while (true) {
            String string;
            String string2;
            xmlPullParser.next();
            xmlPullParser2.next();
            if (xmlPullParser.getEventType() != xmlPullParser2.getEventType()) {
                throw new RuntimeException("inconsistent events");
            }
            if (xmlPullParser.getEventType() == 1) {
                System.err.println("\nOK");
                return;
            }
            if (xmlPullParser.getEventType() == 2 || xmlPullParser.getEventType() == 3) {
                string2 = xmlPullParser.getName();
                if (!string2.equals(string = xmlPullParser2.getName())) {
                    throw new RuntimeException("element names mismatch");
                }
                if (xmlPullParser.getEventType() != 2) {
                    // empty if block
                }
            } else {
                if (xmlPullParser.getEventType() != 4) {
                    throw new RuntimeException("unknown event type " + xmlPullParser.getEventType() + xmlPullParser.getPositionDescription());
                }
                string2 = xmlPullParser.getText();
                if (!string2.equals(string = xmlPullParser2.getText())) {
                    throw new RuntimeException("text content mismatch '" + string2 + "' and '" + string + "'");
                }
            }
            System.err.print(".");
        }
    }
}

