/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.changelist;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.explorer.IconOverlay;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.vcs.cache.LocalStatusCache;
import oracle.jdeveloper.vcs.changelist.ChangeList;
import oracle.jdeveloper.vcs.changelist.ChangeListEventQueue;
import oracle.jdeveloper.vcs.changelist.ChangeListItem;
import oracle.jdeveloper.vcs.icons.VCSIconArb;
import oracle.jdeveloper.vcs.spi.VCSOverlayItemProducer;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.changelist.SVNIncomingChangeList;
import oracle.jdevimpl.vcs.svn.changelist.SVNRemoteStatus;

public final class SVNIncomingEventQueue
extends ChangeListEventQueue {
    private boolean _taskInProgress;
    private SVNIncomingChangeList _changeList;
    private static final Map<String, String> sIconReferences = new HashMap<String, String>(7);

    public SVNIncomingEventQueue(SVNIncomingChangeList changeList) {
        super((ChangeList)changeList);
        this._changeList = changeList;
    }

    protected void setChangeListBusy(boolean isBusy) {
    }

    void setChangeListBusyImpl(boolean isBusy) {
        super.setChangeListBusy(isBusy);
    }

    void setTaskInProgress(boolean taskInProgress) {
        this._taskInProgress = taskInProgress;
    }

    boolean isTaskInProgress() {
        return this._taskInProgress;
    }

    protected ChangeListItem createChangeListItem(URL url) {
        URL url0 = URLFileSystem.canonicalize((URL)url);
        ChangeListItem cli = super.createChangeListItem(url0);
        VCSOverlayItemProducer overlayItemProducer = this.getChangeList().getOverlayItemProducer();
        Object overlayItem = null;
        IconOverlay iconOverlay = null;
        if (overlayItemProducer != null) {
            try {
                LocalStatusCache cache = (LocalStatusCache)this._changeList.getPolicyStatusCache();
                SVNRemoteStatus status = (SVNRemoteStatus)cache.get(url0);
                String iconkey = sIconReferences.get("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_UNVERSIONED");
                if (status.equals(SVNRemoteStatus.TEXT_MODIFIED) || status.equals(SVNRemoteStatus.PROP_MODIFIED) || status.equals(SVNRemoteStatus.TEXT_PROP_MODIFIED)) {
                    iconkey = sIconReferences.get("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_MODIFIED");
                }
                if (status.equals(SVNRemoteStatus.ADDED)) {
                    iconkey = sIconReferences.get("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_ADDED");
                }
                if (status.equals(SVNRemoteStatus.DELETED)) {
                    iconkey = sIconReferences.get("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_REMOVED");
                }
                iconOverlay = new IconOverlay(VCSIconArb.getIcon((String)iconkey), status.getID(), status.getChangeListLabel());
                cli.setOverlay(iconOverlay);
            }
            catch (Exception e) {
                SVNProfile.getQualifiedLogger(((Object)((Object)this)).getClass().getName()).warning(e.getMessage());
            }
        }
        return cli;
    }

    static {
        sIconReferences.put("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_ADDED", "extras/overlay_added.png");
        sIconReferences.put("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_CHECKED_IN", "extras/overlay_checkedin.png");
        sIconReferences.put("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_CHECKED_OUT", "extras/overlay_checkedout.png");
        sIconReferences.put("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_CONFLICTS", "extras/overlay_conflicts.png");
        sIconReferences.put("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_MODIFIED", "extras/overlay_modified.png");
        sIconReferences.put("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_REMOVED", "extras/overlay_removed.png");
        sIconReferences.put("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_UNADDED", "extras/overlay_unversioned.png");
        sIconReferences.put("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_UNVERSIONED", "extras/overlay_unversioned.png");
        sIconReferences.put("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_IGNORED", "extras/overlay_ignored.png");
    }
}

