/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.util;

import java.io.File;
import java.net.URL;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.jdevimpl.vcs.generic.util.AbstractIdentifiable;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;

public class MergeTempFileFilter
extends AbstractIdentifiable
implements URLFilter {
    public boolean accept(URL url) {
        String fileName = URLFileSystem.getFileName((URL)url);
        if (fileName != null) {
            File originalFile;
            String originalName;
            String[] tokens;
            File file = SVNUtil.toFile(url);
            if (fileName.matches(".+\\.r\\d+$")) {
                tokens = fileName.split("\\.r\\d+$");
                originalName = tokens[0];
                originalFile = new File(file.getParent(), originalName);
                File mineFile = new File(file.getParent(), originalName.concat(".mine"));
                if (originalFile.exists() && mineFile.exists()) {
                    return true;
                }
            }
            if (fileName.endsWith(".mine")) {
                tokens = fileName.split("\\.mine");
                originalName = tokens[0];
                originalFile = new File(file.getParent(), originalName);
                if (originalFile.exists()) {
                    return true;
                }
            }
        }
        return false;
    }
}

