/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.persistence;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.TimeZone;
import oracle.dss.util.xml.BaseNode;
import oracle.javatools.annotations.Concealed;

@Concealed
public class AttributeValue
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int m_type = -1;
    private Object m_val = null;
    private SimpleDateFormat m_dateFormat = null;

    public AttributeValue(int type, Object value) {
        this.m_type = type;
        this.m_val = value;
    }

    public int getType() {
        return this.m_type;
    }

    public String getValue() {
        try {
            if (this.m_val == null) {
                return null;
            }
            if (this.m_type == 10) {
                return this.getDateValue();
            }
            String bValue = this.m_val.toString();
            if (bValue != null && bValue.length() > 0) {
                return BaseNode.createEscapes(bValue);
            }
            return bValue;
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public String getUnescapedValue() {
        try {
            if (this.m_val == null) {
                return null;
            }
            if (this.m_type == 10) {
                return this.getDateValue();
            }
            String bValue = this.m_val.toString();
            return bValue;
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    private String getDateValue() {
        this.m_dateFormat = new SimpleDateFormat("z yyyy-MM-dd HH:mm:ss");
        this.m_dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        String bValue = this.m_dateFormat.format((Date)this.m_val);
        return bValue;
    }

    public boolean equals(Object obj) {
        if (((AttributeValue)obj).getValue() == null) {
            return this.getValue() == null && ((AttributeValue)obj).getType() == this.getType();
        }
        return ((AttributeValue)obj).getValue().equals(this.getValue()) && ((AttributeValue)obj).getType() == this.getType();
    }
}

