/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.externaltools;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.ide.util.MetaClass;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import oracle.ide.Addin;
import oracle.ide.config.Preferences;
import oracle.ide.externaltools.ExternalTool;
import oracle.ide.externaltools.ExternalToolManager;
import oracle.ide.externaltools.ExternalToolType;
import oracle.ide.externaltools.macro.MacroRegistry;
import oracle.ideimpl.externaltools.ExternalToolList;
import oracle.ideimpl.externaltools.ExternalToolsHook;
import oracle.ideimpl.externaltools.LazyExternalToolType;
import oracle.ideimpl.externaltools.MenuManager;
import oracle.ideimpl.externaltools.macro.MacroRegistryImpl;
import oracle.ideimpl.externaltools.ui.ExternalToolsWizard;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;

public class ExternalToolAddin
extends ExternalToolManager
implements Addin {
    private Collection<ExternalToolType> m_toolTypes;
    private MacroRegistry m_macroRegistry;
    private MenuManager m_menuManager;

    private MacroRegistry createMacroRegistry() {
        return new MacroRegistryImpl();
    }

    private ExternalToolList getToolList() {
        ExternalToolList list = ExternalToolList.getInstance((PropertyStorage)Preferences.getPreferences());
        return list;
    }

    @Override
    public void addExternalTool(ExternalTool tool) {
        this.getToolList().add(tool);
        this.m_menuManager.addItem(tool);
    }

    void refreshMenus() {
        this.m_menuManager.uninstallItems();
        this.m_menuManager.installItems();
    }

    @Override
    public Collection<ExternalTool> tools() {
        return Collections.unmodifiableCollection(this.getToolList().tools());
    }

    @Override
    public Collection<ExternalTool> toolsOfType(ExternalToolType type) {
        ArrayList<ExternalTool> l = new ArrayList<ExternalTool>();
        for (ExternalTool tool : this.tools()) {
            LazyExternalToolType lazyToolType = (LazyExternalToolType)type;
            MetaClass metaClass = lazyToolType.getExternalToolMetaClass();
            if (!metaClass.getClassName().equals(tool.getClass().getName())) continue;
            l.add(tool);
        }
        return Collections.unmodifiableCollection(l);
    }

    @Override
    public MacroRegistry getMacroRegistry() {
        if (this.m_macroRegistry == null) {
            this.m_macroRegistry = this.createMacroRegistry();
        }
        return this.m_macroRegistry;
    }

    @Override
    public int getRegisteredTypeCount() {
        if (this.m_toolTypes == null) {
            this.getRegisteredTypes();
        }
        return this.m_toolTypes.size();
    }

    public Iterator getRegisteredTypes() {
        if (this.m_toolTypes == null) {
            this.m_toolTypes = ExternalToolsHook.getDeclaredExternalTools().getExternalToolTypes();
        }
        return this.m_toolTypes.iterator();
    }

    @Override
    public ExternalTool invokeCreateWizard(Component parent, ExternalToolType type) {
        ExternalTool t = new ExternalToolsWizard().runCreateWizard(this.getToolList().tools(), this, parent, type);
        if (t != null) {
            this.addExternalTool(t);
        }
        return t;
    }

    @Override
    public boolean invokeEditDialog(Component parent, ExternalTool tool) {
        return false;
    }

    @Override
    public void removeExternalTool(ExternalTool tool) {
        this.m_menuManager.removeItem(tool);
        this.getToolList().remove(tool);
    }

    @Override
    @Deprecated
    public void unregisterType(ExternalToolType type) {
    }

    @Override
    @Deprecated
    public void registerType(ExternalToolType type) {
    }

    private void postInit() {
        this.m_menuManager.delayedInstallItems();
    }

    MenuManager getMenuManager() {
        return this.m_menuManager;
    }

    public void initialize() {
        try {
            InitialContext ic = new InitialContext();
            try {
                ic.lookup("ide");
            }
            catch (NamingException ne) {
                ic.createSubcontext("ide");
            }
            ic.bind("ide/external-tool-manager", (Object)this);
            try {
                ic.lookup("jdeveloper");
            }
            catch (NamingException ne) {
                ic.createSubcontext("jdeveloper");
            }
            ic.bind("jdeveloper/external-tool-manager", (Object)this);
        }
        catch (NamingException ne) {
            ExceptionDialog.showExceptionDialog((Component)null, (Throwable)ne);
        }
        this.m_menuManager = new MenuManager(this);
        this.postInit();
    }
}

