/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.externaltools.program;

import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.externaltools.ExternalProgramToolProperties;
import oracle.ide.externaltools.ExternalTool;
import oracle.ide.externaltools.ExternalToolBaseProperties;
import oracle.ide.externaltools.ExternalToolEvent;
import oracle.ide.externaltools.ExternalToolManager;
import oracle.ide.externaltools.ExternalToolVetoException;
import oracle.ide.externaltools.ToolRunException;
import oracle.ide.externaltools.macro.MacroRegistry;
import oracle.ide.model.NodeUtil;
import oracle.ide.runner.RunProcessListener;
import oracle.ide.runner.SimpleProcess;
import oracle.ideimpl.externaltools.ExternalToolsArb;
import oracle.ideimpl.externaltools.program.ExternalProgramType;
import oracle.javatools.dialogs.MessageDialog;

public final class ExternalProgramTool
extends ExternalTool {
    private static Icon s_defaultIcon;

    @Override
    public Icon getIconWhenRequired() {
        if (s_defaultIcon == null) {
            s_defaultIcon = new ImageIcon(ExternalProgramTool.class.getResource("programtool.gif"));
        }
        return s_defaultIcon;
    }

    private static String[] buildCmdArray(MacroRegistry mr, Context context, String program, String arguments) {
        ArrayList<String> l = new ArrayList<String>();
        l.add(program);
        StringTokenizer tok = new StringTokenizer(arguments, "\" ", true);
        boolean inQuote = false;
        StringBuffer quoteBuffer = null;
        String lastToken = null;
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if ("\"".equals(token)) {
                if (inQuote) {
                    inQuote = false;
                    l.add(mr.expand(quoteBuffer.toString(), context));
                    quoteBuffer = null;
                    continue;
                }
                inQuote = true;
                quoteBuffer = new StringBuffer();
                continue;
            }
            if (" ".equals(token)) {
                if (inQuote) {
                    quoteBuffer.append(token);
                    continue;
                }
                if (lastToken == null) continue;
                l.add(mr.expand(lastToken, context));
                lastToken = null;
                continue;
            }
            if (inQuote) {
                quoteBuffer.append(token);
                continue;
            }
            lastToken = token;
        }
        if (lastToken != null) {
            l.add(mr.expand(lastToken, context));
        }
        if (inQuote && quoteBuffer != null) {
            l.add(quoteBuffer.toString());
        }
        String[] cmdArray = new String[l.size()];
        l.toArray(cmdArray);
        return cmdArray;
    }

    @Override
    public void run(ExternalToolManager mgr, Context ctx) throws ToolRunException {
        IdeAction saveAllAction;
        try {
            mgr.fireToolWillStart(new ExternalToolEvent(this, this));
        }
        catch (ExternalToolVetoException e) {
            return;
        }
        ExternalToolBaseProperties baseProps = ExternalToolBaseProperties.getInstance(this);
        ExternalProgramToolProperties program = ExternalProgramToolProperties.getInstance(this);
        if (baseProps.getSaveAllBeforeRun() && (saveAllAction = IdeActions.getFileSaveAllAction()) != null) {
            try {
                saveAllAction.performAction(ctx);
            }
            catch (Exception e) {
                throw new ToolRunException("Unable to save all before running tool", e);
            }
        }
        String expandedExec = mgr.getMacroRegistry().expand(program.getExecutable(), ctx);
        String expandedRunDir = mgr.getMacroRegistry().expand(program.getRunDirectory(), ctx);
        final SimpleProcess sp = new SimpleProcess(ExternalProgramTool.buildCmdArray(mgr.getMacroRegistry(), ctx, expandedExec, program.getArguments()));
        sp.setLabel(StringUtils.stripMnemonic((String)baseProps.getCaption()));
        if (!baseProps.getShowInRunManager()) {
            sp.setAddToProcessesFolder(false);
            sp.setAddToTerminateMenu(false);
        }
        if (!baseProps.getLogOutput()) {
            sp.setLogCommandString(false);
            sp.setLogStartDirectory(false);
            sp.getRunProcess().setLogError(false);
            sp.getRunProcess().setLogOutput(false);
            sp.getRunProcess().setUseLogPage(false);
        }
        if (expandedRunDir != null && expandedRunDir.trim().length() != 0) {
            boolean doIt;
            File f = new File(expandedRunDir);
            if (!(f.exists() && f.isDirectory() || (doIt = MessageDialog.confirm((Component)ctx.getView().getGUI(), (Object)ExternalToolsArb.getString(3), (String)ExternalToolsArb.getString(4), null)))) {
                return;
            }
            sp.setWorkingDirectory(f);
        }
        if (baseProps.getReloadBuffers()) {
            final HashMap timestampMap = new HashMap();
            NodeUtil.storeAllTimestamps(timestampMap);
            sp.setRunProcessListener(new RunProcessListener(){

                public void processFinished(int exitCode) {
                    NodeUtil.reloadBuffers((Map)timestampMap);
                    sp.setRunProcessListener(null);
                }
            });
        }
        sp.exec();
        if (sp.getExecException() != null) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)ExternalToolsArb.format(6, baseProps.getCaption()), (String)ExternalToolsArb.getString(5), null);
            return;
        }
        mgr.fireToolStarted(new ExternalToolEvent(this, this));
    }

    public Class<ExternalProgramType> getType() {
        return ExternalProgramType.class;
    }

    private ExternalProgramToolProperties props() {
        return ExternalProgramToolProperties.getInstance(this);
    }

    public String getExecutable() {
        return this.props().getExecutable();
    }

    public void setExecutable(String executable) {
        this.props().setExecutable(executable);
    }

    public String getRunDirectory() {
        return this.props().getRunDirectory();
    }

    public void setRunDirectory(String runDirectory) {
        this.props().setRunDirectory(runDirectory);
    }

    public String getArguments() {
        return this.props().getArguments();
    }

    public void setArguments(String arguments) {
        this.props().setArguments(arguments);
    }
}

