/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.layer.ui;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.EventObject;
import oracle.maps.core.MapCanvas;
import oracle.maps.cs.CSTransformer;
import oracle.maps.graphics.MapTip;
import oracle.maps.layer.BasicLayer;

public class PointerLocationLayer
extends BasicLayer {
    NumberFormat formatter = new DecimalFormat(".#####");
    protected MapTip tipper = null;
    protected Point2D topLeftCorner = new Point2D.Double(100.0, 15.0);
    protected String text;
    boolean dragStarted = false;
    int dragStartX = -999;
    int dragStartY = -999;
    Rectangle2D ghostRect = null;
    boolean justDragged = false;

    public PointerLocationLayer(MapCanvas canvas) {
        super(canvas);
        this.properties.setDefaultProperty("oracle.maps.core.Layer.name", "Pointer Location Layer");
        this.tipper = new MapTip();
        this.tipper.setRounded(true);
        this.tipper.setBorderless(true);
        this.tipper.setNeverShrink(true);
    }

    @Override
    public long render(Graphics2D g) {
        if (this.text == null || this.text.length() == 0) {
            return 0L;
        }
        this.tipper.setText(this.text);
        AffineTransform oldXfm = g.getTransform();
        g.setTransform(new AffineTransform());
        long res = this.tipper.render(g, this.topLeftCorner);
        if (this.dragStarted && this.ghostRect != null) {
            g.setColor(Color.magenta);
            g.draw(this.ghostRect);
        }
        g.setTransform(oldXfm);
        return res;
    }

    @Override
    public boolean isMyEvent(EventObject evt) {
        return evt instanceof MouseEvent && this.canvas.getLayerManager().getLayerByTag("dataLayer") != null;
    }

    @Override
    public boolean propagateEvent(EventObject evt) {
        return !this.dragStarted;
    }

    @Override
    public void handleTheEvent(EventObject evt) {
        if (!(evt instanceof MouseEvent)) {
            return;
        }
        MouseEvent me = (MouseEvent)evt;
        int x = me.getX();
        int y = me.getY();
        this.updateLocation(x, y);
        int id = me.getID();
        switch (id) {
            case 501: {
                double deltaX = (double)me.getX() - this.topLeftCorner.getX();
                double deltaY = (double)me.getY() - this.topLeftCorner.getY();
                int w = this.tipper.getWidth() - 10;
                int h = this.tipper.getHeight() - 6;
                if (!(deltaX > 5.0) || !(deltaX < (double)w) || !(deltaY > 3.0) || !(deltaY < (double)h)) break;
                this.dragStarted = true;
                this.canvas.getLayerManager().clearAllHover();
                this.dragStartX = me.getX();
                this.dragStartY = me.getY();
                if (this.ghostRect == null) {
                    this.ghostRect = new Rectangle2D.Double(this.topLeftCorner.getX(), this.topLeftCorner.getY(), this.tipper.getWidth(), this.tipper.getHeight());
                    break;
                }
                this.ghostRect.setRect(this.topLeftCorner.getX(), this.topLeftCorner.getY(), this.tipper.getWidth(), this.tipper.getHeight());
                break;
            }
            case 506: {
                if (!this.dragStarted || this.ghostRect == null) break;
                this.ghostRect.setRect(x, y, this.tipper.getWidth(), this.tipper.getHeight());
                break;
            }
            case 502: 
            case 505: {
                if (this.dragStarted) {
                    this.topLeftCorner.setLocation(x, y);
                }
                this.dragStarted = false;
                this.ghostRect = null;
            }
        }
    }

    private void updateLocation(int x, int y) {
        int userSrid;
        AffineTransform inv = null;
        try {
            inv = this.canvas.getMapRegion().getViewportTransform().createInverse();
        }
        catch (NoninvertibleTransformException ex) {
            this.text = null;
            return;
        }
        Point2D.Double pt = new Point2D.Double(x, y);
        inv.transform(pt, pt);
        double[] mapCoord = new double[]{((Point2D)pt).getX(), ((Point2D)pt).getY()};
        if (Double.isNaN(mapCoord[0]) || Double.isNaN(mapCoord[1])) {
            this.text = null;
            return;
        }
        int mapSrid = this.canvas.getMapRegion().getMapSrid();
        if (mapSrid != (userSrid = this.canvas.getMapRegion().getUserSrid())) {
            boolean res = CSTransformer.transform(mapCoord, 2, new int[]{mapSrid, userSrid}, null);
            this.text = res ? "" + this.formatter.format(mapCoord[0]) + " " + this.formatter.format(mapCoord[1]) : "" + this.formatter.format(mapCoord[0]) + " " + this.formatter.format(mapCoord[1]);
            return;
        }
        this.text = "" + this.formatter.format(((Point2D)pt).getX()) + " " + this.formatter.format(((Point2D)pt).getY());
    }
}

