/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui;

import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import oracle.mdeditor.ui.resources.MessagesBundle;

public class AttributeValueTableModel
extends AbstractTableModel {
    Vector attrRecords = null;
    protected static int NUM_COLUMNS = 2;
    protected static int START_NUM_ROWS = 0;
    protected int numRows = 0;
    private String attributeColumn = MessagesBundle.getMessage("Attribute");
    private String valueColumn = MessagesBundle.getMessage("Value");
    protected Vector valueEditable = new Vector();

    public AttributeValueTableModel() {
        this.attrRecords = new Vector();
        for (int i = 0; i < START_NUM_ROWS; ++i) {
            this.attrRecords.addElement(new AttrRecord());
        }
        this.numRows = START_NUM_ROWS;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return this.attributeColumn;
            }
            case 1: {
                return this.valueColumn;
            }
        }
        return "";
    }

    public void setColumnName(int col, String colName) {
        if (colName == null || colName.trim().length() < 1 || col < 0 || col > 1) {
            return;
        }
        switch (col) {
            case 0: {
                this.attributeColumn = colName.trim();
                break;
            }
            case 1: {
                this.valueColumn = colName.trim();
                break;
            }
        }
        this.fireTableStructureChanged();
    }

    @Override
    public int getColumnCount() {
        return NUM_COLUMNS;
    }

    public Class getColumnClass(int col) {
        if (col == 0) {
            return String.class;
        }
        if (col == 1) {
            return String.class;
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 1 && (Boolean)this.valueEditable.get(row) == true;
    }

    public void setValueEditable(int row, boolean edit) {
        if (row < 0 || row >= this.numRows) {
            return;
        }
        this.valueEditable.remove(row);
        this.valueEditable.add(row, new Boolean(edit));
    }

    @Override
    public int getRowCount() {
        if (this.numRows < START_NUM_ROWS) {
            return START_NUM_ROWS;
        }
        return this.numRows;
    }

    @Override
    public Object getValueAt(int row, int col) {
        try {
            AttrRecord t = (AttrRecord)this.attrRecords.elementAt(row);
            switch (col) {
                case 0: {
                    return t.attribute;
                }
                case 1: {
                    return t.value;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        AttrRecord rr = (AttrRecord)this.attrRecords.elementAt(row);
        switch (col) {
            case 0: {
                rr.attribute = (String)value;
                this.fireTableCellUpdated(row, col);
                break;
            }
            case 1: {
                rr.value = (String)value;
                this.fireTableCellUpdated(row, col);
                break;
            }
        }
    }

    public void clearData() {
        this.valueEditable.clear();
        this.attrRecords.removeAllElements();
        if (this.numRows > START_NUM_ROWS) {
            this.fireTableRowsDeleted(START_NUM_ROWS, this.numRows - 1);
        }
        for (int i = 0; i < START_NUM_ROWS; ++i) {
            this.attrRecords.addElement(new AttrRecord());
        }
        this.fireTableRowsUpdated(0, START_NUM_ROWS - 1);
        this.numRows = START_NUM_ROWS;
    }

    public void addNewRecord(String attribute, String value, boolean edit) {
        AttrRecord newrec = new AttrRecord();
        newrec.attribute = attribute;
        newrec.value = value;
        this.attrRecords.add(newrec);
        this.fireTableRowsInserted(this.numRows, this.numRows);
        ++this.numRows;
        this.valueEditable.add(new Boolean(edit));
    }

    public void removeRecord(int idx) {
        if (idx < 0 || idx >= this.numRows) {
            return;
        }
        this.attrRecords.remove(idx);
        this.fireTableRowsDeleted(idx, idx);
        --this.numRows;
        this.valueEditable.remove(idx);
    }

    class AttrRecord {
        String attribute = null;
        String value = null;

        AttrRecord() {
        }
    }
}

