/*
 * Decompiled with CFR 0.152.
 */
package oracle.as.management.tracing.impl;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import oracle.as.management.logging.impl.Msgs;
import oracle.as.management.logging.messages.Messages;
import oracle.as.management.tracing.ContextListener;
import oracle.as.management.tracing.HttpRequestListener;
import oracle.as.management.tracing.TraceInfo;
import oracle.as.management.tracing.TraceProvider;
import oracle.as.management.tracing.TraceProviderInfo;
import oracle.as.management.tracing.TraceProviderManager;
import oracle.as.management.tracing.impl.IncidentSupport;
import oracle.as.management.tracing.impl.LoggerFactory;
import oracle.as.management.tracing.impl.ODLTraceProvider;
import oracle.core.ojdl.logging.LogUtil;
import oracle.core.ojdl.logging.context.ApplicationContext;
import oracle.core.ojdl.logging.context.DMSLoggingContextProvider;
import oracle.core.ojdl.logging.context.UserContext;
import oracle.core.ojdl.weblogic.ApplicationContextImpl;
import oracle.core.ojdl.weblogic.UserContextImpl;
import oracle.dfw.incident.Incident;
import oracle.dms.context.DMSContextManager;
import oracle.dms.context.ExecutionContext;
import oracle.dms.context.ExecutionContextListener;
import oracle.dms.event.Destination;
import oracle.dms.event.Event;
import oracle.dms.event.EventActionType;
import oracle.dms.event.EventSourceType;
import oracle.dms.event.EventSystem;
import oracle.dms.event.EventType;
import oracle.dms.event.EventTypeEnthusiast;
import oracle.dms.event.Filter;
import oracle.dms.event.NullFilterWithEventTypeProxy;

public class TracingController
implements HttpRequestListener,
TraceProviderManager {
    public static final String ODL_TRACE_ID_KEY = "ODL_TRACE_ID";
    public static final String ODL_TRACE_DISABLED_KEY = "ODL_TRACE_DISABLED";
    public static final String ATTR_COOKIE = "COOKIE";
    public static final String ATTR_USER_ID = "USER_ID";
    public static final String ATTR_APP_STRIPE = "APP_STRIPE";
    public static final String ATTR_APP = "APP";
    private ApplicationContext m_appCtx;
    private UserContext m_userCtx;
    private List<TraceProvider> m_providers = Collections.synchronizedList(new ArrayList());
    private Map<TraceProvider, Set<String>> m_providerAttrs = Collections.synchronizedMap(new HashMap());
    private Map<String, TracingData> m_activeTraces = Collections.synchronizedMap(new LinkedHashMap());
    private List<TraceInfo> m_history = Collections.synchronizedList(new ArrayList());
    private Map<String, Map<String, TracingData>> m_attrTracing = Collections.synchronizedMap(new HashMap());
    private Map<String, TracingData> m_cookieTracing = Collections.synchronizedMap(new HashMap());
    private volatile boolean m_isTracingEnabled = false;
    private Logger m_logger = LoggerFactory.getLogger();
    private static TracingController s_instance = new TracingController();
    private static Method s_getAppIDMet;
    private ODLTraceProvider m_odlProvider = new ODLTraceProvider();
    private static final int MAX_HISTORY_LEN = 25;
    private static final String[] PROV_ERROR_MSGS;

    protected TracingController() {
        String[] props = (String[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new String[]{System.getProperty("oracle.as.management.tracing.applicationcontextprovider"), System.getProperty("oracle.as.management.tracing.usercontextprovider"), System.getProperty("oracle.as.management.tracing.traceproviders")};
            }
        });
        if (props[0] != null && props[0].length() > 0) {
            try {
                this.m_appCtx = (ApplicationContext)Class.forName(props[0]).newInstance();
            }
            catch (Throwable t) {
                this.m_logger.log(Level.FINE, "Unable to initialize ApplicationContext from class " + props[0], t);
            }
        }
        if (this.m_appCtx == null) {
            this.m_appCtx = new ApplicationContextImpl();
        }
        if (props[1] != null && props[1].length() > 0) {
            try {
                this.m_userCtx = (UserContext)Class.forName(props[1]).newInstance();
            }
            catch (Throwable t) {
                this.m_logger.log(Level.FINE, "Unable to initialize UserContext from class " + props[1], t);
            }
        }
        if (this.m_userCtx == null) {
            this.m_userCtx = new UserContextImpl();
        }
        this.initDMS();
        DMSContextManager.setKeyAttribute((String)ODL_TRACE_ID_KEY, (int)1);
        DMSContextManager.setKeyAttribute((String)ODL_TRACE_ID_KEY, (int)2);
        this.addTraceProvider(this.m_odlProvider);
        if (props[2] != null && props[2].length() > 0) {
            StringTokenizer st = new StringTokenizer(props[2], ",");
            while (st.hasMoreTokens()) {
                String providerClassName = st.nextToken();
                try {
                    TraceProvider tp = (TraceProvider)Class.forName(providerClassName).newInstance();
                    this.addTraceProvider(tp);
                    tp.setEnabled(true);
                    this.m_logger.log(Level.FINE, "Added a TraceProvider instance using class " + providerClassName);
                }
                catch (Exception e) {
                    this.m_logger.log(Level.WARNING, "Failed to create TraceProvider instance with class " + providerClassName, e);
                }
            }
        }
        ServiceLoader<TraceProvider> providerLoader = ServiceLoader.load(TraceProvider.class);
        for (TraceProvider tp : providerLoader) {
            if (this.m_logger.isLoggable(Level.FINE)) {
                this.m_logger.log(Level.FINE, "TracingController found TraceProvider: " + tp.getName());
            }
            this.addTraceProvider(tp);
        }
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.log(Level.FINER, "TracingController initialized");
        }
    }

    public static TracingController getInstance() {
        return s_instance;
    }

    @Override
    public synchronized boolean addTraceProvider(TraceProvider tp) {
        if (this.m_providers.contains(tp)) {
            return false;
        }
        this.m_providers.add(tp);
        List<String> supportedAttrs = tp.getTraceProviderInfo(Locale.getDefault()).getSupportedAttributes();
        if (supportedAttrs != null && supportedAttrs.size() > 0) {
            this.m_providerAttrs.put(tp, new HashSet<String>(supportedAttrs));
        }
        return true;
    }

    @Override
    public synchronized boolean removeTraceProvider(TraceProvider tp) {
        if (!this.m_providers.contains(tp)) {
            return false;
        }
        this.m_providerAttrs.remove(tp);
        this.m_providers.remove(tp);
        return true;
    }

    public synchronized List<TraceInfo> getActiveTraces() {
        ArrayList<TraceInfo> list = new ArrayList<TraceInfo>(this.m_activeTraces.size());
        ArrayList<String> expired = new ArrayList<String>();
        long currentTime = System.currentTimeMillis();
        for (TracingData td : this.m_activeTraces.values()) {
            TraceInfo ti = td.m_traceInfo;
            if (ti.getExpirationTime() > 0L && currentTime > ti.getExpirationTime()) {
                expired.add(ti.getTraceId());
                continue;
            }
            TraceInfo ti2 = new TraceInfo();
            ti2.setTraceId(ti.getTraceId());
            ti2.setAttrName(ti.getAttrName());
            ti2.setAttrValue(ti.getAttrValue());
            ti2.setLevel(ti.getLevel());
            ti2.setDesc(ti.getDesc());
            ti2.setExpirationTime(ti.getExpirationTime());
            ti2.setStartTime(ti.getStartTime());
            ti2.setStopTime(ti.getStopTime());
            list.add(ti2);
        }
        for (String traceId : expired) {
            this.stopTracing(traceId);
        }
        return list;
    }

    public synchronized List<TraceInfo> getHistory() {
        ArrayList<TraceInfo> list = new ArrayList<TraceInfo>(this.m_history.size());
        for (TraceInfo ti : this.m_history) {
            TraceInfo ti2 = new TraceInfo();
            ti2.setTraceId(ti.getTraceId());
            ti2.setAttrName(ti.getAttrName());
            ti2.setAttrValue(ti.getAttrValue());
            ti2.setLevel(ti.getLevel());
            ti2.setDesc(ti.getDesc());
            ti2.setExpirationTime(ti.getExpirationTime());
            ti2.setStartTime(ti.getStartTime());
            ti2.setStopTime(ti.getStopTime());
            list.add(ti2);
        }
        return list;
    }

    public synchronized void clearHistory() {
        this.m_history.clear();
    }

    public synchronized void startTracing(String traceId, String attrName, String attrValue, Level level, long duration, String desc) {
        this.startTracing(traceId, attrName, attrValue, level, duration, desc, null);
    }

    public synchronized void startTracing(String traceId, String attrName, String attrValue, Level level, long duration, String desc, Map<String, Map<String, String>> params) {
        String METHOD_NAME = "startTracing";
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.entering(this.getClass().getName(), "startTracing", new Object[]{traceId, attrName, attrValue, level, duration, desc});
        }
        if (traceId == null || attrName == null || attrValue == null && !ATTR_COOKIE.equals(attrName) || level == null) {
            throw new IllegalArgumentException("Method arguments cannot be null");
        }
        if (this.m_activeTraces.containsKey(traceId)) {
            throw new IllegalArgumentException(Msgs.get((String)"ODL-52801", (Object[])new Object[]{traceId}));
        }
        Map<String, TracingData> map = this.m_attrTracing.get(attrName);
        if (map != null && map.containsKey(attrValue)) {
            throw new IllegalArgumentException(Msgs.get((String)"ODL-52802", (Object[])new Object[]{attrName, attrValue}));
        }
        if (params != null) {
            Set<String> availableProviders = this.getAvailableProviders();
            for (String providerName : params.keySet()) {
                if (availableProviders.contains(providerName)) continue;
                throw new IllegalArgumentException("Invalid trace provider name: " + providerName);
            }
        }
        long startTime = System.currentTimeMillis();
        long expirationTime = 0L;
        if (duration > 0L) {
            expirationTime = startTime + duration * 60L * 1000L;
        }
        int status = 0;
        Throwable providerException = null;
        ArrayList<TraceProvider> startedProviders = new ArrayList<TraceProvider>(this.m_providers.size());
        TraceProvider failedProvider = null;
        for (TraceProvider tp : this.m_providers) {
            block22: {
                Map<String, String> providerParams;
                if (!tp.isEnabled() || this.m_providerAttrs.containsKey(tp) && !this.m_providerAttrs.get(tp).contains(attrName)) continue;
                Map<String, String> map2 = providerParams = params != null ? params.get(tp.getName()) : null;
                if (providerParams == null) {
                    providerParams = Collections.emptyMap();
                }
                try {
                    status = tp.startTracing(traceId, attrName, attrValue, level, providerParams);
                    if (status != 0) {
                        failedProvider = tp;
                        this.m_logger.logp(Level.FINE, this.getClass().getName(), "startTracing", "startTracing failed for provider " + tp.getName() + " with status " + status);
                    }
                    break block22;
                }
                catch (Exception e) {
                    failedProvider = tp;
                    providerException = e;
                    this.m_logger.logp(Level.FINE, this.getClass().getName(), "startTracing", "startTracing failed for provider " + tp.getName() + " with exception " + e, e);
                }
                break;
            }
            startedProviders.add(tp);
        }
        if (status != 0 || providerException != null) {
            String cause;
            boolean rolledBack = true;
            for (TraceProvider tp : startedProviders) {
                try {
                    int stopStatus = tp.stopTracing(traceId);
                    if (stopStatus == 0) continue;
                    rolledBack = false;
                    this.m_logger.log(Level.FINE, "Rollback of startTracing operation failed for trace provider '" + tp.getName() + "' with status '" + status + "'.");
                }
                catch (Exception e1) {
                    rolledBack = false;
                    this.m_logger.log(Level.FINE, "Rollback of startTracing operation failed for trace provider '" + tp.getName() + "' with exception: " + e1, e1);
                }
            }
            if (!rolledBack) {
                this.m_logger.logrb(Level.SEVERE, this.getClass().getName(), "startTracing", Messages.class.getName(), "ODL-52805");
                throw new RuntimeException(Msgs.get((String)"ODL-52805", (Object[])new Object[0]));
            }
            if (status != 0) {
                String key = status > 0 && status < PROV_ERROR_MSGS.length ? PROV_ERROR_MSGS[status] : PROV_ERROR_MSGS[0];
                cause = Msgs.getMsg((String)key, (Object[])new Object[0]);
            } else {
                cause = providerException.toString();
            }
            throw new RuntimeException(Msgs.get((String)"ODL-52804", (Object[])new Object[]{failedProvider.getName(), cause}));
        }
        TraceInfo ti = new TraceInfo();
        ti.setTraceId(traceId);
        ti.setAttrName(attrName);
        ti.setAttrValue(attrValue);
        ti.setLevel(level);
        ti.setDesc(desc);
        ti.setExpirationTime(expirationTime);
        ti.setStartTime(startTime);
        TracingData td = new TracingData();
        td.m_traceInfo = ti;
        td.m_level = level;
        td.m_traceId = traceId;
        td.m_expirationTime = expirationTime;
        td.m_startedProviders = startedProviders;
        td.m_startTime = startTime;
        if (attrName.equals(ATTR_COOKIE)) {
            this.m_cookieTracing.put(traceId, td);
        } else {
            Map<String, TracingData> attrMap = this.m_attrTracing.get(attrName);
            if (attrMap == null) {
                attrMap = Collections.synchronizedMap(new HashMap());
                this.m_attrTracing.put(attrName, attrMap);
            }
            attrMap.put(attrValue, td);
        }
        this.m_activeTraces.put(traceId, td);
        this.m_isTracingEnabled = true;
        DMSLoggingContextProvider.setTracingEnabled(true);
    }

    public synchronized void stopTracing(String traceId) {
        this.stopTracing(traceId, false);
    }

    public synchronized void stopTracing(String traceId, boolean createIncident) {
        String METHOD_NAME = "stopTracing";
        if (traceId == null) {
            throw new IllegalArgumentException();
        }
        TracingData td = this.m_activeTraces.get(traceId);
        if (td != null) {
            TraceInfo ti = td.m_traceInfo;
            String attrName = ti.getAttrName();
            if (ATTR_COOKIE.equals(attrName)) {
                this.m_cookieTracing.remove(traceId);
            } else {
                Map<String, TracingData> map = this.m_attrTracing.get(attrName);
                if (map != null) {
                    map.remove(ti.getAttrValue());
                }
            }
            this.m_activeTraces.remove(traceId);
            for (ExecutionContext ctx : td.m_contexts.keySet()) {
                this.resetContext(ctx);
            }
            if (createIncident) {
                boolean hasTraceData = false;
                for (TraceProvider tp : td.m_startedProviders) {
                    if (tp.hasTraceData(traceId)) {
                        hasTraceData = true;
                        if (!this.m_logger.isLoggable(Level.FINE)) continue;
                        this.m_logger.logp(Level.FINE, this.getClass().getName(), "stopTracing", "Trace provider " + tp.getName() + "has data for trace " + traceId);
                        continue;
                    }
                    if (!this.m_logger.isLoggable(Level.FINE)) continue;
                    this.m_logger.logp(Level.FINE, this.getClass().getName(), "stopTracing", "Trace provider " + tp.getName() + "does not have data for trace " + traceId);
                }
                if (!hasTraceData) {
                    createIncident = false;
                    if (this.m_logger.isLoggable(Level.FINE)) {
                        this.m_logger.logp(Level.FINE, this.getClass().getName(), "stopTracing", "No incident will be created because no provider has any data.");
                    }
                }
            }
            Incident incident = null;
            long stopTime = System.currentTimeMillis();
            ti.setStopTime(stopTime);
            try {
                if (createIncident) {
                    incident = IncidentSupport.getInstance().createIncident(ti);
                }
            }
            catch (Exception e) {
                this.m_logger.logrb(Level.SEVERE, this.getClass().getName(), "stopTracing", Messages.class.getName(), "ODL-52807");
                incident = null;
            }
            for (TraceProvider tp : td.m_startedProviders) {
                try {
                    int status = incident != null ? tp.stopTracing(ti, incident) : tp.stopTracing(ti.getTraceId());
                    if (status == 0) continue;
                    this.m_logger.logrb(Level.SEVERE, this.getClass().getName(), "stopTracing", Messages.class.getName(), "ODL-52806", new Object[]{tp.getName(), status});
                }
                catch (Exception e) {
                    LogUtil.logrb(this.m_logger, Level.SEVERE, this.getClass().getName(), "stopTracing", Messages.class.getName(), "ODL-52806", new Object[]{tp.getName(), e.toString()}, e);
                }
            }
            if (this.m_history.size() >= 25) {
                this.m_history.remove(0);
            }
            this.m_history.add(ti);
        }
        if (this.m_activeTraces.size() == 0) {
            this.m_isTracingEnabled = false;
            DMSLoggingContextProvider.setTracingEnabled(false);
        }
    }

    public synchronized void stopTracing() {
        for (String traceId : this.m_activeTraces.keySet()) {
            this.stopTracing(traceId);
        }
    }

    public synchronized Set<String> getAvailableProviders() {
        TreeSet<String> providers = new TreeSet<String>();
        for (TraceProvider tp : this.m_providers) {
            providers.add(tp.getName());
        }
        return providers;
    }

    public synchronized Set<String> getEnabledProviders() {
        TreeSet<String> providers = new TreeSet<String>();
        for (TraceProvider tp : this.m_providers) {
            if (!tp.isEnabled()) continue;
            providers.add(tp.getName());
        }
        return providers;
    }

    public synchronized void setEnabledProviders(Set<String> enabledProviders) throws Exception {
        for (TraceProvider tp : this.m_providers) {
            tp.setEnabled(enabledProviders.contains(tp.getName()));
        }
    }

    public List<TraceProviderInfo> getTraceProviderInfo(Locale loc) {
        ArrayList<TraceProviderInfo> list = new ArrayList<TraceProviderInfo>();
        for (TraceProvider tp : this.m_providers) {
            list.add(tp.getTraceProviderInfo(loc));
        }
        return list;
    }

    public TraceProviderInfo getTraceProviderInfo(String providerName, Locale loc) {
        for (TraceProvider tp : this.m_providers) {
            if (!providerName.equals(tp.getName())) continue;
            return tp.getTraceProviderInfo(loc);
        }
        return null;
    }

    public boolean isEnabledForLoggingEvents() {
        return this.m_odlProvider.isEnabled();
    }

    public void setEnabledForLoggingEvents(boolean enabled) {
        this.m_odlProvider.setEnabled(enabled);
    }

    public Map<String, Boolean> getODLLoggers() {
        return this.m_odlProvider.getODLLoggers();
    }

    public void configureODLLoggers(Map<String, Boolean> loggers) {
        this.m_odlProvider.configureODLLoggers(loggers);
    }

    @Override
    public void handleHttpRequest(HttpServletRequest request, ExecutionContext ctx) {
        TracingData td;
        if (!this.m_isTracingEnabled) {
            return;
        }
        ctx.setValue("CLIENT_ADDR", request.getRemoteAddr());
        ctx.setValue("CLIENT_HOST", request.getRemoteHost());
        if (this.m_cookieTracing.size() == 0) {
            return;
        }
        String traceId = null;
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie c : cookies) {
                if (!"ORA_ODL_TRACE_ID".equals(c.getName())) continue;
                traceId = c.getValue();
                break;
            }
        }
        if (traceId != null && traceId.length() > 0 && (td = this.m_cookieTracing.get(traceId)) != null && !this.isTraceDisabled(ctx)) {
            this.initContext(ctx, td);
        }
    }

    private void initContext(ExecutionContext ctx, TracingData td) {
        if (td.m_expirationTime > 0L && System.currentTimeMillis() > td.m_expirationTime) {
            this.stopTracing(td.m_traceId);
            return;
        }
        ctx.setLogLevel(td.m_level);
        ctx.setValue(ODL_TRACE_ID_KEY, td.m_traceId);
        ctx.setValue("client_identifier", td.m_traceId);
        td.m_contexts.put(ctx, "");
        for (TraceProvider tp : this.m_providers) {
            if (!(tp instanceof ContextListener)) continue;
            ((ContextListener)((Object)tp)).handleNewContext(ctx);
        }
    }

    private void resetContext(ExecutionContext ctx) {
        ctx.setLogLevel(null);
        ctx.setValue(ODL_TRACE_ID_KEY, null);
        ctx.setValue("client_identifier", null);
    }

    private void initDMS() {
        DMSContextListener d = new DMSContextListener();
        NullFilterWithEventTypeProxy f = new NullFilterWithEventTypeProxy("TracingManager.DMSContextFilter", "Filter for DMS context events", (Object)d);
        EventSystem.getEventConfigManager().associateFilterWithDestination((Filter)f, (Destination)d);
    }

    private void handleNewContext(ExecutionContext ctx) {
        if (!this.m_isTracingEnabled) {
            return;
        }
        String app = this.m_appCtx.getApplicationName();
        if ("diagspy".equals(app)) {
            ctx.setValue(ODL_TRACE_DISABLED_KEY, "true");
            return;
        }
        if (this.m_attrTracing.size() > 0) {
            String userName;
            TracingData td;
            TracingData td2;
            Map<String, TracingData> map = this.m_attrTracing.get(ATTR_APP);
            if (map != null && map.containsKey(app) && (td2 = map.get(app)) != null && !this.isTraceDisabled(ctx)) {
                this.initContext(ctx, td2);
                return;
            }
            map = this.m_attrTracing.get(ATTR_USER_ID);
            if (map != null && (td = map.get(userName = this.m_userCtx.getUserName())) != null && !this.isTraceDisabled(ctx)) {
                this.initContext(ctx, td);
                return;
            }
            map = this.m_attrTracing.get(ATTR_APP_STRIPE);
            if (map != null) {
                String appStripe;
                try {
                    appStripe = s_getAppIDMet != null ? (String)s_getAppIDMet.invoke(null, new Object[0]) : null;
                }
                catch (Throwable t) {
                    if (this.m_logger.isLoggable(Level.FINEST)) {
                        this.m_logger.log(Level.FINEST, "Unable to determine APP_STRING: caught exception: " + t, t);
                    }
                    appStripe = null;
                }
                if (appStripe != null && (td = map.get(appStripe)) != null && !this.isTraceDisabled(ctx)) {
                    this.initContext(ctx, td);
                    return;
                }
            }
        }
    }

    private final boolean isTraceDisabled(ExecutionContext ctx) {
        return "true".equals(ctx.getValue(ODL_TRACE_DISABLED_KEY));
    }

    static {
        try {
            Class<?> cl = Class.forName("oracle.security.jps.internal.api.runtime.AppSecurityContext");
            s_getAppIDMet = cl.getDeclaredMethod("getApplicationID", new Class[0]);
        }
        catch (Throwable t) {
            s_getAppIDMet = null;
        }
        PROV_ERROR_MSGS = new String[]{"TP_ERROR_OTHER", "TP_ERROR_1", "TP_ERROR_2", "TP_ERROR_3", "TP_ERROR_4", "TP_ERROR_5"};
    }

    private static class TracingData {
        Level m_level;
        String m_traceId;
        long m_expirationTime;
        List<TraceProvider> m_startedProviders;
        TraceInfo m_traceInfo;
        long m_startTime;
        long m_stopTime;
        WeakHashMap<ExecutionContext, String> m_contexts = new WeakHashMap();

        private TracingData() {
        }
    }

    private class ContextAttributeListener
    implements ExecutionContextListener {
        private ContextAttributeListener() {
        }

        public void keyTouched(String key) {
            ExecutionContext ctx;
            String v;
            TracingData td;
            if (!TracingController.this.m_isTracingEnabled) {
                return;
            }
            Map map = (Map)TracingController.this.m_attrTracing.get(key);
            if (map != null && (td = (TracingData)map.get(v = (ctx = ExecutionContext.get()).getValue(key))) != null && !TracingController.this.isTraceDisabled(ctx)) {
                TracingController.this.initContext(ctx, td);
            }
        }
    }

    private class DMSContextListener
    implements Destination,
    EventTypeEnthusiast {
        private EventType[] s_eventTypesOfInterest = new EventType[]{EventType.getEventType((EventSourceType)EventSourceType.EXECUTION_CONTEXT, (EventActionType)EventActionType.START)};

        private DMSContextListener() {
        }

        public void handleEvent(Event event) {
            ExecutionContext ctx = event.getExecutionContext();
            if (ctx != null) {
                ctx.registerListener((ExecutionContextListener)new ContextAttributeListener());
                if (s_instance != null) {
                    s_instance.handleNewContext(ctx);
                }
            }
        }

        public boolean needsContext() {
            return true;
        }

        public void initDestination() {
        }

        public void shutdownDestination() {
        }

        public EventType[] getEventTypesOfInterest() {
            return this.s_eventTypesOfInterest;
        }

        public String getId() {
            return this.toString();
        }

        public String getName() {
            return this.getClass().getName();
        }

        public void validate() {
        }
    }
}

