/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Set;

public abstract class SocketChannelWrapper
extends SocketChannel {
    protected SocketChannel socketChannel = null;
    protected int bufferSize = 8192;

    SocketChannelWrapper(SocketChannel socketChannel) {
        super(socketChannel != null ? socketChannel.provider() : null);
        this.socketChannel = socketChannel;
    }

    abstract void disconnect() throws IOException;

    public SocketChannel getUnderlyingChannel() {
        return this.socketChannel;
    }

    public void setBufferSize(int n2) {
        this.bufferSize = n2;
    }

    void setUnderlyingChannel(SocketChannel socketChannel) {
        this.socketChannel = socketChannel;
    }

    void setSoTimeout(int n2) {
        if (!(this.socketChannel instanceof SocketChannelWrapper)) {
            throw new UnsupportedOperationException();
        }
        ((SocketChannelWrapper)this.socketChannel).setSoTimeout(n2);
    }

    int getSoTimeout() {
        if (this.socketChannel instanceof SocketChannelWrapper) {
            return ((SocketChannelWrapper)this.socketChannel).getSoTimeout();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T getOption(SocketOption<T> socketOption) throws IOException {
        if (this.socketChannel != null) {
            return this.socketChannel.getOption(socketOption);
        }
        throw new IllegalStateException("Socket is closed.");
    }

    @Override
    public Set<SocketOption<?>> supportedOptions() {
        if (this.socketChannel != null) {
            return this.socketChannel.supportedOptions();
        }
        throw new IllegalStateException("Socket is closed.");
    }

    @Override
    public SocketChannel bind(SocketAddress socketAddress) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> SocketChannel setOption(SocketOption<T> socketOption, T t2) throws IOException {
        if (this.socketChannel != null) {
            return this.socketChannel.setOption((SocketOption)socketOption, (Object)t2);
        }
        throw new IllegalStateException("Socket is closed.");
    }

    @Override
    public SocketChannel shutdownInput() throws IOException {
        if (this.socketChannel != null) {
            return this.socketChannel.shutdownInput();
        }
        throw new IllegalStateException("Socket is closed.");
    }

    @Override
    public SocketChannel shutdownOutput() throws IOException {
        if (this.socketChannel != null) {
            return this.socketChannel.shutdownOutput();
        }
        throw new IllegalStateException("Socket is closed.");
    }

    @Override
    public Socket socket() {
        if (this.socketChannel != null) {
            return this.socketChannel.socket();
        }
        throw new IllegalStateException("Socket is closed.");
    }

    @Override
    public boolean isConnected() {
        return this.socketChannel != null && this.socketChannel.isConnected();
    }

    @Override
    public boolean isConnectionPending() {
        if (this.socketChannel != null) {
            return this.socketChannel.isConnectionPending();
        }
        throw new IllegalStateException("Socket is closed.");
    }

    @Override
    public boolean connect(SocketAddress socketAddress) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean finishConnect() throws IOException {
        if (this.socketChannel != null) {
            return this.socketChannel.finishConnect();
        }
        throw new IllegalStateException("Socket is closed.");
    }

    @Override
    public SocketAddress getRemoteAddress() throws IOException {
        if (this.socketChannel != null) {
            return this.socketChannel.getRemoteAddress();
        }
        throw new IllegalStateException("Socket is closed.");
    }

    @Override
    public long read(ByteBuffer[] byteBufferArray, int n2, int n3) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long write(ByteBuffer[] byteBufferArray, int n2, int n3) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SocketAddress getLocalAddress() throws IOException {
        if (this.socketChannel != null) {
            return this.socketChannel.getLocalAddress();
        }
        throw new IllegalStateException("Socket is closed.");
    }

    @Override
    protected void implCloseSelectableChannel() throws IOException {
        if (this.socketChannel == null) {
            throw new IllegalStateException("Socket is closed.");
        }
        this.socketChannel.close();
    }

    @Override
    protected void implConfigureBlocking(boolean bl) throws IOException {
        if (this.socketChannel == null) {
            throw new IllegalStateException("Socket is closed.");
        }
        this.socketChannel.configureBlocking(bl);
    }
}

