/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.generic;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.Date;
import oracle.ide.Ide;
import oracle.ide.controls.WaitCursor;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IdeUtil;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.algorithm.directory.DirectoryCompareContributor;
import oracle.javatools.compare.algorithm.directory.DirectoryList;
import oracle.javatools.history.HistoryProperty;
import oracle.jdeveloper.compare.BinaryCompareContributor;
import oracle.jdeveloper.compare.InputStreamTextContributor;
import oracle.jdeveloper.compare.PatchCompareDescriptor;
import oracle.jdeveloper.history.RevisionIdentifier;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;

public abstract class VCSHistoryEntry
extends oracle.jdeveloper.vcs.spi.VCSHistoryEntry {
    protected VCSProfile _profile;
    protected URL _url;
    protected SoftReference _compareRef;

    public VCSHistoryEntry(URL url, VCSProfile profile) {
        this._profile = profile;
        this._url = url;
    }

    protected void setValue(String propertyId, Object value) {
        HistoryProperty property = this._profile.getHistoryProperty(propertyId);
        if (property != null) {
            this.setValue(property, value);
        }
    }

    protected Object getValue(String propertyId) {
        return this.getValue(this._profile.getHistoryProperty(propertyId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompareContributor getCompareContributor() throws Exception {
        if (this._compareRef == null || this._compareRef.get() == null) {
            Date date = (Date)this.getValue("oracle.jdeveloper.vcs.history.DATE");
            RevisionIdentifier revision = (RevisionIdentifier)this.getValue("oracle.jdeveloper.vcs.history.REVISION");
            WaitCursor waitCursor = Ide.getWaitCursor();
            waitCursor.show(1000);
            try {
                PatchCompareDescriptor patchDescriptor = this.createPatchDescriptor(this._url, revision, date);
                CompareContributor contrib = this.createCompareContributor(this._url, revision, patchDescriptor);
                this._compareRef = new SoftReference<CompareContributor>(contrib);
            }
            catch (UnsupportedOperationException uoe) {
                CompareContributor compareContributor = null;
                return compareContributor;
            }
            finally {
                waitCursor.hide();
            }
        }
        return (CompareContributor)this._compareRef.get();
    }

    protected CompareContributor createCompareContributor(URL sourceUrl, RevisionIdentifier revision, PatchCompareDescriptor patchDescriptor) throws Exception {
        if (!URLFileSystem.isDirectoryPath((URL)sourceUrl)) {
            CompareContributor contrib = this.createCompareContributor(sourceUrl, revision);
            if (contrib != null && contrib instanceof InputStreamTextContributor && patchDescriptor != null) {
                ((InputStreamTextContributor)contrib).setPatchDescriptor(patchDescriptor);
            }
            return contrib;
        }
        String resourceName = this.getResourceName(sourceUrl, revision);
        DirectoryCompareContributor contrib = this.createDirectoryCompareContributor(this.listDirectory(sourceUrl, revision), resourceName, resourceName);
        this.configureCompareContributor((CompareContributor)contrib, sourceUrl, revision);
        return contrib;
    }

    protected DirectoryList listDirectory(URL directoryUrl, RevisionIdentifier revision) throws Exception, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    protected CompareContributor createCompareContributor(URL sourceUrl, RevisionIdentifier revision) throws Exception {
        String resourceName = this.getResourceName(sourceUrl, revision);
        BinaryCompareContributor contributor = null;
        if (VCSFileSystemUtils.isContentTypeBinary(sourceUrl)) {
            contributor = this.createBinaryCompareContributor(this.getContent(sourceUrl, revision), URLFileSystem.getFileName((URL)sourceUrl), resourceName, resourceName);
        } else {
            try {
                contributor = this.createInputStreamTextContributor(this.getContent(sourceUrl, revision), this.getEncoding(sourceUrl, revision), resourceName, resourceName, URLFileSystem.getSuffix((URL)sourceUrl));
            }
            catch (IOException ioe) {
                FeedbackManager.reportException((Throwable)ioe);
            }
        }
        if (contributor != null) {
            this.configureCompareContributor((CompareContributor)contributor, sourceUrl, revision);
        }
        return contributor;
    }

    private final BinaryCompareContributor createBinaryCompareContributor(InputStream in, String filename, String shortLabel, String longLabel) {
        return new BinaryCompareContributor(in, filename, shortLabel, longLabel);
    }

    private final InputStreamTextContributor createInputStreamTextContributor(InputStream inStream, String defaultEncoding, String shortLabel, String longLabel, String type) throws IOException {
        return new InputStreamTextContributor(inStream, defaultEncoding, shortLabel, longLabel, type);
    }

    private final DirectoryCompareContributor createDirectoryCompareContributor(DirectoryList directoryList, String shortLabel, String longLabel) {
        DirectoryCompareContributor directoryContributor = new DirectoryCompareContributor(){};
        directoryContributor.setDirectoryList(directoryList);
        directoryContributor.setShortLabel(shortLabel);
        directoryContributor.setLongLabel(longLabel);
        return directoryContributor;
    }

    protected void configureCompareContributor(CompareContributor contributor, URL url, RevisionIdentifier rev) {
    }

    protected String getResourceName(URL url, RevisionIdentifier rev) {
        return URLFileSystem.getPlatformPathName((URL)url);
    }

    protected String getEncoding(URL url, RevisionIdentifier rev) throws Exception {
        return IdeUtil.getIdeEncoding();
    }

    protected abstract InputStream getContent(URL var1, RevisionIdentifier var2) throws Exception;

    protected PatchCompareDescriptor createPatchDescriptor(URL sourceUrl, RevisionIdentifier revision, Date date) throws Exception {
        PatchCompareDescriptor pcd = new PatchCompareDescriptor(URLFileSystem.getFileName((URL)sourceUrl));
        pcd.setPatchParentURL(URLFileSystem.getParent((URL)sourceUrl));
        if (date != null) {
            pcd.setLastModified(date.getTime());
        }
        if (revision != null) {
            pcd.setRevision(revision.getLabel());
        }
        return pcd;
    }
}

