/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.historygraph;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;

class DrawConnector {
    private Point[] _pts;
    private int _column;
    private Color _color;
    private Shape _arrow;

    DrawConnector(Point[] pts, int column) {
        this._pts = pts;
        this._column = column;
        if (pts[0].x != pts[pts.length - 1].x) {
            this._arrow = this.createArrowShape(this._pts[this._pts.length - 2], this._pts[this._pts.length - 1]);
        }
    }

    int getColumn() {
        return this._column;
    }

    void paint(Graphics2D gd) {
        gd.setColor(this._color);
        for (int p = 1; p < this._pts.length; ++p) {
            gd.drawLine(this._pts[p - 1].x, this._pts[p - 1].y, this._pts[p].x, this._pts[p].y);
        }
        if (this._arrow != null) {
            gd.fill(this._arrow);
            gd.draw(this._arrow);
        }
    }

    void setColor(Color color) {
        this._color = color;
    }

    private Shape createArrowShape(Point prv, Point tip) {
        Polygon arrowPolygon = new Polygon();
        arrowPolygon.addPoint(tip.x, tip.y);
        arrowPolygon.addPoint(tip.x + 4, tip.y + 4);
        arrowPolygon.addPoint(tip.x - 4, tip.y + 4);
        if (tip.x > prv.x) {
            AffineTransform transform = new AffineTransform();
            transform.rotate(1.5707963267948966, tip.x, tip.y);
            return transform.createTransformedShape(arrowPolygon);
        }
        if (tip.x < prv.x) {
            AffineTransform transform = new AffineTransform();
            transform.rotate(4.71238898038469, tip.x, tip.y);
            return transform.createTransformedShape(arrowPolygon);
        }
        return arrowPolygon;
    }
}

