/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import java.text.MessageFormat;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.IdentityColumnProperties;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.AbstractIncrementerValidator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;

public class IdentityColumnPropertiesValidator
extends AbstractIncrementerValidator<IdentityColumnProperties> {
    public IdentityColumnPropertiesValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    @DBObjectValidator.PropertyValidator(value={"generated"}, level=ValidationLevel.FULL)
    public void validateGenerated(IdentityColumnProperties identityColumnProperties, IdentityColumnProperties identityColumnProperties2) throws ValidationException {
        if (identityColumnProperties2.getGenerated() == null && identityColumnProperties2.getParent() != null) {
            throw new ValidationException((DBObject)identityColumnProperties2, MessageFormat.format(APIBundle.get((String)"IDENTITY_COL_PROPS_GENERATED_NULL_ERROR"), identityColumnProperties2.getParent().getName()));
        }
    }

    @Override
    @DBObjectValidator.PropertyValidator(value={"incrementBy"}, level=ValidationLevel.FULL)
    @DBObjectValidator.PropertyDependency(value={"minValue", "maxValue"})
    public void validateIncrement(IdentityColumnProperties identityColumnProperties, IdentityColumnProperties identityColumnProperties2) throws ValidationException {
        super.validateIncrement(identityColumnProperties, identityColumnProperties2);
    }

    @Override
    @DBObjectValidator.PropertyValidator(value={"startWith"}, level=ValidationLevel.FULL)
    @DBObjectValidator.PropertyDependency(value={"minValue", "maxValue"})
    public void validateStartWith(IdentityColumnProperties identityColumnProperties, IdentityColumnProperties identityColumnProperties2) throws ValidationException {
        super.validateStartWith(identityColumnProperties, identityColumnProperties2);
    }

    @Override
    @DBObjectValidator.PropertyValidator(value={"minValue"}, level=ValidationLevel.FULL)
    @DBObjectValidator.PropertyDependency(value={"startWith", "maxValue"})
    public void validateMinValue(IdentityColumnProperties identityColumnProperties, IdentityColumnProperties identityColumnProperties2) throws ValidationException {
        super.validateMinValue(identityColumnProperties, identityColumnProperties2);
    }

    @Override
    @DBObjectValidator.PropertyValidator(value={"maxValue"}, level=ValidationLevel.FULL)
    @DBObjectValidator.PropertyDependency(value={"minValue", "startWith", "incrementBy", "cycleFlag"})
    public void validateMaxValue(IdentityColumnProperties identityColumnProperties, IdentityColumnProperties identityColumnProperties2) throws ValidationException {
        super.validateMaxValue(identityColumnProperties, identityColumnProperties2);
    }

    @Override
    @DBObjectValidator.PropertyValidator(value={"cacheFlag", "cacheSize"}, level=ValidationLevel.FULL)
    @DBObjectValidator.PropertyDependency(value={"minValue", "maxValue", "startWith", "incrementBy"})
    public void validateCache(IdentityColumnProperties identityColumnProperties, IdentityColumnProperties identityColumnProperties2) throws ValidationException {
        super.validateCache(identityColumnProperties, identityColumnProperties2);
    }

    public DBObjectValidator.NamespaceType getNamespaceType() {
        return super.getNamespaceType();
    }

    protected boolean canHaveEmptyName() {
        return true;
    }
}

