/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import java.util.Collection;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Sequence;
import oracle.javatools.db.validators.AbstractIncrementerValidator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.SchemaObjectValidator;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;

public class SequenceValidator
extends SchemaObjectValidator<Sequence> {
    private final AbstractIncrementerValidator<Sequence> m_delegate;

    public SequenceValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
        this.m_delegate = new AbstractIncrementerValidator(dBObjectProvider);
    }

    protected Collection<String> listAlwaysValidProperties() {
        return this.m_delegate.listAlwaysValidProperties();
    }

    @DBObjectValidator.PropertyValidator(value={"incrementBy"}, level=ValidationLevel.FULL)
    @DBObjectValidator.PropertyDependency(value={"minValue", "maxValue"})
    public void validateIncrement(Sequence sequence, Sequence sequence2) throws ValidationException {
        this.m_delegate.validateIncrement(sequence, sequence2);
    }

    @DBObjectValidator.PropertyValidator(value={"startWith"}, level=ValidationLevel.FULL)
    @DBObjectValidator.PropertyDependency(value={"minValue", "maxValue"})
    public void validateStartWith(Sequence sequence, Sequence sequence2) throws ValidationException {
        this.m_delegate.validateStartWith(sequence, sequence2);
    }

    @DBObjectValidator.PropertyValidator(value={"minValue"}, level=ValidationLevel.FULL)
    @DBObjectValidator.PropertyDependency(value={"startWith", "maxValue"})
    public void validateMinValue(Sequence sequence, Sequence sequence2) throws ValidationException {
        this.m_delegate.validateMinValue(sequence, sequence2);
    }

    @DBObjectValidator.PropertyValidator(value={"maxValue"}, level=ValidationLevel.FULL)
    @DBObjectValidator.PropertyDependency(value={"minValue", "startWith", "incrementBy", "cycleFlag"})
    public void validateMaxValue(Sequence sequence, Sequence sequence2) throws ValidationException {
        this.m_delegate.validateMaxValue(sequence, sequence2);
    }

    @DBObjectValidator.PropertyValidator(value={"cacheFlag", "cacheSize"}, level=ValidationLevel.FULL)
    @DBObjectValidator.PropertyDependency(value={"minValue", "maxValue", "startWith", "incrementBy"})
    public void validateCache(Sequence sequence, Sequence sequence2) throws ValidationException {
        this.m_delegate.validateCache(sequence, sequence2);
    }

    public DBObjectValidator.NamespaceType getNamespaceType() {
        return DBObjectValidator.NamespaceType.SCHEMA;
    }
}

