/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Properties;
import oracle.dbtools.plusplus.connections.db.MessageLogger;
import oracle.dbtools.plusplus.connections.db.storage.NamedConnectionDefinition;
import oracle.dbtools.raptor.newscriptrunner.ConnectionDetails;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.security.pki.OracleSecretStore;
import oracle.security.pki.OracleSecretStoreException;
import oracle.security.pki.OracleWallet;

abstract class ConnectionDefinitionCreator {
    protected final ScriptRunnerContext ctx;
    protected final MessageLogger logger;
    protected final Properties dbtoolProperties = new Properties();
    private final Properties ojdbcProperties = new Properties();
    protected String connectionName;
    protected OracleWallet wallet;

    public ConnectionDefinitionCreator(ScriptRunnerContext ctx, MessageLogger logger) {
        this.ctx = ctx;
        this.logger = logger;
    }

    protected OracleWallet createWallet(String spec, String user, char[] pwd) throws IOException {
        OracleWallet wallet = new OracleWallet();
        wallet.createSSO();
        try {
            OracleSecretStore oss = wallet.getSecretStore();
            int i = 1;
            oss.setSecret("oracle.security.client.connect_string" + i, spec.toCharArray());
            oss.setSecret("oracle.security.client.username" + i, user.toCharArray());
            oss.setSecret("oracle.security.client.password" + i, pwd);
            wallet.setSecretStore(oss);
        }
        catch (OracleSecretStoreException e) {
            throw new IOException(e);
        }
        return wallet;
    }

    protected char[] promptForPassword(String spec, String user) {
        char[] pwd = new char[]{};
        ConnectionDetails cd = new ConnectionDetails(spec, false, user, null, spec, null, false, -1, -1, null);
        cd.setConnectDB(MessageFormat.format("jdbc:oracle:{0}:@//{1}", "thin", spec));
        ConnectionDetails updatedDetails = this.ctx.getConnectFieldsProvider().get3Fields(this.ctx, cd, false);
        if (updatedDetails != null) {
            String connPwd = updatedDetails.getConnectPassword();
            pwd = connPwd.toCharArray();
        }
        return pwd;
    }

    protected final void setDbToolsPropertyValue(String key, String value) {
        this.dbtoolProperties.setProperty(key, value);
    }

    protected final void setOjdbcPropertyValue(String key, String value) {
        this.ojdbcProperties.setProperty(key, value);
    }

    public final NamedConnectionDefinition createDefinition() {
        NamedConnectionDefinition.Builder builder = NamedConnectionDefinition.builder(this.connectionName);
        if (!this.dbtoolProperties.isEmpty()) {
            builder = builder.dbtoolsProperties(this.dbtoolProperties);
        }
        if (!this.ojdbcProperties.isEmpty()) {
            builder = builder.ojdbcProperties(this.ojdbcProperties);
        }
        if (this.wallet != null) {
            try {
                builder = builder.wallet(this.wallet);
            }
            catch (IOException e) {
                this.logger.logError("Wallet error", e);
            }
        }
        return builder.build();
    }
}

