/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db;

import java.io.IOException;
import java.util.Objects;
import java.util.ServiceLoader;
import oracle.dbtools.plusplus.connections.db.ConnectionStoreResources;
import oracle.dbtools.plusplus.connections.db.MessageLogger;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.PropertyValues;

interface ConnectionSaverFactory {
    public static final ServiceLoader<ConnectionSaverFactory> LOADER = ServiceLoader.load(ConnectionSaverFactory.class);

    public String getConnectorType();

    public ConnectionSaver createConnectionSaver(ScriptRunnerContext var1, MessageLogger var2);

    public static ConnectionSaver finderSaver(String specType, ScriptRunnerContext ctx, MessageLogger logger) {
        ConnectionSaver saver = null;
        for (ConnectionSaverFactory factory : LOADER) {
            if (!Objects.equals(specType, factory.getConnectorType())) continue;
            try {
                saver = factory.createConnectionSaver(ctx, logger);
            }
            catch (Exception ex) {
                logger.logError("error creating saver factory", ex);
            }
            break;
        }
        if (saver == null) {
            saver = (connName, properties, user, skipPwd) -> {
                logger.logUserMessage(ConnectionStoreResources.format("ERROR_UNSUPPORTED_CONNECTOR", specType));
                return false;
            };
        }
        return saver;
    }

    public static interface ConnectionSaver {
        public boolean saveConnection(String var1, PropertyValues var2, String var3, boolean var4) throws IOException;
    }
}

