/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.connections.api.Connections;
import oracle.dbtools.db.ConnectionDetails;
import oracle.dbtools.db.ConnectionStoreBridge;
import oracle.dbtools.plusplus.connections.db.ConnectionIdentifiers;
import oracle.dbtools.plusplus.connections.db.DatabaseConnection;
import oracle.dbtools.plusplus.connections.db.ImplicitConnection;
import oracle.dbtools.plusplus.connections.db.storage.ConnectionStorage;
import oracle.dbtools.plusplus.connections.db.storage.NamedConnectionDefinition;
import oracle.dbtools.plusplus.connections.db.storage.StoreException;

class NamedConnections {
    private static final ConnectionStoreBridge BRIDGE = new ConnectionStoreBridge(){

        @Override
        public void addConnection(ConnectionDetails cd) {
            NamedConnections.instance().addConnectionImpl(cd);
        }

        @Override
        public boolean removeConnection(String name) {
            return NamedConnections.instance().removeConnectionImpl(name);
        }
    };
    private final Map<Connections.Identifier, NamedConnectionDefinition> connectionDefinitions = new HashMap<Connections.Identifier, NamedConnectionDefinition>();
    private final Map<String, Connections.Identifier> names = new HashMap<String, Connections.Identifier>();
    private final Map<String, DatabaseConnection> openConnections = new HashMap<String, DatabaseConnection>();

    static ConnectionStoreBridge connectionStoreBridge() {
        return BRIDGE;
    }

    static NamedConnections instance() {
        return Holder.INSTANCE;
    }

    private NamedConnections() {
        this.loadConnections();
    }

    private void loadConnections() {
        ConnectionStorage fileSystem = ConnectionStorage.instance();
        fileSystem.listConnections().forEach(id -> this.loadConnection((String)id, fileSystem));
    }

    private void loadConnection(String identifier, ConnectionStorage fileSystem) {
        Connections.Identifier ci = ConnectionIdentifiers.createIdentifier(identifier);
        NamedConnectionDefinition def = fileSystem.loadConnection(identifier);
        this.connectionDefinitions.put(ci, def);
        String connName = def.getConnectionName();
        this.names.put(connName, ci);
    }

    public List<String> listConnections() {
        return new ArrayList<String>(this.names.keySet());
    }

    public Connections.Identifier lookupConnectionIdentifier(String name) {
        return this.names.get(name);
    }

    public NamedConnectionDefinition getConnectionDefinition(Connections.Identifier id) {
        return this.connectionDefinitions.get(id);
    }

    void refreshConnections() {
        this.connectionDefinitions.clear();
        this.loadConnections();
    }

    void addConnection(NamedConnectionDefinition definition) throws StoreException {
        String id = definition.getIdentifier();
        String name = definition.getConnectionName();
        Connections.Identifier ci = ConnectionIdentifiers.createIdentifier(id);
        ConnectionStorage store = ConnectionStorage.instance();
        store.storeDefinition(definition);
        this.refreshConnections();
    }

    private void addConnectionImpl(ConnectionDetails cd) {
        ImplicitConnection dbconn = new ImplicitConnection(cd);
        String name = dbconn.getName();
        if (this.openConnections.containsKey(name)) {
            this.openConnections.remove(name);
        }
        this.openConnections.put(name, dbconn);
    }

    private boolean removeConnectionImpl(String name) {
        return name.startsWith("\"") && this.openConnections.remove(name) != null;
    }

    DatabaseConnection findOpenConnection(String name) {
        return this.openConnections.get(name);
    }

    DatabaseConnection findOpenConnection(Connection conn) {
        Map.Entry entry = this.openConnections.entrySet().stream().filter(e -> ((DatabaseConnection)e.getValue()).matchConnection(conn)).findFirst().orElse(null);
        return entry != null ? (DatabaseConnection)entry.getValue() : null;
    }

    private static class Holder {
        private static final NamedConnections INSTANCE = new NamedConnections();

        private Holder() {
        }
    }
}

