/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands;

import java.sql.Connection;
import oracle.dbtools.raptor.console.StatusBarComponent;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.AForAllStmtsCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;
import oracle.jdbc.OracleConnection;
import org.jline.utils.AttributedString;

@Restricted(level=Restricted.Level.R4)
public class ShowEncoding
extends AForAllStmtsCommand
implements IShowCommand,
StatusBarComponent {
    private static final String[] SHOWENCODING = new String[]{"encoding"};

    public ShowEncoding() {
        super(SQLCommand.StmtSubType.G_S_FORALLSTMTS_STMTSUBTYPE);
    }

    @Override
    public String[] getShowAliases() {
        return SHOWENCODING;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.getCurrentConnection() == null || ctx.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowEncoding(conn, ctx, cmd);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }

    private boolean doShowEncoding(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        try {
            if (ctx.getEncoding() != null) {
                ctx.write("encoding \"" + ctx.getEncoding() + "\"\n");
            } else {
                ctx.write("encoding \"\" \n");
            }
        }
        catch (Exception e) {
            ctx.write(e.getLocalizedMessage());
        }
        return true;
    }

    @Override
    public String getName() {
        return SHOWENCODING[0];
    }

    @Override
    public String getDescription() {
        return "Displays the local encoding set.";
    }

    @Override
    public void update(StatusBarComponent.Context context) {
        context.append(new AttributedString((CharSequence)context.getScriptRunnerContext().getEncoding()));
    }
}

