/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.ocsp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import oracle.security.crypto.asn1.ASN1BitString;
import oracle.security.crypto.asn1.ASN1ConstructedInputStream;
import oracle.security.crypto.asn1.ASN1Date;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.X500Name;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.cert.X509ExtensionSet;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AuthenticationException;
import oracle.security.crypto.ocsp.OCSP;
import oracle.security.crypto.ocsp.OCSPUtils;
import oracle.security.crypto.ocsp.ResponseInfo;
import oracle.security.crypto.ocsp.SingleBasicResponse;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VersionException;

public class BasicOCSPResponse
extends ResponseInfo {
    private static final ASN1ObjectID respType = OCSP.id_pkix_ocsp_basic;
    private int version = 0;
    private X500Principal responder = null;
    private byte[] keyHash = null;
    private Date producedAt;
    private Vector respList = new Vector();
    private X509ExtensionSet respExts = null;
    private AlgorithmIdentifier sigAlgID;
    private byte[] sigBytes;
    private Vector sigCerts = null;
    private Vector X509sigCerts = null;
    private ASN1Sequence tbs;
    private ASN1Sequence bas;

    public BasicOCSPResponse(X500Principal responder) {
        this.responder = responder;
    }

    public BasicOCSPResponse(PublicKey respKey) throws NoSuchAlgorithmException {
        MessageDigest sha = MessageDigest.getInstance("SHA-1");
        this.keyHash = sha.digest(respKey.getEncoded());
    }

    public BasicOCSPResponse(InputStream is) throws IOException {
        this.input(is);
    }

    @Override
    public ASN1ObjectID getResponseType() {
        return respType;
    }

    public X500Principal getResponder() {
        return this.responder;
    }

    public byte[] getResponderKeyHash() {
        return this.keyHash;
    }

    public Date getProducedAt() {
        return this.producedAt;
    }

    public Enumeration responses() {
        return this.respList.elements();
    }

    public void addResponse(SingleBasicResponse response) {
        this.respList.addElement(response);
        this.reset();
    }

    public void addRespExtension(X509Extension ext) {
        if (this.respExts == null) {
            this.respExts = new X509ExtensionSet();
        }
        this.respExts.addExtension(ext);
        this.reset();
    }

    public void setRespExtensions(X509ExtensionSet extensionSet) {
        this.respExts = extensionSet;
        this.reset();
    }

    public X509Extension getRespExtension(ASN1ObjectID type) {
        if (this.respExts != null) {
            return this.respExts.getExtension(type);
        }
        return null;
    }

    public X509ExtensionSet getRespExtensions() {
        return this.respExts;
    }

    public void sign(PrivateKey signingKey) throws SignatureException {
        this.producedAt = new Date();
        try {
            String alg = signingKey.getAlgorithm();
            if (alg.equals("RSA")) {
                alg = "SHA1withRSA";
            } else if (alg.equals("DSA")) {
                alg = "SHA1withDSA";
            }
            Signature sig = Signature.getInstance(alg);
            sig.initSign(signingKey);
            sig.update(Utils.toBytes((Streamable)this.tbsResponse()));
            this.sigAlgID = OCSPUtils.getAlgoID(sig.getAlgorithm());
            this.sigBytes = sig.sign();
        }
        catch (InvalidKeyException ex) {
            throw new SignatureException(ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new SignatureException(ex);
        }
        this.resetContents();
    }

    public void sign(PrivateKey signingKey, AlgorithmIdentifier sigAlgID) throws SignatureException {
        this.producedAt = new Date();
        try {
            Signature sig = Signature.getInstance(OCSPUtils.getAlgoName(sigAlgID));
            sig.initSign(signingKey);
            sig.update(Utils.toBytes((Streamable)this.tbsResponse()));
            this.sigAlgID = OCSPUtils.getAlgoID(sig.getAlgorithm());
            this.sigBytes = sig.sign();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new SignatureException(ex.toString());
        }
        catch (InvalidKeyException ex) {
            throw new SignatureException(ex.toString());
        }
        this.resetContents();
    }

    public void addSigVerifyCert(X509Certificate cert) throws CertificateEncodingException {
        if (this.sigCerts == null) {
            this.sigCerts = new Vector();
            this.X509sigCerts = new Vector();
        }
        this.sigCerts.addElement(cert);
        this.X509sigCerts.addElement(OCSPUtils.convertX509(cert));
    }

    public Vector getSigVerifyCerts() {
        return this.sigCerts;
    }

    public AlgorithmIdentifier getSigAlgID() {
        return this.sigAlgID;
    }

    public byte[] getSigBytes() {
        return this.sigBytes;
    }

    public boolean verifySignature(PublicKey verifyKey) throws AuthenticationException {
        try {
            Signature signature = Signature.getInstance(OCSPUtils.getAlgoName(this.sigAlgID));
            signature.initVerify(verifyKey);
            signature.update(Utils.toBytes((Streamable)this.tbsResponse()));
            return signature.verify(this.sigBytes);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (InvalidKeyException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (SignatureException ex) {
            throw new AuthenticationException(ex.toString());
        }
    }

    public void input(InputStream is) throws IOException {
        try {
            this.reset();
            ASN1SequenceInputStream seq = new ASN1SequenceInputStream(is);
            this.inputTbsResponse((InputStream)seq);
            this.sigAlgID = new AlgorithmIdentifier((InputStream)seq);
            this.sigBytes = ASN1BitString.inputValue((InputStream)seq);
            if (seq.hasMoreData()) {
                ASN1ConstructedInputStream cis = new ASN1ConstructedInputStream((InputStream)seq, 0);
                ASN1SequenceInputStream certs = new ASN1SequenceInputStream((InputStream)cis);
                this.sigCerts = new Vector();
                this.X509sigCerts = new Vector();
                try {
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    while (certs.hasMoreData()) {
                        X509 X509Cert = new X509((InputStream)certs);
                        this.sigCerts.addElement(cf.generateCertificate(new ByteArrayInputStream(X509Cert.getEncoded())));
                        this.X509sigCerts.addElement(X509Cert);
                    }
                }
                catch (CertificateEncodingException ex) {
                    throw new IOException(ex.toString());
                }
                catch (CertificateException ex) {
                    throw new IOException(ex.toString());
                }
                certs.terminate();
                cis.terminate();
            } else {
                this.sigCerts = null;
                this.X509sigCerts = null;
            }
            seq.terminate();
        }
        catch (ClassCastException ex) {
            throw new ASN1FormatException(ex.toString());
        }
        catch (IndexOutOfBoundsException ex) {
            throw new ASN1FormatException(ex.toString());
        }
    }

    private void inputTbsResponse(InputStream is) throws IOException {
        try {
            ASN1ConstructedInputStream cis;
            this.reset();
            ASN1SequenceInputStream seq = new ASN1SequenceInputStream(is);
            if (seq.getCurrentTag() == 0) {
                cis = new ASN1ConstructedInputStream((InputStream)seq, 0);
                this.version = ASN1Integer.inputValue((InputStream)cis).intValue();
                if (this.version != 0) {
                    throw new VersionException("Invalid version number");
                }
                cis.terminate();
            }
            if (seq.getCurrentTag() == 1) {
                cis = new ASN1ConstructedInputStream((InputStream)seq, 1);
                this.responder = new X500Principal(new X500Name((InputStream)cis).toString());
                cis.terminate();
                this.keyHash = null;
            } else if (seq.getCurrentTag() == 2) {
                cis = new ASN1ConstructedInputStream((InputStream)seq, 2);
                this.keyHash = ASN1OctetString.inputValue((InputStream)cis);
                cis.terminate();
                this.responder = null;
            }
            this.producedAt = ASN1Date.inputValue((InputStream)seq);
            ASN1SequenceInputStream respSeq = new ASN1SequenceInputStream((InputStream)seq);
            this.respList = new Vector();
            while (respSeq.hasMoreData()) {
                this.respList.addElement(new SingleBasicResponse((InputStream)respSeq));
            }
            respSeq.terminate();
            if (seq.getCurrentTag() == 1) {
                ASN1ConstructedInputStream cis2 = new ASN1ConstructedInputStream((InputStream)seq, 1);
                this.respExts = new X509ExtensionSet((InputStream)cis2);
                cis2.terminate();
            } else {
                this.respExts = null;
            }
            seq.terminate();
        }
        catch (ClassCastException ex) {
            throw new ASN1FormatException(ex.toString());
        }
        catch (IndexOutOfBoundsException ex) {
            throw new ASN1FormatException(ex.toString());
        }
    }

    private ASN1Sequence tbsResponse() {
        if (this.tbs != null) {
            return this.tbs;
        }
        this.tbs = new ASN1Sequence();
        if (this.version != 0) {
            this.tbs.addElement((ASN1Object)new ASN1Integer((long)this.version));
        }
        if (this.responder != null && this.keyHash == null) {
            this.tbs.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)new X500Name(OCSPUtils.formatX500Name(this.responder)), 1));
        } else if (this.keyHash != null && this.responder == null) {
            this.tbs.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)new ASN1OctetString(this.keyHash), 2));
        } else {
            throw new IllegalStateException("Both responder name and public key hash may not be present");
        }
        this.tbs.addElement((ASN1Object)new ASN1Date(this.producedAt, true));
        ASN1Sequence list = new ASN1Sequence();
        Enumeration e = this.respList.elements();
        while (e.hasMoreElements()) {
            list.addElement((ASN1Object)((SingleBasicResponse)e.nextElement()));
        }
        this.tbs.addElement((ASN1Object)list);
        if (this.respExts != null) {
            this.tbs.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)this.respExts, 1));
        }
        return this.tbs;
    }

    private ASN1Sequence toASN1Sequence() {
        if (this.bas != null) {
            return this.bas;
        }
        if (this.sigBytes == null) {
            throw new IllegalStateException("OCSP response must be signed");
        }
        this.bas = new ASN1Sequence();
        this.bas.addElement((ASN1Object)this.tbsResponse());
        this.bas.addElement((ASN1Object)this.sigAlgID);
        this.bas.addElement((ASN1Object)new ASN1BitString(this.sigBytes));
        if (this.sigCerts != null && this.sigCerts.size() > 0) {
            ASN1Sequence certs = new ASN1Sequence();
            Enumeration e = this.X509sigCerts.elements();
            while (e.hasMoreElements()) {
                certs.addElement((ASN1Object)((X509)e.nextElement()));
            }
            this.bas.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)certs, 0));
        }
        return this.bas;
    }

    public void output(OutputStream os) throws IOException {
        this.toASN1Sequence().output(os);
    }

    public int length() {
        return this.toASN1Sequence().length();
    }

    private void reset() {
        this.tbs = null;
        this.resetContents();
    }

    private void resetContents() {
        this.bas = null;
    }

    public String toString() {
        StringBuffer s = new StringBuffer("Basic OCSP Response: ");
        Enumeration e = this.respList.elements();
        while (e.hasMoreElements()) {
            s.append(e.nextElement());
            s.append("; ");
        }
        if (this.responder != null) {
            s.append("responder = " + this.responder + ";");
        } else {
            s.append("key hash = " + Utils.toHexString((byte[])this.keyHash));
        }
        s.append("produced at = " + this.producedAt + ";");
        if (this.respExts != null) {
            s.append("basic response extensions = " + this.respExts);
        }
        return s.toString();
    }
}

