/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.customizer.swing;

import ilog.views.customizer.swing.IlvNumberEditor;
import ilog.views.customizer.swing.IlvSwingCustomizerControl;
import ilog.views.util.IlvLocaleUtil;
import ilog.views.util.IlvResourceUtil;
import ilog.views.util.beans.editor.IlvColorPropertyEditor;
import ilog.views.util.psheet.CustomPropertyEditor;
import ilog.views.util.swing.IlvJComboBox;
import ilog.views.util.swing.SwingFactories;
import ilog.views.util.swing.border.IlvEtchedLineBorder;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class IlvBorderEditor
extends JPanel
implements IlvSwingCustomizerControl {
    protected JComboBox _borderBox;
    private JButton a;
    private SettingPanel b;
    private JDialog c;
    private Border d;
    private boolean e;
    private Map f = new HashMap();

    public IlvBorderEditor() {
        this(true);
    }

    private IlvBorderEditor(boolean bl) {
        this.setLayout(new BoxLayout(this, SwingFactories.getBoxLayoutLineAxis()));
        Object[] objectArray = this.initializeBorders(bl);
        this._borderBox = new IlvJComboBox(objectArray);
        this._borderBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (object != null) {
                    jLabel.setIcon((BorderImpl)object);
                    jLabel.setText(((BorderImpl)object).getLabel());
                }
                jLabel.setComponentOrientation(jList.getComponentOrientation());
                return jLabel;
            }
        });
        this._borderBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    IlvBorderEditor.this.borderSelected(((JComboBox)itemEvent.getSource()).getSelectedItem());
                }
            }
        });
        this.add(this._borderBox);
        this.add(Box.createHorizontalStrut(3));
        this.a = new JButton(this.a("BorderEditor.Configure"));
        this.a.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IlvBorderEditor.this.a();
            }
        });
        this.add(this.a);
    }

    protected BorderImpl[] initializeBorders(boolean bl) {
        BorderImpl[] borderImplArray = new BorderImpl[bl ? 8 : 6];
        int n = 0;
        if (bl) {
            int n2 = n++;
            borderImplArray[n2] = new BorderImpl(null, this.a("BorderEditor.None")){

                @Override
                public BorderSettingPanel createSettingPanel() {
                    return null;
                }

                @Override
                public boolean accept(Border border) {
                    return border == null;
                }
            };
        }
        int n3 = n++;
        borderImplArray[n3] = new BorderImpl(BorderFactory.createEtchedBorder(), this.a("BorderEditor.Etched")){

            @Override
            public BorderSettingPanel createSettingPanel() {
                return new EtchedSetting(true);
            }

            @Override
            public boolean accept(Border border) {
                return border.getClass() == EtchedBorder.class;
            }
        };
        int n4 = n++;
        borderImplArray[n4] = new BorderImpl(BorderFactory.createLineBorder(Color.black), this.a("BorderEditor.Line")){

            @Override
            public BorderSettingPanel createSettingPanel() {
                return new LineSetting();
            }

            @Override
            public boolean accept(Border border) {
                return border.getClass() == LineBorder.class;
            }
        };
        int n5 = n++;
        borderImplArray[n5] = new BorderImpl(BorderFactory.createRaisedBevelBorder(), this.a("BorderEditor.Bevel")){

            @Override
            public BorderSettingPanel createSettingPanel() {
                return new BevelSetting();
            }

            @Override
            public boolean accept(Border border) {
                return border.getClass() == BevelBorder.class;
            }
        };
        int n6 = n++;
        borderImplArray[n6] = new BorderImpl(BorderFactory.createTitledBorder(this.a("BorderEditor.TitledBorderTitle")), this.a("BorderEditor.Titled")){

            @Override
            public BorderSettingPanel createSettingPanel() {
                return new TitledSetting();
            }

            @Override
            public boolean accept(Border border) {
                return border.getClass() == TitledBorder.class;
            }
        };
        int n7 = n++;
        borderImplArray[n7] = new BorderImpl(BorderFactory.createMatteBorder(1, 5, 2, 1, Color.black), this.a("BorderEditor.Matte")){

            @Override
            public BorderSettingPanel createSettingPanel() {
                return new MatteSetting();
            }

            @Override
            public boolean accept(Border border) {
                return border.getClass() == MatteBorder.class;
            }
        };
        if (bl) {
            int n8 = n++;
            borderImplArray[n8] = new BorderImpl(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createLineBorder(Color.black)), this.a("BorderEditor.Compound")){

                @Override
                public BorderSettingPanel createSettingPanel() {
                    return new CompoundSetting();
                }

                @Override
                public boolean accept(Border border) {
                    return border.getClass() == CompoundBorder.class;
                }
            };
        }
        int n9 = n++;
        borderImplArray[n9] = new BorderImpl(BorderFactory.createEmptyBorder(), this.a("BorderEditor.Empty")){

            @Override
            public BorderSettingPanel createSettingPanel() {
                return new EmptySetting();
            }

            @Override
            public boolean accept(Border border) {
                return border.getClass() == EmptyBorder.class;
            }
        };
        return borderImplArray;
    }

    protected void borderSelected(Object object) {
        this.e = true;
        Border border = this.d;
        BorderSettingPanel borderSettingPanel = this.a((BorderImpl)object);
        this.a.setEnabled(borderSettingPanel != null && borderSettingPanel.isConfigurable());
        this.d = borderSettingPanel != null ? borderSettingPanel.createBorder() : null;
        if (border != this.d) {
            this.fireActionPerformed();
        }
        this.e = false;
    }

    private void a() {
        BorderSettingPanel borderSettingPanel;
        BorderImpl borderImpl = (BorderImpl)this._borderBox.getSelectedItem();
        if (this.c == null) {
            this.c();
        }
        if ((borderSettingPanel = this.a(borderImpl)) != null) {
            this.b.setPanel(borderSettingPanel);
            borderSettingPanel.setObject(this.d);
            this.c.setTitle(borderSettingPanel.getSettingTitle());
            JFrame jFrame = this.b();
            if (jFrame != null) {
                this.c.setLocationRelativeTo(jFrame);
            }
            this.c.pack();
            this.c.setVisible(true);
            if (this.b.isOk()) {
                Border border = this.d;
                this.d = borderSettingPanel.createBorder();
                borderImpl.setBorder(this.d);
                if (border != this.d) {
                    this.fireActionPerformed();
                }
            }
        }
    }

    private JFrame b() {
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof JFrame)) continue;
            return (JFrame)container;
        }
        return null;
    }

    private void c() {
        this.c = new JDialog(this.b(), "", true);
        this.b = new SettingPanel();
        this.c.getContentPane().add(this.b);
    }

    private BorderSettingPanel a(BorderImpl borderImpl) {
        Class<?> clazz;
        BorderSettingPanel borderSettingPanel = null;
        Border border = borderImpl.getBorder();
        if (border != null && (borderSettingPanel = (BorderSettingPanel)this.f.get(clazz = border.getClass())) == null) {
            borderSettingPanel = borderImpl.createSettingPanel();
            this.f.put(clazz, borderSettingPanel);
        }
        return borderSettingPanel;
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(ActionListener.class, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(ActionListener.class, actionListener);
    }

    public void fireActionPerformed() {
        Object[] objectArray = this.listenerList.getListenerList();
        ActionEvent actionEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ActionListener.class) continue;
            if (actionEvent == null) {
                actionEvent = new ActionEvent(this, 1001, "border");
            }
            ((ActionListener)objectArray[i + 1]).actionPerformed(actionEvent);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._borderBox.setEnabled(bl);
        this.a.setEnabled(bl);
    }

    @Override
    public Object getValue() {
        return this.d;
    }

    @Override
    public void setValue(Object object) {
        if (object != null && !(object instanceof Border)) {
            throw new IllegalArgumentException("Unexpected value type: " + object.getClass().getName() + " expected type: " + Border.class.getName());
        }
        if (this.e) {
            return;
        }
        this.d = (Border)object;
        if (object != null) {
            BorderImpl borderImpl;
            if (this.b == null) {
                this.c();
            }
            if ((borderImpl = this.a(this.d)) != null) {
                BorderSettingPanel borderSettingPanel = this.a(borderImpl);
                if (borderSettingPanel != null) {
                    borderSettingPanel.setObject(this.d);
                }
                borderImpl.setBorder(this.d);
                this._borderBox.setSelectedItem(borderImpl);
            } else {
                this._borderBox.setSelectedIndex(0);
            }
        } else {
            this._borderBox.setSelectedIndex(0);
            if (this.a != null) {
                this.a.setEnabled(false);
            }
        }
    }

    private BorderImpl a(Border border) {
        for (int i = 0; i < this._borderBox.getItemCount(); ++i) {
            BorderImpl borderImpl = (BorderImpl)this._borderBox.getItemAt(i);
            if (!borderImpl.accept(border)) continue;
            return borderImpl;
        }
        return null;
    }

    private String a(String string) {
        return IlvResourceUtil.getString(string, "bordereditor", IlvBorderEditor.class, IlvLocaleUtil.getCurrentLocale());
    }

    @Override
    public boolean isLabelPlacedBeforeControl() {
        return true;
    }

    protected static abstract class BorderImpl
    extends BorderIcon {
        private String a;

        public BorderImpl(Border border, String string) {
            this(border, string, new Dimension(25, 20));
        }

        public BorderImpl(Border border, String string, Dimension dimension) {
            super(border, dimension);
            this.a = string;
        }

        public String getLabel() {
            return this.a;
        }

        public abstract BorderSettingPanel createSettingPanel();

        public abstract boolean accept(Border var1);
    }

    private static class BorderIcon
    implements Icon {
        private Border a;
        private Dimension b;
        private JPanel c = new JPanel();

        public BorderIcon(Border border, Dimension dimension) {
            this.a = border;
            this.b = dimension;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.a == null) {
                return;
            }
            graphics.setColor(UIManager.getColor("Panel.background"));
            graphics.fillRect(n, n2, this.b.width, this.b.height);
            Rectangle rectangle = graphics.getClipBounds();
            graphics.setClip(n, n2, this.b.width, this.b.height);
            this.a.paintBorder(this.c, graphics, n, n2, this.b.width, this.b.height);
            graphics.setClip(rectangle);
        }

        @Override
        public final int getIconHeight() {
            return this.b.height;
        }

        @Override
        public final int getIconWidth() {
            return this.b.width;
        }

        public final void setBorder(Border border) {
            this.a = border;
        }

        public final Border getBorder() {
            return this.a;
        }
    }

    private class SettingPanel
    extends JPanel
    implements ActionListener,
    PropertyChangeListener {
        private static final String a = "_OK_CMD__";
        private static final String b = "_CANCEL_CMD__";
        private boolean c;
        private BorderSettingPanel d;
        private BorderIcon e;
        private JPanel f;

        public SettingPanel() {
            double[][] dArrayArray = new double[][]{{2.0, -1.0, 3.0, -1.0, 2.0}, {-1.0, 2.0, -2.0}};
            this.setLayout((LayoutManager)new TableLayout((double[][])dArrayArray));
            this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            JButton jButton = new JButton(IlvBorderEditor.this.a("BorderEditor.OK"));
            jButton.setActionCommand(a);
            jButton.addActionListener(this);
            Box box = SwingFactories.createHorizontalBox();
            box.add(Box.createHorizontalGlue());
            box.add(jButton);
            box.add(Box.createHorizontalStrut(5));
            JButton jButton2 = new JButton(IlvBorderEditor.this.a("BorderEditor.CANCEL"));
            jButton2.setActionCommand(b);
            jButton2.addActionListener(this);
            box.add(jButton2);
            box.add(Box.createHorizontalGlue());
            Dimension dimension = jButton.getPreferredSize();
            Dimension dimension2 = jButton2.getPreferredSize();
            if (dimension.width > dimension2.width) {
                dimension2.width = dimension.width;
            } else {
                dimension.width = dimension2.width;
            }
            jButton.setPreferredSize(dimension);
            jButton2.setPreferredSize(dimension2);
            if (box instanceof JComponent) {
                ((JComponent)box).setBorder(BorderFactory.createCompoundBorder(new IlvEtchedLineBorder(1), BorderFactory.createEmptyBorder(4, 0, 4, 0)));
            }
            jButton.setAlignmentX(0.5f);
            jButton2.setAlignmentX(0.5f);
            this.add((Component)box, "1,2,3,2");
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setOpaque(false);
            jPanel.setBorder(BorderFactory.createTitledBorder(new IlvEtchedLineBorder(1), IlvBorderEditor.this.a("BorderEditor.Preview")));
            this.e = new BorderIcon(BorderFactory.createEmptyBorder(), new Dimension(60, 50));
            jPanel.add((Component)new JLabel(this.e), "Center");
            this.add((Component)jPanel, "3,0");
            this.f = new JPanel(new BorderLayout());
            this.f.setOpaque(false);
            this.f.setBorder(BorderFactory.createTitledBorder(new IlvEtchedLineBorder(1), IlvBorderEditor.this.a("BorderEditor.Settings")));
            this.add((Component)this.f, "1,0");
            Component component = Box.createHorizontalStrut(5);
            this.add(component, "2,0");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.c = actionEvent.getActionCommand() == a;
            SwingUtilities.getRoot(this).setVisible(false);
        }

        public void setPanel(BorderSettingPanel borderSettingPanel) {
            if (this.d != null) {
                this.e.setBorder(BorderFactory.createEmptyBorder());
                this.f.remove(this.d);
                this.d.removePropertyChangeListener(this);
            }
            this.d = borderSettingPanel;
            if (this.d != null) {
                this.e.setBorder(this.d.createBorder());
                this.f.add((Component)this.d, "Center");
                this.d.addPropertyChangeListener(this);
            }
            this.revalidate();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.e.setBorder(this.d.createBorder());
            this.revalidate();
            this.repaint();
        }

        public boolean isOk() {
            return this.c;
        }
    }

    private final class CompoundSetting
    extends BorderSettingPanel {
        private IlvBorderEditor a;
        private IlvBorderEditor b;

        public CompoundSetting() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = SwingFactories.getGridBagLayoutLineStart();
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 50.0;
            JLabel jLabel = new JLabel(IlvBorderEditor.this.a("BorderEditor.Compound.Inner"));
            this.a = new IlvBorderEditor(false){

                @Override
                public void fireActionPerformed() {
                    CompoundSetting.this.propertyChange(null);
                }

                @Override
                protected void borderSelected(Object object) {
                    super.borderSelected(object);
                    CompoundSetting.this.propertyChange(null);
                }
            };
            gridBagConstraints.gridy = 1;
            this.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.gridy = 2;
            this.add((Component)this.a, gridBagConstraints);
            jLabel = new JLabel(IlvBorderEditor.this.a("BorderEditor.Compound.Outer"));
            this.b = new IlvBorderEditor(false){

                @Override
                public void fireActionPerformed() {
                    CompoundSetting.this.propertyChange(null);
                }

                @Override
                protected void borderSelected(Object object) {
                    super.borderSelected(object);
                    CompoundSetting.this.propertyChange(null);
                }
            };
            gridBagConstraints.gridy = 3;
            this.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.gridy = 4;
            this.add((Component)this.b, gridBagConstraints);
        }

        @Override
        public Border createBorder() {
            Border border = (Border)this.a.getValue();
            Border border2 = (Border)this.b.getValue();
            return new CompoundBorder(border2 != null ? border2 : BorderFactory.createEmptyBorder(), border != null ? border : BorderFactory.createEmptyBorder());
        }

        private void a() {
            this.propertyChange(null);
        }

        @Override
        public String getSettingTitle() {
            return IlvBorderEditor.this.a("BorderEditor.Compound.SettingTitle");
        }

        @Override
        public void setObject(Object object) {
            if (!(object instanceof CompoundBorder)) {
                throw new IllegalArgumentException("Not a CompoundBorder");
            }
            CompoundBorder compoundBorder = (CompoundBorder)object;
            this.a.setValue(compoundBorder.getInsideBorder());
            this.b.setValue(compoundBorder.getOutsideBorder());
        }
    }

    private final class MatteSetting
    extends BorderSettingPanel {
        private Insets a;
        private IlvColorPropertyEditor b;
        private IlvNumberEditor c;
        private IlvNumberEditor d;
        private IlvNumberEditor e;
        private IlvNumberEditor f;

        public MatteSetting() {
            this.a = new Insets(1, 1, 1, 1);
            double[][] dArrayArray = new double[][]{{3.0, -1.0, 3.0, -1.0, 3.0}, {-1.0, -2.0, 2.0, -2.0, 2.0, -2.0, 2.0, -2.0, 2.0, -2.0, -1.0}};
            this.setLayout((LayoutManager)new TableLayout((double[][])dArrayArray));
            JLabel jLabel = new JLabel(IlvBorderEditor.this.a("BorderEditor.Matte.Color"));
            CustomPropertyEditor customPropertyEditor = new CustomPropertyEditor(IlvBorderEditor.this.b(), null);
            this.b = new IlvColorPropertyEditor();
            this.b.setValue(Color.black);
            customPropertyEditor.setEditor(this.b);
            this.b.addPropertyChangeListener(this);
            this.add((Component)jLabel, "1,1");
            this.add((Component)customPropertyEditor, "3,1");
            jLabel = new JLabel(IlvBorderEditor.this.a("BorderEditor.Empty.Left"));
            this.c = new IlvNumberEditor(0.0, 10.0, 1.0, null, null);
            this.c.setValue(this.a.left);
            this.c.addPropertyChangeListener("value", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    ((MatteSetting)MatteSetting.this).a.left = ((Double)propertyChangeEvent.getNewValue()).intValue();
                    MatteSetting.this.propertyChange(null);
                }
            });
            this.add((Component)jLabel, "1,3");
            this.add((Component)this.c, "3,3");
            jLabel = new JLabel(IlvBorderEditor.this.a("BorderEditor.Empty.Right"));
            this.f = new IlvNumberEditor(0.0, 10.0, 1.0, null, null);
            this.f.setValue(this.a.right);
            this.f.addPropertyChangeListener("value", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    ((MatteSetting)MatteSetting.this).a.right = ((Double)propertyChangeEvent.getNewValue()).intValue();
                    MatteSetting.this.propertyChange(null);
                }
            });
            this.add((Component)jLabel, "1,5");
            this.add((Component)this.f, "3,5");
            jLabel = new JLabel(IlvBorderEditor.this.a("BorderEditor.Empty.Top"));
            this.d = new IlvNumberEditor(0.0, 10.0, 1.0, null, null);
            this.d.setValue(this.a.top);
            this.d.addPropertyChangeListener("value", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    ((MatteSetting)MatteSetting.this).a.top = ((Double)propertyChangeEvent.getNewValue()).intValue();
                    MatteSetting.this.propertyChange(null);
                }
            });
            this.add((Component)jLabel, "1,7");
            this.add((Component)this.d, "3,7");
            jLabel = new JLabel(IlvBorderEditor.this.a("BorderEditor.Empty.Bottom"));
            this.e = new IlvNumberEditor(0.0, 10.0, 1.0, null, null);
            this.e.setValue(this.a.bottom);
            this.e.addPropertyChangeListener("value", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    ((MatteSetting)MatteSetting.this).a.bottom = ((Double)propertyChangeEvent.getNewValue()).intValue();
                    MatteSetting.this.propertyChange(null);
                }
            });
            this.add((Component)jLabel, "1,9");
            this.add((Component)this.e, "3,9");
        }

        @Override
        public Border createBorder() {
            return new MatteBorder(this.a, (Color)this.b.getValue());
        }

        @Override
        public String getSettingTitle() {
            return IlvBorderEditor.this.a("BorderEditor.Matte.SettingTitle");
        }

        @Override
        public void setObject(Object object) {
            if (!(object instanceof MatteBorder)) {
                throw new IllegalArgumentException("Not a MatteBorder");
            }
            this.a = ((MatteBorder)object).getBorderInsets();
            this.c.setValue(this.a.left);
            this.f.setValue(this.a.right);
            this.d.setValue(this.a.top);
            this.e.setValue(this.a.bottom);
            this.b.setValue(((MatteBorder)object).getMatteColor());
        }
    }

    private final class EmptySetting
    extends BorderSettingPanel {
        Insets a;
        private IlvNumberEditor b;
        private IlvNumberEditor c;
        private IlvNumberEditor d;
        private IlvNumberEditor e;

        public EmptySetting() {
            this.a = new Insets(1, 1, 1, 1);
            double[][] dArrayArray = new double[][]{{3.0, -1.0, 3.0, -1.0, 3.0}, {-1.0, -2.0, 2.0, -2.0, 2.0, -2.0, 2.0, -2.0, -1.0}};
            this.setLayout((LayoutManager)new TableLayout((double[][])dArrayArray));
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    EmptySetting.this.propertyChange(null);
                }
            };
            JLabel jLabel = new JLabel(IlvBorderEditor.this.a("BorderEditor.Empty.Left"));
            this.b = new IlvNumberEditor(0.0, 99.0, 1.0, null, null);
            this.b.setValue(this.a.left);
            this.b.addPropertyChangeListener("value", propertyChangeListener);
            this.add((Component)jLabel, "1,1");
            this.add((Component)this.b, "3,1");
            jLabel = new JLabel(IlvBorderEditor.this.a("BorderEditor.Empty.Right"));
            this.e = new IlvNumberEditor(0.0, 99.0, 1.0, null, null);
            this.e.setValue(this.a.right);
            this.e.addPropertyChangeListener("value", propertyChangeListener);
            this.add((Component)jLabel, "1,3");
            this.add((Component)this.e, "3,3");
            jLabel = new JLabel(IlvBorderEditor.this.a("BorderEditor.Empty.Top"));
            this.c = new IlvNumberEditor(0.0, 99.0, 1.0, null, null);
            this.c.setValue(this.a.top);
            this.c.addPropertyChangeListener("value", propertyChangeListener);
            this.add((Component)jLabel, "1,5");
            this.add((Component)this.c, "3,5");
            jLabel = new JLabel(IlvBorderEditor.this.a("BorderEditor.Empty.Bottom"));
            this.d = new IlvNumberEditor(0.0, 99.0, 1.0, null, null);
            this.d.setValue(this.a.bottom);
            this.d.addPropertyChangeListener("value", propertyChangeListener);
            this.add((Component)jLabel, "1,7");
            this.add((Component)this.d, "3,7");
        }

        @Override
        public Border createBorder() {
            this.a.top = (int)this.c.getValue();
            this.a.left = (int)this.b.getValue();
            this.a.right = (int)this.e.getValue();
            this.a.bottom = (int)this.d.getValue();
            return new EmptyBorder(this.a);
        }

        @Override
        public String getSettingTitle() {
            return IlvBorderEditor.this.a("BorderEditor.Empty.SettingTitle");
        }

        @Override
        public void setObject(Object object) {
            if (!(object instanceof EmptyBorder)) {
                throw new IllegalArgumentException("Not a EmptyBorder");
            }
            this.a = ((EmptyBorder)object).getBorderInsets();
            this.b.setValue(this.a.left);
            this.e.setValue(this.a.right);
            this.c.setValue(this.a.top);
            this.d.setValue(this.a.bottom);
        }
    }

    private final class TitledSetting
    extends BorderSettingPanel {
        private JTextField a;

        public TitledSetting() {
            double[][] dArrayArray = new double[][]{{3.0, -1.0, 3.0, -1.0, 3.0}, {-1.0, -2.0, -1.0}};
            this.setLayout((LayoutManager)new TableLayout((double[][])dArrayArray));
            this.a = new JTextField(10);
            this.a.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TitledSetting.this.propertyChange(null);
                }
            });
            JLabel jLabel = new JLabel(IlvBorderEditor.this.a("BorderEditor.Title.Title"));
            this.add((Component)jLabel, "1,1");
            this.add((Component)this.a, "3,1");
        }

        @Override
        public Border createBorder() {
            return new TitledBorder(this.a.getText());
        }

        @Override
        public void setObject(Object object) {
            if (!(object instanceof TitledBorder)) {
                throw new IllegalArgumentException("Not a TitledBorder");
            }
            this.a.setText(((TitledBorder)object).getTitle());
        }

        @Override
        public String getSettingTitle() {
            return IlvBorderEditor.this.a("BorderEditor.Title.SettingTitle");
        }
    }

    private final class LineSetting
    extends BorderSettingPanel {
        private IlvColorPropertyEditor a;
        private JSlider b;
        private JCheckBox c;

        public LineSetting() {
            double[][] dArrayArray = new double[][]{{3.0, -1.0, 3.0, -1.0, 3.0}, {-1.0, -2.0, 2.0, -2.0, 2.0, -2.0, -1.0}};
            this.setLayout((LayoutManager)new TableLayout((double[][])dArrayArray));
            JLabel jLabel = new JLabel(IlvBorderEditor.this.a("BorderEditor.Line.LineColor"));
            CustomPropertyEditor customPropertyEditor = new CustomPropertyEditor(IlvBorderEditor.this.b(), null);
            this.a = new IlvColorPropertyEditor();
            customPropertyEditor.setEditor(this.a);
            this.a.addPropertyChangeListener(this);
            this.add((Component)jLabel, "1,1");
            this.add((Component)customPropertyEditor, "3,1");
            jLabel = new JLabel(IlvBorderEditor.this.a("BorderEditor.Line.Thickness"));
            this.b = new JSlider(0, 1, 10, 1);
            Dimension dimension = this.b.getPreferredSize();
            dimension.width = 80;
            this.b.setPreferredSize(dimension);
            this.b.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    LineSetting.this.propertyChange(null);
                }
            });
            this.add((Component)jLabel, "1,3");
            this.add((Component)this.b, "3,3");
            this.c = new JCheckBox(IlvBorderEditor.this.a("BorderEditor.Line.RoundCorner"));
            this.c.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    LineSetting.this.propertyChange(null);
                }
            });
            this.add((Component)this.c, "1,5,3,5");
        }

        @Override
        public Border createBorder() {
            return new LineBorder((Color)this.a.getValue(), this.b.getValue(), this.c.isSelected());
        }

        @Override
        public void setObject(Object object) {
            if (!(object instanceof LineBorder)) {
                throw new IllegalArgumentException("Not a LineBorder");
            }
            LineBorder lineBorder = (LineBorder)object;
            this.b.setValue(lineBorder.getThickness());
            this.c.setSelected(lineBorder.getRoundedCorners());
            this.a.setValue(lineBorder.getLineColor());
        }

        @Override
        public String getSettingTitle() {
            return IlvBorderEditor.this.a("BorderEditor.Line.SettingTitle");
        }
    }

    private final class BevelSetting
    extends EtchedSetting {
        public BevelSetting() {
            super(true);
        }

        @Override
        public Border createBorder() {
            return new BevelBorder(((EtchedSetting)this).a, this.c, this.c, this.d, this.d);
        }

        @Override
        public String getSettingTitle() {
            return IlvBorderEditor.this.a("BorderEditor.Bevel.SettingTitle");
        }

        @Override
        public void setObject(Object object) {
            if (!(object instanceof BevelBorder)) {
                throw new IllegalArgumentException("Not a BevelBorder");
            }
            BevelBorder bevelBorder = (BevelBorder)object;
            this.h.setSelected(bevelBorder.getBevelType() == this.getLoweredTypeValue());
            this.c = bevelBorder.getHighlightInnerColor();
            boolean bl = this.c == null;
            this.f.setSelected(bl);
            this.b.setValue(!bl ? this.c : bevelBorder.getHighlightInnerColor(this.j));
            this.d = bevelBorder.getShadowInnerColor();
            bl = this.d == null;
            this.g.setSelected(bl);
            this.e.setValue(!bl ? this.d : bevelBorder.getShadowInnerColor(this.j));
        }

        @Override
        protected int getLoweredTypeValue() {
            return 1;
        }

        @Override
        protected int getRaisedTypeValue() {
            return 0;
        }
    }

    private class EtchedSetting
    extends BorderSettingPanel {
        int a;
        IlvColorPropertyEditor b;
        Color c;
        Color d;
        IlvColorPropertyEditor e;
        JCheckBox f;
        JCheckBox g;
        JRadioButton h;
        JRadioButton i;
        JPanel j;

        public EtchedSetting(boolean bl) {
            Serializable serializable;
            Serializable serializable2;
            JLabel jLabel;
            this.a = this.getLoweredTypeValue();
            this.j = new JPanel();
            double[][] dArrayArray = new double[][]{{3.0, -1.0, 3.0, -1.0, 3.0}, {-1.0, -2.0, 2.0, -2.0, 2.0, -2.0, 2.0, -2.0, 2.0, -2.0, 2.0, -2.0, -1.0}};
            this.setLayout((LayoutManager)new TableLayout((double[][])dArrayArray));
            if (bl) {
                jLabel = new JLabel(IlvBorderEditor.this.a("BorderEditor.Etched.Type"));
                serializable2 = new Dimension(22, 22);
                serializable = new ButtonGroup();
                this.h = new JRadioButton(IlvBorderEditor.this.a("BorderEditor.Etched.Lowered"));
                this.h.setToolTipText(IlvBorderEditor.this.a("BorderEditor.Etched.Lowered"));
                ItemListener itemListener = new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent itemEvent) {
                        if (itemEvent.getStateChange() == 1) {
                            EtchedSetting.this.a = itemEvent.getSource() == EtchedSetting.this.h ? EtchedSetting.this.getLoweredTypeValue() : EtchedSetting.this.getRaisedTypeValue();
                            EtchedSetting.this.propertyChange(null);
                        }
                    }
                };
                this.h.addItemListener(itemListener);
                ((ButtonGroup)serializable).add(this.h);
                this.i = new JRadioButton(IlvBorderEditor.this.a("BorderEditor.Etched.Raised"));
                this.i.setToolTipText(IlvBorderEditor.this.a("BorderEditor.Etched.Raised"));
                this.i.addItemListener(itemListener);
                ((ButtonGroup)serializable).add(this.i);
                this.add((Component)jLabel, "1,1");
                this.add((Component)this.h, "1,3");
                this.add((Component)this.i, "3,3");
            }
            jLabel = new JLabel(IlvBorderEditor.this.a("BorderEditor.Etched.Highlight"));
            serializable2 = new CustomPropertyEditor(IlvBorderEditor.this.b(), null);
            this.b = new IlvColorPropertyEditor();
            ((CustomPropertyEditor)serializable2).setEditor(this.b);
            this.f = new JCheckBox(IlvBorderEditor.this.a("BorderEditor.Etched.Automatic"));
            this.f.addItemListener(new ItemListener((CustomPropertyEditor)serializable2){
                final /* synthetic */ CustomPropertyEditor b;
                {
                    this.b = customPropertyEditor;
                }

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        EtchedSetting.this.c = null;
                        this.b.setEnabled(false);
                    } else {
                        this.b.setEnabled(true);
                        EtchedSetting.this.c = (Color)EtchedSetting.this.b.getValue();
                    }
                    EtchedSetting.this.propertyChange(null);
                }
            });
            this.b.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    EtchedSetting.this.c = (Color)EtchedSetting.this.b.getValue();
                }
            });
            this.b.addPropertyChangeListener(this);
            this.add((Component)jLabel, "1,5");
            this.add((Component)this.f, "1,7");
            this.add((Component)serializable2, "3,7");
            jLabel = new JLabel(IlvBorderEditor.this.a("BorderEditor.Etched.Shadow"));
            serializable = new CustomPropertyEditor(IlvBorderEditor.this.b(), null);
            this.e = new IlvColorPropertyEditor();
            ((CustomPropertyEditor)serializable).setEditor(this.e);
            this.g = new JCheckBox(IlvBorderEditor.this.a("BorderEditor.Etched.Automatic"));
            this.g.addItemListener(new ItemListener((CustomPropertyEditor)serializable){
                final /* synthetic */ CustomPropertyEditor b;
                {
                    this.b = customPropertyEditor;
                }

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        EtchedSetting.this.d = null;
                        this.b.setEnabled(false);
                    } else {
                        this.b.setEnabled(true);
                        EtchedSetting.this.d = (Color)EtchedSetting.this.e.getValue();
                    }
                    EtchedSetting.this.propertyChange(null);
                }
            });
            this.e.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    EtchedSetting.this.d = (Color)EtchedSetting.this.e.getValue();
                }
            });
            this.e.addPropertyChangeListener(this);
            this.add((Component)jLabel, "1,9");
            this.add((Component)this.g, "1,11");
            this.add((Component)serializable, "3,11");
        }

        @Override
        public Border createBorder() {
            return BorderFactory.createEtchedBorder(this.a, this.c, this.d);
        }

        @Override
        public void setObject(Object object) {
            if (!(object instanceof EtchedBorder)) {
                throw new IllegalArgumentException("Not a EtchedBorder");
            }
            EtchedBorder etchedBorder = (EtchedBorder)object;
            this.h.setSelected(etchedBorder.getEtchType() == this.getLoweredTypeValue());
            this.c = etchedBorder.getHighlightColor();
            boolean bl = this.c == null;
            this.f.setSelected(bl);
            this.b.setValue(!bl ? this.c : etchedBorder.getHighlightColor(this.j));
            this.d = etchedBorder.getShadowColor();
            bl = this.d == null;
            this.g.setSelected(bl);
            this.e.setValue(!bl ? this.d : etchedBorder.getShadowColor(this.j));
        }

        @Override
        public String getSettingTitle() {
            return IlvBorderEditor.this.a("BorderEditor.Etched.SettingTitle");
        }

        protected int getLoweredTypeValue() {
            return 1;
        }

        protected int getRaisedTypeValue() {
            return 0;
        }
    }

    protected abstract class BorderSettingPanel
    extends JPanel
    implements PropertyChangeListener {
        PropertyChangeEvent a = new PropertyChangeEvent(this, null, null, null);
        private PropertyChangeSupport b;

        protected BorderSettingPanel() {
        }

        public abstract Border createBorder();

        public abstract String getSettingTitle();

        public boolean isConfigurable() {
            return true;
        }

        public void setObject(Object object) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent == null) {
                propertyChangeEvent = this.a;
            }
            if (this.b != null) {
                this.b.firePropertyChange(propertyChangeEvent);
            }
            this.revalidate();
            this.repaint();
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.b == null) {
                this.b = new PropertyChangeSupport(this);
            }
            this.b.addPropertyChangeListener(propertyChangeListener);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.b != null) {
                this.b.removePropertyChangeListener(propertyChangeListener);
            }
        }
    }
}

