/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.interactor;

import ilog.views.IlvGraphicUtil;
import ilog.views.IlvGrid;
import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.interactor.IlvAbstractScrollInteractor;
import ilog.views.interactor.RectangleDraggedEvent;
import ilog.views.interactor.RectangleDraggedListener;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import javax.swing.event.EventListenerList;

public class IlvDragRectangleInteractor
extends IlvAbstractScrollInteractor {
    private final transient IlvPoint a = new IlvPoint();
    private final transient IlvPoint b = new IlvPoint();
    IlvRect c = new IlvRect();
    private transient boolean d = false;
    private transient boolean e = false;
    private float f = 0.0f;
    private float[] g;
    private boolean h;
    private transient IlvPoint[] i;
    private EventListenerList j = new EventListenerList();
    private transient RectangleDraggedEvent k;
    private Cursor l;
    private Cursor m;
    private int n = 16;
    private boolean o = false;
    private IlvPoint p = new IlvPoint();

    public IlvDragRectangleInteractor() {
        this.enableEvents(48L);
        this.setOpaqueMode(false);
    }

    public final boolean isGridMode() {
        return this.e;
    }

    public final void setGridMode(boolean bl) {
        this.e = bl;
    }

    public void setOpaqueMode(boolean bl) {
        this.h = bl;
    }

    public boolean isOpaqueMode() {
        return this.h;
    }

    @Override
    public boolean isXORGhost() {
        return this.isOpaqueMode() ? super.isXORGhost() : true;
    }

    @Override
    protected void attach(IlvManagerView ilvManagerView) {
        super.attach(ilvManagerView);
        if (!this.getCursor().equals(ilvManagerView.getCursor())) {
            this.m = ilvManagerView.isCursorSet() ? ilvManagerView.getCursor() : null;
            ilvManagerView.setCursor(this.getCursor());
        }
    }

    @Override
    protected void detach() {
        this.stopDraggingScrollTimer();
        this.f();
        this.getManagerView().setCursor(this.m);
        this.m = null;
        this.d = false;
        this.c.width = 0.0f;
        this.c.height = 0.0f;
        super.detach();
    }

    public Cursor getCursor() {
        if (this.l == null) {
            if (this.getManagerView() != null) {
                return this.getManagerView().getCursor();
            }
            return Cursor.getDefaultCursor();
        }
        return this.l;
    }

    public void setCursor(Cursor cursor) {
        this.l = cursor;
    }

    public float getRectangleAspectRatio() {
        return this.f;
    }

    public void setRectangleAspectRatio(float f) {
        this.f = f;
    }

    float a() {
        IlvGrid ilvGrid;
        if (this.e && (ilvGrid = this.getManagerView().getGrid()) != null && ilvGrid.isActive()) {
            return ilvGrid.getHorizontalSpacing();
        }
        return 0.0f;
    }

    float b() {
        IlvGrid ilvGrid;
        if (this.e && (ilvGrid = this.getManagerView().getGrid()) != null && ilvGrid.isActive()) {
            return ilvGrid.getVerticalSpacing();
        }
        return 0.0f;
    }

    private float d() {
        float f = this.a();
        return this.a(f);
    }

    private float e() {
        float f = this.b();
        return this.a(f);
    }

    float a(float f) {
        IlvTransformer ilvTransformer = this.getTransformer();
        if (f == 0.0f || ilvTransformer == null || ilvTransformer.isIdentity()) {
            return f;
        }
        IlvPoint ilvPoint = new IlvPoint(0.0f, 0.0f);
        IlvPoint ilvPoint2 = new IlvPoint(0.0f, f);
        ilvTransformer.apply(ilvPoint);
        ilvTransformer.apply(ilvPoint2);
        double d = ilvPoint2.x - ilvPoint.x;
        double d2 = ilvPoint2.y - ilvPoint.y;
        return (float)Math.sqrt(d * d + d2 * d2);
    }

    protected IlvPoint getStartPoint() {
        return new IlvPoint(this.a);
    }

    public void setLineStyle(float[] fArray) {
        this.g = fArray;
    }

    public float[] getLineStyle() {
        return this.g;
    }

    public final void setStartDragModifier(int n) {
        this.n = n;
    }

    public final int getStartDragModifier() {
        return this.n;
    }

    protected boolean isStartDragModifierDown(MouseEvent mouseEvent) {
        return (mouseEvent.getModifiers() & this.getStartDragModifier()) != 0;
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 501: {
                this.handleButtonDown(mouseEvent);
                break;
            }
            case 502: {
                this.handleButtonUp(mouseEvent);
            }
        }
        super.processMouseEvent(mouseEvent);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 506) {
            this.handleButtonDragged(mouseEvent);
        }
        super.processMouseMotionEvent(mouseEvent);
    }

    protected boolean handleButtonDown(MouseEvent mouseEvent) {
        if (this.d) {
            return false;
        }
        if (this.isStartDragModifierDown(mouseEvent)) {
            this.d = true;
            IlvTransformer ilvTransformer = this.getTransformer();
            this.b.move(mouseEvent.getX(), mouseEvent.getY());
            if (this.e) {
                this.getManagerView().snapToGrid(this.b);
            }
            this.a.setLocation(this.b);
            if (this.isRotationAllowed()) {
                if (ilvTransformer != null) {
                    ilvTransformer.inverse(this.a);
                }
                this.c.reshape(this.a.x, this.a.y, 0.0f, 0.0f);
            } else {
                this.c.reshape(this.b.x, this.b.y, 0.0f, 0.0f);
                if (ilvTransformer != null) {
                    ilvTransformer.inverse(this.a);
                }
            }
            return true;
        }
        return false;
    }

    protected boolean handleButtonDragged(MouseEvent mouseEvent) {
        if (!this.d) {
            return false;
        }
        if (this.doAutoScroll(mouseEvent)) {
            return true;
        }
        this.c();
        this.a(mouseEvent.getX(), mouseEvent.getY(), this.getTransformer());
        this.c();
        return true;
    }

    @Override
    protected boolean dragscroll(MouseEvent mouseEvent) {
        return this.handleButtonDragged(mouseEvent);
    }

    void a(float f, float f2, IlvTransformer ilvTransformer) {
        float f3;
        float f4;
        IlvPoint ilvPoint = new IlvPoint(f, f2);
        this.adjustPointIfOutsideView(ilvPoint, this.p);
        this.p.move(ilvPoint.x, ilvPoint.y);
        IlvPoint ilvPoint2 = new IlvPoint(ilvPoint);
        if (this.e) {
            this.getManagerView().snapToGrid(ilvPoint);
        }
        float f5 = this.getRectangleAspectRatio();
        boolean bl = this.isRotationAllowed();
        float f6 = 0.0f;
        float f7 = 0.0f;
        if (bl) {
            f6 = this.a.x;
            f7 = this.a.y;
            this.c.reshape(f6, f7, 0.0f, 0.0f);
            if (ilvTransformer != null) {
                ilvTransformer.inverse(ilvPoint);
                ilvTransformer.inverse(ilvPoint2);
            }
            this.c.add(ilvPoint.x, ilvPoint.y);
            if (f5 > 0.0f) {
                if (this.c.width > f5 * this.c.height) {
                    this.c.height = this.c.width / f5;
                } else {
                    this.c.width = f5 * this.c.height;
                }
                if (this.c.x == ilvPoint.x) {
                    this.c.x = f6 - this.c.width;
                }
                if (this.c.y == ilvPoint.y) {
                    this.c.y = f7 - this.c.height;
                }
            }
        } else {
            float f8;
            f6 = this.b.x;
            f7 = this.b.y;
            f4 = ilvPoint.x - f6;
            f3 = ilvPoint.y - f7;
            float f9 = ilvPoint.x < f6 ? ilvPoint.x : f6;
            float f10 = ilvPoint.y < f7 ? ilvPoint.y : f7;
            float f11 = f4 > 0.0f ? f4 : -f4;
            float f12 = f8 = f3 > 0.0f ? f3 : -f3;
            if (f5 > 0.0f) {
                float f13;
                if (f11 > f5 * f8) {
                    f13 = f11 / f5;
                    if (f3 < 0.0f) {
                        f10 += f8 - f13;
                    }
                    f8 = f13;
                } else {
                    f13 = f5 * f8;
                    if (f4 < 0.0f) {
                        f9 += f11 - f13;
                    }
                    f11 = f13;
                }
            }
            this.c.reshape(f9, f10, f11, f8);
        }
        f4 = bl ? this.a() : this.d();
        float f14 = f3 = bl ? this.b() : this.e();
        if (this.c.width < f4) {
            if (ilvPoint2.x < f6) {
                this.c.x = f6 - f4;
                this.c.width = f4;
                ilvPoint.x = this.c.x;
            } else {
                this.c.width = f4;
                ilvPoint.x = this.c.x + this.c.width;
            }
        }
        if (this.c.height < f3) {
            if (ilvPoint2.y < f7) {
                this.c.y = f7 - f3;
                this.c.height = f3;
                ilvPoint.y = this.c.y;
            } else {
                this.c.height = f3;
                ilvPoint.y = this.c.y + this.c.height;
            }
        }
        if (bl) {
            if (ilvTransformer != null) {
                ilvTransformer.apply(ilvPoint);
            }
            this.a(ilvPoint);
        } else {
            double d = 0.0;
            double d2 = 0.0;
            IlvTransformer ilvTransformer2 = this.getTransformer();
            if (ilvTransformer2 != null) {
                d = ilvTransformer2.getx0();
                d2 = ilvTransformer2.gety0();
            }
            this.a(ilvPoint);
            ilvTransformer2 = this.getTransformer();
            if (ilvTransformer2 != null) {
                d = ilvTransformer2.getx0() - d;
                d2 = ilvTransformer2.gety0() - d2;
            }
            if (d != 0.0 || d2 != 0.0) {
                this.b.x = (float)((double)this.b.x + d);
                this.b.y = (float)((double)this.b.y + d2);
                this.c.reshape(this.c.x + (float)d, this.c.y + (float)d2, this.c.width - (float)d, this.c.height - (float)d2);
            }
        }
    }

    private void a(IlvPoint ilvPoint) {
        boolean bl = this.getManagerView().isOptimizedTranslation();
        if (!bl) {
            this.f();
        }
        IlvTransformer ilvTransformer = this.getTransformer();
        this.ensureVisible(ilvPoint);
        IlvTransformer ilvTransformer2 = this.getTransformer();
        if (ilvTransformer2 != null && !ilvTransformer2.equals(ilvTransformer)) {
            if (ilvTransformer != null) {
                ilvTransformer.inverse(this.p);
            }
            if (ilvTransformer2 != null) {
                ilvTransformer2.apply(this.p);
            }
        }
        if (!bl) {
            this.drawGhost();
        }
    }

    protected boolean handleButtonUp(MouseEvent mouseEvent) {
        IlvTransformer ilvTransformer;
        if (!this.d) {
            return false;
        }
        this.stopDraggingScrollTimer();
        this.d = false;
        IlvRect ilvRect = new IlvRect(this.c);
        this.f();
        this.c.width = 0.0f;
        this.c.height = 0.0f;
        if (!this.isRotationAllowed() && (ilvTransformer = this.getTransformer()) != null && !ilvTransformer.isIdentity()) {
            ilvTransformer.boundingBox(ilvRect, true);
        }
        this.fireRectangleDraggedEvent(ilvRect, mouseEvent);
        return true;
    }

    @Override
    protected void drawGhost(Graphics graphics) {
        IlvRect ilvRect = this.getDraggedRectangle();
        if (ilvRect.width <= 0.0f || ilvRect.height <= 0.0f) {
            return;
        }
        float[] fArray = this.getLineStyle();
        if (this.isRotationAllowed()) {
            IlvPoint[] ilvPointArray = this.a(ilvRect, this.getTransformer());
            if (!this.isOpaqueMode() && fArray == null) {
                fArray = new float[1];
                fArray[0] = 100000.0f;
            }
            IlvGraphicUtil.DrawPolyline(graphics, ilvPointArray, 5, 1.0f, 1, 0, fArray, null);
        } else if (fArray == null) {
            graphics.drawRect((int)ilvRect.x, (int)ilvRect.y, (int)ilvRect.width, (int)ilvRect.height);
        } else {
            IlvPoint[] ilvPointArray = this.a(ilvRect, null);
            IlvGraphicUtil.DrawPolyline(graphics, ilvPointArray, 5, 1.0f, 0, 0, fArray, null);
        }
    }

    private IlvPoint[] a(IlvRect ilvRect, IlvTransformer ilvTransformer) {
        if (this.i == null) {
            this.i = new IlvPoint[5];
            for (int i = 0; i < 5; ++i) {
                this.i[i] = new IlvPoint();
            }
        }
        this.i[0].move(ilvRect.x, ilvRect.y);
        this.i[1].move(ilvRect.x + ilvRect.width, ilvRect.y);
        this.i[2].move(ilvRect.x + ilvRect.width, ilvRect.y + ilvRect.height);
        this.i[3].move(ilvRect.x, ilvRect.y + ilvRect.height);
        this.i[4].move(ilvRect.x, ilvRect.y);
        if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
            ilvTransformer.apply(this.i[0]);
            ilvTransformer.apply(this.i[1]);
            ilvTransformer.apply(this.i[2]);
            ilvTransformer.apply(this.i[3]);
            ilvTransformer.apply(this.i[4]);
        }
        return this.i;
    }

    private void f() {
        this.c();
    }

    void c() {
        if (this.isOpaqueMode()) {
            IlvManagerView ilvManagerView = this.getManagerView();
            if (ilvManagerView == null) {
                return;
            }
            if (this.c != null && this.c.width > 0.0f && this.c.height > 0.0f) {
                IlvTransformer ilvTransformer;
                IlvRect ilvRect = new IlvRect(this.c);
                if (this.isRotationAllowed() && (ilvTransformer = this.getTransformer()) != null) {
                    ilvTransformer.boundingBox(ilvRect, false);
                }
                ilvManagerView.invalidateRect(ilvRect);
                ilvManagerView.reDrawViews();
            }
        } else {
            this.drawGhost();
        }
    }

    public void addRectangleDraggedListener(RectangleDraggedListener rectangleDraggedListener) {
        this.j.add(RectangleDraggedListener.class, rectangleDraggedListener);
    }

    public void removeRectangleDraggedListener(RectangleDraggedListener rectangleDraggedListener) {
        this.j.remove(RectangleDraggedListener.class, rectangleDraggedListener);
    }

    protected void fireRectangleDraggedEvent(IlvRect ilvRect, MouseEvent mouseEvent) {
        Object[] objectArray = this.j.getListenerList();
        int n = objectArray.length;
        if (n != 0) {
            if (this.k == null) {
                this.k = new RectangleDraggedEvent(this, ilvRect, mouseEvent);
            } else {
                this.k.a(this);
                this.k.a(ilvRect);
                this.k.a(mouseEvent);
            }
            for (int i = n - 1; i >= 0; i -= 2) {
                ((RectangleDraggedListener)objectArray[i]).rectangleDragged(this.k);
            }
        }
    }

    public IlvRect getDraggedRectangle() {
        return this.c;
    }

    public void setRotationAllowed(boolean bl) {
        this.o = bl;
    }

    public boolean isRotationAllowed() {
        return this.o;
    }
}

