/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.collections;

import java.io.Serializable;

public class IlvFloatArrayList
implements Cloneable,
Serializable {
    private static float[] a = new float[0];
    private float[] b;
    private int c;

    public IlvFloatArrayList() {
        this.b = new float[10];
        this.c = 0;
    }

    public IlvFloatArrayList(int n) {
        this.b = new float[n];
        this.c = 0;
    }

    public IlvFloatArrayList(float[] fArray) {
        int n = fArray.length;
        n += n / 4;
        this.b = new float[n];
        this.c = fArray.length;
        System.arraycopy(fArray, 0, this.b, 0, this.c);
    }

    public int size() {
        return this.c;
    }

    public boolean isEmpty() {
        return this.c == 0;
    }

    public float get(int n) {
        if (n < this.c) {
            return this.b[n];
        }
        throw new IndexOutOfBoundsException("index " + n + " too large for size " + this.c);
    }

    public float set(int n, float f) {
        if (n < this.c) {
            float f2 = this.b[n];
            this.b[n] = f;
            return f2;
        }
        throw new IndexOutOfBoundsException("index " + n + " too large for size " + this.c);
    }

    public void copyInto(float[] fArray) {
        if (this.c > 0) {
            System.arraycopy(this.b, 0, fArray, 0, this.c);
        }
    }

    public float[] toArray() {
        if (this.c > 0) {
            float[] fArray = new float[this.c];
            System.arraycopy(this.b, 0, fArray, 0, this.c);
            return fArray;
        }
        return a;
    }

    public void add(float f) {
        this.ensureCapacity(this.c + 1);
        this.b[this.c] = f;
        ++this.c;
    }

    public void add(int n, float f) {
        if (n < 0 && n > this.c) {
            throw new IndexOutOfBoundsException("index " + n + " inappropriate for size " + this.c);
        }
        this.ensureCapacity(this.c + 1);
        if (n < this.c) {
            System.arraycopy(this.b, n, this.b, n + 1, this.c - n);
        }
        this.b[n] = f;
        ++this.c;
    }

    public float remove(int n) {
        if (n < 0 && n >= this.c) {
            throw new IndexOutOfBoundsException("index " + n + " inappropriate for size " + this.c);
        }
        float f = this.b[n];
        if (n + 1 < this.c) {
            System.arraycopy(this.b, n + 1, this.b, n, this.c - n - 1);
        }
        --this.c;
        return f;
    }

    public void removeRange(int n, int n2) {
        if (n < 0 || n2 > this.c || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = n2 - n;
        if (n3 > 0) {
            if (n2 < this.c) {
                System.arraycopy(this.b, n2, this.b, n, this.c - n2);
            }
            this.c -= n3;
        }
    }

    public void clear() {
        this.c = 0;
    }

    public void trimToSize() {
        if (this.b.length > this.c) {
            if (this.c > 0) {
                float[] fArray = new float[this.c];
                System.arraycopy(this.b, 0, fArray, 0, this.c);
                this.b = fArray;
            } else {
                this.b = a;
            }
        }
    }

    public void ensureCapacity(int n) {
        if (n > this.b.length) {
            int n2 = this.b.length;
            if ((n2 += n2 / 4) < n) {
                n2 = n;
            }
            float[] fArray = new float[n2];
            System.arraycopy(this.b, 0, fArray, 0, this.c);
            this.b = fArray;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i = 0; i < this.c; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.b[i]);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof IlvFloatArrayList) {
            IlvFloatArrayList ilvFloatArrayList = (IlvFloatArrayList)object;
            if (this.c != ilvFloatArrayList.c) {
                return false;
            }
            int n = this.c;
            for (int i = 0; i < n; ++i) {
                if (Float.floatToRawIntBits(this.b[i]) == Float.floatToRawIntBits(ilvFloatArrayList.b[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int n = this.c + 1;
        for (int i = 0; i < this.c; ++i) {
            n = 31 * n + Float.floatToRawIntBits(this.b[i]);
        }
        return n;
    }

    public Object clone() {
        try {
            IlvFloatArrayList ilvFloatArrayList = (IlvFloatArrayList)super.clone();
            ilvFloatArrayList.b = this.toArray();
            return ilvFloatArrayList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }
}

