/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.olapi.replay;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import oracle.express.olapi.replay.DefinitionWriter;
import oracle.express.olapi.replay.OutputHandler;
import oracle.express.olapi.replay.XMLFactory;
import oracle.olapi.data.source.Source;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ExceptionDefinitionWriter {
    public static final String DEFAULTPACKAGE = "oracle.express.olapi.replay";
    public static final String DEFAULT_DEFINITION_WRITER = "oracle.olapi.exceptiondefinitionwriter";
    private static ExceptionDefinitionWriter _default = ExceptionDefinitionWriter._createDefaultInstance();
    private DefinitionWriter _writer;
    private OutputHandler _handler;

    public ExceptionDefinitionWriter(DefinitionWriter definitionWriter, OutputHandler outputHandler) throws NullPointerException {
        if (definitionWriter == null || outputHandler == null) {
            throw new NullPointerException();
        }
        this._writer = definitionWriter;
        this._handler = outputHandler;
    }

    public void write(Source source, Throwable throwable) {
        try {
            Document document = this._writer.createDocument(DefinitionWriter.toCollection(source));
            document.getDocumentElement().insertBefore(this.makeExceptionElement(document, throwable), null);
            StringWriter stringWriter = new StringWriter();
            this._writer.getParameters().getXMLDocumentFactory().print(document, stringWriter);
            document = null;
            String string = stringWriter.toString();
            stringWriter = null;
            this._handler.write(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected Element makeExceptionElement(Document document, Throwable throwable) {
        XMLFactory xMLFactory = new XMLFactory(document);
        Element element = xMLFactory.createElement("Error");
        try {
            element.setAttributeNode(xMLFactory.createAttribute("class", throwable.getClass().getName()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            element.appendChild(xMLFactory.createCDATAElement("Message", throwable.getMessage()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            element.appendChild(xMLFactory.createCDATAElement("Stacktrace", this.getStackTrace(throwable)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return element;
    }

    private String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, false);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        return stringWriter.toString();
    }

    public DefinitionWriter getDefinitionWriter() {
        return this._writer;
    }

    public static ExceptionDefinitionWriter getDefaultInstance() {
        return _default;
    }

    public static void dispatch(Source source, Exception exception) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ExceptionDefinitionWriter _createDefaultInstance() {
        ExceptionDefinitionWriter exceptionDefinitionWriter = null;
        try {
            String string = System.getProperty(DEFAULT_DEFINITION_WRITER);
            if (string != null) {
                String string2;
                String string3;
                int n = string.indexOf(58);
                if (n < 0) {
                    string3 = string;
                    string2 = "";
                } else {
                    string3 = string.substring(0, n);
                    string2 = string.substring(n + 1);
                }
                OutputHandler outputHandler = ExceptionDefinitionWriter.loadOutputHandler(string3, string2);
                exceptionDefinitionWriter = new ExceptionDefinitionWriter(new DefinitionWriter(), outputHandler);
                return exceptionDefinitionWriter;
            }
        }
        catch (Exception exception) {}
        finally {
            return exceptionDefinitionWriter;
        }
    }

    protected static OutputHandler loadOutputHandler(String string, String string2) {
        try {
            if (string.indexOf(46) < 0) {
                string = "oracle.express.olapi.replay." + string;
            }
            Class<?> clazz = Class.forName(string);
            Constructor<?> constructor = null;
            Object[] objectArray = null;
            try {
                constructor = clazz.getConstructor(String.class);
                objectArray = new Object[]{string2};
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    constructor = clazz.getConstructor(new Class[0]);
                    objectArray = new Object[]{};
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    // empty catch block
                }
            }
            return (OutputHandler)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

