/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata;

import java.util.List;
import oracle.olapi.metadata.BaseMetadataObject;
import oracle.olapi.metadata.MetadataModificationException;
import oracle.olapi.metadata.MetadataProperty;
import oracle.olapi.metadata.MetadataToXMLConverter;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.mdm.MdmXMLTags;

final class MetadataStringProperty
extends MetadataProperty {
    private String m_PropertyValue = null;
    private boolean m_Local = false;
    private boolean m_IsFixedValue = false;

    MetadataStringProperty(XMLTag xMLTag, String string) {
        super(xMLTag);
        this.setPropertyValue(string, true, null);
        this.setLocal(false);
        this.setIsFixedValue(false);
    }

    private MetadataStringProperty(MetadataStringProperty metadataStringProperty, boolean bl) {
        super(metadataStringProperty);
        this.setPropertyValue(metadataStringProperty.getPropertyValue(), true, null);
        if (bl) {
            this.setLocal(metadataStringProperty.isLocal());
        } else {
            this.setLocal(false);
        }
        this.setIsFixedValue(metadataStringProperty.isFixedValue());
    }

    @Override
    boolean addChildrenToXMLWriter(MetadataToXMLConverter metadataToXMLConverter, List list) {
        return false;
    }

    @Override
    void gatherReferencedSources(List list) {
    }

    @Override
    void appendXMLString(MetadataToXMLConverter metadataToXMLConverter, BaseMetadataObject baseMetadataObject) {
        if (null == this.getPropertyValue() || this.getPropertyValue().length() == 0) {
            return;
        }
        if (this.getPropertyTag() == MdmXMLTags.IS_92_LIST_DIMENSION) {
            return;
        }
        if (!metadataToXMLConverter.getXMLFormat().is10gMode() && 3 == this.getXMLFormatType()) {
            metadataToXMLConverter.appendIDAttribute(this.getPropertyTag(), this.getPropertyValue(), baseMetadataObject);
        } else if (metadataToXMLConverter.getXMLFormat().is10gMode() || 2 == this.getXMLFormatType()) {
            metadataToXMLConverter.appendAttribute(this.getPropertyTag(), this.getPropertyValue(), baseMetadataObject);
        }
    }

    @Override
    void appendIncrementalXMLString(MetadataToXMLConverter metadataToXMLConverter, BaseMetadataObject baseMetadataObject) {
        if (3 == this.getXMLFormatType()) {
            this.appendXMLString(metadataToXMLConverter, baseMetadataObject);
        } else if (this.isModification(metadataToXMLConverter, baseMetadataObject)) {
            if (null == this.getPropertyValue() || this.getPropertyValue().length() == 0) {
                metadataToXMLConverter.appendAttribute(this.getPropertyTag(), "", baseMetadataObject);
            } else {
                this.appendXMLString(metadataToXMLConverter, baseMetadataObject);
            }
        }
    }

    String getPropertyValue() {
        return this.m_PropertyValue;
    }

    @Override
    boolean isAttribute(MetadataToXMLConverter metadataToXMLConverter, BaseMetadataObject baseMetadataObject) {
        return true;
    }

    @Override
    public boolean isLocal() {
        return this.m_Local;
    }

    public void setLocal(boolean bl) {
        this.m_Local = bl;
    }

    void setPropertyValue(String string, BaseMetadataObject baseMetadataObject) {
        this.setPropertyValue(string, false, baseMetadataObject);
    }

    void setPropertyValue(String string, boolean bl, BaseMetadataObject baseMetadataObject) {
        if (null == string) {
            string = "";
        }
        if (string.equals(this.m_PropertyValue)) {
            return;
        }
        if (this.isFixedValue() && !bl) {
            throw new MetadataModificationException("UnmodifiableAttribute", this.getPropertyTag().getDefaultName(), baseMetadataObject.getID());
        }
        this.m_PropertyValue = string;
    }

    @Override
    MetadataProperty cloneProperty(boolean bl) {
        return new MetadataStringProperty(this, bl);
    }

    @Override
    void updateFromChild(MetadataProperty metadataProperty) {
        MetadataStringProperty metadataStringProperty = (MetadataStringProperty)metadataProperty;
        this.setPropertyValue(metadataStringProperty.getPropertyValue(), true, null);
        if (metadataStringProperty.isLocal()) {
            this.setLocal(true);
        }
    }

    @Override
    void updateFromParent(MetadataProperty metadataProperty) {
        if (this.isLocal()) {
            return;
        }
        MetadataStringProperty metadataStringProperty = (MetadataStringProperty)metadataProperty;
        this.setPropertyValue(metadataStringProperty.getPropertyValue(), true, null);
    }

    private boolean isFixedValue() {
        return this.m_IsFixedValue;
    }

    void setIsFixedValue(boolean bl) {
        this.m_IsFixedValue = bl;
    }

    @Override
    boolean isModification(MetadataToXMLConverter metadataToXMLConverter, BaseMetadataObject baseMetadataObject) {
        return this.isLocal() && super.isModification(metadataToXMLConverter, baseMetadataObject);
    }

    @Override
    final boolean isServerSendable(MetadataProperty metadataProperty) {
        boolean bl = true;
        if (!this.isLocal()) {
            bl = false;
        }
        return bl;
    }
}

